/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.mbg.client.AbstractMbgViewListFormRollProcessUI;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.notify.CellDoubleClickListener;
import com.kingdee.eas.ma.mbg.client.roll.MbgViewListFormRollActionManager;
import com.kingdee.eas.ma.mbg.client.roll.MbgViewListFormRollContextManager;
import com.kingdee.eas.ma.mbg.client.roll.MbgViewListFormRollMenuManager;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.designer.IActionManager;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.eas.ma.mbg.designer.IMenuManager;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewListFormRollProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class MbgViewListFormRollProcessUI
extends AbstractMbgViewListFormRollProcessUI {
    private static final long serialVersionUID = 3281710855350609675L;
    private static final Logger logger = CoreUIObject.getLogger(MbgViewListFormRollProcessUI.class);

    @Override
    public IActionManager createActionsManagerImpl() {
        return new MbgViewListFormRollActionManager(this.getContextManager());
    }

    @Override
    public IContextManager createContextManagerImpl() {
        return new MbgViewListFormRollContextManager(this.getUIContext(), this);
    }

    @Override
    public IMenuManager createMenuManagerImpl() {
        return new MbgViewListFormRollMenuManager();
    }

    @Override
    public void doubleClickCell() {
        if (this.getContextManager().getProvider() instanceof MbgViewListFormRollProvider) {
            SpreadContext spreadContext = ((BookContextManager)this.getContextManager()).getSpreadContext();
            Book book = spreadContext.getBook();
            Cell cell = book.getActiveSheet().getActiveCell();
            ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
            DimensionMemberCheckHelper helper = null;
            if (itemFormula != null) {
                try {
                    MbgViewListFormRollProvider provider = (MbgViewListFormRollProvider)this.getContextManager().getProvider();
                    String cellOrgId = itemFormula.getExt("ORGUNITID");
                    String cellOrgNum = itemFormula.getExt("ORGUNIT");
                    IMbgViewBase view = (IMbgViewBase)provider.getBgViewManagerForMulOrg().get(cellOrgNum);
                    helper = this.getHelper(provider, cellOrgId, view);
                    String editScen = helper.getEditScen(view, cell.getSheet().getSheetIndex(), BgScenarioType.BudgetData);
                    CellDoubleClickListener cellDoubleClickListener = new CellDoubleClickListener(this.getMainStatusBar(), cell, this.getBgFormInfo(), editScen, helper, provider.getBgDataMap(), provider.getCanEditPeriodNumbers());
                    cellDoubleClickListener.doubleClick();
                }
                catch (Exception provider) {}
            } else {
                Range range;
                if (cell == null && (range = book.getActiveSheet().getSelectionRange()) != null) {
                    CellBlock block = range.getBlock(0);
                    cell = book.getActiveSheet().getCell(block.getRow(), block.getCol(), true);
                }
                MBGViewListFormProvider provider = (MBGViewListFormProvider)this.getContextManager().getProvider();
                CellDoubleClickListener cellDoubleClickListener = new CellDoubleClickListener(this.getMainStatusBar(), cell, this.getBgFormInfo(), null, helper, provider.getBgDataMap());
                cellDoubleClickListener.doubleClick();
            }
        }
    }

    public String getUITitle() {
        return BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", "budgetRollForm") + " - " + MessageFormat.format(BgNFCHelper.getMessageStr(this.getOprtState()), "", "") + " - " + this.getEditData().get("name").toString();
    }

    @Override
    public void actionDataStateEdit_actionPerformed(ActionEvent e) throws Exception {
        this.getActionsManager().doAction(e);
    }
}

