/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.client.AbstractNewDimensionSelectUI;
import com.kingdee.eas.ma.mbg.common.MbgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class NewDimensionSelectUI
extends AbstractNewDimensionSelectUI {
    private static final long serialVersionUID = -4474232191646730940L;
    private static final Logger logger = CoreUIObject.getLogger(NewDimensionSelectUI.class);
    private boolean isCanceled = true;
    protected List<DimSettingDisplayInfo> data = null;
    public static final String COL_SELECTED = "selected";
    public static final String COL_NAME = "name";
    public static final String FILTER_SOURCE_ID = "filterSourceId";
    public static final String ISMULTI = "isMulti";
    public static final String FILTER_MODEL = "filterModel";
    public static final String ORG_UNIT = "orgUnit";
    public static final String ONLY_MBGDIM = "onlyMbgDim";
    public static final String IS_CSL = "isCsl";
    public static final String IS_HIDE_DIMNUMBER = "isHideDimNumbeer";
    public static final String HAS_SCEN_ELEMENT = "HAS_SCEN_ELEMENT";
    public static final String OWNER = "owner";
    public static final int FILTER_ALL = 0;
    public static final int FILTER_NOINDEX = 1;
    public static final int FILTER_ONLYINEX = 2;
    private boolean isCsl = false;
    private boolean isMulti = true;
    private int filterModel = 1;
    protected boolean hasScenElement = false;
    protected boolean isHideDimNumber = false;
    protected BgSchemeDimensionHelper schemeHelper = null;
    private DimSettingDisplayInfo oneData = null;

    public void onLoad() throws Exception {
        super.onLoad();
        IRow head = this.tblMain.getHeadRow(0);
        head.getCell(COL_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"406_NewDimSelectUI"));
        this.isMulti = Boolean.TRUE.equals(this.getUIContext().get(ISMULTI));
        this.isCsl = Boolean.TRUE.equals(this.getUIContext().get(IS_CSL));
        this.isHideDimNumber = Boolean.TRUE.equals(this.getUIContext().get(IS_HIDE_DIMNUMBER));
        if (this.getUIContext().get(FILTER_MODEL) instanceof Integer) {
            this.filterModel = (Integer)this.getUIContext().get(FILTER_MODEL);
        }
        this.hasScenElement = Boolean.TRUE.equals(this.getUIContext().get(HAS_SCEN_ELEMENT));
        if (this.getUIContext().get("BGSCHEME_HELPER") instanceof BgSchemeDimensionHelper) {
            this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        }
        if (!this.isMulti) {
            this.tblMain.getSelectManager().setSelectMode(2);
            this.tblMain.checkParsed();
            this.tblMain.getColumn(COL_SELECTED).getStyleAttributes().setHided(true);
            this.btnSelectAll.setEnabled(false);
            this.btnSelectAll.setVisible(false);
        }
    }

    public void onShow() throws Exception {
        this.loadDimension();
        super.onShow();
    }

    protected boolean isIgnoreOrg() {
        return false;
    }

    protected void loadDimension() throws BOSException, EASBizException {
        String bgSchemeId = null;
        bgSchemeId = (String)this.getUIContext().get("BGSCHEME_ID");
        boolean isOnlyMbgDim = this.getUIContext().get(ONLY_MBGDIM) != null ? (Boolean)this.getUIContext().get(ONLY_MBGDIM) : false;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(COL_NAME);
        sic.add("number");
        sic.add("bgDimSettings.*");
        BgSchemeInfo bgschemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId), sic);
        if (!bgschemeInfo.getBgDimSettings().isEmpty()) {
            BgDimSettingsCollection settingColls = bgschemeInfo.getBgDimSettings();
            if (this.schemeHelper == null) {
                this.schemeHelper = new BgSchemeDimensionHelper(bgSchemeId);
            }
            settingColls.sort("seq");
            int size = settingColls.size();
            BgDimSettingsInfo settingInfo = null;
            List headDim = (List)this.getUIContext().get("headDim");
            MbgDimensionMember dimMember = (MbgDimensionMember)this.getUIContext().get("dimMember");
            for (int i = 0; i < size; ++i) {
                settingInfo = settingColls.get(i);
                if (this.isIgnoreOrg() && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(settingInfo.getDimNumber()) || (!this.hasScenElement || !DimensionConstants.DEF_SCENARIO_NUMBER.equals(settingInfo.getDimNumber()) && !DimensionConstants.DEF_ELEMENT_NUMBER.equals(settingInfo.getDimNumber())) && isOnlyMbgDim && DimensionConstants.necessary.contains(settingInfo.getDimNumber()) || !this.isCsl && DimensionConstants.DEF_CSL_NUMBER.equals(settingInfo.getDimNumber()) || null != headDim && !this.removeHeadDim(settingInfo, headDim)) continue;
                IRow row = this.tblMain.addRow();
                row.setUserObject((Object)settingInfo);
                if (null != dimMember && dimMember.getType().indexOf(settingInfo.getDimNumber()) > -1) {
                    row.getCell(COL_SELECTED).setValue((Object)Boolean.TRUE);
                } else {
                    row.getCell(COL_SELECTED).setValue((Object)Boolean.FALSE);
                }
                row.getCell(COL_NAME).setValue((Object)new DimSettingDisplayInfo(settingInfo));
            }
        }
        HashSet<String> srcNumbers = new HashSet<String>();
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                srcNumbers.add(this.data.get(i).getDimSettingInfo().getDimNumber());
            }
        }
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            DimSettingDisplayInfo source = (DimSettingDisplayInfo)this.tblMain.getCell(i, COL_NAME).getValue();
            this.tblMain.getCell(i, COL_SELECTED).setValue((Object)srcNumbers.contains(source.getDimSettingInfo().getDimNumber()));
        }
    }

    private boolean removeHeadDim(BgDimSettingsInfo settingInfo, List<String> headDim) {
        for (String dim : headDim) {
            if (!(this.isHideDimNumber ? settingInfo.getDimNumber().equals(dim) : dim.indexOf(settingInfo.getDimNumber()) > -1 || this.schemeHelper != null && this.schemeHelper.getSrcNumber(settingInfo.getDimNumber()) != null && dim.indexOf(this.schemeHelper.getSrcNumber(settingInfo.getDimNumber())) > -1)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        block9: {
            ArrayList<DimSettingDisplayInfo> newData;
            HashSet<String> srcNumbers;
            block8: {
                super.btnOk_actionPerformed(e);
                if (!this.isMulti) {
                    this.selectOne();
                    return;
                }
                HashMap<Integer, DimSettingDisplayInfo> refFields = new HashMap<Integer, DimSettingDisplayInfo>();
                srcNumbers = new HashSet<String>();
                int in = this.tblMain.getRowCount();
                for (int i = 0; i < in; ++i) {
                    IRow row = this.tblMain.getRow(i);
                    if (!Boolean.TRUE.equals(row.getCell(COL_SELECTED).getValue())) continue;
                    DimSettingDisplayInfo source = (DimSettingDisplayInfo)row.getCell(COL_NAME).getValue();
                    Integer refField = source.getDimSettingInfo().getSeq();
                    if (refFields.containsKey(refField)) {
                        throw new DimensionException(DimensionException.SELECTDIMENSIONSOURCE);
                    }
                    refFields.put(refField, source);
                    srcNumbers.add(source.getDimSettingInfo().getDimNumber());
                }
                newData = new ArrayList<DimSettingDisplayInfo>();
                if (!refFields.isEmpty()) {
                    Object[] sorted = refFields.keySet().toArray();
                    Arrays.sort(sorted);
                    for (int i = 0; i < sorted.length; ++i) {
                        newData.add((DimSettingDisplayInfo)refFields.get(sorted[i]));
                    }
                }
                if (this.data != null && !this.data.isEmpty()) break block8;
                if (newData.isEmpty()) break block9;
                this.data = newData;
                break block9;
            }
            if (this.data.size() != newData.size()) {
                this.data = newData;
            } else {
                for (int i = 0; i < this.data.size(); ++i) {
                    if (srcNumbers.contains(this.data.get(i).getDimSettingInfo().getSeq())) continue;
                    this.data = newData;
                    break;
                }
            }
        }
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    private void selectOne() {
        if (this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        this.oneData = (DimSettingDisplayInfo)row.getCell(COL_NAME).getValue();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.selectOne();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.actionExitCurrent_actionPerformed(e);
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void reShow() {
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        if (!this.isMulti) {
            return this.oneData;
        }
        return this.data;
    }

    public void dataChanged(DataChangeEvent eventObj) {
        this.data = eventObj.getNewValue() instanceof List ? (List)eventObj.getNewValue() : null;
        HashSet<String> srcNumbers = new HashSet<String>();
        if (this.data != null) {
            for (int i = 0; i < this.data.size(); ++i) {
                srcNumbers.add(this.data.get(i).getDimSettingInfo().getDimNumber());
            }
        }
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            DimSettingDisplayInfo source = (DimSettingDisplayInfo)this.tblMain.getCell(i, COL_NAME).getValue();
            this.tblMain.getCell(i, COL_SELECTED).setValue((Object)srcNumbers.contains(source.getDimSettingInfo().getDimNumber()));
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int in = this.tblMain.getRowCount();
        for (int i = 0; i < in; ++i) {
            this.tblMain.getCell(i, COL_SELECTED).setValue((Object)true);
        }
    }
}

