/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.DivSpanPanel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.client.AbstractNewLayoutDesignerUI;
import com.kingdee.eas.ma.mbg.client.ViewTemplateEditUI;
import com.kingdee.eas.ma.mbg.client.common.ComponentDragSourceForMBGView;
import com.kingdee.eas.ma.mbg.client.common.DimensionTargetSubject;
import com.kingdee.eas.ma.mbg.client.common.MbgBackgroupTextBorder;
import com.kingdee.eas.ma.mbg.client.common.PanelDropTargetForMBGView;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class NewLayoutDesignerUI
extends AbstractNewLayoutDesignerUI
implements PanelDropTargetForMBGView.IGetComponent {
    private static final long serialVersionUID = -1232157374354753494L;
    private static final Logger logger = CoreUIObject.getLogger(NewLayoutDesignerUI.class);
    private Map<String, BgDimensionInfo> dimComponentMap = new HashMap<String, BgDimensionInfo>();
    private Map<String, KDWorkButton> componentMap = new HashMap<String, KDWorkButton>();
    private DivSpanPanel dsp = new DivSpanPanel();
    private DimensionTargetSubject layoutSubject = new DimensionTargetSubject();
    ContainerListener cl = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        private void fireSpanChanged() {
            int r = NewLayoutDesignerUI.this.pnlLeftBottom.getComponentCount();
            int c = NewLayoutDesignerUI.this.pnlRightTop.getComponentCount();
            String[] rows = new String[r];
            String[] cols = new String[c];
            NewLayoutDesignerUI.this.dsp.setDiv(rows, cols);
            NewLayoutDesignerUI.this.dsp.updateUI();
        }
    };

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.enableEvents(64L);
        this.pnlSelect.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlSelect.setName(Integer.toString(5));
        this.setTextBorder((JComponent)this.pnlView, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"viewDimensionDes"));
        this.setTextBorder((JComponent)this.pnlPage, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"pageDimensionDes"));
        this.setTextBorder((JComponent)this.pnlLeftBottom, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"rowDimensionDes"));
        this.setTextBorder((JComponent)this.pnlRightTop, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"colDimensionDes"));
        this.setTextBorder((JComponent)this.pnlRightBottom, EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"dataField"));
        this.pnlPage.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlPage.setName(Integer.toString(2));
        this.pnlLeftBottom.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlLeftBottom.setName(Integer.toString(3));
        this.pnlRightTop.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlRightTop.setName(Integer.toString(4));
        this.pnlView.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlView.setName(Integer.toString(1));
        new PanelDropTargetForMBGView(this, (JPanel)this.pnlSelect, 5, this.getDimensionManager(), false);
        new PanelDropTargetForMBGView(this, (JPanel)this.pnlLeftBottom, 3, this.getDimensionManager(), false);
        new PanelDropTargetForMBGView(this, (JPanel)this.pnlRightTop, 4, this.getDimensionManager(), false);
        new PanelDropTargetForMBGView(this, (JPanel)this.pnlView, 1, this.getDimensionManager(), false);
        new PanelDropTargetForMBGView(this, (JPanel)this.pnlPage, 2, this.getDimensionManager(), false);
        this.pnlSelect.addContainerListener(this.cl);
        this.pnlLeftBottom.addContainerListener(this.cl);
        this.pnlRightTop.addContainerListener(this.cl);
        this.pnlView.addContainerListener(this.cl);
        this.pnlPage.addContainerListener(this.cl);
        this.pnlLeftTop.setLayout((LayoutManager)new BorderLayout());
        this.pnlLeftTop.add((Component)this.dsp, (Object)"Center");
    }

    protected void setTextBorder(JComponent comp, String text) {
        if (comp != null && !(comp.getBorder() instanceof MbgBackgroupTextBorder)) {
            comp.setBorder(new MbgBackgroupTextBorder(comp, text));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.curSheetTxt.setText(this.getSheetManager().getSheetName());
        IBgDimensionManager iDimensionManager = this.getDimensionManager();
        if (OprtState.ADDNEW.equals(this.getOprtState()) || iDimensionManager.getDimension().isEmpty()) {
            this.initDefaultLayoutForDiemsnionManager(iDimensionManager);
        }
        HashSet usedDiemnsionNum = new HashSet();
        this.loadDimensionsToUI(iDimensionManager, usedDiemnsionNum);
    }

    protected void loadDimensionsToUI(IBgDimensionManager iDimensionManager, Set usedDiemnsionNum) {
        this.loadLayout(iDimensionManager.getViewDimension(), this.pnlView, usedDiemnsionNum);
        this.loadLayout(iDimensionManager.getPageDimension(), this.pnlPage, usedDiemnsionNum);
        this.loadLayout(iDimensionManager.getRowDimension(), this.pnlLeftBottom, usedDiemnsionNum);
        this.loadLayout(iDimensionManager.getColDimension(), this.pnlRightTop, usedDiemnsionNum);
    }

    protected void loadLayout(List viewDimensions, KDPanel pnl, Set usedDiemnsionNum) {
        BgDimensionInfo bgDimensionInfo = null;
        for (int i = 0; i < viewDimensions.size(); ++i) {
            bgDimensionInfo = (BgDimensionInfo)viewDimensions.get(i);
            KDWorkButton btn = new KDWorkButton();
            btn.setText(bgDimensionInfo.getName());
            btn.setName(bgDimensionInfo.getNumber());
            int type = 2;
            ComponentDragSourceForMBGView.createDragSource((Component)btn, bgDimensionInfo, type);
            pnl.add((Component)btn, null);
            usedDiemnsionNum.add(bgDimensionInfo.getNumber());
            this.dimComponentMap.put(bgDimensionInfo.getNumber(), bgDimensionInfo);
            this.componentMap.put(bgDimensionInfo.getNumber(), btn);
        }
    }

    private void initDefaultLayoutForDiemsnionManager(IBgDimensionManager iDimensionManager) {
        BgSchemeDimensionHelper schemeHelper = null;
        try {
            schemeHelper = DimensionMemberSelectHelper.getSchemeHelper(this.getOwner());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            SysUtil.abort();
        }
        if (schemeHelper == null) {
            return;
        }
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER), "page");
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_CURRENCY_NUMBER), "page");
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_SCENARIO_NUMBER), "page");
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_VERSION_NUMBER), "page");
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER), "row");
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_PERIOD_NUMBER), "col");
        this.addDimension(iDimensionManager, schemeHelper.getDimension(DimensionConstants.DEF_ELEMENT_NUMBER), "col");
        List<String> others = schemeHelper.getAccAndOtherDim(true);
        Collections.sort(others);
        if (others != null && !others.isEmpty()) {
            for (int i = 0; i < others.size(); ++i) {
                this.addDimension(iDimensionManager, schemeHelper.getDimension(others.get(i)), "view");
            }
        }
    }

    private void addDimension(IBgDimensionManager dimensionManager, BgDimensionInfo bgDimensionInfo, String layout) {
        bgDimensionInfo = bgDimensionInfo.cloneValue();
        bgDimensionInfo.setDimensionManager(dimensionManager);
        bgDimensionInfo.getMember().clear();
        bgDimensionInfo.setLayout(layout);
        dimensionManager.addDimensionInfo(bgDimensionInfo);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        IBgDimensionManager iDimensionManager = this.getDimensionManager();
        iDimensionManager.getDimension().clear();
        iDimensionManager.getRowDimension().clear();
        iDimensionManager.getColDimension().clear();
        iDimensionManager.getPageDimension().clear();
        iDimensionManager.getViewDimension().clear();
        this.storeLayoutToDimensionManager(this.getRowDimensions(), "row");
        this.storeLayoutToDimensionManager(this.getColDimensions(), "col");
        this.storeLayoutToDimensionManager(this.getViewDimensions(), "view");
        this.storeLayoutToDimensionManager(this.getPageDimensions(), "page");
        this.getDimensionManager().reloadDefaultDisplayDimension();
    }

    private void storeLayoutToDimensionManager(List<BgDimensionInfo> bgDimensions, String layout) {
        BgDimensionInfo bgDimensionInfo = null;
        for (int i = 0; i < bgDimensions.size(); ++i) {
            bgDimensionInfo = bgDimensions.get(i);
            bgDimensionInfo.setLayout(layout);
            this.getDimensionManager().addDimensionInfo(bgDimensionInfo);
        }
    }

    private List<BgDimensionInfo> getViewDimensions() {
        return this.getDimension(this.pnlView);
    }

    private List<BgDimensionInfo> getPageDimensions() {
        return this.getDimension(this.pnlPage);
    }

    private List<BgDimensionInfo> getRowDimensions() {
        return this.getDimension(this.pnlLeftBottom);
    }

    private List<BgDimensionInfo> getColDimensions() {
        return this.getDimension(this.pnlRightTop);
    }

    private List<BgDimensionInfo> getAllDimensions() {
        ArrayList<BgDimensionInfo> list = new ArrayList<BgDimensionInfo>();
        list.addAll(this.getViewDimensions());
        list.addAll(this.getPageDimensions());
        list.addAll(this.getRowDimensions());
        list.addAll(this.getColDimensions());
        return list;
    }

    private List<BgDimensionInfo> getDimension(KDPanel parent) {
        ArrayList<BgDimensionInfo> hList = new ArrayList<BgDimensionInfo>();
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            if (!this.dimComponentMap.containsKey(c.getName())) continue;
            hList.add(this.dimComponentMap.get(c.getName()));
        }
        return hList;
    }

    public void verifyData() throws Exception {
        List<BgDimensionInfo> rowDimensions = this.getRowDimensions();
        if (rowDimensions == null || rowDimensions.size() == 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
        List<BgDimensionInfo> colDimensions = this.getColDimensions();
        if (colDimensions == null || colDimensions.size() == 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
    }

    public ViewTemplateEditUI getOwner() {
        return (ViewTemplateEditUI)this.getUIContext().get("Owner");
    }

    public IMbgSheetManager getSheetManager() {
        return this.getOwner().getCurMbgSheetManager();
    }

    public IBgDimensionManager getDimensionManager() {
        return this.getOwner().getCurDimensionManager();
    }

    public DimensionTargetSubject getLayoutSubject() {
        return this.layoutSubject;
    }

    public KDTextField getSheetNameTxt() {
        return this.curSheetTxt;
    }

    @Override
    public JComponent getDimensionComponent(Object dimension) {
        if (dimension instanceof BgDimensionInfo) {
            return (JComponent)this.componentMap.get(((BgDimensionInfo)dimension).getNumber());
        }
        return null;
    }
}

