/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.ma.mbg.client.AbstractProgressSynchUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.template.MBGContextManager;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProgressSynchUI
extends AbstractProgressSynchUI {
    private static final long serialVersionUID = -7838577504269882927L;
    private static final Logger logger = CoreUIObject.getLogger(ProgressSynchUI.class);
    private IUIObject uiObject = null;
    private Map<String, Object> bgDataMap = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.uiObject = (IUIObject)this.getUIContext().get("ANALYSEINFO");
    }

    public void onShow() throws Exception {
        super.onShow();
        SynchThread thread = new SynchThread();
        thread.start();
    }

    public Map<String, Object> getBgDataMap() {
        return this.bgDataMap;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
    }

    class SynchThread
    extends Thread {
        public SynchThread() {
            ProgressSynchUI.this.progressBar.setMinimum(0);
            ProgressSynchUI.this.progressBar.setMaximum(1);
            ProgressSynchUI.this.progressBar.setValue(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            if (ProgressSynchUI.this.uiObject instanceof MBGFormProcessUI) {
                MBGContextManager contextManager = (MBGContextManager)((MBGFormProcessUI)ProgressSynchUI.this.uiObject).getContextManager();
                MBGBaseFormProvider provider = (MBGBaseFormProvider)contextManager.getProvider();
                Book book = contextManager.getSpreadContext().getBook();
                if (provider != null && book != null) {
                    Map<String, Map<String, BgNViewDataInfo>> viewDataMap = null;
                    try {
                        viewDataMap = provider.getDimData(book, true, null);
                        if (viewDataMap != null) {
                            ProgressSynchUI.this.progressBar.setMaximum(viewDataMap.size());
                            for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
                                provider.fillBgDataValue(book.getSheet(sheetIndex), viewDataMap, ProgressSynchUI.this.progressBar);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ProgressSynchUI.this.handUIException(ex);
                    }
                    finally {
                        contextManager.getSpreadContext().repaint();
                    }
                }
            }
            ProgressSynchUI.this.getUIWindow().close();
        }
    }
}

