/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.AbstractProgressUI;
import com.kingdee.eas.ma.mbg.client.BgRecalculateReportUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.RecalculateObjInfo;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ProgressUI
extends AbstractProgressUI {
    private static final long serialVersionUID = 4517593707582280755L;
    private static boolean recalculateStopFlag = false;
    private Date beginTime;
    private List allBgFormInfoList;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPopProgressBar();
        ProgressUI.setRecalculateStopFlag(false);
        this.allBgFormInfoList = (List)this.getUIContext().get("allBgFormInfoList");
        this.beginTime = new Date(System.currentTimeMillis());
        MultiRecalculateThread thread = new MultiRecalculateThread(this.allBgFormInfoList);
        thread.start();
    }

    private void initPopProgressBar() {
        this.kDProgressBar1.setStringPainted(false);
        this.kDProgressBar1.setString("");
        this.kDProgressBar1.setMinimum(0);
        this.kDProgressBar1.setMaximum(100);
        this.kDProgressBar1.setIndeterminate(true);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        ProgressUI.setRecalculateStopFlag(true);
        this.destroyWindow();
    }

    public static boolean isRecalculateStopFlag() {
        return recalculateStopFlag;
    }

    public static synchronized void setRecalculateStopFlag(boolean recalculateStopFlag) {
        ProgressUI.recalculateStopFlag = recalculateStopFlag;
    }

    private void MultiTableCalculate(List bgFormInfoList) throws Exception {
        int num = bgFormInfoList.size();
        if (num == 0) {
            return;
        }
        IReport iReport = ReportFactory.getRemoteInstance();
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        for (int i = 0; i < num && !ProgressUI.isRecalculateStopFlag(); ++i) {
            RecalculateObjInfo roi = (RecalculateObjInfo)bgFormInfoList.get(i);
            if (!roi.getRecalculateResult().equals("cancel")) continue;
            BgFormInfo info = roi.getBgForm();
            info.put("myBgPeriod", info.getBgPeriod());
            if (BgTemFormTypeEnum.VIEWFORM == info.getBgTemplate().getFormType() || BgTemFormTypeEnum.VIEWLIST == info.getBgTemplate().getFormType()) continue;
            Book _book = info.getBook();
            this.reFillTables(_book, info);
            byte[] newData = iReport.backCacl((IObjectValue)info, info.getZipData());
            info.setData(newData);
            _book = IOHelper.unpackBook((byte[])newData);
            this.recoverTables(_book);
            info.setBook(_book);
            iBgForm.submit(info.getId(), (IObjectValue)info, true);
            BgFormInfo showInfo = new BgFormInfo();
            showInfo.setName(info.getName());
            showInfo.setProcessType(info.getProcessType());
            showInfo.getBgSpecialItems().addCollection(info.getBgSpecialItems());
            roi.setBgForm(showInfo);
            roi.setRecalculateResult("success");
        }
        if (!ProgressUI.isRecalculateStopFlag()) {
            this.destroyWindow();
        }
    }

    protected Map getBgDataMap(BgFormInfo bgformInfo) throws EASBizException, BOSException {
        HashSet<Integer> viewState = new HashSet<Integer>();
        viewState.add(1);
        viewState.add(9);
        viewState.add(3);
        viewState.add(5);
        viewState.add(13);
        viewState.add(11);
        String orgUnitId = bgformInfo.getOrgUnit().getId().toString();
        Map result = BgFormFactory.getRemoteInstance().getBgDataInfo(bgformInfo, viewState);
        if (result.containsKey(orgUnitId) && result.get(orgUnitId) != null) {
            return (Map)result.get(orgUnitId);
        }
        return null;
    }

    public void updateChangeValueInfo(Book _book, Map initValueMap, Map adjustMap) {
        if (_book == null || initValueMap == null || adjustMap == null || initValueMap.isEmpty() || adjustMap.isEmpty()) {
            return;
        }
        Sheet _sheet = null;
        int size = _book.getSheetCount();
        for (int index = 0; index < size; ++index) {
            _sheet = _book.getSheet(index);
            this.updateSheetChangeValueInfo(initValueMap, adjustMap, _sheet);
        }
    }

    private void updateSheetChangeValueInfo(Map initValueMap, Map adjustMap, Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Cell _cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                _cell = sheet.getCell(rowIndex, colIndex, false);
                this.updateCellChangeValueInfo(initValueMap, adjustMap, _cell);
            }
        }
    }

    private void updateCellChangeValueInfo(Map initValueMap, Map adjustMap, Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            BigDecimal _oldValue = null;
            String _formulaStr = null;
            _formulaStr = BgNFSHelper.getFormulaOfCell(cell);
            _obj = BgNFSHelper.getValue(cell);
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue(cell, BgNConstants.ZERO);
                    _newValue = BgNConstants.ZERO;
                }
            }
            if (initValueMap.containsKey(_formulaStr)) {
                _oldValue = (BigDecimal)initValueMap.get(_formulaStr);
                if (_newValue.compareTo(_oldValue) != 0) {
                    if (adjustMap.containsKey(_formulaStr)) {
                        this.updateDivInfo(cell, _formulaStr, _newValue, adjustMap);
                    } else {
                        this.createDivInfo(cell, _formulaStr, _newValue, _oldValue, adjustMap);
                    }
                } else {
                    this.removeDivInfo(cell, _formulaStr, adjustMap);
                }
            }
        }
    }

    private void removeDivInfo(Cell cell, String formulaStr, Map adjustMap) {
        adjustMap.remove(formulaStr);
        BgNFSHelper.setBackGroup(cell, BgNConstants.BASE_COLOR);
    }

    private void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue, Map adjustMap) {
        BgFormDiversityData divData = new BgFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustor(this.getUserPk().toString());
        divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        adjustMap.put(formulaStr, divData);
        BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
    }

    private void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, Map adjustMap) {
        BgFormDiversityData divData = (BgFormDiversityData)adjustMap.get(formulaStr);
        if (divData != null) {
            divData.setNewValue(newValue);
            divData.setAdjustor(this.getUserPk().toString());
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        }
        BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
    }

    private void reFillTables(Book book, BgFormInfo info) throws Exception {
        Map bgDataMap = this.getBgDataMap(info);
        HashSet<String> actScenarios = new HashSet<String>();
        List scenarios = BgScenarioHelper.getAcScenario();
        for (BgScenarioInfo scenario : scenarios) {
            actScenarios.add(scenario.getNumber());
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        int tableSize = book.getSheetCount();
        for (int tableIndex = 0; tableIndex < tableSize; ++tableIndex) {
            Sheet sheet = book.getSheet(tableIndex);
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            for (int r = 0; r <= rowCount; ++r) {
                for (int c = 0; c <= colCount; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || bgDataMap == null || bgDataMap.isEmpty()) continue;
                    String formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    String dimkey = DimUtils.getDimDataKey(formulaStr, info.getBgVersion().getNumber());
                    if (StringUtils.isEmpty((String)formulaStr) || !bgDataMap.containsKey(dimkey) || bgDataMap.get(dimkey) == null) continue;
                    try {
                        if (actScenarios.contains(((IBgNData)bgDataMap.get(dimkey)).getBgScenario())) {
                            BgNFSHelper.setValue(cell, ((IBgNData)bgDataMap.get(dimkey)).getBizActual());
                            continue;
                        }
                        if (((IBgNData)bgDataMap.get(dimkey)).getAdjustValue() != null) {
                            BgNFSHelper.setValue(cell, ((IBgNData)bgDataMap.get(dimkey)).getAdjustValue());
                            continue;
                        }
                        BgNFSHelper.setValue(cell, ((IBgNData)bgDataMap.get(dimkey)).getBudgetValue());
                        continue;
                    }
                    catch (Exception ex) {
                        BgNFSHelper.setValue(cell, BgNConstants.ZERO);
                    }
                }
            }
        }
        info.setBook(book);
    }

    private void recoverTables(Book book) {
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        int tableSize = book.getSheetCount();
        for (int tableIndex = 0; tableIndex < tableSize; ++tableIndex) {
            Sheet sheet = book.getSheet(tableIndex);
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            for (int r = 0; r <= rowCount; ++r) {
                for (int c = 0; c <= colCount; ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    if (cell == null || !cell.hasFormula() || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    try {
                        Object obj = BgNFSHelper.getValue(cell);
                        BgNFSHelper.setBudgetValue(cell, new BigDecimal(obj.toString()));
                        continue;
                    }
                    catch (Exception ex) {
                        BgNFSHelper.setBudgetValue(cell, BgNConstants.ZERO);
                    }
                }
            }
        }
    }

    private void createReportUI(List bgFormList) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("bgFormList", bgFormList);
        ctx.put("beginTime", this.beginTime.toLocaleString());
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(BgRecalculateReportUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException e) {
            ProgressUI.setRecalculateStopFlag(true);
            this.destroyWindow();
        }
    }

    public boolean destroyWindow() {
        BgNFCHelper.refreshListUI(this);
        return super.destroyWindow();
    }

    public List getAllBgFormInfoList() {
        return this.allBgFormInfoList;
    }

    private class MultiRecalculateThread
    extends Thread {
        private List allBgFormInfoList;

        public MultiRecalculateThread(List allBgFormInfoList) {
            this.allBgFormInfoList = allBgFormInfoList;
        }

        @Override
        public void run() {
            try {
                ProgressUI.this.MultiTableCalculate(this.allBgFormInfoList);
            }
            catch (Exception e) {
                ProgressUI.setRecalculateStopFlag(true);
                ProgressUI.this.destroyWindow();
            }
        }
    }

    private class CreateReportUIThread
    extends Thread {
        private CreateReportUIThread() {
        }

        @Override
        public void run() {
            ProgressUI.this.createReportUI(ProgressUI.this.allBgFormInfoList);
        }
    }
}

