/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.QingAnalyseFunctionLabel;
import com.kingdee.eas.ma.mbg.client.utils.MbgQingAnalyseUtils;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;

public class QingAnalyseFunctionPanel
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private static final int BUTTON_WIDHT = 110;
    private static final int BUTTON_HEIGHT = 110;
    KDPanel pnlAnalyse;
    private boolean isMousePressed;
    private BgSchemeInfo schemeInfo;
    private CoreUI ui;
    private OrgUnitInfo orgUnitInfo;
    QingAnalyseFunctionLabel currentLabel;
    List<MbgQingAnalyseInfo> cacheList;

    public CoreUI getUi() {
        return this.ui;
    }

    public void setUi(CoreUI ui) {
        this.ui = ui;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public void setOrgUnitInfo(OrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public BgSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(BgSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    public QingAnalyseFunctionLabel getCurrentLabel() {
        return this.currentLabel;
    }

    public void setCurrentLabel(QingAnalyseFunctionLabel currentLabel) {
        this.currentLabel = currentLabel;
    }

    public List<MbgQingAnalyseInfo> getCacheList() {
        return this.cacheList;
    }

    public void setCacheList(List<MbgQingAnalyseInfo> cacheList) {
        this.cacheList = cacheList;
    }

    public QingAnalyseFunctionPanel(KDPanel parentPnl, List<MbgQingAnalyseInfo> list) {
        this.pnlAnalyse = parentPnl;
        this.setLayout(new FlowLayout(0));
        this.cacheList = list;
    }

    public void load() {
        this.currentLabel = null;
        this.addFunctionLabel();
    }

    public void addFunctionLabel() {
        if (this.cacheList != null && !this.cacheList.isEmpty()) {
            for (MbgQingAnalyseInfo info : this.cacheList) {
                QingAnalyseFunctionLabel label = new QingAnalyseFunctionLabel(info, false);
                label.setPreferredSize(new Dimension(110, 110));
                this.installListener(label);
                this.add((Component)((Object)label));
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void installListener(QingAnalyseFunctionLabel analyseLabel) {
        analyseLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        analyseLabel.addMouseListener(new FunctionMouseListener());
    }

    private void newMousePressed(MouseEvent e) {
        QingAnalyseFunctionLabel thisButton = (QingAnalyseFunctionLabel)((Object)e.getSource());
        this.setCurrentLabelCustomerStatus();
        this.isMousePressed = true;
        this.currentLabel = thisButton;
        this.setStatusByMouseSelected(thisButton);
        thisButton.repaint();
    }

    public void newMouseExited(MouseEvent e) {
        QingAnalyseFunctionLabel thislabel = (QingAnalyseFunctionLabel)((Object)e.getSource());
        if (!thislabel.isMousePressed()) {
            thislabel.setInColor(null);
            thislabel.repaint();
        }
    }

    public void newMouseEntered(MouseEvent e) {
        QingAnalyseFunctionLabel thisLabel = (QingAnalyseFunctionLabel)((Object)e.getSource());
        if (!thisLabel.isMousePressed() && !this.isMousePressed) {
            this.setStatusByMouseEntered(thisLabel);
            thisLabel.repaint();
        }
    }

    private void setStatusByMouseEntered(QingAnalyseFunctionLabel label) {
        label.setInColor(Color.decode("#F7F7F7"));
        label.setBorderColor(Color.decode("#C8C8C8"));
        label.setBorderWidth(1.0f);
    }

    private void newMouseClicked1(MouseEvent e) {
        QingAnalyseFunctionLabel thisLabel = (QingAnalyseFunctionLabel)((Object)e.getSource());
        thisLabel.requestFocus();
    }

    private void setCurrentLabelCustomerStatus() {
        if (this.currentLabel != null) {
            this.setCustomStatus(this.currentLabel);
            this.currentLabel.repaint();
            this.isMousePressed = false;
            this.currentLabel = null;
        }
    }

    private void setCustomStatus(QingAnalyseFunctionLabel label) {
        label.setInColor(null);
        label.setBorderColor(null);
        label.setMousePressed(false);
        label.setOpen(false);
    }

    private void setStatusByMouseSelected(QingAnalyseFunctionLabel label) {
        label.setMousePressed(true);
        label.setInColor(Color.decode("#FFFDEF"));
        label.setBorderColor(Color.decode("#C8C8C8"));
    }

    public String getPermissionNum() {
        return "mbg_qingAnalyse06_analyse";
    }

    class FunctionMouseListener
    extends MouseAdapter {
        FunctionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                if (e.getClickCount() == 1) {
                    QingAnalyseFunctionPanel.this.newMouseClicked1(e);
                }
                if (e.getClickCount() == 2) {
                    try {
                        BgPermissionUtil.checkPermission((String)QingAnalyseFunctionPanel.this.getPermissionNum());
                        String analyseId = QingAnalyseFunctionPanel.this.currentLabel.getMenu().getId().toString();
                        boolean flag = MbgQingAnalyseUtils.verifyAnalyse(MbgQingAnalyseFactory.getRemoteInstance(), analyseId, QingAnalyseFunctionPanel.this.orgUnitInfo, QingAnalyseFunctionPanel.this.getSchemeInfo());
                        if (!flag) {
                            MsgBox.showInfo((Component)QingAnalyseFunctionPanel.this.ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"cannotAnalyse"));
                            return;
                        }
                        MbgQingAnalyseFacadeFactory.getRemoteInstance().checkQingFilesIsEmpty(QingAnalyseFunctionPanel.this.getSchemeInfo(), QingAnalyseFunctionPanel.this.orgUnitInfo.getId().toString());
                        MbgQingAnalyseHelper.analyse(QingAnalyseFunctionPanel.this.ui, QingAnalyseFunctionPanel.this.currentLabel.getMenu(), QingAnalyseFunctionPanel.this.getOrgUnitInfo());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        QingAnalyseFunctionPanel.this.ui.handUIExceptionAndAbort(ex);
                    }
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            QingAnalyseFunctionPanel.this.newMouseExited(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            QingAnalyseFunctionPanel.this.newMouseEntered(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            QingAnalyseFunctionPanel.this.newMousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            QingAnalyseFunctionPanel.this.isMousePressed = false;
        }
    }
}

