/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IRollRule;
import com.kingdee.eas.ma.mbg.IRollTemplate;
import com.kingdee.eas.ma.mbg.RollRuleFactory;
import com.kingdee.eas.ma.mbg.RollTemplateFactory;
import com.kingdee.eas.ma.mbg.RollTemplateInfo;
import com.kingdee.eas.ma.mbg.client.AbstractRollTemplateEditUI;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class RollTemplateEditUI
extends AbstractRollTemplateEditUI {
    private static final long serialVersionUID = -2133391076306840503L;
    private static final Logger logger = CoreUIObject.getLogger(RollTemplateEditUI.class);
    private CostCenterOrgUnitInfo cost = null;

    public void onLoad() throws Exception {
        this.cost = DimensionFilterHelper.queryCostCenter(null, ((OrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO)).getId().toString());
        super.onLoad();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        this.prmtType.setEntityViewInfo(evi);
        this.prmtBgTemplate.setSelectorCollection(new SelectorItemCollection());
        this.prmtBgTemplate.getSelectorCollection().add("id");
        this.prmtBgTemplate.getSelectorCollection().add("number");
        this.prmtBgTemplate.getSelectorCollection().add("name");
        this.prmtBgTemplate.getSelectorCollection().add("bgType.id");
        this.prmtBgTemplate.getSelectorCollection().add("bgType.number");
        this.prmtBgTemplate.getSelectorCollection().add("bgType.name");
        this.setBgTemplateFilter();
        EntityViewInfo view = this.prmtActDataScenario.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtActDataScenario.setEntityViewInfo(view);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            ObjectUuidPK pk = new ObjectUuidPK("cvEAAAAp7mlPzqsX");
            try {
                IRollRule server = RollRuleFactory.getRemoteInstance();
                DataBaseInfo dataBaseInfo = server.getDataBaseInfo((IObjectPK)pk);
                this.prmtRollRule.setData((Object)dataBaseInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.prmtBgTemplate.getData() == null || this.prmtRollRule.getData() == null || this.prmtActDataScenario.getData() == null) {
            throw new BgRollException(BgRollException.NOTNULL);
        }
    }

    @Override
    protected void prmtType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtType_dataChanged(e);
        this.synName(this.prmtType, this.txtBgTypeName);
        this.setBgTemplateFilter();
        if (e != null && e.getNewValue() != e.getOldValue()) {
            this.prmtBgTemplate.setData(null);
            this.txtBgTemplateName.setText("");
        }
    }

    public void synName(KDBizPromptBox prmt, KDTextField txt) {
        if (prmt.getData() instanceof IObjectValue) {
            txt.setText(((IObjectValue)prmt.getData()).getString("name"));
        } else {
            txt.setText("");
        }
    }

    protected void setBgTemplateFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id = root.Id"));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("formType", (Object)4));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.cost.getId().toString(), CompareType.EQUALS));
        if (this.prmtType.getData() instanceof BgTypeInfo) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgType.id", (Object)((BgTypeInfo)this.prmtType.getData()).getId().toString(), CompareType.EQUALS));
        }
        this.prmtBgTemplate.setEntityViewInfo(evi);
    }

    @Override
    protected void prmtBgTemplate_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgTemplate_dataChanged(e);
        this.synName(this.prmtBgTemplate, this.txtBgTemplateName);
        BgTypeInfo bgType = null;
        if (this.prmtBgTemplate.getData() instanceof BgTemplateInfo) {
            bgType = ((BgTemplateInfo)this.prmtBgTemplate.getData()).getBgType();
            this.prmtType.setDataNoNotify((Object)bgType);
        }
    }

    @Override
    protected void prmtRollRule_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtRollRule_dataChanged(e);
        this.synName(this.prmtRollRule, this.txtRollRuleName);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("bgTemplate.bgType.number");
        sic.add("bgTemplate.bgType.name");
        sic.add("bgTemplate.bgType.id");
        return sic;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IRollTemplate rollrule = RollTemplateFactory.getRemoteInstance();
        String id = this.editData.getId().toString();
        if (id == null) {
            return;
        }
        if (rollrule.isQuotedByBgForm(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.RollRuleResource", (String)"isQuotedByFormUnEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRollTemplate rollrule = RollTemplateFactory.getRemoteInstance();
        String id = this.editData.getId().toString();
        if (id == null) {
            return;
        }
        if (rollrule.isQuotedByBgForm(id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.RollRuleResource", (String)"isQuotedByFormUnDelete"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        RollTemplateInfo info = new RollTemplateInfo();
        info.setCU(this.cost.getCU());
        info.setOrgUnit(this.cost);
        info.setCreateTime(now);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(now);
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RollTemplateFactory.getRemoteInstance();
    }
}

