/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class SpecialWizzardIO
extends WizzardIO {
    private static final Logger logger = CoreUIObject.getLogger(SpecialWizzardIO.class);
    private static final String RESOURCE = "com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource";
    protected BgSchemeDimensionHelper bgSchemeHelper = null;
    protected BgTemplateInfo bgTemplate = null;
    private File file = new File(System.getProperty("user.dir") + "\\export.properties");
    private final SimpleFileFilter Filter_PDF = new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_HTML = new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page"));
    private final SimpleFileFilter Filter_Excel2003 = new SimpleFileFilter("xls", "MS Excel2003" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_Excel2007 = new SimpleFileFilter("xlsx", "MS Excel2007" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_KDF = new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_XML = new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table"));

    public BgSchemeDimensionHelper getBgSchemeHelper() {
        return this.bgSchemeHelper;
    }

    public BgTemplateInfo getBgTemplate() {
        return this.bgTemplate;
    }

    public SpecialWizzardIO(Dialog parent, SpreadContext context, BgSchemeDimensionHelper bgSchemeHelper, BgTemplateInfo bgTemplate) {
        super(parent, context);
        this.bgSchemeHelper = bgSchemeHelper;
        this.bgTemplate = bgTemplate;
    }

    public SpecialWizzardIO(Frame parent, SpreadContext context, BgSchemeDimensionHelper bgSchemeHelper, BgTemplateInfo bgTemplate) {
        super(parent, context);
        this.bgSchemeHelper = bgSchemeHelper;
        this.bgTemplate = bgTemplate;
    }

    protected boolean checkBgSpeciaItems(Book book) throws BOSException {
        UserObject obj = book.getUserObject("bgSpecialItems");
        if (obj == null) {
            return false;
        }
        List importItemList = (List)obj.getValue();
        Map importItemMap = (Map)importItemList.get(0);
        BgSpecialItemsInfo importItem = new BgSpecialItemsInfo();
        importItem.setDimensionNumber((String)importItemMap.get("dimensionNumber"));
        importItem.setDimensionName((String)importItemMap.get("dimensionName"));
        importItem.setMemberName(importItemMap.get("memberName").toString());
        importItem.setMemberDisplayName((String)importItemMap.get("memberDisplayName"));
        List<? extends BgDimensionBaseInfo> importDims = BgSpecialBudgetHelper.getBgDimensionsBySpecialItems(importItem, this.getBgSchemeHelper());
        HashMap<String, BgDimensionBaseInfo> importMap = new HashMap<String, BgDimensionBaseInfo>();
        for (BgDimensionBaseInfo bgDimensionBaseInfo : importDims) {
            importMap.put(bgDimensionBaseInfo.getNumber(), bgDimensionBaseInfo);
        }
        List<? extends BgDimensionBaseInfo> specialDims = BgSpecialBudgetHelper.getBgDimensionsByTemplate(null, this.getBgTemplate(), this.getBgSchemeHelper());
        HashMap<String, BgDimensionBaseInfo> hashMap = new HashMap<String, BgDimensionBaseInfo>();
        for (BgDimensionBaseInfo bgDimensionBaseInfo : specialDims) {
            hashMap.put(bgDimensionBaseInfo.getNumber(), bgDimensionBaseInfo);
        }
        if (importMap.size() != hashMap.size()) {
            return false;
        }
        if (!importMap.keySet().containsAll(hashMap.keySet())) {
            return false;
        }
        for (String string : importMap.keySet()) {
            BgDimensionBaseInfo importDim = (BgDimensionBaseInfo)importMap.get(string);
            BgDimensionBaseInfo specialDim = (BgDimensionBaseInfo)hashMap.get(string);
            if (importDim.getMember().size() != specialDim.getMember().size()) {
                return false;
            }
            if (importDim.getMember().size() == 0 || ((BgDimensionMember)importDim.getMember().get(0)).getNumber().equals(((BgDimensionMember)specialDim.getMember().get(0)).getNumber())) continue;
            return false;
        }
        return true;
    }

    protected void overWriteImport() {
        String clzNameStr = "com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO$SheetListPanel";
        String filedNameStr = "_book";
        Class<?> pnlClz = null;
        Field bookField = null;
        Class<?>[] clz = WizzardIO.class.getDeclaredClasses();
        for (int i = 0; i < clz.length; ++i) {
            if (!clz[i].getName().equals(clzNameStr)) continue;
            pnlClz = clz[i];
            break;
        }
        if (pnlClz != null) {
            Field[] fields = null;
            fields = pnlClz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(filedNameStr)) continue;
                bookField = fields[i];
                break;
            }
        }
        if (bookField != null) {
            Book book = null;
            bookField.setAccessible(true);
            try {
                book = (Book)bookField.get(this._pnlSheet);
                if (!this.checkBgSpeciaItems(book)) {
                    MsgBox.showInfo((Component)((Object)this), (String)com.kingdee.bos.util.EASResource.getString((String)RESOURCE, (String)"specialitem.unmatch"));
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
            super.overWriteImport();
        }
    }

    public boolean prepare() {
        boolean prepare = super.prepare();
        if (this._isForImport) {
            this.setDefaultFilePath();
        }
        return prepare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultFilePath() {
        InputStream is = null;
        try {
            if (this.file.exists()) {
                Properties properties = new Properties();
                is = new FileInputStream(this.file);
                properties.load(is);
                String value = properties.getProperty("exportPath");
                if (!StringUtils.isEmpty((String)value)) {
                    File tmp = new File(value);
                    String path = tmp.getParent();
                    String filename = tmp.getName();
                    String fileType = filename.substring(filename.lastIndexOf(".") + 1);
                    if ("xml".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
                    } else if ("xls".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_Excel2003);
                    } else if ("xlsx".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_Excel2007);
                    } else if ("pdf".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_PDF);
                    } else if ("htm".equalsIgnoreCase(fileType) || "html".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_HTML);
                    }
                    String separator = File.separator;
                    this._chsFile.setSelectedFile(new File(tmp.getPath()));
                }
            } else {
                File file = this._chsFile.getCurrentDirectory();
                if (file != null) {
                    file = new File(file.getPath());
                    this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
                    this._chsFile.setSelectedFile(file);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }
}

