/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.UserGroupFactory;
import com.kingdee.eas.ma.mbg.UserGroupInfo;
import com.kingdee.eas.ma.mbg.UserGroupRefFactory;
import com.kingdee.eas.ma.mbg.UserGroupRefInfo;
import com.kingdee.eas.ma.mbg.client.AbstractUserGroupEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserGroupEditUI
extends AbstractUserGroupEditUI {
    private static final long serialVersionUID = 8560911256365790916L;
    private static final Logger logger = CoreUIObject.getLogger(UserGroupEditUI.class);
    private final String RES = "com.kingdee.eas.ma.mbg.MbgPermissionResource";
    private static final String COL_ID = "id";
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_ORG_NAME = "defOrgUnit.name";
    private Set<String> chooseIDs = new HashSet<String>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initHead();
        this.initTable();
    }

    private void initHead() {
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRm.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRmAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.txtSearch.setBackground(new Color(7645403));
    }

    protected void initTable() throws BOSException {
        this.tblUser.checkParsed();
        this.tblUser.setEditable(false);
        this.tblUser.getSelectManager().setSelectMode(10);
        this.tblChooseUser.checkParsed();
        this.tblChooseUser.setEditable(false);
        this.tblChooseUser.getSelectManager().setSelectMode(10);
        this.loadUserData(this.tblUser);
    }

    protected void loadUserData(final KDTable tblUser) throws BOSException {
        tblUser.getDataRequestManager().putBindContents(COL_ID, "mainQuery", COL_ID);
        tblUser.getDataRequestManager().putBindContents(COL_NUMBER, "mainQuery", COL_NUMBER);
        tblUser.getDataRequestManager().putBindContents(COL_NAME, "mainQuery", COL_NAME);
        tblUser.getDataRequestManager().putBindContents(COL_ORG_NAME, "mainQuery", COL_ORG_NAME);
        tblUser.getDataRequestManager().setDataRequestMode(1);
        UserGroupEditUI.removeRequestDataListener(tblUser);
        tblUser.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(UserGroupEditUI.COL_ID);
                    sic.add(UserGroupEditUI.COL_NUMBER);
                    sic.add(UserGroupEditUI.COL_NAME);
                    sic.add(UserGroupEditUI.COL_ORG_NAME);
                    viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                    viewInfo.setSorter(new SorterItemCollection());
                    SorterItemInfo sortItem = new SorterItemInfo(UserGroupEditUI.COL_NUMBER);
                    viewInfo.getSorter().add(sortItem);
                    sortItem.setSortType(SortType.ASCEND);
                    FilterInfo filter = new FilterInfo();
                    viewInfo.setFilter(filter);
                    String searchStr = UserGroupEditUI.this.txtSearch.getText().trim();
                    if (!StringUtils.isEmpty((String)searchStr)) {
                        filter.getFilterItems().add(new FilterItemInfo(UserGroupEditUI.COL_NUMBER, (Object)("%" + searchStr + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo(UserGroupEditUI.COL_NAME, (Object)("%" + searchStr + "%"), CompareType.LIKE));
                        String maskString = "(#0 or #1)";
                        filter.setMaskString(maskString);
                    }
                    filter.getFilterItems().add(new FilterItemInfo(UserGroupEditUI.COL_NUMBER, (Object)"administrator", CompareType.NOTEQUALS));
                    if (filter.getFilterItems().size() > 1) {
                        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                    } else {
                        filter.setMaskString(" #0 ");
                    }
                    CtrlUnitInfo ctrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
                    filter.getFilterItems().add(new FilterItemInfo("defOrgUnit.id", (Object)ctrlUnit.getId().toString(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("defOrgUnit.longnumber", (Object)(ctrlUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    if (filter.getFilterItems().size() <= 2) {
                        filter.setMaskString("( #0 or #1 )");
                    } else {
                        filter.setMaskString(filter.getMaskString() + " and ( #" + (filter.getFilterItems().size() - 2) + " or #" + (filter.getFilterItems().size() - 1) + " )");
                    }
                    EntityObjectInfo entity = BgEntityUtil.getEntity((BOSObjectType)new UserInfo().getBOSType());
                    IDataProvider mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
                    mainExec.setObjectView(viewInfo);
                    Uuid queryId = mainExec.openQuery();
                    List allIdList = mainExec.getQueryKeys(queryId);
                    mainExec.option().isAutoTranslateEnum = true;
                    mainExec.option().pageCount = tblUser.getDataRequestManager().getPageRowCount();
                    int start = (Integer)e.getParam1();
                    int length = (Integer)e.getParam2() - start + 1;
                    IRowSet res = mainExec.executeQuery(queryId, start, length);
                    e.setRowSet(res);
                    tblUser.setRowCount(allIdList.size());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        tblUser.checkParsed();
        tblUser.removeRows();
    }

    public static void removeRequestDataListener(KDTable kdTable) {
        DataSetWrapperFactory dataSetFactory = kdTable.getDataRequestManager().getDataSetFactory();
        EventListener[] listener = dataSetFactory.getRequestRowSetListeners();
        for (int i = 0; i < listener.length; ++i) {
            dataSetFactory.removeRequestRowSetListener((RequestRowSetListener)listener[i]);
        }
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        this.tblUser.removeRows();
    }

    protected void addRow(List<Integer> rows) throws Exception {
        if (rows == null) {
            return;
        }
        IRow row = null;
        IRow addRow = null;
        for (Integer rowIndex : rows) {
            row = this.tblUser.getRow(rowIndex.intValue());
            String id = (String)row.getCell(COL_ID).getValue();
            String number = (String)row.getCell(COL_NUMBER).getValue();
            String name = (String)row.getCell(COL_NAME).getValue();
            String orgName = (String)row.getCell(COL_ORG_NAME).getValue();
            if (this.chooseIDs.contains(id)) continue;
            this.chooseIDs.add(id);
            addRow = this.tblChooseUser.addRow();
            addRow.getCell(COL_ID).setValue((Object)id);
            addRow.getCell(COL_NUMBER).setValue((Object)number);
            addRow.getCell(COL_NAME).setValue((Object)name);
            addRow.getCell(COL_ORG_NAME).setValue((Object)orgName);
        }
    }

    protected void removeRow(List<Integer> rows) throws Exception {
        if (rows == null) {
            return;
        }
        IRow row = null;
        Collections.sort(rows, (Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        });
        for (Integer rowIndex : rows) {
            row = this.tblChooseUser.getRow(rowIndex.intValue());
            String id = (String)row.getCell(COL_ID).getValue();
            this.chooseIDs.remove(id);
            this.tblChooseUser.removeRow(rowIndex.intValue());
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        this.tblUser.removeRows();
    }

    @Override
    protected void tblUser_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 2) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            rows.add(new Integer(this.tblUser.getSelectManager().getActiveRowIndex()));
            this.addRow(rows);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblUser);
        this.addRow(rows);
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        Integer allRowCount = this.tblUser.getRowCount1();
        for (int rowIndex = 0; rowIndex < allRowCount && this.tblUser.getRow(rowIndex) != null; ++rowIndex) {
            rows.add(rowIndex);
        }
        this.addRow(rows);
    }

    @Override
    protected void btnRm_actionPerformed(ActionEvent e) throws Exception {
        List rows = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblChooseUser);
        this.removeRow(rows);
    }

    @Override
    protected void btnRmAll_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        Integer allRowCount = this.tblChooseUser.getRowCount3();
        for (int rowIndex = 0; rowIndex < allRowCount; ++rowIndex) {
            if (this.tblChooseUser.getRow(rowIndex) == null) continue;
            rows.add(rowIndex);
        }
        this.removeRow(rows);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.chooseIDs.clear();
            this.tblChooseUser.removeRows();
            this.txtSearch.setText(null);
            this.tblUser.refresh();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        HashSet<String> userids = (HashSet<String>)this.editData.get("userIDs");
        if (userids == null) {
            userids = new HashSet<String>();
        } else {
            userids.clear();
        }
        userids.addAll(this.chooseIDs);
        this.editData.put("userIDs", userids);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        HashSet<String> userIDs = new HashSet<String>();
        this.editData.put("userids", userIDs);
        if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            String id = this.editData.getId().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("userGroup.id", (Object)id, CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo(COL_ID));
            selector.add(new SelectorItemInfo("user.id"));
            selector.add(new SelectorItemInfo("user.number"));
            selector.add(new SelectorItemInfo("user.name"));
            selector.add(new SelectorItemInfo("user.defOrgUnit.name"));
            view.setSelector(selector);
            CoreBaseCollection colls = null;
            try {
                colls = UserGroupRefFactory.getRemoteInstance().getCollection(view);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            ArrayList<UserInfo> userList = new ArrayList<UserInfo>();
            if (colls != null && colls.size() > 0) {
                for (int i = 0; i < colls.size(); ++i) {
                    UserInfo user = ((UserGroupRefInfo)colls.get(i)).getUser();
                    userIDs.add(user.getId().toString());
                    userList.add(user);
                }
            }
            this.chooseIDs.addAll(userIDs);
            this.fillTableData(userList);
        }
    }

    protected void fillTableData(List<UserInfo> userList) {
        if (userList == null) {
            return;
        }
        Collections.sort(userList, (Comparator)new Comparator<UserInfo>(){

            @Override
            public int compare(UserInfo o1, UserInfo o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        this.tblChooseUser.checkParsed();
        this.tblChooseUser.removeRows();
        IRow row = null;
        for (UserInfo user : userList) {
            row = this.tblChooseUser.addRow();
            row.getCell(COL_ID).setValue((Object)user.getId().toString());
            row.getCell(COL_NUMBER).setValue((Object)user.getNumber());
            row.getCell(COL_NAME).setValue((Object)user.getName());
            row.getCell(COL_ORG_NAME).setValue((Object)user.getDefOrgUnit().getName());
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgPermissionResource", (String)"nullGroupNumber"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgPermissionResource", (String)"nullGroupName"));
            SysUtil.abort();
        }
        if (this.chooseIDs != null && this.chooseIDs.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgPermissionResource", (String)"nullChooseUser"));
            SysUtil.abort();
        }
    }

    public boolean isModify() {
        Set oldUserIDS = (Set)this.editData.get("userids");
        if (this.getOprtState().equals(OprtState.EDIT) && oldUserIDS != null) {
            return oldUserIDS.size() != this.chooseIDs.size() || !oldUserIDS.containsAll(this.chooseIDs) || super.isModify();
        }
        return super.isModify();
    }

    protected IObjectValue createNewData() {
        UserGroupInfo userGroup = new UserGroupInfo();
        userGroup.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        userGroup.setOrgUnit(SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        return userGroup;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void onShow() throws Exception {
        super.onShow();
    }
}

