/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodVariable;
import com.kingdee.eas.ma.mbg.BgCustomerParamsFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgVersionCopyWayEnum;
import com.kingdee.eas.ma.mbg.BgVersionFormStateEnum;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgCustomerParamsFacade;
import com.kingdee.eas.ma.mbg.IVersionCopy;
import com.kingdee.eas.ma.mbg.VersionCopyBgOrgUnitNodeInfo;
import com.kingdee.eas.ma.mbg.VersionCopyBgPeriodNodeInfo;
import com.kingdee.eas.ma.mbg.VersionCopyBgScenarioNodeInfo;
import com.kingdee.eas.ma.mbg.VersionCopyFactory;
import com.kingdee.eas.ma.mbg.VersionCopyFilterParam;
import com.kingdee.eas.ma.mbg.VersionCopyInfo;
import com.kingdee.eas.ma.mbg.client.AbstractVersionCopyEditUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.common.BgViewOrgDimensionF7;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.VersionCopyClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class VersionCopyEditUI
extends AbstractVersionCopyEditUI {
    private static final long serialVersionUID = -2577133834938359444L;
    private static final Logger logger = CoreUIObject.getLogger(VersionCopyEditUI.class);
    private final Map<String, VersionCopyBgPeriodNodeInfo> bgPeriodNodes = new HashMap<String, VersionCopyBgPeriodNodeInfo>();
    private final Map<String, VersionCopyBgScenarioNodeInfo> bgScenarioNodes = new HashMap<String, VersionCopyBgScenarioNodeInfo>();
    private final Map<String, VersionCopyBgOrgUnitNodeInfo> bgOrgUnitNodes = new HashMap<String, VersionCopyBgOrgUnitNodeInfo>();
    protected CostCenterOrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentCostUnit();
    private BgPeriodDialog periodDialog = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private String BG_SCHEME_ID = "BG_SCHEME_ID";
    private String BG_PERIOD_IDS = "BG_PERIOD_IDS";
    private String BG_PERIOD_NUMBERS = "BG_PERIOD_NUMBERS";
    private String BG_PERIOD_MUTI = "BG_PERIOD_MUTI";
    private String BG_SCENARIO_IDS = "BG_SCENARIO_IDS";
    private String BG_STANDTARDPERIOD_ID = "BG_STANDTARD_ID ";
    private String BG_SOURCEVERSION_ID = "BG_SOURCEVERSION_ID ";
    private String BG_TARGETVERSION_ID = "BG_TARGETVERSION_ID ";
    private String BG_ORGUNIT_IDS = "BG_ORGUNIT_IDS";
    private String BG_UPDATEEXISTSDATA_ID = "BG_UPDATEEXISTSDATA_ID ";
    private static final String BG_LEAVEFORMSTATE_ID = "BG_LEAVEFORMSTATE_ID";
    private static final String BG_FROMFORMSTATE_ID = "BG_FROMFORMSTATE_ID";
    private String BG_RETAINUSER_ID = "BG_RETAINUSER_ID ";
    private BgSchemeInfo bgschemeInfo = null;
    private CostCenterOrgUnitInfo costCenter = null;
    private String bgSchemeID = null;
    private Set<String> bgPeriodTypeNumbers = null;
    protected CoreUI owner = null;

    public VersionCopyEditUI() throws Exception {
        this.editData = (VersionCopyInfo)this.createNewData();
        this.dataBinder.setValueObject((IObjectValue)this.editData);
    }

    public void setCostCenterOrgUnitInfo(CostCenterOrgUnitInfo costCenter) {
        this.costCenter = costCenter;
    }

    private CostCenterOrgUnitInfo getOrgUnit() {
        return this.costCenter;
    }

    public VersionCopyEditUI(CoreUI owner, BgSchemeInfo bgscheme) throws Exception {
        this.owner = owner;
        this.getUIContext().put("Owner", owner);
        this.getUIContext().put("isNeedNSetting", true);
        this.editData = (VersionCopyInfo)this.createNewData();
        this.dataBinder.setValueObject((IObjectValue)this.editData);
        this.bgschemeInfo = bgscheme;
    }

    public String getBgSchemeID() {
        return this.bgSchemeID;
    }

    public void setBgSchemeID(String bgSchemeID) {
        this.bgSchemeID = bgSchemeID;
    }

    public Set<String> getBgPeriodTypeNumbers() {
        return this.bgPeriodTypeNumbers;
    }

    public void setBgPeriodTypeNumbers(Set<String> bgPeriodTypeNumbers) {
        this.bgPeriodTypeNumbers = bgPeriodTypeNumbers;
    }

    public BgPeriodDialog getPeriodDialog(BgSchemeInfo schemeInfo) {
        if (this.periodDialog == null) {
            this.periodDialog = new BgPeriodDialog();
        }
        this.periodDialog.setMultiSelect(true);
        this.periodDialog.setCanSelectUserPeriod(true);
        this.periodDialog.setBgSchemeID(schemeInfo.getId().toString());
        this.periodDialog.setBgPeriodTypeNumbers(this.bgPeriodTypeNumbers);
        this.periodDialog.setBgPeriodBeginDate(schemeInfo.getDateFrom());
        this.periodDialog.setBgPeriodEndDate(schemeInfo.getDateTo());
        return this.periodDialog;
    }

    public CoreUI getOwner() {
        return this.owner;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtBgScheme.setEditable(false);
        this.prmtBgPeriods.setEditable(false);
        this.prmtBgScenario.setEditable(false);
        this.prmtStandardPeriod.setEditable(false);
        this.prmtSourceVersion.setEditable(false);
        this.prmtTargetVersion.setEditable(false);
        this.prmtBgOrgUnit.setEditable(false);
        this.chkUpdateExistsData.setSelected(false);
        this.initBgSchemeF7();
        this.formStateComboBox.addItems(new Object[]{BgVersionFormStateEnum.allSate, BgVersionFormStateEnum.approved});
        BgVersionFormStateEnum fromState = this.editData.getFromState();
        if (fromState != null) {
            this.formStateComboBox.setSelectedItem((Object)fromState);
        } else {
            this.formStateComboBox.setSelectedItem((Object)BgVersionFormStateEnum.allSate);
        }
        boolean leaveOriState = this.editData.isLeaveOriState();
        this.leaveStateCheckBox.setSelected(leaveOriState);
    }

    protected void initBgSchemeF7() throws Exception {
        if (this.bgschemeInfo == null) {
            BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, BgNFCHelper.getSourceType((IUIObject)this), (OrgUnitInfo)this.orgUnit);
        } else {
            this.prmtBgScheme.setData((Object)this.bgschemeInfo);
        }
        BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.orgUnit, false, BgNFCHelper.getSourceType((IUIObject)this), false, true);
        EntityViewInfo view = this.prmtBgScheme.getEntityViewInfo();
        if (view == null || this.bgschemeInfo == null) {
            return;
        }
        FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)this.bgschemeInfo.getId().toString());
        EntityViewInfo clone = (EntityViewInfo)view.clone();
        clone.getFilter().getFilterItems().add(filterItemInfo);
        BgSchemeCollection bgSchemeCollection = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(clone);
        if (bgSchemeCollection == null || bgSchemeCollection.isEmpty()) {
            this.prmtBgScheme.setData(null);
            this.bgschemeInfo = null;
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        BgSchemeInfo oldValue = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newValue = (BgSchemeInfo)e.getNewValue();
        if (BgCommCHelper.isEqualsPK((IObjectValue)newValue, (IObjectValue)oldValue) || newValue == null) {
            return;
        }
        this.setBgSchemeID(newValue.getId().toString());
        this.schemeHelper = new BgSchemeDimensionHelper(newValue.getId().toString());
        BgDimensionInfo bgDimensionInfo = this.schemeHelper.getDimension("BG_Period");
        this.prmtBgPeriods.setDataNoNotify(null);
        this.setBgPeriodTypeNumbers(new HashSet<String>(bgDimensionInfo.getMember()));
        this.periodDialog = this.getPeriodDialog(newValue);
        this.prmtBgPeriods.setSelector((KDPromptSelector)this.periodDialog);
        this.prmtStandardPeriod.setDataNoNotify(null);
        BgPeriodDialog dialogStandardPeriod = new BgPeriodDialog((CoreUIObject)this);
        dialogStandardPeriod.setMultiSelect(false);
        dialogStandardPeriod.setBgPeriodTypeNumbers(this.schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        this.prmtStandardPeriod.setSelector((KDPromptSelector)dialogStandardPeriod);
        this.prmtBgScenario.setEnabledMultiSelection(true);
        this.prmtBgScenario.setValue(null);
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgScenario, DimensionConstants.DEF_SCENARIO_NUMBER, this.schemeHelper);
        if (this.prmtBgScenario.getEntityViewInfo() == null) {
            this.prmtBgScenario.setEntityViewInfo(new EntityViewInfo());
            this.prmtBgScenario.getEntityViewInfo().setFilter(new FilterInfo());
        }
        this.prmtBgScenario.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("type", (Object)0));
        this.prmtSourceVersion.setValue(null);
        DimensionMemberSelectHelper.addIdFilter(this.prmtSourceVersion, DimensionConstants.DEF_VERSION_NUMBER, this.schemeHelper);
        this.prmtTargetVersion.setValue(null);
        DimensionMemberSelectHelper.addIdFilter(this.prmtTargetVersion, DimensionConstants.DEF_VERSION_NUMBER, this.schemeHelper);
        this.prmtBgOrgUnit.setData(null);
        BgViewOrgDimensionF7 f7 = new BgViewOrgDimensionF7((IUIObject)this);
        f7.setMultipleSelect(false);
        f7.setBgOrgViewId(this.schemeHelper.getBgOrgViewId());
        f7.setFilterByCurOrg(false);
        f7.setMultipleSelect(true);
        f7.setOnlyLeaf(true);
        f7.setShowVirtualOrg(false);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)f7);
        this.prmtBgOrgUnit.setEnabledMultiSelection(true);
        this.chkUpdateExistsData.setSelected(false);
    }

    protected EntityViewInfo getEntityViewInfo(Set<String> bgPeriodNumbers) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", bgPeriodNumbers, CompareType.INCLUDE));
        entityViewInfo.setSelector(sic);
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        if (cp == null) {
            cp = new CustomerParams();
        }
        FilterParam filterParam = this.createFilterParam();
        this.saveToParams(filterParam);
        this.saveCustomerParams(cp, filterParam);
        return cp;
    }

    public BgPeriodInfo[] NPeriodToPeriod(List bgPeriodList, BgPeriodInfo standardPeriod) {
        ArrayList<String> bgPeriodResult = new ArrayList<String>();
        BgPeriodInfo[] bgPeriods = new BgPeriodInfo[bgPeriodList.size()];
        standardPeriod = (BgPeriodInfo)this.prmtStandardPeriod.getData();
        int standardPeriodType = standardPeriod.getPeriodType().getValue();
        String standardPeriodNumber = standardPeriod.getNumber();
        IBgPeriod periodInstance = null;
        try {
            periodInstance = BgPeriodFactory.getRemoteInstance();
            BgPeriodCollection bgPeriodCollection = new BgPeriodCollection();
            String targerPeriod = null;
            for (int n = 0; n < bgPeriodList.size(); ++n) {
                targerPeriod = BgPeriodNVariableHelper.getBgPeriodByN((String)standardPeriodNumber, (String)bgPeriodList.get(n).toString(), (int)standardPeriodType);
                bgPeriodResult.add(targerPeriod);
            }
            bgPeriodCollection = periodInstance.getBgPeriodCollection(this.getEntityViewInfo(new HashSet<String>(bgPeriodResult)));
            for (int i = 0; i < bgPeriodCollection.size(); ++i) {
                bgPeriods[i] = bgPeriodCollection.get(i);
            }
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        catch (BgPeriodException ex) {
            ex = new BgPeriodException(BgPeriodException.TRANSPERIODVARIABLEVERSIONCOPY);
            this.handUIException(ex);
        }
        return bgPeriods;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        FilterParam filterParam = this.createFilterParam();
        this.loadCustomerParams(cp, filterParam);
        filterParam = this.loadFilterParam(filterParam);
        this.loadFromParams(filterParam);
    }

    protected FilterParam createFilterParam() {
        return new VersionCopyFilterParam();
    }

    public FilterParam getFilterParam(CustomerParams cp) {
        if (cp == null) {
            return null;
        }
        FilterParam filterParam = this.createFilterParam();
        this.loadCustomerParams(cp, filterParam);
        filterParam = this.loadFilterParam(filterParam);
        return filterParam;
    }

    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        String retainUser;
        int i;
        if (cp == null || filterParam == null || !(filterParam instanceof VersionCopyFilterParam)) {
            return;
        }
        String id = null;
        ArrayList bgPeriodIds = new ArrayList();
        ArrayList bgPeriodsVar = new ArrayList();
        Object[] bgPeriodsMuti = null;
        ArrayList bgOrgUnitIds = new ArrayList();
        ArrayList bgScenarioIds = new ArrayList();
        VersionCopyFilterParam _filterParam = (VersionCopyFilterParam)filterParam;
        id = cp.getCustomerParam(this.BG_SCHEME_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setBgScheme(new BgSchemeInfo());
            _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setBgScheme(null);
        }
        bgScenarioIds = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam("BG_SCENARIO_IDS"));
        if (bgScenarioIds != null && !bgScenarioIds.isEmpty()) {
            BgScenarioInfo[] bgScenarioInfos = new BgScenarioInfo[bgScenarioIds.size()];
            for (i = 0; i < bgScenarioIds.size(); ++i) {
                bgScenarioInfos[i] = new BgScenarioInfo();
                bgScenarioInfos[i].setId(BOSUuid.read((String)((String)bgScenarioIds.get(i))));
            }
            _filterParam.setBgScenarios(bgScenarioInfos);
        } else {
            _filterParam.setBgScenarios(null);
        }
        bgPeriodIds = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam("BG_PERIOD_IDS"));
        if (bgPeriodIds != null && !bgPeriodIds.isEmpty()) {
            BgPeriodInfo[] bgPeriodInfos = new BgPeriodInfo[bgPeriodIds.size()];
            for (i = 0; i < bgPeriodIds.size(); ++i) {
                bgPeriodInfos[i] = new BgPeriodInfo();
                bgPeriodInfos[i].setId(BOSUuid.read((String)((String)bgPeriodIds.get(i))));
            }
            _filterParam.setBgPeriods(bgPeriodInfos);
        } else {
            _filterParam.setBgPeriods(null);
        }
        bgPeriodsVar = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam("BG_PERIOD_NUMBERS"));
        if (bgPeriodsVar != null && !bgPeriodsVar.isEmpty()) {
            _filterParam.setBgPeriodVarList(bgPeriodsVar);
        } else {
            _filterParam.setBgPeriodVarList(null);
        }
        bgPeriodsMuti = (Object[])BgAnalyseHelper.decodeObject(cp.getCustomerParam("BG_PERIOD_MUTI"));
        if (bgPeriodsMuti != null && bgPeriodsMuti.length > 0) {
            _filterParam.setBgPeriodMutiList(bgPeriodsMuti);
        } else {
            _filterParam.setBgPeriodMutiList(null);
        }
        id = cp.getCustomerParam(this.BG_STANDTARDPERIOD_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setStandardPeriod(new BgPeriodInfo());
            _filterParam.getStandardPeriod().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setStandardPeriod(null);
        }
        id = cp.getCustomerParam(this.BG_SOURCEVERSION_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setSourceVersion(new BgVersionInfo());
            _filterParam.getSourceVersion().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setSourceVersion(null);
        }
        id = cp.getCustomerParam(this.BG_TARGETVERSION_ID);
        if (!StringUtils.isEmpty((String)id)) {
            _filterParam.setTargetVersion(new BgVersionInfo());
            _filterParam.getTargetVersion().setId(BOSUuid.read((String)id));
        } else {
            _filterParam.setTargetVersion(null);
        }
        bgOrgUnitIds = (ArrayList)BgAnalyseHelper.decodeObject(cp.getCustomerParam("BG_ORGUNIT_IDS"));
        if (bgOrgUnitIds != null && !bgOrgUnitIds.isEmpty()) {
            BgOrgUnitInfo[] bgOrgUnitInfos = new BgOrgUnitInfo[bgOrgUnitIds.size()];
            for (i = 0; i < bgOrgUnitIds.size(); ++i) {
                bgOrgUnitInfos[i] = new BgOrgUnitInfo();
                bgOrgUnitInfos[i].setId(BOSUuid.read((String)((String)bgOrgUnitIds.get(i))));
            }
            _filterParam.setBgOrgUnits(bgOrgUnitInfos);
        } else {
            _filterParam.setBgOrgUnits(null);
        }
        String updateExistsData = cp.getCustomerParam(this.BG_UPDATEEXISTSDATA_ID);
        _filterParam.setUpdateExistsData(Boolean.valueOf(updateExistsData));
        BgVersionInfo targetVersion = _filterParam.getTargetVersion();
        if (targetVersion != null && targetVersion.getId() != null) {
            try {
                BgVersionInfo info = BgVersionFactory.getRemoteInstance().getBgVersionInfo("where id='" + targetVersion.getId() + "'");
                if ("Ve".equals(info.getNumber())) {
                    _filterParam.setFromFormState(1);
                    _filterParam.setLeaveFormState(Boolean.TRUE);
                } else {
                    String formState = cp.getCustomerParam(BG_FROMFORMSTATE_ID);
                    if (formState != null) {
                        _filterParam.setFromFormState(Integer.valueOf(formState));
                    } else {
                        _filterParam.setFromFormState(0);
                        _filterParam.setLeaveFormState(Boolean.FALSE);
                    }
                    String leaveFormState = cp.getCustomerParam(BG_LEAVEFORMSTATE_ID);
                    if (leaveFormState != null) {
                        _filterParam.setLeaveFormState(Boolean.valueOf(leaveFormState));
                    }
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        _filterParam.setRetainUser(StringUtils.isEmpty((String)(retainUser = cp.getCustomerParam(this.BG_RETAINUSER_ID))) ? Boolean.TRUE : Boolean.valueOf(retainUser));
    }

    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        if (cp == null || filterParam == null || !(filterParam instanceof VersionCopyFilterParam)) {
            return;
        }
        ArrayList<String> bgScenarioIds = null;
        ArrayList<String> bgPeriodIds = null;
        ArrayList<String> bgOrgUnitIds = null;
        Object[] bgPeriodsMuti = null;
        VersionCopyFilterParam _filterParam = (VersionCopyFilterParam)filterParam;
        if (_filterParam.getBgScheme() != null) {
            cp.addCustomerParam(this.BG_SCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(this.BG_SCHEME_ID);
        }
        if (_filterParam.getBgScenarios().length != 0) {
            bgScenarioIds = new ArrayList<String>();
            Object[] bgScenarioInfo = (Object[])this.prmtBgScenario.getData();
            if (bgScenarioInfo.length > 0) {
                BgScenarioInfo info = null;
                for (int i = 0; i < bgScenarioInfo.length; ++i) {
                    info = (BgScenarioInfo)bgScenarioInfo[i];
                    bgScenarioIds.add(info.getId().toString());
                }
            }
            cp.addCustomerParam(this.BG_SCENARIO_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(bgScenarioIds)));
        } else {
            cp.removeCustomerParam(this.BG_SCENARIO_IDS);
        }
        if (_filterParam.getBgPeriodVarList() != null) {
            cp.addCustomerParam(this.BG_PERIOD_NUMBERS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(_filterParam.getBgPeriodVarList())));
        } else {
            cp.removeCustomerParam(this.BG_PERIOD_NUMBERS);
        }
        if (_filterParam.getBgPeriods() != null) {
            BgPeriodInfo[] data = _filterParam.getBgPeriods();
            bgPeriodIds = new ArrayList<String>();
            bgPeriodsMuti = new Object[data.length];
            boolean flag = false;
            BgPeriodInfo bg = null;
            for (int i = 0; i < data.length; ++i) {
                bg = data[i];
                if (bg.getId() != null) {
                    bgPeriodIds.add(bg.getId().toString());
                    bgPeriodsMuti[i] = bg;
                    continue;
                }
                flag = true;
                bgPeriodsMuti[i] = bg.getNumber();
            }
            cp.addCustomerParam(this.BG_PERIOD_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(bgPeriodIds)));
            if (flag) {
                cp.addCustomerParam(this.BG_PERIOD_MUTI, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(bgPeriodsMuti)));
            } else {
                cp.removeCustomerParam(this.BG_PERIOD_MUTI);
            }
        } else {
            cp.removeCustomerParam(this.BG_PERIOD_IDS);
        }
        if (_filterParam.getStandardPeriod() != null) {
            cp.addCustomerParam(this.BG_STANDTARDPERIOD_ID, _filterParam.getStandardPeriod().getId().toString());
        } else {
            cp.removeCustomerParam(this.BG_STANDTARDPERIOD_ID);
        }
        if (_filterParam.getSourceVersion() != null) {
            cp.addCustomerParam(this.BG_SOURCEVERSION_ID, _filterParam.getSourceVersion().getId().toString());
        } else {
            cp.removeCustomerParam(this.BG_SOURCEVERSION_ID);
        }
        if (_filterParam.getTargetVersion() != null) {
            cp.addCustomerParam(this.BG_TARGETVERSION_ID, _filterParam.getTargetVersion().getId().toString());
        } else {
            cp.removeCustomerParam(this.BG_TARGETVERSION_ID);
        }
        if (_filterParam.getBgOrgUnits() != null) {
            bgOrgUnitIds = new ArrayList<String>();
            for (BgOrgUnitInfo bg : _filterParam.getBgOrgUnits()) {
                bgOrgUnitIds.add(bg.getId().toString());
            }
            cp.addCustomerParam(this.BG_ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(bgOrgUnitIds)));
        } else {
            cp.removeCustomerParam(this.BG_ORGUNIT_IDS);
        }
        cp.addCustomerParam(this.BG_UPDATEEXISTSDATA_ID, String.valueOf(_filterParam.getUpdateExistsData()));
        cp.addCustomerParam(BG_FROMFORMSTATE_ID, String.valueOf(_filterParam.getFromFormState()));
        cp.addCustomerParam(BG_LEAVEFORMSTATE_ID, String.valueOf(_filterParam.isLeaveFormState()));
        cp.addCustomerParam(this.BG_RETAINUSER_ID, String.valueOf(_filterParam.getRetainUser()));
    }

    protected void loadFromParams(FilterParam filterParam) {
        int i;
        int in;
        if (!(filterParam instanceof VersionCopyFilterParam)) {
            return;
        }
        VersionCopyFilterParam _filterParam = (VersionCopyFilterParam)filterParam;
        try {
            Set<String> schemeIds = BgNFCHelper.getPermitedSchemeIDs((OrgUnitInfo)this.orgUnit, BgNFCHelper.getSourceType((IUIObject)this));
            if (_filterParam.getBgScheme() != null && schemeIds.contains(_filterParam.getBgScheme().getId().toString())) {
                this.prmtBgScheme.setData((Object)_filterParam.getBgScheme());
            } else {
                this.prmtBgScheme.setData(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (_filterParam.getBgScenarios().length > 0) {
            BgScenarioInfo[] bgScenarioInfoTemp = _filterParam.getBgScenarios();
            BgScenarioInfo[] bgScenarioInfos = new BgScenarioInfo[_filterParam.getBgScenarios().length];
            in = _filterParam.getBgScenarios().length;
            for (i = 0; i < in; ++i) {
                bgScenarioInfos[i] = bgScenarioInfoTemp[i];
            }
            this.prmtBgScenario.setDataNoNotify((Object)bgScenarioInfos);
        } else {
            this.prmtBgScenario.setDataNoNotify(null);
        }
        if (_filterParam.getBgPeriodMutiList() != null) {
            this.prmtBgPeriods.setData((Object)_filterParam.getBgPeriodMutiList());
        } else if (_filterParam.getBgPeriods() != null) {
            this.prmtBgPeriods.setDataNoNotify((Object)_filterParam.getBgPeriods());
        } else if (_filterParam.getBgPeriodVarList() != null) {
            this.prmtBgPeriods.setData(_filterParam.getBgPeriodVarList());
        } else {
            this.prmtBgPeriods.setDataNoNotify(null);
        }
        this.prmtStandardPeriod.setDataNoNotify((Object)_filterParam.getStandardPeriod());
        this.prmtSourceVersion.setDataNoNotify((Object)_filterParam.getSourceVersion());
        this.prmtTargetVersion.setDataNoNotify((Object)_filterParam.getTargetVersion());
        if (_filterParam.getBgOrgUnits() != null) {
            BgOrgUnitInfo[] bgOrgUnitsTemp = _filterParam.getBgOrgUnits();
            BgOrgUnitInfo[] bgOrgUnits = new BgOrgUnitInfo[_filterParam.getBgOrgUnits().length];
            in = _filterParam.getBgOrgUnits().length;
            for (i = 0; i < in; ++i) {
                bgOrgUnits[i] = bgOrgUnitsTemp[i];
            }
            this.prmtBgOrgUnit.setDataNoNotify((Object)bgOrgUnits);
        } else {
            this.prmtBgOrgUnit.setDataNoNotify(null);
        }
        this.chkUpdateExistsData.setSelected(_filterParam.getUpdateExistsData());
        BgVersionInfo targetVersion = _filterParam.getTargetVersion();
        try {
            BgVersionInfo info = BgVersionFactory.getRemoteInstance().getBgVersionInfo("where id='" + targetVersion.getId() + "'");
            if (info != null) {
                if ("Ve".equals(info.getNumber())) {
                    this.formStateComboBox.setSelectedItem((Object)BgVersionFormStateEnum.approved);
                    this.formStateComboBox.setEnabled(false);
                    this.leaveStateCheckBox.setEnabled(false);
                } else if (BgVersionFormStateEnum.allSate.equals((Object)BgVersionFormStateEnum.getEnum(_filterParam.getFromFormState()))) {
                    this.formStateComboBox.setSelectedItem((Object)BgVersionFormStateEnum.allSate);
                    this.formStateComboBox.setEnabled(true);
                } else {
                    this.formStateComboBox.setEnabled(true);
                    this.formStateComboBox.setSelectedItem((Object)BgVersionFormStateEnum.getEnum(_filterParam.getFromFormState()));
                    if (this.formStateComboBox.getSelectedItem().equals((Object)BgVersionFormStateEnum.allSate)) {
                        this.leaveStateCheckBox.setEnabled(false);
                    } else if (!this.formStateComboBox.getSelectedItem().equals((Object)BgVersionFormStateEnum.approved) || "Ve".equals(info.getNumber())) {
                        // empty if block
                    }
                    this.leaveStateCheckBox.setEnabled(true);
                }
                this.leaveStateCheckBox.setSelected(_filterParam.isLeaveFormState());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        this.chkRetainUser.setSelected(_filterParam.getRetainUser());
    }

    @Override
    protected void formStateComboBox_itemStateChanged(ItemEvent e) throws Exception {
        Object data;
        super.formStateComboBox_itemStateChanged(e);
        if (e.getItem().equals((Object)BgVersionFormStateEnum.allSate)) {
            this.leaveStateCheckBox.setSelected(false);
            this.leaveStateCheckBox.setEnabled(false);
        } else if (e.getItem().equals((Object)BgVersionFormStateEnum.approved) && (data = this.prmtTargetVersion.getData()) instanceof BgVersionInfo) {
            BgVersionInfo versionInfo = (BgVersionInfo)data;
            if ("Ve".equals(versionInfo.getNumber())) {
                this.leaveStateCheckBox.setSelected(true);
            }
            this.leaveStateCheckBox.setEnabled(true);
        }
    }

    @Override
    protected void prmtTargetVersion_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtTargetVersion_dataChanged(e);
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if ((oldValue != null && !oldValue.equals(newValue) || newValue != null && !newValue.equals(oldValue)) && newValue instanceof BgVersionInfo) {
            BgVersionInfo info = (BgVersionInfo)newValue;
            if ("Ve".equals(info.getNumber())) {
                this.formStateComboBox.setSelectedItem((Object)BgVersionFormStateEnum.approved);
                this.formStateComboBox.setEnabled(false);
                this.leaveStateCheckBox.setSelected(true);
                this.leaveStateCheckBox.setEnabled(false);
            } else {
                this.formStateComboBox.setEnabled(true);
                this.formStateComboBox.setSelectedItem((Object)BgVersionFormStateEnum.allSate);
            }
        }
    }

    protected void saveToParams(FilterParam filterParam) {
        if (!(filterParam instanceof VersionCopyFilterParam)) {
            return;
        }
        VersionCopyFilterParam _filterParam = (VersionCopyFilterParam)filterParam;
        if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
            _filterParam.setBgScheme((BgSchemeInfo)this.prmtBgScheme.getData());
        } else {
            _filterParam.setBgScheme(null);
        }
        Object[] bgScenarionInfo = (Object[])this.prmtBgScenario.getData();
        BgScenarioInfo[] infos = new BgScenarioInfo[bgScenarionInfo.length];
        if (infos.length > 0) {
            for (int i = 0; i < bgScenarionInfo.length; ++i) {
                infos[i] = (BgScenarioInfo)bgScenarionInfo[i];
            }
            _filterParam.setBgScenarios(infos);
        } else {
            _filterParam.setBgScenarios(null);
        }
        if (this.prmtBgPeriods.getData() instanceof MbgViewListResultData) {
            _filterParam.setBgPeriodResultData((MbgViewListResultData)this.prmtBgPeriods.getData());
        } else {
            _filterParam.setBgPeriodResultData(null);
        }
        if (this.prmtBgPeriods.getData() instanceof ArrayList) {
            _filterParam.setBgPeriodVarList((ArrayList)this.prmtBgPeriods.getData());
        } else if (this.prmtBgPeriods.getData() instanceof BgPeriodInfo[]) {
            _filterParam.setBgPeriods((BgPeriodInfo[])this.prmtBgPeriods.getData());
        } else {
            _filterParam.setBgPeriods(null);
            _filterParam.setBgPeriodVarList(null);
        }
        if (this.prmtStandardPeriod.getData() instanceof BgPeriodInfo) {
            _filterParam.setStandardPeriod((BgPeriodInfo)this.prmtStandardPeriod.getData());
        } else {
            _filterParam.setStandardPeriod(null);
        }
        if (this.prmtSourceVersion.getData() instanceof BgVersionInfo) {
            _filterParam.setSourceVersion((BgVersionInfo)this.prmtSourceVersion.getData());
        } else {
            _filterParam.setSourceVersion(null);
        }
        if (this.prmtTargetVersion.getData() instanceof BgVersionInfo) {
            _filterParam.setTargetVersion((BgVersionInfo)this.prmtTargetVersion.getData());
        } else {
            _filterParam.setTargetVersion(null);
        }
        if (this.prmtBgOrgUnit.getData() instanceof BgOrgUnitInfo[]) {
            _filterParam.setBgOrgUnits((BgOrgUnitInfo[])this.prmtBgOrgUnit.getData());
        }
        _filterParam.setUpdateExistsData(this.chkUpdateExistsData.isSelected());
        Object selectedItem = this.formStateComboBox.getSelectedItem();
        if (selectedItem instanceof BgVersionFormStateEnum) {
            _filterParam.setFromFormState(((BgVersionFormStateEnum)((Object)selectedItem)).getValue());
        }
        boolean selected = this.leaveStateCheckBox.isSelected();
        _filterParam.setLeaveFormState(selected);
        _filterParam.setRetainUser(this.chkRetainUser.isSelected());
    }

    protected IBgCustomerParamsFacade getCPInterface() throws Exception {
        return BgCustomerParamsFacadeFactory.getRemoteInstance();
    }

    protected FilterParam loadFilterParam(FilterParam filterParam) {
        try {
            filterParam = this.getCPInterface().loadCustomerParams(filterParam);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        return filterParam;
    }

    protected void checkSelectBgPeriodAndBgScheme(SelectorEvent e) {
        if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"please.choose.scheme"));
            SysUtil.abort();
        } else if (this.prmtBgPeriods.getData() == null) {
            String message = EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"BgPeriodNull");
            MsgBox.showWarning((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        Object data = this.prmtBgPeriods.getData();
        if (!this.checkPeriodHaveVar(data)) {
            String message = EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"periodNVar");
            MsgBox.showWarning((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }

    protected boolean checkPeriodHaveVar(Object data) {
        int i;
        Object[] newdata;
        if (data == null) {
            String message = EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"BgPeriodNull");
            MsgBox.showWarning((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (data instanceof ArrayList && ((ArrayList)data).get(0).toString().contains("!")) {
            return true;
        }
        if (data instanceof BgPeriodInfo && ((BgPeriodInfo)data).getNumber().contains("!")) {
            return true;
        }
        if (data instanceof BgPeriodInfo[]) {
            newdata = (BgPeriodInfo[])data;
            for (i = 0; i < newdata.length; ++i) {
                if (!newdata[i].getNumber().contains("!")) continue;
                return true;
            }
        }
        if (data instanceof Object[]) {
            newdata = (Object[])data;
            for (i = 0; i < newdata.length; ++i) {
                if (!(newdata[i] instanceof String) || !((String)newdata[i]).contains("!")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void prmtBgPeriods_willShow(SelectorEvent e) throws Exception {
        super.prmtBgPeriods_willShow(e);
        this.checkSelectBgScheme(e);
        KDBizPromptBox prmtDimension = (KDBizPromptBox)e.getSource();
        BgPeriodDialog dialog = (BgPeriodDialog)prmtDimension.getSelector();
        Object newValue = prmtDimension.getData();
        DataChangeEvent event = new DataChangeEvent((Object)prmtDimension, newValue, null);
        this.periodDialog.dataChanged(event);
    }

    @Override
    protected void prmtStandardPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtStandardPeriod_willShow(e);
        this.checkSelectBgPeriodAndBgScheme(e);
    }

    @Override
    protected void prmtBgScenario_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScenario_willShow(e);
        this.checkSelectBgScheme(e);
    }

    @Override
    protected void prmtSourceVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtSourceVersion_willShow(e);
        this.checkSelectBgScheme(e);
        BgNFormListUI.addRollVersionFilter(this.prmtSourceVersion);
    }

    @Override
    protected void prmtTargetVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtTargetVersion_willShow(e);
        this.checkSelectBgScheme(e);
        BgNFormListUI.addRollVersionFilter(this.prmtTargetVersion);
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtBgOrgUnit_willShow(e);
        this.checkSelectBgScheme(e);
    }

    protected void checkSelectBgScheme(SelectorEvent e) {
        if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"please.choose.scheme"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.afterStoreFields();
    }

    protected void afterStoreFields() {
        int updateExistDataState;
        this.editData.getBgPeriods().clear();
        BgPeriodInfo[] bgPeriods = null;
        Object data = this.prmtBgPeriods.getData();
        if (this.checkPeriodHaveVar(data)) {
            Object[] bgPeriodCom;
            Object[] bgPeriodVar;
            BgPeriodInfo standardPeriod;
            ArrayList<BgPeriodInfo> periodCom;
            ArrayList<Object> periodVar;
            Object[] newdata;
            if (data instanceof ArrayList) {
                ArrayList bgPeriodList = (ArrayList)data;
                bgPeriods = new BgPeriodInfo[bgPeriodList.size()];
                BgPeriodInfo standardPeriod2 = (BgPeriodInfo)this.prmtStandardPeriod.getData();
                bgPeriods = this.NPeriodToPeriod(bgPeriodList, standardPeriod2);
            } else if (data instanceof BgPeriodInfo[]) {
                newdata = (BgPeriodInfo[])data;
                bgPeriods = new BgPeriodInfo[newdata.length];
                periodVar = new ArrayList<Object>();
                periodCom = new ArrayList<BgPeriodInfo>();
                for (int i = 0; i < newdata.length; ++i) {
                    if (newdata[i].getNumber().contains("!")) {
                        periodVar.add(newdata[i]);
                        continue;
                    }
                    periodCom.add(newdata[i]);
                }
                standardPeriod = (BgPeriodInfo)this.prmtStandardPeriod.getData();
                bgPeriodVar = this.NPeriodToPeriod(periodVar, standardPeriod);
                bgPeriodCom = periodCom.toArray(new BgPeriodInfo[periodCom.size()]);
                bgPeriods = (BgPeriodInfo[])ArrayUtils.addAll((Object[])bgPeriodVar, (Object[])bgPeriodCom);
            } else if (data instanceof Object[]) {
                newdata = (Object[])data;
                bgPeriods = new BgPeriodInfo[newdata.length];
                periodVar = new ArrayList();
                periodCom = new ArrayList();
                for (int i = 0; i < newdata.length; ++i) {
                    if (newdata[i] instanceof String && ((String)newdata[i]).contains("!")) {
                        periodVar.add((String)newdata[i]);
                        continue;
                    }
                    if (!(newdata[i] instanceof BgPeriodInfo)) continue;
                    periodCom.add(newdata[i]);
                }
                standardPeriod = (BgPeriodInfo)this.prmtStandardPeriod.getData();
                bgPeriodVar = this.NPeriodToPeriod(periodVar, standardPeriod);
                bgPeriodCom = periodCom.toArray(new BgPeriodInfo[periodCom.size()]);
                bgPeriods = (BgPeriodInfo[])ArrayUtils.addAll((Object[])bgPeriodVar, (Object[])bgPeriodCom);
            }
        } else {
            bgPeriods = (BgPeriodInfo[])data;
        }
        if (bgPeriods != null) {
            VersionCopyBgPeriodNodeInfo node = null;
            for (int i = 0; i < bgPeriods.length; ++i) {
                if (bgPeriods[i] == null) continue;
                if (this.bgPeriodNodes.containsKey(bgPeriods[i].getId().toString())) {
                    node = this.bgPeriodNodes.get(bgPeriods[i].getId().toString());
                } else {
                    node = new VersionCopyBgPeriodNodeInfo();
                    node.setVersionCopy(this.editData);
                    node.setBgPeriod(bgPeriods[i]);
                }
                this.editData.getBgPeriods().add(node);
            }
        }
        this.editData.getBgScenarios().clear();
        Object[] bgScenarios = (Object[])this.prmtBgScenario.getData();
        if (bgPeriods != null) {
            BgScenarioInfo info = null;
            VersionCopyBgScenarioNodeInfo node = null;
            for (int i = 0; i < bgScenarios.length; ++i) {
                info = (BgScenarioInfo)bgScenarios[i];
                if (this.bgScenarioNodes.containsKey(info.getId().toString())) {
                    node = this.bgScenarioNodes.get(info.getId().toString());
                } else {
                    node = new VersionCopyBgScenarioNodeInfo();
                    node.setVersionCopy(this.editData);
                    node.setBgScenario(info);
                }
                this.editData.getBgScenarios().add(node);
            }
        }
        this.editData.getBgOrgUnits().clear();
        Object[] bgOrgUnits = (Object[])this.prmtBgOrgUnit.getData();
        if (bgOrgUnits != null) {
            BgOrgUnitInfo info = null;
            VersionCopyBgOrgUnitNodeInfo node = null;
            for (int i = 0; i < bgOrgUnits.length; ++i) {
                info = (BgOrgUnitInfo)bgOrgUnits[i];
                if (info == null) continue;
                if (this.bgOrgUnitNodes.containsKey(info.getId().toString())) {
                    node = this.bgOrgUnitNodes.get(info.getId().toString());
                } else {
                    node = new VersionCopyBgOrgUnitNodeInfo();
                    node.setVersionCopy(this.editData);
                    node.setBgOrgUnit(info);
                }
                this.editData.getBgOrgUnits().add(node);
            }
        }
        if ((updateExistDataState = this.chkUpdateExistsData.getSelected()) == 32) {
            this.editData.setUpdateExistsData(true);
        } else {
            this.editData.setUpdateExistsData(false);
        }
        int retainUser = this.chkRetainUser.getSelected();
        if (retainUser == 32) {
            this.editData.setRetainUser(true);
        } else {
            this.editData.setRetainUser(false);
        }
        this.editData.setCopyWay(this.getCopyWay());
        if (this.getOrgUnit() != null) {
            this.editData.setOrgUnit(this.getOrgUnit());
        }
        this.editData.setLeaveOriState(this.leaveStateCheckBox.isSelected());
        Object selectedItem = this.formStateComboBox.getSelectedItem();
        if (selectedItem instanceof BgVersionFormStateEnum) {
            this.editData.setFromState((BgVersionFormStateEnum)((Object)selectedItem));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.bgPeriodNodes.clear();
        BgPeriodInfo[] bgPeriods = null;
        List periodList = null;
        if (!this.editData.getBgPeriods().isEmpty() && !this.editData.getStandardPeriod().isEmpty()) {
            bgPeriods = new BgPeriodInfo[this.editData.getBgPeriods().size()];
            for (int i = 0; i < this.editData.getBgPeriods().size(); ++i) {
                this.bgPeriodNodes.put(this.editData.getBgPeriods().get(i).getBgPeriod().getId().toString(), this.editData.getBgPeriods().get(i));
                bgPeriods[i] = this.editData.getBgPeriods().get(i).getBgPeriod();
            }
            periodList = this.bgPeriodsToStringVar(this.editData.getStandardPeriod(), bgPeriods);
        }
        this.prmtBgPeriods.setData(bgPeriods);
        this.bgScenarioNodes.clear();
        BgScenarioInfo[] bgScenariods = null;
        if (!this.editData.getBgScenarios().isEmpty()) {
            bgScenariods = new BgScenarioInfo[this.editData.getBgScenarios().size()];
            for (int i = 0; i < this.editData.getBgScenarios().size(); ++i) {
                this.bgScenarioNodes.put(this.editData.getBgScenarios().get(i).getBgScenario().getId().toString(), this.editData.getBgScenarios().get(i));
                bgScenariods[i] = this.editData.getBgScenarios().get(i).getBgScenario();
            }
        }
        this.prmtBgScenario.setData(bgScenariods);
        this.bgOrgUnitNodes.clear();
        BgOrgUnitInfo[] bgOrgUnits = null;
        if (!this.editData.getBgOrgUnits().isEmpty()) {
            bgOrgUnits = new BgOrgUnitInfo[this.editData.getBgOrgUnits().size()];
            for (int i = 0; i < this.editData.getBgOrgUnits().size(); ++i) {
                this.bgOrgUnitNodes.put(this.editData.getBgOrgUnits().get(i).getBgOrgUnit().getId().toString(), this.editData.getBgOrgUnits().get(i));
                bgOrgUnits[i] = this.editData.getBgOrgUnits().get(i).getBgOrgUnit();
            }
        }
        this.prmtBgOrgUnit.setData(bgOrgUnits);
    }

    protected List bgPeriodsToStringVar(BgPeriodInfo standardPeriod, BgPeriodInfo[] bgPeriods) {
        ArrayList<String> userPeriodList = new ArrayList<String>();
        BgPeriodInfo info = null;
        String number = null;
        Object value = null;
        int standardPeriodType = standardPeriod.getPeriodType().getValue();
        String standardPeriodNumber = standardPeriod.getNumber();
        BgPeriodVariable bgPeriodVariable = new BgPeriodVariable();
        int yearValue = BgNPeriodHelper.parserBgPeriodYear((String)standardPeriodNumber);
        BgPeriodEnum periodType = standardPeriod.getPeriodType();
        if (periodType == BgPeriodEnum.YEAR) {
            bgPeriodVariable.setYear(yearValue);
            bgPeriodVariable.setType(1);
        }
        if (periodType == BgPeriodEnum.HALFYEAR) {
            int halfYearValue = BgPeriodVariable.parseIntPeriod((String)standardPeriodNumber, (int)2);
            bgPeriodVariable.setYear(yearValue);
            bgPeriodVariable.setHalfYear(halfYearValue);
            bgPeriodVariable.setType(2);
        }
        if (periodType == BgPeriodEnum.QUARTER) {
            int quarterValue = BgPeriodVariable.parseIntPeriod((String)standardPeriodNumber, (int)4);
            bgPeriodVariable.setYear(yearValue);
            bgPeriodVariable.setQuarter(quarterValue);
            bgPeriodVariable.setType(4);
        }
        if (periodType == BgPeriodEnum.MONTH) {
            int monthValue = BgPeriodVariable.parseIntPeriod((String)standardPeriodNumber, (int)12);
            bgPeriodVariable.setYear(yearValue);
            bgPeriodVariable.setMonth(monthValue);
            bgPeriodVariable.setType(12);
        }
        for (int n = 0; n < bgPeriods.length; ++n) {
            info = bgPeriods[n];
            number = info.getNumber();
            String periodNvalue = BgPeriodVariable.getBgPeriodParam((String)number, (BgPeriodVariable)bgPeriodVariable);
            userPeriodList.add(periodNvalue);
        }
        return userPeriodList;
    }

    protected IObjectValue createNewData() {
        VersionCopyInfo info = new VersionCopyInfo();
        info.setCU(this.orgUnit.getCU());
        info.setOrgUnit(this.orgUnit);
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("bgScenarios.bgScenario.id");
        sic.add("bgScenarios.bgScenario.number");
        sic.add("bgScenarios.bgScenario.name");
        sic.add("bgScenarios.bgScenario.scenarioId");
        sic.add("bgPeriods.bgPeriod.id");
        sic.add("bgPeriods.bgPeriod.number");
        sic.add("bgPeriods.bgPeriod.name");
        return sic;
    }

    public void clear() {
        super.clear();
        try {
            this.initBgSchemeF7();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtBgScenario.setData(null);
        this.prmtBgOrgUnit.setData(null);
        this.prmtBgPeriods.setData(null);
        this.prmtSourceVersion.setData(null);
        this.prmtTargetVersion.setData(null);
        this.prmtStandardPeriod.setDataNoNotify(null);
        this.chkUpdateExistsData.setSelected(false);
    }

    public boolean verify() {
        boolean re = super.verify();
        StringBuffer stringInfo = new StringBuffer();
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            stringInfo.append(this.contBgScheme.getBoundLabelText());
            stringInfo.append(",");
        }
        if (this.prmtBgScenario.getData() == null) {
            this.prmtBgScenario.requestFocus();
            stringInfo.append(this.contBgScenario.getBoundLabelText());
            stringInfo.append(",");
        }
        if (this.prmtBgPeriods.getData() == null) {
            this.prmtBgPeriods.requestFocus();
            stringInfo.append(this.contBgPeriods.getBoundLabelText());
            stringInfo.append(",");
        }
        if (this.prmtSourceVersion.getData() == null) {
            this.prmtSourceVersion.requestFocus();
            stringInfo.append(this.contSourceVersion.getBoundLabelText());
            stringInfo.append(",");
        }
        if (this.prmtTargetVersion.getData() == null) {
            this.prmtTargetVersion.requestFocus();
            stringInfo.append(this.contTargetVersion.getBoundLabelText());
            stringInfo.append(",");
        }
        if (stringInfo.length() != 0) {
            if (re) {
                stringInfo.deleteCharAt(stringInfo.length() - 1);
                MsgBox.showWarning((Component)((Object)this), (String)(stringInfo + EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource.versionCopyVerify")));
                re = false;
            }
            return re;
        }
        Object data = this.prmtBgPeriods.getData();
        if (this.checkPeriodHaveVar(data) && this.prmtStandardPeriod.getData() == null) {
            if (re) {
                String message = EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"standardPeriodNull");
                MsgBox.showWarning((String)message);
                re = false;
            }
            return re;
        }
        BgVersionInfo source = (BgVersionInfo)this.prmtSourceVersion.getData();
        BgVersionInfo target = (BgVersionInfo)this.prmtTargetVersion.getData();
        if (source.getId().equals((Object)target.getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"sourceAndTargetVersionSame"));
            return false;
        }
        if (this.schemeHelper != null) {
            Map<String, HashSet<Object>> leafMap = new HashMap();
            leafMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, new HashSet());
            Object[] bgScenarios = (Object[])this.prmtBgScenario.getData();
            for (int i = 0; i < bgScenarios.length; ++i) {
                ((Set)leafMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER)).add(((BgScenarioInfo)bgScenarios[i]).getNumber());
            }
            leafMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, new HashSet());
            ((Set)leafMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER)).add(source.getNumber());
            ((Set)leafMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER)).add(target.getNumber());
            try {
                leafMap = DimensionFormulaFacadeFactory.getRemoteInstance().getLeafMember(((BgSchemeInfo)this.prmtBgScheme.getData()).getOrgUnit().getId().toString(), ((BgSchemeInfo)this.prmtBgScheme.getData()).getId().toString(), leafMap, this.schemeHelper.getDimensionBySrcNumber(), false);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            if (leafMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER) == null || ((Set)leafMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER)).isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"selectLeafScenario"));
                SysUtil.abort();
            }
            if (leafMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER) == null || ((Set)leafMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER)).size() != 2) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"selectLeafVersion"));
                SysUtil.abort();
            }
        }
        this.storeFields();
        return true;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.storeFields();
        VersionCopyClientHelper.startExecute(this, this.editData);
    }

    private BgVersionCopyWayEnum getCopyWay() {
        return BgVersionCopyWayEnum.byData;
    }

    protected IVersionCopy getBizInterface() throws BOSException {
        return VersionCopyFactory.getRemoteInstance();
    }

    public boolean isModify() {
        return false;
    }

    public class TimeMark {
        CoreUI ui;
        boolean isRuning = false;
        long time = 0L;

        public TimeMark(CoreUI _ui) {
            this.ui = _ui;
        }

        public boolean isRuning() {
            return this.isRuning;
        }

        public void Start() {
            this.isRuning = true;
            this.time = System.currentTimeMillis();
        }

        public void Stop() {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"69_TimeMark");
            this.isRuning = false;
        }

        public String getSuccessMsg() {
            this.isRuning = false;
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"69_TimeMark");
            return MessageFormat.format(msg, Long.toString(System.currentTimeMillis() - this.time));
        }
    }
}

