/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.mbg.AbstractBgDataCopyResultInfo;
import com.kingdee.eas.ma.mbg.BgDataCopyResultCollection;
import com.kingdee.eas.ma.mbg.BgDataCopyResultEnum;
import com.kingdee.eas.ma.mbg.BgDataCopyResultFactory;
import com.kingdee.eas.ma.mbg.BgDataCopyResultInfo;
import com.kingdee.eas.ma.mbg.BgVersionCopyWayEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.VersionCopyFactory;
import com.kingdee.eas.ma.mbg.VersionCopyInfo;
import com.kingdee.eas.ma.mbg.client.AbstractVersionCopyProgressUI;
import com.kingdee.eas.ma.mbg.client.MyMsgBox;
import com.kingdee.eas.ma.mbg.client.VersionCopyListUI;
import com.kingdee.eas.ma.mbg.client.utils.VersionCopyClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class VersionCopyProgressUI
extends AbstractVersionCopyProgressUI {
    private static final long serialVersionUID = 4364260932934775501L;
    private static final Logger logger = CoreUIObject.getLogger(VersionCopyProgressUI.class);
    public static final String SOURCE_TYPE = "sourceTypeEnum";
    private boolean isClose = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.progBar.setStringPainted(true);
        CoreBaseInfo info = (CoreBaseInfo)this.getUIContext().get("InitDataObject");
        RptSrcTypeEnum sourceType = (RptSrcTypeEnum)((Object)this.getUIContext().get(SOURCE_TYPE));
        if (info instanceof BgDataCopyResultInfo) {
            BgDataCopyResultInfo resultInfo = (BgDataCopyResultInfo)info;
            if (BgDataCopyResultEnum.run.equals((Object)resultInfo.getState())) {
                this.startShowResultThread(resultInfo);
            } else {
                this.showReportUI(resultInfo);
            }
        } else {
            BgDataCopyResultInfo resultInfo = new BgDataCopyResultInfo();
            resultInfo.setId(BOSUuid.create((BOSObjectType)resultInfo.getBOSType()));
            resultInfo.setOperateID(info.getId());
            if (info instanceof VersionCopyInfo) {
                resultInfo.setCopyWay(((VersionCopyInfo)info).getCopyWay());
            }
            this.startExecuteCopyThread(info, resultInfo, sourceType);
            this.startShowResultThread(resultInfo);
        }
    }

    protected void startExecuteCopyThread(final CoreBaseInfo info, final BgDataCopyResultInfo resultInfo, final RptSrcTypeEnum sourceType) {
        Thread executor = new Thread(){

            @Override
            public void run() {
                VersionCopyProgressUI.this.execute((IObjectValue)info, resultInfo, sourceType);
            }
        };
        executor.start();
    }

    protected void startShowResultThread(final BgDataCopyResultInfo resultInfo) {
        Thread result = new Thread(){

            @Override
            public void run() {
                if (UserMonitorClientTool.getRegistryInfo() != null) {
                    UserMonitorClientTool.getRegistryInfo().setFinished(false);
                }
                try {
                    VersionCopyProgressUI.this.showResult(resultInfo);
                }
                finally {
                    if (UserMonitorClientTool.getRegistryInfo() != null) {
                        UserMonitorClientTool.getRegistryInfo().setFinished(true);
                    }
                }
            }
        };
        result.start();
    }

    private void showResult(BgDataCopyResultInfo resultInfo) {
        long startTime = System.currentTimeMillis();
        long maxTimeout = 600000L;
        ObjectUuidPK pk = new ObjectUuidPK(resultInfo.getId());
        boolean isFirst = true;
        while (!this.isClose) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"", (Throwable)e);
            }
            try {
                AbstractBgDataCopyResultInfo r = null;
                BgDataCopyResultCollection col = BgDataCopyResultFactory.getRemoteInstance().getBgDataCopyResultCollection("where id = '" + pk + "'");
                if (col != null && !col.isEmpty()) {
                    r = col.get(0);
                    if (isFirst) {
                        VersionCopyListUI listUI = (VersionCopyListUI)((Object)this.getUIContext().get("Owner"));
                        listUI.refreshList();
                        isFirst = false;
                    }
                }
                if (r == null) {
                    if (System.currentTimeMillis() - startTime <= maxTimeout) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"copyTimeOut"));
                    this.destroyWindow();
                    return;
                }
                if (BgDataCopyResultEnum.success.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.showReportUI((BgDataCopyResultInfo)r);
                    return;
                }
                if (BgDataCopyResultEnum.exception.equals((Object)r.getState())) {
                    this.isClose = true;
                    this.showException((BgDataCopyResultInfo)r);
                    return;
                }
                if (!BgDataCopyResultEnum.run.equals((Object)r.getState())) continue;
                this.progBar.setMaximum(r.getTotalCount());
                this.progBar.setValue(r.getCurrentIndex());
                this.lblState.setText(r.getResult());
                this.progBar.setString(r.getCurrentIndex() + "/" + r.getTotalCount());
                this.updateUI();
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                if (VersionCopyProgressUI.isSessionClosedException(e)) {
                    if (MyMsgBox.showSessionError((Component)((Object)this), e) == 99) continue;
                    this.isClose = true;
                    continue;
                }
                this.isClose = true;
                this.handUIExceptionAndAbort(e);
            }
        }
        this.destroyWindow();
    }

    private static boolean isSessionClosedException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        while (true) {
            int errorCode = Utils.getRPCErrorCode((Throwable)exc);
            if (Utils.isRPCException((Throwable)exc) && (errorCode == 1002 || errorCode == 1001) || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                return true;
            }
            if (exc.getCause() == null) {
                return false;
            }
            exc = exc.getCause();
        }
    }

    private void showException(BgDataCopyResultInfo r) {
        MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"copyException"), (String)r.getException(), (int)1);
        if (r.getCurrentIndex() > 0) {
            this.showReportUI(r);
        }
    }

    protected void showReportUI(BgDataCopyResultInfo r) {
        this.destroyWindow();
        VersionCopyListUI listUI = (VersionCopyListUI)((Object)this.getUIContext().get("Owner"));
        VersionCopyClientHelper.showReport(listUI, r.getOperateID().toString(), r.getCopyWay());
    }

    protected void execute(IObjectValue info, BgDataCopyResultInfo resultInfo, RptSrcTypeEnum sourceType) {
        try {
            if (info instanceof VersionCopyInfo) {
                VersionCopyInfo versionCopy = (VersionCopyInfo)info;
                BgVersionCopyWayEnum copyWay = versionCopy.getCopyWay();
                if (BgVersionCopyWayEnum.byForm.equals((Object)copyWay)) {
                    VersionCopyFactory.getRemoteInstance().startExecuteByForm((VersionCopyInfo)info, resultInfo, sourceType);
                } else {
                    VersionCopyFactory.getRemoteInstance().startExecute((VersionCopyInfo)info, resultInfo);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public boolean destroyWindow() {
        this.isClose = true;
        return super.destroyWindow();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.menuBar.setVisible(false);
        if (this.statusBar != null) {
            this.statusBar.setVisible(false);
        }
    }
}

