/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.client.NewDimensionMemberF7UI;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewListAddMemberF7UI
extends NewDimensionMemberF7UI {
    private static final long serialVersionUID = 1L;
    private BigDecimal versionNum = BigDecimal.ZERO;
    protected Object dimension = null;
    protected MbgViewListResultData returnData;

    public Object getDimension() {
        return this.dimension;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("versionNum") instanceof BigDecimal) {
            this.versionNum = (BigDecimal)this.getUIContext().get("versionNum");
        }
    }

    @Override
    protected Set getDimNumberFilter(BgDimensionBaseInfo dimension) {
        return this.getNumberFilter(dimension.getNumber());
    }

    @Override
    protected BgDimensionBaseInfo getSelectDimension() {
        return DimensionClientHelper.getSelectDimension(this.cbxDimension);
    }

    @Override
    public Object getData() {
        return this.getReturnData();
    }

    protected MbgViewListResultData getReturnData() {
        MbgViewListResultData data = null;
        Object obj = super.getData();
        if (obj != null && obj instanceof List) {
            data = new MbgViewListResultData();
            data.setMembers((List)obj);
            data.setMemberType(BgMemberSelectTypeEnum.Member);
            if (this.dimension instanceof MbgViewListDimensionInfo && data.getCanAddMembers().isEmpty()) {
                data.getCanAddMembers().addAll(((MbgViewListDimensionInfo)this.dimension).getCanAddMember());
            }
        } else if (this.getUIContext().get("isFormAddMembers") != null && this.getUIContext().get("isFormAddMembers") instanceof Boolean && ((Boolean)this.getUIContext().get("isFormAddMembers")).booleanValue() && this.dimension instanceof MbgViewListDimensionInfo) {
            data = new MbgViewListResultData();
            data.getCanAddMembers().addAll(((MbgViewListDimensionInfo)this.dimension).getCanAddMember());
        }
        this.returnData = data;
        return this.returnData instanceof MbgViewListResultData ? this.returnData : null;
    }

    @Override
    public void dataChanged(DataChangeEvent eventObj) {
        if (this.returnData == eventObj.getNewValue() || eventObj.getNewValue() == null) {
            return;
        }
        if (eventObj.getNewValue() instanceof MbgViewListResultData && this.returnData == null && ((MbgViewListResultData)eventObj.getNewValue()).getMembers().isEmpty()) {
            return;
        }
        if (eventObj.getNewValue() instanceof MbgViewListResultData && eventObj.getOldValue() instanceof MbgViewListResultData && !this.isSameDimResult((MbgViewListResultData)eventObj.getOldValue(), (MbgViewListResultData)eventObj.getNewValue()).booleanValue()) {
            return;
        }
        if (this.returnData instanceof MbgViewListResultData && eventObj.getNewValue() instanceof MbgViewListResultData && !this.isSameDimResult(this.returnData, (MbgViewListResultData)eventObj.getNewValue()).booleanValue()) {
            return;
        }
        if (eventObj.getNewValue() instanceof MbgViewListResultData) {
            try {
                BgViewMemberSelectHelper.reFillMembers(this.getSelectDimension(), this.tblRight, this.getSelectHelper(), ((MbgViewListResultData)eventObj.getNewValue()).getMembers());
                this.enableTblRight();
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            this.resettblRight();
        }
    }

    private void enableTblRight() {
        IRow row = null;
        BgDimensionMember member = null;
        int size = this.tblRight.getRowCount();
        for (int index = 0; index < size; ++index) {
            row = this.tblRight.getRow(index);
            if (!(row.getUserObject() instanceof BgDimensionMember)) continue;
            member = (BgDimensionMember)row.getUserObject();
            if (this.versionNum.compareTo(member.getVersion()) > 0) {
                row.getStyleAttributes().setBackground(BgViewMemberSelectHelper.lockColor);
                continue;
            }
            row.getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
        }
    }

    private void resettblRight() {
        IRow row = null;
        for (int m = 0; m < this.tblRight.getRowCount(); ++m) {
            row = this.tblRight.getRow(m);
            if (row.getStyleAttributes().getBackground().equals(BgViewMemberSelectHelper.lockColor)) continue;
            this.tblRight.removeRow(m);
        }
    }

    private Boolean isSameDimResult(MbgViewListResultData result1, MbgViewListResultData result2) {
        if (result1 == null || result2 == null) {
            return false;
        }
        String dimNum1 = this.getDimNumByResultData(result1);
        String dimNum2 = this.getDimNumByResultData(result2);
        return dimNum1.equalsIgnoreCase(dimNum2);
    }

    private String getDimNumByResultData(MbgViewListResultData resultData) {
        int index;
        String dimNum = "";
        for (index = 0; index < resultData.getMembers().size(); ++index) {
            if (dimNum != "" || !(resultData.getMembers().get(index) instanceof BgDimensionMember)) continue;
            dimNum = ((BgDimensionMember)resultData.getMembers().get(index)).getType();
            break;
        }
        if (StringUtils.isEmpty((String)dimNum)) {
            for (index = 0; index < resultData.getCanAddMembers().size(); ++index) {
                if (dimNum != "" || !(resultData.getCanAddMembers().get(index) instanceof BgDimensionMember)) continue;
                dimNum = ((BgDimensionMember)resultData.getCanAddMembers().get(index)).getType();
                break;
            }
        }
        return dimNum;
    }

    @Override
    protected Integer getBottomIndex() {
        return -1;
    }

    @Override
    protected void checkCanRemove(KDTable table, List<Integer> rows) throws EASBizException, BOSException {
        BgDimensionBaseInfo dimension = DimensionClientHelper.getSelectDimension(this.cbxDimension);
        BgMemberSelectTypeEnum selectType = BgMemberSelectTypeEnum.Member;
        MBGViewListFormClientHelper.checkCanRemove(this, dimension, this.dimension, selectType, table, rows, this.orgId, this.getSelectHelper().getSchemeHelper());
    }

    private void addSubMembers(Map<String, Set<String>> subMembers, String sourceNumber, String subMemberNumber) {
        if (!subMembers.containsKey(sourceNumber)) {
            subMembers.put(sourceNumber, new HashSet());
        }
        subMembers.get(sourceNumber).add(subMemberNumber);
    }
}

