/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodF7ListUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgViewMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

public class ViewListAddPeriodF7UI
extends BgPeriodF7ListUI {
    private BgSchemeDimensionHelper schemeHelper = null;

    public void dataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() instanceof MbgViewListResultData) {
            this.reFillMembers((MbgViewListResultData)eventObj.getNewValue());
        } else {
            this.tblRight.removeRows(false);
        }
    }

    protected final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = this.getUIContext().get("BGSCHEME_HELPER") != null ? (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER") : new BgSchemeDimensionHelper(null, (String)this.getUIContext().get("BGSCHEME_ID"));
        }
        return this.schemeHelper;
    }

    protected void remove(List rows) throws Exception {
        Object sourceDimension = this.getUIContext().get("dimension");
        String orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.filterLockRows(this.tblRight, rows);
        if (rows.isEmpty()) {
            return;
        }
        int type = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgCommonResource", (String)"deleteSelectedRowsAndData"));
        if (type == 2 || type == 1) {
            return;
        }
        MBGViewListFormClientHelper.collectFormulas((CoreUI)this, this.getSchemeHelper().getDimension(DimensionConstants.DEF_PERIOD_NUMBER), sourceDimension, this.tblRight, rows, this.schemeHelper);
        super.remove(rows);
    }

    private void filterLockRows(KDTable table, List<Integer> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        Iterator<Integer> it = rows.iterator();
        while (it.hasNext()) {
            if (this.isCanRemove(table.getRow(it.next().intValue()))) continue;
            it.remove();
        }
    }

    protected void reFillMembers(MbgViewListResultData newData) {
        List members = newData.getMembers();
        boolean isCanDeleteTemplateMembers = this.isCanDeleteTemplateMembers();
        if (members != null && !members.isEmpty()) {
            this.tblRight.removeRows();
            for (int i = 0; i < members.size(); ++i) {
                MbgViewListDimensionMember member;
                IRow rowRight;
                if (members.get(i) instanceof BgPeriodInfo) {
                    BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)members.get(i);
                    if (bgPeriodInfo == null) continue;
                    rowRight = this.tblRight.addRow();
                    rowRight.getCell("number").setValue((Object)bgPeriodInfo.getNumber());
                    rowRight.getCell("name").setValue((Object)bgPeriodInfo.getName());
                    rowRight.getCell("alias").setValue((Object)bgPeriodInfo.getDisplayName());
                    if (!(bgPeriodInfo.get("versionNum") instanceof BigDecimal)) continue;
                    BigDecimal verNum = bgPeriodInfo.getBigDecimal("versionNum");
                    rowRight.setUserObject((Object)verNum);
                    if (isCanDeleteTemplateMembers) continue;
                    if (this.versionNum.compareTo(verNum) > 0) {
                        rowRight.getStyleAttributes().setBackground(BgViewMemberSelectHelper.lockColor);
                        continue;
                    }
                    rowRight.getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
                    continue;
                }
                if (!(members.get(i) instanceof MbgViewListDimensionMember) || (member = (MbgViewListDimensionMember)members.get(i)) == null) continue;
                rowRight = this.tblRight.addRow();
                rowRight.getCell("number").setValue((Object)member.getNumber());
                rowRight.getCell("name").setValue((Object)member.getName());
                rowRight.getCell("alias").setValue((Object)member.getAlias());
                rowRight.setUserObject((Object)member.getVersion());
                if (isCanDeleteTemplateMembers) continue;
                if (this.versionNum.compareTo(member.getVersion()) > 0) {
                    rowRight.getStyleAttributes().setBackground(BgViewMemberSelectHelper.lockColor);
                    continue;
                }
                rowRight.getStyleAttributes().setBackground(BgNConstants.BASE_COLOR);
            }
        }
    }

    protected boolean isCanDeleteTemplateMembers() {
        boolean canDeleteTemplateMembers = false;
        try {
            IMbgViewBase viewBase;
            ViewListProvider provider;
            if (this.getUIContext().get("provider") instanceof ViewListProvider && (provider = (ViewListProvider)this.getUIContext().get("provider")).getEditValue() instanceof BgFormInfo && (viewBase = ((BgFormInfo)provider.getEditValue()).getBgTemplate().getView()) instanceof MbgViewListManager) {
                canDeleteTemplateMembers = ((MbgViewListSheetManager)((MbgViewListManager)viewBase).getSheetManagers().get(0)).isCanDeleteTemplateMembers();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return canDeleteTemplateMembers;
    }
}

