/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.MultiColorListCellRenderer;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.MultiColorListElement;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgMeasureUnitEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.StyleSetInfo;
import com.kingdee.eas.ma.mbg.client.AbstractViewListCalculatorEditUI;
import com.kingdee.eas.ma.mbg.client.ViewListCalculatorRowSelectUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgFormulaPicker;
import com.kingdee.eas.ma.mbg.client.utils.NumberDisplayComboBoxUi;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListCalculatorDataStyleInfo;
import com.kingdee.eas.ma.mbg.common.calcRow.AbstractCalcExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ColExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ExprParseHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.FormulaExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.LeftBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.OperatorExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RightBracket;
import com.kingdee.eas.ma.mbg.common.calcRow.RowExpr;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class ViewListCalculatorEditUI
extends AbstractViewListCalculatorEditUI {
    private static final long serialVersionUID = 3180526163308669358L;
    private static final Logger logger = CoreUIObject.getLogger(ViewListCalculatorEditUI.class);
    private boolean isCancel = true;
    private boolean isCol = false;
    private MbgViewListCalcutor calc = null;
    private BgTemplateInfo bgTemplateInfo = null;
    private StyleSetInfo styleSetInfo = null;
    private boolean isReparse = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtMain.setBorder(BorderFactory.createEtchedBorder());
        DefaultStyledDocument doc = new DefaultStyledDocument(){
            private static final long serialVersionUID = -7499312351538921650L;

            @Override
            protected void fireInsertUpdate(DocumentEvent e) {
                super.fireInsertUpdate(e);
                ViewListCalculatorEditUI.this.reParseDocumentStyle();
            }

            @Override
            protected void fireRemoveUpdate(DocumentEvent e) {
                super.fireRemoveUpdate(e);
                ViewListCalculatorEditUI.this.reParseDocumentStyle();
            }
        };
        this.txtMain.setStyledDocument((StyledDocument)doc);
        this.isCol = Boolean.TRUE.equals(this.getUIContext().get("col"));
        if (this.isCol) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"calcColSet"));
            this.btnRow.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"colGroupIndex"));
        }
        this.calc = (MbgViewListCalcutor)this.getUIContext().get("InitDataObject");
        if (this.calc != null) {
            this.txtMain.setText(this.calc.getFormula());
        }
        if (this.getUIContext().get("editDataValue") instanceof BgTemplateInfo) {
            this.bgTemplateInfo = (BgTemplateInfo)this.getUIContext().get("editDataValue");
            this.styleSetInfo = this.bgTemplateInfo.getStyleSet();
        }
        if (this.getUIContext().get("styleSetInfo") instanceof StyleSetInfo) {
            this.styleSetInfo = (StyleSetInfo)this.getUIContext().get("styleSetInfo");
        }
        this.loadFields();
    }

    @Override
    protected void btnRow_actionPerformed(ActionEvent e) throws Exception {
        super.btnRow_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"dimension.object", this.getUIContext().get("dimension.object"));
        uiContext.put((Object)"col", this.getUIContext().get("col"));
        uiContext.put((Object)"currIndex", this.getUIContext().get("currIndex"));
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ViewListCalculatorRowSelectUI.class.getName(), (Map)uiContext);
        ViewListCalculatorRowSelectUI ui = (ViewListCalculatorRowSelectUI)window.getUIObject();
        window.show();
        if (!ui.isCancel()) {
            this.addText(AbstractCalcExpr.getCombin(this.isCol ? "C" : "R", String.valueOf(ui.getGroupIndex())));
        }
        this.txtMain.requestFocus();
    }

    private void addText(String text) {
        this.txtMain.replaceSelection(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reParseDocumentStyle() {
        if (!this.isReparse) {
            try {
                this.isReparse = true;
                String text = this.txtMain.getText();
                StyledDocument doc = this.txtMain.getStyledDocument();
                int position = this.txtMain.getCaretPosition();
                if (doc.getLength() > 0) {
                    doc.remove(0, doc.getLength());
                }
                ExprParseHelper.parseDocument(text, doc);
                this.txtMain.setCaretPosition(position);
            }
            catch (BadLocationException e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
            finally {
                this.isReparse = false;
            }
        }
    }

    @Override
    protected void btnFormula_actionPerformed(ActionEvent e) throws Exception {
        super.btnFormula_actionPerformed(e);
        MbgFormulaPicker picker = new MbgFormulaPicker((Component)((Object)this));
        RptContextManager rptContext = new RptContextManager();
        rptContext.setReportInfo((VirtualSheetParamInfo)this.getUIContext().get("editDataValue"));
        picker.setRptContextManager(rptContext);
        picker.setFormulaPickListener(new FormulaPickListener(){

            public void setFormulaLine(String formulaLine) {
                ViewListCalculatorEditUI.this.addText(AbstractCalcExpr.getCombin("GVF", formulaLine));
            }

            public String pickFormulaLine() {
                return null;
            }
        });
        picker.show();
        this.txtMain.requestFocus();
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        this.addOperator("+");
    }

    @Override
    protected void btnSub_actionPerformed(ActionEvent e) throws Exception {
        super.btnSub_actionPerformed(e);
        this.addOperator("-");
    }

    @Override
    protected void btnMulti_actionPerformed(ActionEvent e) throws Exception {
        super.btnMulti_actionPerformed(e);
        this.addOperator("*");
    }

    @Override
    protected void btnDiv_actionPerformed(ActionEvent e) throws Exception {
        super.btnDiv_actionPerformed(e);
        this.addOperator("/");
    }

    @Override
    protected void btnLeft_actionPerformed(ActionEvent e) throws Exception {
        super.btnLeft_actionPerformed(e);
        this.addOperator("(");
    }

    @Override
    protected void btnRight_actionPerformed(ActionEvent e) throws Exception {
        super.btnRight_actionPerformed(e);
        this.addOperator(")");
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    private void addOperator(String operator) {
        this.addText(operator);
        this.txtMain.requestFocus();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.verifyData();
        this.calc.setFormula(this.txtMain.getText());
        this.calc.setDataStyleInfo(this.getDataStyleInfo());
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void txtMain_mouseClicked(MouseEvent e) throws Exception {
        super.txtMain_mouseClicked(e);
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            int position = this.txtMain.getCaretPosition();
            List<IExpr> exprs = ExprParseHelper.parse(this.txtMain.getText());
            IExpr expr = null;
            int beginIndex = 0;
            String source = null;
            block0: for (int i = 0; i < exprs.size(); ++i) {
                if (position < beginIndex + exprs.get(i).getSource().length()) {
                    expr = exprs.get(i);
                    source = expr.getSource();
                    if (!(expr instanceof FormulaExpr)) break;
                    FormulaExpr formulaExpr = (FormulaExpr)expr;
                    int newIndex = beginIndex + ("GVF".length() + ":".length() + "[".length());
                    List<Object> tokens = formulaExpr.getTokens();
                    for (int t = 0; t < tokens.size(); ++t) {
                        if (tokens.get(t) instanceof IExpr) {
                            if (position >= newIndex + ((IExpr)tokens.get(t)).getSource().length()) continue;
                            expr = (IExpr)tokens.get(t);
                            source = expr.getSource();
                            beginIndex = newIndex;
                            break block0;
                        }
                        if (position < newIndex + String.valueOf(tokens.get(t)).length()) break block0;
                        newIndex += String.valueOf(tokens.get(t)).length();
                    }
                    break;
                }
                beginIndex += exprs.get(i).getSource().length();
            }
            if (expr instanceof RowExpr || expr instanceof ColExpr) {
                return;
            }
            if (expr instanceof FormulaExpr) {
                final FormulaExpr formulaExpr = (FormulaExpr)expr;
                final int bgi = beginIndex;
                final String s = source;
                MbgFormulaPicker picker = new MbgFormulaPicker((Component)((Object)this));
                RptContextManager rptContext = new RptContextManager();
                rptContext.setReportInfo((VirtualSheetParamInfo)this.getUIContext().get("editDataValue"));
                picker.setRptContextManager(rptContext);
                picker.setFormulaPickListener(new FormulaPickListener(){

                    public void setFormulaLine(String formulaLine) {
                        ViewListCalculatorEditUI.this.txtMain.setText(ViewListCalculatorEditUI.this.txtMain.getText().substring(0, bgi) + AbstractCalcExpr.getCombin("GVF", formulaLine) + ViewListCalculatorEditUI.this.txtMain.getText().substring(bgi + s.length()));
                    }

                    public String pickFormulaLine() {
                        return "=" + formulaExpr.getPickFormula();
                    }
                });
                picker.show();
            }
        }
    }

    @Override
    protected void txtMain_caretUpdate(CaretEvent e) throws Exception {
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    public void verifyData() throws Exception {
        boolean isCol;
        OperatorExpr expr;
        List<IExpr> exprs;
        super.verifyData();
        String formula = this.txtMain.getText();
        if (formula == null || formula.trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"formulaCannotEmpty"));
            SysUtil.abort();
        }
        if ((exprs = ExprParseHelper.parse(this.txtMain.getText())).get(0) instanceof OperatorExpr && ((expr = (OperatorExpr)exprs.get(0)).getOperator().equals("+") || expr.getOperator().equals("*") || expr.getOperator().equals("/"))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"startByAMS"));
            SysUtil.abort();
        }
        if (exprs.get(exprs.size() - 1) instanceof OperatorExpr) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"endByOperator"));
            SysUtil.abort();
        }
        boolean hasOther = false;
        Integer curIndex = (Integer)this.getUIContext().get("currIndex");
        if (!(hasOther = ViewListCalculatorEditUI.verifyExpr(this, exprs, hasOther, curIndex, isCol = Boolean.TRUE.equals(this.getUIContext().get("col"))))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"mustHasOther"));
            SysUtil.abort();
        }
        Sheet sheet = Book.Manager.getNewBook((String)"Book", (int)1).getSheet(0);
        FormulaDefinition.registerFormulaToBook((Book)sheet.getBook(), (ICalculateContextProvider)new ReportCalculateContext(null));
        IExpr beforeExpr = null;
        int bracketCount = 0;
        for (int i = 0; i < exprs.size(); ++i) {
            Expr _expr;
            MbgViewListSheetManager sheetManager;
            if (exprs.get(i) instanceof LeftBracket) {
                ++bracketCount;
                continue;
            }
            if (exprs.get(i) instanceof RightBracket) {
                if (beforeExpr == null || beforeExpr instanceof OperatorExpr) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"rightBrackedBeforeByOther"));
                    SysUtil.abort();
                }
                if (--bracketCount >= 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"brackedMustBoth"));
                SysUtil.abort();
                continue;
            }
            if (exprs.get(i) instanceof OperatorExpr) {
                if (i > 0 && exprs.get(i - 1) instanceof LeftBracket) {
                    if (exprs.get(i - 1) instanceof LeftBracket) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"leftBracketCannotAfterByOper"));
                        SysUtil.abort();
                    }
                } else if (beforeExpr instanceof OperatorExpr) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"operatorBetweenByOther"));
                    SysUtil.abort();
                }
                beforeExpr = exprs.get(i);
                continue;
            }
            if (beforeExpr != null && !(beforeExpr instanceof OperatorExpr)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"otherMustBeforeByOperator"));
                SysUtil.abort();
            }
            if (exprs.get(i) instanceof RowExpr) {
                sheetManager = this.getSheetManager();
                if (!MbgViewListManager.checkHasRow(sheetManager.getDimensionManager().getRows(), ((RowExpr)exprs.get(i)).getRow())) {
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"rowIndexNotExists"), ((RowExpr)exprs.get(i)).getSource()));
                    SysUtil.abort();
                }
            } else if (exprs.get(i) instanceof ColExpr) {
                sheetManager = this.getSheetManager();
                if (!MbgViewListManager.checkHasRow(sheetManager.getDimensionManager().getColumns(), ((ColExpr)exprs.get(i)).getCol())) {
                    MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"colIndexNotExists"), ((ColExpr)exprs.get(i)).getSource()));
                    SysUtil.abort();
                }
            } else if (exprs.get(i) instanceof FormulaExpr && ((_expr = sheet.getExpr((ICalculable)sheet.getCell(0, 0, true), ((FormulaExpr)exprs.get(i)).getCheckFormula())) == null || _expr.hasUnknownMethod() || _expr.isSyntaxError())) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"formulaError"), ((FormulaExpr)exprs.get(i)).getSource()));
                SysUtil.abort();
            }
            beforeExpr = exprs.get(i);
        }
        if (bracketCount != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"brackedMustBoth"));
            SysUtil.abort();
        }
    }

    public static boolean verifyExpr(CoreUI owner, List<IExpr> exprs, boolean hasOther, Integer curIndex, boolean isCol) {
        return DimensionClientHelper.verifyExpr((Component)owner, exprs, hasOther, curIndex, isCol);
    }

    private MbgViewListSheetManager getSheetManager() {
        return (MbgViewListSheetManager)this.getUIContext().get("dimension.object");
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void enableChk() {
    }

    @Override
    protected void cbxDecimal_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxDecimal_itemStateChanged(e);
        this.initNegativeList(this.cbxDecimal.getSelectedIndex(), this.chkThouSeperator.isSelected(), this.cbxNegetive, this.chkShowPercent.isSelected());
    }

    @Override
    protected void chkThouSeperator_stateChanged(ChangeEvent e) throws Exception {
        super.chkThouSeperator_stateChanged(e);
        this.initNegativeList(this.cbxDecimal.getSelectedIndex(), this.chkThouSeperator.isSelected(), this.cbxNegetive, this.chkShowPercent.isSelected());
    }

    @Override
    protected void chkShowPercent_stateChanged(ChangeEvent e) throws Exception {
        super.chkShowPercent_stateChanged(e);
        this.initNegativeList(this.cbxDecimal.getSelectedIndex(), this.chkThouSeperator.isSelected(), this.cbxNegetive, this.chkShowPercent.isSelected());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initNegativeList(this.cbxDecimal.getSelectedIndex(), this.chkThouSeperator.isSelected(), this.cbxNegetive, this.chkShowPercent.isSelected());
        if (this.calc.getDataStyleInfo() == null) {
            this.cbxDecimal.setSelectedIndex(2);
            this.chkThouSeperator.setSelected(true);
            this.cbxMeasureUnit.setSelectedIndex(0);
            this.chkShowPercent.setSelected(false);
            this.initNegativeList(2, true, this.cbxNegetive, false);
        } else {
            ViewListCalculatorDataStyleInfo calcDataStyle = this.calc.getDataStyleInfo();
            this.cbxDecimal.setSelectedIndex(calcDataStyle.getDecNums());
            this.chkThouSeperator.setSelected(calcDataStyle.isHasGroupSep());
            this.cbxNegetive.setSelectedIndex(calcDataStyle.getNegativeIndex());
            this.cbxMeasureUnit.setSelectedIndex(calcDataStyle.getMeasureUnit());
            this.chkShowPercent.setSelected(calcDataStyle.isShowPercent());
        }
        this.enableChk();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.cbxNegetive.setUI((ComboBoxUI)((Object)new NumberDisplayComboBoxUi()));
        this.cbxNegetive.setRenderer((ListCellRenderer)new MultiColorListCellRenderer());
        this.initDecimal(this.cbxDecimal);
        this.initMeasureUnit(this.cbxMeasureUnit);
    }

    private void initDecimal(KDComboBox combox) {
        combox.addItem((Object)0);
        combox.addItem((Object)1);
        combox.addItem((Object)2);
        combox.addItem((Object)3);
        combox.addItem((Object)4);
        combox.addItem((Object)5);
        combox.addItem((Object)6);
        combox.addItem((Object)7);
        combox.addItem((Object)8);
    }

    private void initMeasureUnit(KDComboBox combox) {
        combox.addItem((Object)BgMeasureUnitEnum.one);
        combox.addItem((Object)BgMeasureUnitEnum.thousand);
        combox.addItem((Object)BgMeasureUnitEnum.tenThounsand);
        combox.addItem((Object)BgMeasureUnitEnum.hundredThousand);
        combox.addItem((Object)BgMeasureUnitEnum.million);
        combox.addItem((Object)BgMeasureUnitEnum.tenMillion);
        combox.addItem((Object)BgMeasureUnitEnum.billion);
    }

    private void initNegativeList(int decimal, boolean group, KDComboBox comboBox, boolean isShowPercent) {
        String str;
        String percent = isShowPercent ? "%" : "";
        String dd = "";
        StringBuffer sdec = new StringBuffer();
        for (int i = decimal - 1; i >= 0; --i) {
            int n = i;
            if (n >= 10) {
                n %= 10;
            }
            sdec.append(n);
        }
        if (sdec.length() > 0) {
            dd = '.' + sdec.toString();
        }
        String string = str = group ? "1,234" : "1234";
        if (comboBox == null) {
            comboBox = new KDComboBox();
            comboBox.setRenderer((ListCellRenderer)new MultiColorListCellRenderer());
        }
        int oldSelectIndex = comboBox.getSelectedIndex();
        comboBox.removeAllItems();
        String e = '(' + str + dd + percent + ')';
        MultiColorListElement element = new MultiColorListElement();
        element.setElement((Object)e);
        element.setForegroud(Color.RED);
        comboBox.addItem((Object)element);
        element = new MultiColorListElement();
        element.setElement((Object)e);
        comboBox.addItem((Object)element);
        e = str + dd + percent;
        element = new MultiColorListElement();
        element.setElement((Object)e);
        element.setForegroud(Color.RED);
        comboBox.addItem((Object)element);
        e = '-' + e;
        element = new MultiColorListElement();
        element.setElement((Object)e);
        comboBox.addItem((Object)element);
        element = new MultiColorListElement();
        element.setElement((Object)e);
        element.setForegroud(Color.RED);
        comboBox.addItem((Object)element);
        if (oldSelectIndex != -1) {
            comboBox.setSelectedIndex(oldSelectIndex);
        } else {
            comboBox.setSelectedItem((Object)element);
        }
    }

    private ViewListCalculatorDataStyleInfo getDataStyleInfo() {
        ViewListCalculatorDataStyleInfo dataStyleInfo = new ViewListCalculatorDataStyleInfo();
        dataStyleInfo.setDecNums(this.cbxDecimal.getSelectedIndex());
        dataStyleInfo.setHasGroupSep(this.chkThouSeperator.isSelected());
        dataStyleInfo.setNegativeIndex(this.cbxNegetive.getSelectedIndex());
        dataStyleInfo.setMeasureUnit(this.cbxMeasureUnit.getSelectedIndex());
        dataStyleInfo.setShowPercent(this.chkShowPercent.isSelected());
        return dataStyleInfo;
    }
}

