/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.utils.IViewDimensionMemberF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractViewListFormCombinMemberF7UI;
import com.kingdee.eas.ma.mbg.client.BgCombinMemberImportUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ViewListFormCombinMemberF7UI
extends AbstractViewListFormCombinMemberF7UI
implements IViewDimensionMemberF7,
IGetSchemeHelper {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ViewListFormCombinMemberF7UI.class);
    public static final String COL_NUMBER = "number.";
    public static final String COL_NAME = "name.";
    protected boolean isCanceled = true;
    protected MbgViewListResultData data = null;
    private CostCenterOrgUnitInfo orgUnit = null;
    private FullOrgUnitInfo unionGroupInfo = null;
    private DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);

    public CostCenterOrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    public FullOrgUnitInfo getUnionGroupInfo() {
        return this.unionGroupInfo;
    }

    public DimensionCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.readOrgUnit();
        super.onLoad();
    }

    @Override
    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.getUIContext().get("BGSCHEME_HELPER") != null) {
            return (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        }
        return DimensionMemberSelectHelper.getSchemeHelper(this.getUIContext().get("Owner"));
    }

    public Object getData() throws BOSException, EASBizException {
        return this.data;
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.tblMain.addRow();
        this.tblMain.getSelectManager().select(this.tblMain.getRowCount(), 0);
    }

    @Override
    protected void btnCopyRow_actionPerformed(ActionEvent e) throws Exception {
        int activeRow = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRow < 0) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"no_select"));
            return;
        }
        int colCounts = this.tblMain.getColumnCount();
        IRow fromRow = this.tblMain.getRow(activeRow);
        IRow toRow = this.tblMain.addRow(activeRow);
        for (int i = 0; i < colCounts; ++i) {
            toRow.getCell(i).setValue(fromRow.getCell(i).getValue());
        }
    }

    @Override
    protected void btnDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.removeRows((KDTable)this.tblMain);
    }

    @Override
    protected void btnInput_actionPerformed(ActionEvent e) throws Exception {
        super.btnInput_actionPerformed(e);
        this.importExcel();
    }

    @Override
    protected void btnOutput_actionPerformed(ActionEvent e) throws Exception {
        super.btnOutput_actionPerformed(e);
        this.export();
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkHideRow();
        BgCommCHelper.moveTop((KDTable)this.tblMain);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkHideRow();
        BgCommCHelper.moveUp((KDTable)this.tblMain);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkHideRow();
        BgCommCHelper.moveDown((KDTable)this.tblMain);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkHideRow();
        BgCommCHelper.moveBottom((KDTable)this.tblMain);
    }

    protected void checkHideRow() {
        int count = this.tblMain.getRowCount();
        for (int index = 0; index < count; ++index) {
            if (!this.tblMain.getRow(index).getStyleAttributes().isHided()) continue;
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"searchAll"));
            SysUtil.abort();
        }
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.isCanceled = false;
        this.verifyData();
        this.getUIWindow().close();
    }

    public void verifyData() throws Exception {
        int rowCount = this.tblMain.getRowCount();
        int colCount = this.tblMain.getColumnCount();
        HashMap<String, Integer> repeat = new HashMap<String, Integer>();
        IColumn column = null;
        ICell cell = null;
        BgDimensionBaseInfo dimension = null;
        MbgViewListResultData resultData = new MbgViewListResultData();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (this.isEmptyRow(this.tblMain.getRow(rowIndex)).booleanValue()) continue;
            String columnKey = null;
            String cellValue = "";
            BgDimensionMember member = null;
            BgDimensionMember[] members = new BgDimensionMember[colCount / 2];
            for (int colIndex = 0; colIndex < colCount / 2; ++colIndex) {
                column = this.tblMain.getColumn(colIndex * 2);
                cell = this.tblMain.getCell(rowIndex, colIndex * 2);
                columnKey = column.getKey();
                dimension = (BgDimensionBaseInfo)this.getUserObject(this.tblMain, column);
                if (cell.getValue() instanceof String) {
                    cellValue = (String)cell.getValue();
                } else if (cell.getValue() == null) {
                    cellValue = null;
                }
                member = new BgDimensionMember(dimension.getNumber(), dimension.getAttribute(), null, null);
                member.setSrcNumber(this.getSchemeHelper().getSrcNumber(dimension.getNumber()));
                if (this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), true).equals(columnKey)) {
                    member.setNumber(cellValue);
                }
                member.setName((String)this.tblMain.getCell(rowIndex, colIndex * 2 + 1).getValue());
                members[colIndex] = member;
            }
            BgDimensionMember combineMember = ViewlistCombinHelper.getCombinMemberByDimMember(members);
            if (!repeat.containsKey(combineMember.getNumber())) {
                repeat.put(combineMember.getNumber(), rowIndex);
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"checkCombin_repeat", (Object[])new Object[]{(Integer)repeat.get(combineMember.getNumber()) + 1, rowIndex + 1}));
                SysUtil.abort();
            }
            resultData.getMembers().add(combineMember);
        }
        this.data = resultData;
    }

    protected Boolean isEmptyRow(IRow row) {
        boolean empty = true;
        int count = this.tblMain.getColumnCount();
        for (int index = 0; index < count; ++index) {
            if (row.getCell(index).getValue() == null || !(row.getCell(index).getValue() instanceof String) || StringUtils.isEmpty((String)((String)row.getCell(index).getValue()))) continue;
            empty = false;
            break;
        }
        return empty;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.search();
    }

    protected void search() {
        String text = this.txtSearch.getText();
        int rowCount = this.tblMain.getRowCount();
        int colCount = this.tblMain.getColumnCount();
        ICell cell = null;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            Boolean match = false;
            String cellValue = "";
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                cell = this.tblMain.getCell(rowIndex, colIndex);
                if (cell.getValue() instanceof String) {
                    cellValue = (String)cell.getValue();
                }
                if (cellValue.indexOf(text) < 0) continue;
                match = true;
                break;
            }
            if (!match.booleanValue()) {
                this.tblMain.getRow(rowIndex).getStyleAttributes().setHided(true);
                continue;
            }
            this.tblMain.getRow(rowIndex).getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        super.txtSearch_focusLost(e);
        this.search();
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        ICell cell = row.getCell(colIndex);
        BgDimensionMember member = null;
        BgDimensionBaseInfo dimension = (BgDimensionBaseInfo)this.getUserObject(this.tblMain, this.tblMain.getColumn(colIndex));
        if (cell.getValue() instanceof BgDimensionMember || cell.getValue() instanceof List && ((List)cell.getValue()).size() >= 0) {
            if (cell.getValue() instanceof BgDimensionMember) {
                member = (BgDimensionMember)cell.getValue();
            } else {
                List list = (List)cell.getValue();
                member = (BgDimensionMember)list.get(0);
            }
            row.getCell(colIndex).setValue((Object)member.getNumber());
            row.getCell(this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), false)).setValue((Object)member.getName());
        } else if (cell.getValue() == null) {
            row.getCell(colIndex).setValue(null);
            row.getCell(this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), false)).setValue(null);
        } else if (cell.getValue() instanceof BgPeriodInfo) {
            String periodNum = ((BgPeriodInfo)cell.getValue()).getNumber();
            String periodName = ((BgPeriodInfo)cell.getValue()).getName();
            row.getCell(colIndex).setValue((Object)periodNum);
            row.getCell(this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), false)).setValue((Object)periodName);
        }
    }

    public void reShow() {
    }

    public void dataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() != null || eventObj.getOldValue() != null || eventObj.getNewValue() == eventObj.getOldValue()) {
            // empty if block
        }
        try {
            this.loadTable();
            if (eventObj.getNewValue() instanceof MbgViewListResultData) {
                this.reFillData(eventObj);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void reFillData(DataChangeEvent eventObj) {
        MbgViewListResultData resultData = (MbgViewListResultData)eventObj.getNewValue();
        if (!resultData.getMembers().isEmpty()) {
            List combinMembers = resultData.getMembers();
            String[] numbers = null;
            String[] names = null;
            for (BgDimensionMember combinMember : combinMembers) {
                numbers = combinMember.getNumber().split(DimensionConstants.COMMA_SEPARATOR);
                names = combinMember.getName().split(DimensionConstants.TICK_SEPARATOR);
                IRow row = this.tblMain.addRow();
                for (int colIndex = 0; colIndex < this.tblMain.getColumnCount() / 2; ++colIndex) {
                    try {
                        row.getCell(colIndex * 2).setValue((Object)numbers[colIndex]);
                        row.getCell(colIndex * 2 + 1).setValue((Object)names[colIndex]);
                        continue;
                    }
                    catch (Exception e) {
                        row.getCell(colIndex * 2).setValue(null);
                        row.getCell(colIndex * 2 + 1).setValue(null);
                    }
                }
            }
        }
    }

    public void setMultiSelect(boolean multiSelect) {
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    protected List<BgDimensionBaseInfo> getCombinDimensions() {
        if (this.getUIContext().get("combinDimensions") != null) {
            List combinDimensions = (List)this.getUIContext().get("combinDimensions");
            ArrayList<BgDimensionBaseInfo> dimmensions = new ArrayList<BgDimensionBaseInfo>();
            for (int i = 0; i < combinDimensions.size(); ++i) {
                if (((BgDimensionBaseInfo)combinDimensions.get(i)).getNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
                dimmensions.add((BgDimensionBaseInfo)combinDimensions.get(i));
            }
            return dimmensions;
        }
        return null;
    }

    protected void loadTable() throws EASBizException, BOSException {
        List<BgDimensionBaseInfo> combinDimensions = this.getCombinDimensions();
        if (combinDimensions != null) {
            this.tblMain.removeColumns();
            BgDimensionBaseInfo dimension = null;
            IColumn column = null;
            IRow head = this.tblMain.getHeadRow(0);
            if (head == null) {
                head = this.tblMain.addHeadRow();
            }
            for (int index = 0; index < combinDimensions.size(); ++index) {
                dimension = combinDimensions.get(index);
                column = this.tblMain.addColumn();
                column.setKey(this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), true));
                this.setUserObject(this.tblMain, column, dimension);
                column.setEditor((ICellEditor)this.initCellEditor(dimension));
                column.getStyleAttributes().setLocked(false);
                head.getCell(column.getColumnIndex()).setValue((Object)MessageFormat.format(BgCommCHelper.getMessageStr((String)DimensionConstants.DIMEN_COMMON_RESOURCE, (String)"sourceNumber"), dimension.getName()));
                column = this.tblMain.addColumn();
                column.setKey(this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), false));
                this.setUserObject(this.tblMain, column, dimension);
                head.getCell(column.getColumnIndex()).setValue((Object)MessageFormat.format(BgCommCHelper.getMessageStr((String)DimensionConstants.DIMEN_COMMON_RESOURCE, (String)"sourceName"), dimension.getName()));
                column.getStyleAttributes().setLocked(true);
            }
        }
    }

    public String getColumnKey(String srcNumber, boolean isNumber) {
        return (isNumber ? COL_NUMBER : COL_NAME) + srcNumber;
    }

    private KDTDefaultCellEditor initCellEditor(BgDimensionBaseInfo dimension) throws EASBizException, BOSException {
        BgPeriodDialog dialog = null;
        boolean isPeriodDisp = false;
        if (dimension.getNumber().equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
            dialog = new BgPeriodDialog((CoreUIObject)this);
            dialog.setMultiSelect(false);
            isPeriodDisp = true;
            String bgSchemeId = this.getSchemeHelper().getBgSchemeId();
            BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId));
            dialog.setBgPeriodBeginDate(bgSchemeInfo.getDateFrom());
            dialog.setBgPeriodEndDate(bgSchemeInfo.getDateTo());
            dialog.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
            dialog.setBgSchemeID(this.getSchemeHelper().getBgSchemeId());
        }
        NewDimensionMemberSelectDialog orgUnitDim = this.createDimensionF7(this, this.getSchemeHelper().getBgSchemeId(), this.getSchemeHelper().getDimension(dimension.getNumber()), this.orgUnit, this.unionGroupInfo);
        KDBizPromptBox prmtDim = new KDBizPromptBox();
        prmtDim.setRequired(true);
        prmtDim.setEditable(false);
        if (!isPeriodDisp) {
            prmtDim.setSelector((KDPromptSelector)orgUnitDim);
        } else {
            prmtDim.setSelector((KDPromptSelector)dialog);
        }
        return new KDTDefaultCellEditor((IKDEditor)prmtDim);
    }

    protected NewDimensionMemberSelectDialog createDimensionF7(CoreUI ownerUI, String bgSchemeId, BgDimensionInfo dimInfo, CostCenterOrgUnitInfo orgUnit, FullOrgUnitInfo unionGroupInfo) {
        NewDimensionMemberSelectDialog orgUnitDim = new NewDimensionMemberSelectDialog((Component)ownerUI, bgSchemeId, dimInfo, orgUnit.getId().toString(), false, false);
        if (unionGroupInfo != null) {
            orgUnitDim.setUninGroupId(unionGroupInfo.getId().toString());
        }
        if (!DimensionConstants.necessary.contains(dimInfo.getNumber())) {
            orgUnitDim.setShowFilterRadioBtn(true);
        }
        return orgUnitDim;
    }

    private void readOrgUnit() throws Exception {
        String orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        this.orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        String groupOrgId = (String)this.getUIContext().get("GROUPORG_ID");
        if (groupOrgId != null) {
            this.unionGroupInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(groupOrgId));
        }
    }

    public void setUserObject(KDTable tblMain, IColumn column, BgDimensionBaseInfo dimension) {
        HashMap<String, BgDimensionBaseInfo> userObject = (HashMap<String, BgDimensionBaseInfo>)tblMain.getUserObject();
        if (userObject == null) {
            userObject = new HashMap<String, BgDimensionBaseInfo>();
            tblMain.setUserObject(userObject);
        }
        userObject.put(column.getKey(), dimension);
    }

    public Object getUserObject(KDTable tblMain, IColumn column) {
        Map userObject = (Map)tblMain.getUserObject();
        if (userObject != null) {
            return userObject.get(column.getKey());
        }
        return null;
    }

    public List<String> getSrcNumbers(KDTable table, BgSchemeDimensionHelper schemeHelper) {
        ArrayList<String> srcNumbers = new ArrayList<String>();
        if (table != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                BgDimensionBaseInfo info;
                if (!(this.getUserObject(table, table.getColumn(i)) instanceof BgDimensionBaseInfo) || srcNumbers.contains(schemeHelper.getSrcNumber((info = (BgDimensionBaseInfo)this.getUserObject(table, table.getColumn(i))).getNumber()))) continue;
                srcNumbers.add(schemeHelper.getSrcNumber(info.getNumber()));
            }
        }
        return srcNumbers;
    }

    public void export() throws Exception {
        String filePath = ViewListFormCombinMemberF7UI.showExportDialog(this);
        KDSBook kdsBook = new KDSBook("aaa");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "Sheet1");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        List<String> srcNumbers = this.getSrcNumbers(this.tblMain, this.getSchemeHelper());
        int srcNumSize = srcNumbers.size();
        for (int i = 0; i < srcNumSize; ++i) {
            kdsSheet.setColumnWidth(i * 2, 35.0f);
            kdsSheet.setCellValue(0, i * 2, this.tblMain.getHeadRow(0).getCell(this.getColumnKey(srcNumbers.get(i), true)).getValue());
            kdsSheet.setColumnWidth(i * 2 + 1, 50.0f);
            kdsSheet.setCellValue(0, i * 2 + 1, this.tblMain.getHeadRow(0).getCell(this.getColumnKey(srcNumbers.get(i), false)).getValue());
        }
        IRow row = null;
        Object dimensionNumber = null;
        Object dimensionName = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            for (int c = 0; c < srcNumSize; ++c) {
                dimensionNumber = row.getCell(this.getColumnKey(srcNumbers.get(c), true)).getValue();
                dimensionName = row.getCell(this.getColumnKey(srcNumbers.get(c), false)).getValue();
                kdsSheet.setCellValue(i + 1, c * 2, (Object)StringUtils.cnulls((Object)dimensionNumber));
                kdsSheet.setCellValue(i + 1, c * 2 + 1, (Object)StringUtils.cnulls((Object)dimensionName));
            }
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"22_BgExportHelper"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"fileIsNotOpen"));
        }
    }

    protected List<String[]> getImportNumAndNames(KDSSheet sheet, List<String> srcNumbers, Date startDate, Date endDate, StringBuffer errorDetail) throws EASBizException, BOSException {
        int rowCount = sheet.getRowCount();
        ArrayList<String[]> lst = new ArrayList<String[]>();
        String[] dimensionNumberAndName = null;
        for (int i = 1; i < rowCount; ++i) {
            dimensionNumberAndName = this.importDimNumberAndName(this, this.tblMain, sheet, i, srcNumbers, this.getSchemeHelper(), startDate, endDate, errorDetail);
            lst.add(dimensionNumberAndName);
        }
        return lst;
    }

    public void importExcel() throws EASBizException, BOSException {
        List<BgDimensionBaseInfo> combinDimensions = this.getCombinDimensions();
        if (combinDimensions == null) {
            return;
        }
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"template", (Object)this.tblMain);
        ctx.put((Object)"combinDimensions", combinDimensions);
        ctx.put((Object)"BGSCHEME_HELPER", (Object)this.getSchemeHelper());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.mbg.client.BgCombinMemberImportUI", (Map)ctx, null, OprtState.VIEW);
        window.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"importTitle"));
        window.show();
        if (((BgCombinMemberImportUI)window.getUIObject()).sheet == null) {
            return;
        }
        boolean isReturnRightNow = 1 == ((BgCombinMemberImportUI)window.getUIObject()).getErrorNum();
        StringBuffer errorDetail = new StringBuffer();
        boolean isTooLong = false;
        KDSSheet sheet = ((BgCombinMemberImportUI)window.getUIObject()).sheet;
        int rowCount = sheet.getRowCount();
        int colCount = ViewlistCombinHelper.getColumnCount(sheet);
        if (!this.checkColumsTiltle(this.tblMain, sheet)) {
            MsgBox.showInfo((Component)((Object)this), (String)DimensionRelationClientHelper.getDimCommResource("combinMember_importError"));
            return;
        }
        if (2 * combinDimensions.size() - colCount != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)DimensionRelationClientHelper.getDimCommResource("dimIndexCountError"));
            return;
        }
        List<String> NumberList = this.getEntriesNumberCombin(this.tblMain);
        List<String> srcNumbers = this.getSrcNumbers(this.tblMain, this.getSchemeHelper());
        String bgSchemeId = this.getSchemeHelper().getBgSchemeId();
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId));
        Date startDate = bgSchemeInfo.getDateFrom();
        Date endDate = bgSchemeInfo.getDateTo();
        String[] dimensionNumberAndName = null;
        List<String[]> dimensionNumberAndNames = this.getImportNumAndNames(sheet, srcNumbers, startDate, endDate, errorDetail);
        Map existMembers = this.queryExistMembers(combinDimensions, dimensionNumberAndNames);
        String importRepeatMsg = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"importRepeat");
        String dimMsg = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"dimensionNumber");
        try {
            block3: for (int i = 0; i < rowCount - 1; ++i) {
                dimensionNumberAndName = dimensionNumberAndNames.get(i);
                if (dimensionNumberAndName != null) {
                    if (!(isTooLong || dimensionNumberAndName[0].length() <= 255 && dimensionNumberAndName[1].length() <= 255)) {
                        isTooLong = true;
                        continue;
                    }
                    if (NumberList.contains(dimensionNumberAndName[0])) {
                        String[] combinas = DimensionFormulaHelper.splitCombinations(dimensionNumberAndName[0]);
                        StringBuffer numberMsg = new StringBuffer();
                        for (int c = 0; c < combinas.length; ++c) {
                            if (numberMsg.length() > 0) {
                                numberMsg.append("\uff0c");
                            }
                            String srcNumber = DimensionFormulaHelper.getSrcNumber(combinas[c]);
                            String number = DimensionFormulaHelper.getMemberNumber(combinas[c]);
                            if (StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)number)) continue;
                            numberMsg.append(MessageFormat.format(dimMsg, this.getSchemeHelper().getDimensionBySrcNumber().get(srcNumber).getName(), number));
                        }
                        String msg = MessageFormat.format(importRepeatMsg, i, numberMsg);
                        continue;
                    }
                    NumberList.add(dimensionNumberAndName[0]);
                }
                if (dimensionNumberAndName == null) continue;
                String dimensionNumber = dimensionNumberAndName[0];
                String dimensionName = dimensionNumberAndName[1];
                String[] Numbers = dimensionNumber.split(DimensionConstants.COMMA_SEPARATOR);
                String[] Names2 = DimensionRelationClientHelper.split(dimensionName, DimensionConstants.TICK_SEPARATOR);
                IRow row = this.tblMain.addRow();
                String[] subNumber = null;
                String numberKey = null;
                String nameKey = null;
                for (int j = 0; j < Numbers.length; ++j) {
                    subNumber = Numbers[j].split(DimensionConstants.COLON_SEPARATOR);
                    numberKey = this.getColumnKey(subNumber[0], true);
                    nameKey = this.getColumnKey(subNumber[0], false);
                    if (row.getCell(numberKey) == null) continue;
                    String memberNumber = subNumber.length > 1 ? subNumber[1] : null;
                    String dimNumber = this.getSchemeHelper().getDimensionBySrcNumber().get(subNumber[0]).getNumber();
                    String dimName = this.getSchemeHelper().getDimensionBySrcNumber().get(subNumber[0]).getAlias();
                    if (memberNumber != null && existMembers.containsKey(dimNumber) && ((Map)existMembers.get(dimNumber)).containsKey(memberNumber)) {
                        row.getCell(numberKey).setValue((Object)memberNumber);
                        row.getCell(nameKey).getStyleAttributes().setLocked(true);
                        if (((Map)existMembers.get(dimNumber)).get(memberNumber) instanceof BgDimensionMember) {
                            row.getCell(nameKey).setValue((Object)((BgDimensionMember)((Map)existMembers.get(dimNumber)).get(memberNumber)).getName());
                            continue;
                        }
                        row.getCell(nameKey).setValue((Object)Names2[j]);
                        continue;
                    }
                    int rowInx = i + 1;
                    errorDetail.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"combinMemberImport_error", (Object[])new Object[]{rowInx, dimName, memberNumber})).append("  \n");
                    this.tblMain.removeRow(row.getRowIndex());
                    if (!isReturnRightNow) continue block3;
                    MsgBox.showWarning((Component)((Object)this), (String)errorDetail.toString());
                    return;
                }
            }
        }
        catch (AbortException e) {
            throw e;
        }
        catch (Exception ee) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (!isReturnRightNow && errorDetail.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"dataError"), (String)errorDetail.toString(), (int)0);
        }
        if (isTooLong) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"tooLongNumAndName"));
            SysUtil.abort();
        }
    }

    private static KDSBook showImportDialog(CoreUI ownerUI) {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"dimMemberImport"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)ownerUI) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            kdsBook = POIXlsReader.parse((String)filePath);
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"excelBad"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"notFile"));
            SysUtil.abort();
        }
        return kdsBook;
    }

    private static String showExportDialog(CoreUI ownerUi) {
        ExcelFile file = new ExcelFile();
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"dimMemberExport"));
        fileChooser.setFileFilter((FileFilter)file);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)ownerUi) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        return filePath;
    }

    private boolean checkColumsTiltle(KDTable tblMain, KDSSheet sheet) {
        IRow head = tblMain.getHeadRow(0);
        int colCount = ViewlistCombinHelper.getColumnCount(sheet);
        for (int i = 0; i < colCount; ++i) {
            String excelColname;
            String colName = head.getCell(i).getValue().toString().trim();
            if (colName.equals(excelColname = StringUtils.cnulls((Object)sheet.getCell(0, i, false).getValue()).trim())) continue;
            return false;
        }
        return true;
    }

    private List<String> getEntriesNumberCombin(KDTable tblMain) throws EASBizException, BOSException {
        ArrayList<String> numberList = new ArrayList<String>();
        IRow row = null;
        Object object = null;
        BgDimensionBaseInfo dimension = null;
        StringBuffer combinNumber = new StringBuffer();
        int j = tblMain.getRowCount();
        for (int i = 0; i < j; ++i) {
            String n;
            row = tblMain.getRow(i);
            combinNumber.setLength(0);
            for (int c = 0; c < tblMain.getColumnCount(); ++c) {
                object = row.getCell(c).getValue();
                if (this.getUserObject(tblMain, tblMain.getColumn(c)) == null) continue;
                dimension = (BgDimensionBaseInfo)this.getUserObject(tblMain, tblMain.getColumn(c));
                if (!tblMain.getColumn(c).getKey().equals(this.getColumnKey(this.getSchemeHelper().getSrcNumber(dimension.getNumber()), true))) continue;
                if (object != null && !StringUtils.isEmpty((String)((String)object))) {
                    combinNumber.append(this.getSchemeHelper().getSrcNumber(dimension.getNumber())).append(":").append(object.toString()).append(",");
                    continue;
                }
                combinNumber.append(",");
            }
            if (!combinNumber.toString().endsWith(",") || numberList.contains(n = combinNumber.toString().substring(0, combinNumber.toString().length() - 1))) continue;
            numberList.add(n);
        }
        return numberList;
    }

    private String[] importDimNumberAndName(CoreUI ownerUI, KDTable tblMain, KDSSheet sheet, int rowIndex, List<String> srcNumbers, BgSchemeDimensionHelper schemeHelper, Date startDate, Date endDate, StringBuffer errorDetail) {
        BgDimensionBaseInfo dimensionInfo = null;
        String dimNumber = null;
        String dimName = null;
        int count = 0;
        String[] numberCol = new String[srcNumbers.size()];
        String[] nameCol = new String[srcNumbers.size()];
        int srcNumSize = srcNumbers.size();
        for (int i = 0; i < srcNumSize; ++i) {
            int indexOf;
            Date periodDate;
            dimNumber = StringUtils.cnulls((Object)sheet.getCell(rowIndex, i * 2, false).getValue()).trim();
            dimName = StringUtils.cnulls((Object)sheet.getCell(rowIndex, i * 2 + 1, false).getValue()).trim();
            if (EmptyUtil.isEmpty((String)dimNumber) && EmptyUtil.isEmpty((String)dimName)) {
                numberCol[count] = null;
                nameCol[count++] = null;
                continue;
            }
            if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumbers.get(i)) && (periodDate = BgNPeriodHelper.getPeriodDate((String)dimNumber.substring((indexOf = dimNumber.indexOf(".")) + 1, dimNumber.length()))) != null && (endDate.before(periodDate) || startDate.after(periodDate))) {
                errorDetail.append(EASResource.getString((String)DimensionConstants.DIMEN_COMMON_RESOURCE, (String)"cantPeriodLimit", (Object[])new Object[]{rowIndex + 1, dimNumber, dimName})).append("\n");
                continue;
            }
            dimensionInfo = (BgDimensionBaseInfo)this.getUserObject(tblMain, tblMain.getColumn(this.getColumnKey(srcNumbers.get(i), true)));
            numberCol[count] = schemeHelper.getSrcNumber(dimensionInfo.getNumber()) + DimensionConstants.COLON_SEPARATOR + dimNumber;
            nameCol[count++] = dimName;
        }
        List<String> sortNumbers = this.getSrcNumbers(tblMain, schemeHelper);
        Object[] sortNumberCol = new String[srcNumbers.size()];
        Object[] sortnameCol = new String[srcNumbers.size()];
        block1: for (int i = 0; i < sortNumbers.size(); ++i) {
            String srcNumber = sortNumbers.get(i);
            String prefix = srcNumber + DimensionConstants.COLON_SEPARATOR;
            for (int j = 0; j < srcNumbers.size(); ++j) {
                if (numberCol[j] == null || !numberCol[j].startsWith(prefix)) continue;
                sortNumberCol[i] = numberCol[j];
                sortnameCol[i] = nameCol[j];
                continue block1;
            }
        }
        String number = DimensionRelationClientHelper.arrayToString(sortNumberCol, DimensionConstants.COMMA_SEPARATOR);
        String name = DimensionRelationClientHelper.arrayToString(sortnameCol, DimensionConstants.TICK_SEPARATOR);
        return new String[]{number, name};
    }

    protected Map queryExistMembers(List<BgDimensionBaseInfo> dimensions, List<String[]> combins) throws EASBizException, BOSException {
        if (combins == null || combins.isEmpty()) {
            return null;
        }
        HashMap queryMap = new HashMap();
        HashMap<String, Boolean> queryByName = new HashMap<String, Boolean>();
        for (BgDimensionBaseInfo dim : dimensions) {
            HashMap tmp = new HashMap();
            tmp.put(0, new HashSet());
            queryMap.put(dim.getNumber(), tmp);
            queryByName.put(dim.getNumber(), false);
        }
        String[] tmpStrs = null;
        String dimNumber = null;
        int in = combins.size();
        for (int i = 0; i < in; ++i) {
            tmpStrs = combins.get(i);
            String[] numArr = tmpStrs[0].split(",");
            int jn = numArr.length;
            for (int j = 0; j < jn; ++j) {
                String cimbinNum;
                String[] arr;
                if (StringUtils.isEmpty((String)numArr[j]) || (arr = (cimbinNum = numArr[j]).split(":")).length != 2) continue;
                dimNumber = this.getSchemeHelper().getDimensionBySrcNumber().get(arr[0]).getNumber();
                ((Set)((Map)queryMap.get(dimNumber)).get(0)).add(arr[1]);
            }
        }
        Map members = MBGViewListFormFacadeFactory.getRemoteInstance().queryExistingMember(this.getSchemeHelper().getBgSchemeId(), this.getOrgUnit().getId().toString(), queryMap, queryByName);
        return members;
    }
}

