/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.BgHideItemEnum;
import com.kingdee.eas.ma.mbg.client.AbstractViewListPropertySetUI;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class ViewListPropertySetUI
extends AbstractViewListPropertySetUI {
    private static final long serialVersionUID = -1471388743734813506L;
    private static final Logger logger = CoreUIObject.getLogger(ViewListPropertySetUI.class);
    private MbgViewListManager view = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.view = (MbgViewListManager)this.getUIContext().get("InitDataObject");
        this.setHide(this.view.getRowHide(), false);
        this.setHide(this.view.getColHide(), true);
    }

    @Override
    protected void chkRowNull_itemStateChanged(ItemEvent e) throws Exception {
        super.chkRowNull_itemStateChanged(e);
        this.chkBoxChange(e, false);
    }

    @Override
    protected void chkRowZero_itemStateChanged(ItemEvent e) throws Exception {
        super.chkRowZero_itemStateChanged(e);
        this.chkBoxChange(e, false);
    }

    @Override
    protected void chkRowZeroNull_itemStateChanged(ItemEvent e) throws Exception {
        super.chkRowZeroNull_itemStateChanged(e);
        this.chkBoxChange(e, false);
    }

    @Override
    protected void chkColNull_itemStateChanged(ItemEvent e) throws Exception {
        super.chkColNull_itemStateChanged(e);
        this.chkBoxChange(e, true);
    }

    @Override
    protected void chkColZero_itemStateChanged(ItemEvent e) throws Exception {
        super.chkColZero_itemStateChanged(e);
        this.chkBoxChange(e, true);
    }

    @Override
    protected void chkColZeroNull_itemStateChanged(ItemEvent e) throws Exception {
        super.chkColZeroNull_itemStateChanged(e);
        this.chkBoxChange(e, true);
    }

    private void chkBoxChange(ItemEvent e, boolean isCol) {
        if (e.getStateChange() == 1) {
            KDCheckBox source = (KDCheckBox)e.getSource();
            KDCheckBox[] boxes = this.getCheckBoxes(isCol);
            for (int i = 0; i < boxes.length; ++i) {
                if (boxes[i] == source) continue;
                boxes[i].setSelected(false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private KDCheckBox[] getCheckBoxes(boolean isCol) {
        if (isCol) {
            return new KDCheckBox[]{this.chkColZero, this.chkColNull, this.chkColZeroNull};
        }
        return new KDCheckBox[]{this.chkRowZero, this.chkRowNull, this.chkRowZeroNull};
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.view.setRowHide(this.getHide(false));
        this.view.setColHide(this.getHide(true));
        this.getUIWindow().close();
    }

    private void setHide(BgHideItemEnum hide, boolean isCol) {
        KDCheckBox[] boxes = this.getCheckBoxes(isCol);
        for (int i = 0; i < boxes.length; ++i) {
            if (!boxes[i].getActionCommand().equals(hide.getName())) continue;
            boxes[i].setSelected(true);
            return;
        }
    }

    private BgHideItemEnum getHide(boolean isCol) {
        KDCheckBox[] boxes = this.getCheckBoxes(isCol);
        for (int i = 0; i < boxes.length; ++i) {
            if (!boxes[i].isSelected()) continue;
            return BgHideItemEnum.getEnum(boxes[i].getActionCommand());
        }
        return BgHideItemEnum.UNHIDE;
    }
}

