/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.appframework.uistatemanage.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.designer.IActionManager;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.apache.log4j.Logger;

public abstract class AbstractActionManager
implements IActionManager {
    private static final Logger logger = CoreUIObject.getLogger(AbstractActionManager.class);
    private IContextManager contextManager = null;
    private Map actions = new HashMap();
    private List<String> classPres = new ArrayList<String>();
    private final String classPre = "com.kingdee.eas.ma.mbg.client.action.actions.";

    public AbstractActionManager(IContextManager contextManager) {
        this.contextManager = contextManager;
        this.initClassPre();
        this.initToolsAction();
        this.initAction();
    }

    protected void initClassPre() {
        this.addClassPre("com.kingdee.eas.ma.mbg.client.action.actions.");
    }

    public List<String> getClassPres() {
        return this.classPres;
    }

    protected void addClassPre(String classPre) {
        this.classPres.add(classPre);
    }

    protected void disableAction(ActionManager manager, String strActionKey) {
        this.disableAction(manager, strActionKey, true, false);
    }

    protected void disableAction(ActionManager manager, String strActionKey, boolean isVisible, boolean isEnable) {
        ItemAction item = null;
        item = manager.getAction(strActionKey);
        if (item != null) {
            item.setEnabled(isEnable);
            item.setVisible(isVisible);
        }
    }

    protected void enableAction(ActionManager manager, String strActionKey) {
        ItemAction item = null;
        item = manager.getAction(strActionKey);
        if (item != null) {
            item.setEnabled(true);
            item.setVisible(true);
        }
    }

    @Override
    public IContextManager getContextManager() {
        return this.contextManager;
    }

    @Override
    public Map getActionMap() {
        return this.actions;
    }

    protected abstract void initToolsAction();

    protected abstract void initAction();

    @Override
    public void registerActionToFirstToolBar(IItemAction action) {
        this.registerAction(action, true);
        ToolBarManager barManager = this.getToolBarManager();
        if (barManager != null) {
            barManager.addFirstGroupItem((Action)action, "common");
        }
    }

    @Override
    public void registerActionToLastToolBar(IItemAction action) {
        this.registerAction(action, true);
        ToolBarManager barManager = this.getToolBarManager();
        if (barManager != null) {
            barManager.addLastGroupItem((Action)action, "common");
        }
    }

    public void registerSeparatorToLastToolBar() {
        ToolBarManager barManager = this.getToolBarManager();
        if (barManager != null) {
            barManager.addLastGroupItem((Component)new KDSeparator(), "common");
        }
    }

    public void registerSeparatorToFirstToolBar() {
        ToolBarManager barManager = this.getToolBarManager();
        if (barManager != null) {
            barManager.addFirstGroupItem((Component)new KDSeparator(), "common");
        }
    }

    @Override
    public void registerAction(IItemAction action) {
        this.registerAction(action, false);
    }

    private void registerAction(IItemAction action, boolean hasSynchro) {
        if (action == null) {
            return;
        }
        String _common = action.getClass().getSimpleName();
        if (!this.getActionMap().containsKey(_common)) {
            IItemAction itemAction = this.loadAction(action, _common);
            if (hasSynchro) {
                this.synchro(action, itemAction);
            }
        }
    }

    protected IItemAction loadAction(IItemAction action, String _common) {
        ItemAction itemAction = null;
        Class _class = null;
        try {
            Map serviceContext4Dyn;
            _class = this.loadClass(_common);
            itemAction = (ItemAction)_class.newInstance();
            if (action.getServices() != null) {
                for (Object s : action.getServices().values()) {
                    if (!(s instanceof IBindService)) continue;
                    itemAction.addService((IBindService)s);
                }
            }
            if ((serviceContext4Dyn = this.contextManager.getOwnerUI().getServiceContext4Dyn()) != null) {
                itemAction = (IItemAction)ActionProxyFactory.getProxy((Object)itemAction, (Class[])new Class[]{IItemAction.class}, (Map)serviceContext4Dyn);
            }
            itemAction.setUIObject(action.getUIObject());
            this.getActionMap().put(_common, itemAction);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)this, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)this, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)this, (Throwable)e);
        }
        return itemAction;
    }

    protected Class loadClass(String _common) throws ClassNotFoundException {
        Class<?> cls = null;
        String pres = null;
        for (int i = this.getClassPres().size() - 1; i >= 0; --i) {
            try {
                pres = this.getClassPres().get(i);
                cls = pres.endsWith(".") || pres.endsWith("$") ? Class.forName(this.getClassPres().get(i) + _common) : Class.forName(this.getClassPres().get(i) + "." + _common);
                return cls;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        throw new ClassNotFoundException("common:" + _common + " classPres:" + Arrays.toString(this.getClassPres().toArray()));
    }

    private void synchro(IItemAction actionTo, IItemAction actionFrom) {
        if (actionTo != null && actionFrom != null) {
            if (actionTo.getValue("SmallIcon") == null || actionTo.getValue("SmallIcon").toString().length() == 0) {
                actionTo.putValue("SmallIcon", actionFrom.getValue("SmallIcon"));
            }
            if (actionTo.getValue("Name") == null || actionTo.getValue("Name").toString().length() == 0) {
                actionTo.putValue("Name", actionFrom.getValue("Name"));
            }
            if (actionTo.getValue("ShortDescription") == null || actionTo.getValue("ShortDescription").toString().length() == 0) {
                actionTo.putValue("ShortDescription", actionFrom.getValue("ShortDescription"));
            }
            if (actionTo.getValue("LongDescription") == null || actionTo.getValue("LongDescription").toString().length() == 0) {
                actionTo.putValue("LongDescription", actionFrom.getValue("LongDescription"));
            }
        }
    }

    @Override
    public void doAction(ActionEvent e) throws Exception {
        String[] _tmpStrs;
        if (e == null) {
            return;
        }
        String _command = e.getActionCommand();
        if (!StringUtils.isEmpty((String)_command) && (_tmpStrs = _command.split("\\$")) != null) {
            IItemAction action;
            int index = _tmpStrs.length - 1;
            String _actionStr = _tmpStrs[index];
            if (this.getActionMap().containsKey(_actionStr) && (action = (IItemAction)this.getActionMap().get(_actionStr)) != null) {
                action.actionPerformed(e);
            }
        }
    }

    protected ToolBarManager getToolBarManager() {
        if (this.getContextManager() instanceof BookContextManager) {
            BookContextManager _manager = (BookContextManager)this.getContextManager();
            return _manager.getSpreadContext().getToolBarManager();
        }
        return null;
    }

    @Override
    public void refreshActionState() {
    }

    protected void setDecomposeGather(BgProcessEnum processType, ActionManager manager) {
        if (BgProcessEnum.C04.equals((Object)processType)) {
            this.registerSeparatorToLastToolBar();
            this.registerActionToLastToolBar((IItemAction)manager.getAction("actionGather"));
            this.registerActionToLastToolBar((IItemAction)manager.getAction("actionMultiGather"));
            this.registerActionToLastToolBar((IItemAction)manager.getAction("actionGatherView"));
            if (!OprtState.EDIT.equals(this.getContextManager().getOwnerUI().getOprtState())) {
                this.disableAction(manager, "actionGather", true, false);
                this.disableAction(manager, "actionMultiGather", true, false);
            }
            this.disableAction(manager, "actionGatherView", true, true);
        } else {
            this.disableAction(manager, "actionGather", false, false);
            this.disableAction(manager, "actionMultiGather", false, false);
            this.disableAction(manager, "actionGatherView", false, false);
        }
    }
}

