/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBgExamineClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ActionBaseExamineCheck
extends AbstractAction {
    private static final long serialVersionUID = -3358559241820013338L;
    private boolean hasExamineCheck = false;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_examinecheck");
    }

    @Override
    protected String getName() {
        return BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"actionBgExamineCheck");
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    public void setHasExamineCheck(boolean hasExamineCheck) {
        this.hasExamineCheck = hasExamineCheck;
    }

    public boolean isHasExamineCheck() {
        return this.hasExamineCheck;
    }

    protected void examineCheck(final String billId) {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)this.uiObj);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        this.setHasExamineCheck(false);
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Object obj = null;
                try {
                    obj = ActionBaseExamineCheck.this.getBgExamineInterface().examines(new String[]{billId});
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)((Component)ActionBaseExamineCheck.this.uiObj), (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                catch (Exception ex) {
                    throw ex;
                }
                return obj;
            }

            public void afterExec(Object result) throws Exception {
                ArrayList<String> billIds = new ArrayList<String>();
                billIds.add(billId);
                ActionBaseExamineCheck.this.showCheckReport(result, billIds);
            }
        });
        dialog.show();
    }

    protected void showCheckReport(Object result, List<String> billIds) throws Exception {
        if (result instanceof BgExamineResult) {
            BgExamineResult checkResult = (BgExamineResult)result;
            BOSUuid bgOrgViewId = null;
            Object viewId = this.uiObj.getUIContext().get("BGORGVIEW_ID");
            if (viewId instanceof BOSUuid) {
                bgOrgViewId = (BOSUuid)viewId;
            } else if (viewId instanceof String) {
                bgOrgViewId = BOSUuid.read((String)viewId.toString());
            }
            MBgExamineClientUtils.getInstance().showCheckReport(checkResult, bgOrgViewId, true, billIds);
        } else {
            MsgBox.showError((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineError"));
        }
    }

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }
}

