/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.mbg.client.BgViewFormAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.ActionCalculate;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustContextManager;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ActionBizCalculate
extends ActionCalculate {
    private static final long serialVersionUID = 7045403484259523895L;
    private Map<String, BgNViewDataInfo> bgDataMap = null;
    private Map<String, BigDecimal> bgCacheMap = new HashMap<String, BigDecimal>();
    private Map<String, BigDecimal> bizCalcMap = null;
    private boolean calcBizRule = true;

    public void setBgDataMap(Map<String, BgNViewDataInfo> bgDataMap) {
        this.bgDataMap = bgDataMap;
    }

    public Map<String, BgNViewDataInfo> getBgDataMap() {
        return this.bgDataMap;
    }

    public Map<String, BigDecimal> getBgCacheMap() {
        return this.bgCacheMap;
    }

    public void setBizCalcMap(Map<String, BigDecimal> bizCalcMap) {
        this.bizCalcMap = bizCalcMap;
    }

    public Map<String, BigDecimal> getBizCalcMap() {
        return this.bizCalcMap;
    }

    public void setCalcBizRule(boolean calcBizRule) {
        this.calcBizRule = calcBizRule;
    }

    public boolean isCalcBizRule() {
        return this.calcBizRule;
    }

    @Override
    protected void beforeCalculate(IContextManager contextManager) {
        super.beforeCalculate(contextManager);
        if (this.getBizCalcMap() != null) {
            this.getBizCalcMap().clear();
        }
        if (contextManager == null) {
            return;
        }
        Object obj = this.getValue("AUTO_CALCULATOR");
        if (obj instanceof Boolean) {
            Boolean calcBiz = (Boolean)obj;
            this.setCalcBizRule(calcBiz);
            this.putValue("AUTO_CALCULATOR", null);
        } else {
            this.setCalcBizRule(true);
        }
        if (!this.isCalcBizRule()) {
            return;
        }
        Set<String> orgNums = this.getOrgUnitNums(contextManager);
        if (orgNums == null || orgNums.size() > 1) {
            return;
        }
        Map<Object, Object> bgDataMap = null;
        BookContextManager manager = (BookContextManager)contextManager;
        IProvider provider = manager.getProvider();
        if (provider instanceof MBGBaseFormProvider) {
            bgDataMap = ((MBGBaseFormProvider)provider).getBgDataMap().get(provider.getOrgUnitId());
        }
        if (bgDataMap == null) {
            bgDataMap = new HashMap();
        }
        this.setBgDataMap(bgDataMap);
    }

    @Override
    protected void afterCalculate(IContextManager contextManager) {
        super.afterCalculate(contextManager);
    }

    protected Set<String> getOrgUnitNums(IContextManager manager) {
        if (manager == null) {
            return null;
        }
        BookContextManager _manager = (BookContextManager)manager;
        MBGBaseFormProvider provider = (MBGBaseFormProvider)_manager.getProvider();
        HashSet<String> orgNums = new HashSet<String>();
        orgNums.add(provider.getOrgNumsForCurSheet(0, orgNums));
        return orgNums;
    }

    protected IObjectValue getEditValue(IContextManager manager) {
        return null;
    }

    protected BOSUuid getBgSchemeId(IObjectValue model) {
        return null;
    }

    protected String getOrgUnitNum(Set<String> orgNums) {
        if (orgNums == null) {
            return null;
        }
        return orgNums.iterator().next();
    }

    protected int getValueType() {
        return 1;
    }

    @Override
    protected void setBudgetValue(Cell cell, BigDecimal _newValue) {
        super.setBudgetValue(cell, _newValue);
    }

    @Override
    protected void updateCellChangeValueInfo(Cell cell) {
        super.updateCellChangeValueInfo(cell);
        if (this.getBizCalcMap() != null && BgNFSHelper.checkHasFormulaOfCell(cell)) {
            ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
            String formula = BgNFSHelper.getFormulaOfItem(itemFormula);
            String versionNum = BgNFSHelper.getVersionOfitem(itemFormula);
            String dimKey = DimUtils.getDimDataKey(formula, versionNum);
            if (this.getBizCalcMap().containsKey(dimKey)) {
                if (this.getUIObject() instanceof BgViewFormAdjustProcessUI) {
                    BgViewAdjustContextManager context = (BgViewAdjustContextManager)((BgViewFormAdjustProcessUI)this.getUIObject()).getContextManager();
                    if (!cell.isLocked()) {
                        ((BgViewAdjustProvider)context.getProvider()).getAdjustHelper().setDivInfo(cell, this.getBizCalcMap().get(dimKey), BgNFSHelper.getBudgetValue(cell));
                    }
                    ((BgViewAdjustProvider)context.getProvider()).setCellAdjustValue(cell, formula, this.getBizCalcMap().get(dimKey));
                } else if (this.getBgDataMap().containsKey(dimKey)) {
                    BgNViewDataInfo bgData = this.getBgDataMap().get(dimKey);
                    if (bgData.getState() == 1) {
                        BgNFSHelper.setValue(cell, this.getBizCalcMap().get(dimKey));
                    }
                } else {
                    BgNFSHelper.setValue(cell, this.getBizCalcMap().get(dimKey));
                }
            }
        }
    }
}

