/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.MeasureUnitCellActionAfterListener;
import com.kingdee.eas.ma.mbg.utils.BgExportUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ActionExport
extends AbstractAction {
    private static final long serialVersionUID = -7650381281433709417L;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_output");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke("ctrl shift E");
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionExport");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        BgFormInfo info;
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.uiObj;
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        IObjectValue iObjectValue = contextManager.getProvider().getEditValue();
        boolean hasCreateDir = false;
        File dirc = null;
        KDFileChooser fc = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        try {
            fc = bgFileUtil.getFileChooserForExp((Object)processUI);
        }
        catch (BOSException ex) {
            processUI.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        dirc = BgCommHelper.getDefaultDirtory().equals(fc.getCurrentDirectory().getAbsolutePath()) ? (iObjectValue.getObjectValue("orgUnit") != null ? new File(fc.getCurrentDirectory().getAbsolutePath() + "//" + iObjectValue.getObjectValue("orgUnit").getString("name")) : new File(fc.getCurrentDirectory().getAbsolutePath() + "//Export")) : new File(fc.getCurrentDirectory().getAbsolutePath());
        if (!dirc.exists() || dirc.isDirectory()) {
            dirc.mkdir();
            hasCreateDir = true;
        }
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "fileExport"));
        Excel2007FileFilter xlsxFilter = new Excel2007FileFilter();
        fc.setFileFilter((FileFilter)new ExcelFileFilter());
        fc.setFileFilter((FileFilter)xlsxFilter);
        fc.setAcceptAllFileFilterUsed(false);
        String fileName = BgExportUtils.convert(iObjectValue.get("name").toString(), '_');
        if (iObjectValue instanceof BgFormInfo && DimensionCommonHelper.isDecompose((info = (BgFormInfo)iObjectValue).getProcessType())) {
            fileName = fileName + '_' + (Object)((Object)info.getProcessType());
        }
        fc.setSelectedFile(new File(dirc.getAbsolutePath() + "//" + fileName));
        if (fc.showSaveDialog((Component)((Object)processUI)) == 0) {
            File file = fc.getSelectedFile();
            String name = file.getName().replaceAll(" ", "");
            String x = file.toString().substring(0, file.toString().indexOf(file.getName()));
            fc.setSelectedFile(new File(x + name));
            String postfix = null;
            if (file.getName().indexOf(".") == -1) {
                FileFilter fileFilter = fc.getFileFilter();
                postfix = fileFilter == xlsxFilter ? ".xlsx" : ".xls";
                file = new File(fc.getSelectedFile() + postfix);
                fc.setSelectedFile(file);
            }
            if (file != null) {
                if (file.exists()) {
                    int re = MsgBox.showConfirm3((Component)((Object)processUI), (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "existsFile"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    if (re == 0 && !file.delete()) {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                        return;
                    }
                }
                try {
                    file = fc.getSelectedFile();
                    BookContextManager contextManagers = (BookContextManager)processUI.getContextManager();
                    Book _book = contextManagers.getSpreadContext().getBook();
                    String _filename = file.getPath();
                    String sen = GlobalFunction.getFileExtension((String)_filename);
                    if (sen.equals("xls")) {
                        Book exportBook = Book.Manager.getNewBook(null, (int)_book.getSheetCount());
                        try {
                            MeasureUnitCellActionAfterListener.setExport(_book, true);
                            int sheetSize = _book.getSheetCount();
                            for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
                                exportBook.getSheet(sheetIndex).copySheetFrom(_book.getSheet(sheetIndex));
                            }
                        }
                        finally {
                            MeasureUnitCellActionAfterListener.setExport(_book, false);
                        }
                        int Excel2003_MaxColCount = 256;
                        boolean isOver = false;
                        Sheet srcSheet = null;
                        for (int i = 0; i < exportBook.getSheetCount(); ++i) {
                            srcSheet = exportBook.getSheet(i);
                            if (srcSheet.getMaxColIndex() <= 256) continue;
                            isOver = true;
                            break;
                        }
                        if (isOver) {
                            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGNBUDGETAutoGenerateResource", (String)"110_BgExportHelper"));
                            SysUtil.abort();
                        }
                    }
                    this.exportBookContent(file, processUI);
                    bgFileUtil.storeDefaultPathForEXP((Object)_filename, (Object)processUI);
                }
                catch (POIExportException ex) {
                    ex.printStackTrace();
                    if (hasCreateDir) {
                        dirc.delete();
                    }
                    MsgBox.showInfo((Component)((Object)processUI), (String)ex.getCause().getMessage());
                    SysUtil.abort();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (hasCreateDir) {
                        dirc.delete();
                    }
                    processUI.handUIExceptionAndAbort(ex);
                }
            }
        }
        if (hasCreateDir) {
            dirc.delete();
        }
    }

    protected void exportBookContent(File file, BgSpreadCoreViewUI processUI) throws Exception {
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        String _filename = file.getPath();
        BigDecimal _coefficient = BgNConstants.ONE;
        if (contextManager.getProvider().getBgDimensionManager() instanceof IBgDimensionManager) {
            ((IBgDimensionManager)contextManager.getProvider().getBgDimensionManager()).getDefaultMeasureUnit().getCoefficient();
        }
        _book.getProtection().deleteOperations();
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        _parameter.put("EXPORT_BOOK", _book);
        _parameter.put("EXPORT_COEFFICIENT", _coefficient);
        if (contextManager.getCellDisplayProvider().getDisplayValueProvider() instanceof BudgetDisplayValueProvider) {
            _parameter.put("DISPLAYMODE", ((BudgetDisplayValueProvider)contextManager.getCellDisplayProvider().getDisplayValueProvider()).getDisplayMode());
        }
        HashMap newMeasureUnitMap = new HashMap();
        Map measureUnitMap = null;
        Method method = processUI.getClass().getMethod("getMeasureUnitMap", null);
        measureUnitMap = method != null ? (Map)method.invoke((Object)processUI, null) : new HashMap();
        Set keySet = measureUnitMap.keySet();
        for (Object o : keySet) {
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)measureUnitMap.get(o);
            newMeasureUnitMap.put(o, measureUnitInfo.getCoefficient());
        }
        _parameter.put("EXPORT_MEASUREUNIT", newMeasureUnitMap);
        _parameter.put("EXPORT_BGFORMULA", null);
        if (processUI instanceof MBGFormProcessUI) {
            if (((MBGFormProcessUI)processUI).getMenuItemDealReplace().isSelected()) {
                _parameter.put("EXPORT_DATA", Boolean.FALSE);
            } else if (((MBGFormProcessUI)processUI).getMenuItemMeasReplace().isSelected()) {
                _parameter.put("EXPORT_DATA", Boolean.TRUE);
            }
        } else {
            _parameter.put("EXPORT_DATA", Boolean.FALSE);
        }
        KDSBook _kdsBook = BgNFCHelper.exportExcel(_parameter);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        em.exportToExcel(_kdsBook, _filename);
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionExportName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionExportName");
    }
}

