/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.client.template.MBGContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionDescriptionHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ActionImport
extends AbstractAction {
    private static final long serialVersionUID = -1852291174579656944L;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_input");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 2);
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionImport");
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.uiObj;
        KDFileChooser fileChooser = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        try {
            fileChooser = bgFileUtil.getFileChooserForImp((Object)processUI);
        }
        catch (BOSException ex) {
            processUI.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        fileChooser.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "fileImport"));
        fileChooser.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)processUI)) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            String fileName = file.getPath();
            String sen = GlobalFunction.getFileExtension((String)fileName);
            KDSBook books = null;
            if (sen.equals("xlsx")) {
                books = POIXlsxReader.parse((String)fileName);
                if (books == null) {
                    try {
                        books = new Excel2007Reader().parse(fileName);
                    }
                    catch (Exception exception) {}
                }
            } else {
                books = POIXlsReader.parse((String)fileName);
            }
            if (books == null) {
                MsgBox.showInfo((Component)((Object)processUI), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
                return;
            }
            try {
                Method method = processUI.getClass().getMethod("isViewImportCheck", null);
                boolean isViewImportCheck = false;
                if (method != null) {
                    isViewImportCheck = (Boolean)method.invoke((Object)processUI, null);
                }
                if (isViewImportCheck) {
                    ActionImport.checkViewImport(books, ((MBGContextManager)processUI.getContextManager()).getSpreadContext().getBook());
                }
                ActionImport.importBookContent(books, processUI);
                bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)processUI);
                processUI.updateUI();
                processUI.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                processUI.showMessage();
            }
            catch (Exception ex) {
                processUI.handUIExceptionAndAbort(ex);
            }
        }
    }

    public static void importForm(File file, BgSpreadCoreViewUI processUI, String[] sheetNames) {
        BgFileUtil bgFileUtil = new BgFileUtil();
        if (file != null && file.isFile()) {
            String fileName = file.getPath();
            String sen = GlobalFunction.getFileExtension((String)fileName);
            KDSBook books = null;
            if (sen.equals("xlsx")) {
                books = POIXlsxReader.parse((String)fileName);
                if (books == null) {
                    try {
                        books = new Excel2007Reader().parse(fileName);
                    }
                    catch (Exception exception) {}
                }
            } else {
                books = POIXlsReader.parse((String)fileName);
            }
            if (books == null) {
                MsgBox.showInfo((Component)((Object)processUI), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
                return;
            }
            try {
                Method method = processUI.getClass().getMethod("isViewImportCheck", null);
                boolean isViewImportCheck = false;
                if (method != null) {
                    isViewImportCheck = (Boolean)method.invoke((Object)processUI, null);
                }
                if (isViewImportCheck) {
                    ActionImport.checkViewImport(books, ((MBGContextManager)processUI.getContextManager()).getSpreadContext().getBook());
                }
                ActionImport.importBookContent(books, processUI, sheetNames);
                bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)processUI);
                processUI.updateUI();
                processUI.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                processUI.showMessage();
            }
            catch (Exception ex) {
                processUI.handUIExceptionAndAbort(ex);
            }
        }
    }

    protected static void checkViewImport(KDSBook kdsBook, Book book) throws Exception {
        for (int i = 0; i < kdsBook.getSheetCount(); ++i) {
            KDSSheet kdsSheet = kdsBook.getSheet((Object)i);
            Sheet bookSheet = book.getSheet(i);
            if (bookSheet == null) continue;
            ActionImport.checkSheet(kdsSheet, bookSheet);
        }
    }

    private static void checkSheet(KDSSheet kdsSheet, Sheet bookSheet) throws EASBizException {
        int kdsRowCount = kdsSheet.getRowCount();
        int kdsColCount = kdsSheet.getExpandedColumns() + 1;
        String sheetName = bookSheet.getSheetName();
        KDSCell kdsCell = null;
        Cell bookCell = null;
        for (int row = 0; row < kdsRowCount; ++row) {
            for (int col = 0; col < kdsColCount; ++col) {
                kdsCell = kdsSheet.getCell(row, col, false);
                if (kdsCell == null || (bookCell = bookSheet.getCell(row, col, true)).isLocked()) continue;
                String cellName = bookCell.getName(false, false);
                if (BgNFSHelper.checkHasItemFormula(bookCell)) {
                    if (EmptyUtil.isEmpty((Object)kdsCell.getValue()) || 0 == kdsCell.getType()) continue;
                    if (kdsCell.getValue() != null && kdsCell.getValue().toString().indexOf("%") != -1) {
                        String replaceValue = kdsCell.getValue().toString().replaceAll("%", "");
                        if (BgNFSHelper.checkIsNumeric(replaceValue)) continue;
                        Object[] sheetcell = new Object[]{sheetName, cellName};
                        throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                    }
                    Object[] sheetcell = new Object[]{sheetName, cellName};
                    throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                }
                if (DimensionDescriptionHelper.checkHashDescriptionFormula(bookCell) || (kdsCell.getValue() == null || StringUtils.isEmpty((String)kdsCell.getValue().toString())) && (bookCell.getValue() == Variant.nullVariant || bookCell.getValue() == null)) continue;
                CellBlock _mergeBlock = bookSheet.getMergeBlock(bookCell);
                if (_mergeBlock != null && Boolean.TRUE.equals(bookSheet.getRange(_mergeBlock).getUserObject("row_member_merge"))) {
                    bookCell = bookSheet.getCell(_mergeBlock.getRow(), _mergeBlock.getCol(), false);
                }
                if (bookCell == null || bookCell.getValue().getValue() == null) {
                    kdsCell.setValue(null);
                    continue;
                }
                kdsCell.setValue(bookCell.getValue().getValue());
            }
        }
    }

    protected static void importBookContent(KDSBook kdsBook, BgSpreadCoreViewUI processUI) throws Exception {
        ActionImport.importBookContent(kdsBook, processUI, null);
    }

    protected static void importBookContent(KDSBook kdsBook, BgSpreadCoreViewUI processUI, String[] sheetNames) throws Exception {
        if (kdsBook == null) {
            MsgBox.showWarning((Component)((Object)processUI), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        MBGContextManager contextManager = (MBGContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        BigDecimal _coefficient = contextManager.getProvider().getCurMbgViewManager().getDefaultMeasureUnit().getCoefficient();
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("IMPORT_BOOK", _book);
        _tmpMap.put("IMPORT_KDSBOOK", kdsBook);
        _tmpMap.put("IMPORT_COEFFICIENT", _coefficient);
        _tmpMap.put("IMPORT_SHEET", sheetNames);
        HashMap newMeasureUnitMap = new HashMap();
        Map measureUnitMap = ((IBgNumberCellDisplayHelper)((Object)processUI)).getMeasureUnitMap();
        for (Object o : measureUnitMap.keySet()) {
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)measureUnitMap.get(o);
            newMeasureUnitMap.put(o, measureUnitInfo.getCoefficient());
        }
        _tmpMap.put("IMPORT_MEASUREUNIT", newMeasureUnitMap);
        _tmpMap.put("IMPORT_BGFORMULA", ((IBgNumberCellDisplayHelper)((Object)processUI)).getFormulaMap());
        _tmpMap.put("IMPORT_DATA", ActionImport.getImportData(processUI));
        BgNFCHelper.importExcel(_tmpMap);
        if (contextManager.getProvider() instanceof BgViewAdjustProvider) {
            ((BgViewAdjustProvider)contextManager.getProvider()).getAdjustHelper().updateChangeValueInfo(_book);
        }
        contextManager.getSpreadContext().getSpread().repaint();
    }

    protected static Boolean getImportData(BgSpreadCoreViewUI processUI) {
        if (processUI instanceof MBGFormProcessUI) {
            if (((MBGFormProcessUI)processUI).getMenuItemDealReplace().isSelected()) {
                return Boolean.FALSE;
            }
            if (((MBGFormProcessUI)processUI).getMenuItemMeasReplace().isSelected()) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionImportName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionImportName");
    }
}

