/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.template;

import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.template.MBGContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class ActionSwapAxes
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_swapaxes");
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"396_ActionSwapAxes");
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        BgSpreadCoreViewUI baseUI = (BgSpreadCoreViewUI)this.uiObj;
        MBGContextManager contextManager = (MBGContextManager)baseUI.getContextManager();
        IMbgSheetManager sheetManager = contextManager.getProvider().getCurMbgSheetManager();
        IBgDimensionManager dimensionManager = sheetManager.getDimensionManager();
        this.SwapAxes(dimensionManager);
        try {
            contextManager.storeWidthStyle(contextManager.getProvider().getCurMbgViewManager());
            BgViewClientHelper.confirmClearWidth(contextManager, sheetManager);
            contextManager.refreshSheet(sheetManager.getSheetIndex());
            contextManager.getModifyManager().setModified();
        }
        catch (Exception e1) {
            baseUI.handUIExceptionAndAbort(e1);
        }
    }

    protected void SwapAxes(IBgDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return;
        }
        ArrayList<BgDimensionInfo> viewDimensions = new ArrayList<BgDimensionInfo>(dimensionManager.getViewDimension());
        ArrayList<BgDimensionInfo> pageDimensions = new ArrayList<BgDimensionInfo>(dimensionManager.getPageDimension());
        ArrayList<BgDimensionInfo> rowDimensions = new ArrayList<BgDimensionInfo>(dimensionManager.getRowDimension());
        ArrayList<BgDimensionInfo> colDimensions = new ArrayList<BgDimensionInfo>(dimensionManager.getColDimension());
        dimensionManager.getDimension().clear();
        dimensionManager.getRowDimension().clear();
        dimensionManager.getColDimension().clear();
        dimensionManager.getPageDimension().clear();
        dimensionManager.getViewDimension().clear();
        this.storeLayoutToDimensionManager(dimensionManager, viewDimensions, "view");
        this.storeLayoutToDimensionManager(dimensionManager, pageDimensions, "page");
        this.storeLayoutToDimensionManager(dimensionManager, colDimensions, "row");
        this.storeLayoutToDimensionManager(dimensionManager, rowDimensions, "col");
        dimensionManager.reloadDefaultDisplayDimension();
    }

    private void storeLayoutToDimensionManager(IBgDimensionManager dimensionManager, List<BgDimensionInfo> bgDimensions, String layout) {
        BgDimensionInfo bgDimensionInfo = null;
        for (int i = 0; i < bgDimensions.size(); ++i) {
            bgDimensionInfo = bgDimensions.get(i);
            bgDimensionInfo.setLayout(layout);
            dimensionManager.addDimensionInfo(bgDimensionInfo);
        }
    }
}

