/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.viewListForm;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgDimensionParseCommonHelper;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.ExpandMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListCell;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListMemberRender;
import com.kingdee.eas.ma.mbg.common.ViewListSheetParseHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.ConditionalFormatHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.apache.log4j.Logger;

public class ActionInsertRow
extends AbstractAction {
    private static final long serialVersionUID = 7846271573854260986L;
    private static final Logger logger = Logger.getLogger((String)ActionInsertRow.class.getName());
    public static final String RES_CLIENT = "com.kingdee.eas.ma.mbg.client.MBGViewListFormResource";
    private ViewListSheetParseHelper viewListSheetParseHelper = null;
    private Sheet sheet = null;
    private MbgViewListDimensionManager dimensionManager = null;
    private Set<Integer> itemFields = null;
    private ViewListProvider provide = null;

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public MbgViewListDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    public void setDimensionManager(MbgViewListDimensionManager dimensionManager) {
        this.dimensionManager = dimensionManager;
        this.itemFields = DimensionCommonHelper.getItemFields(dimensionManager.getSheet());
    }

    public void setProvide(ViewListProvider provide) {
        this.provide = provide;
    }

    private ViewListProvider getProvider() {
        return this.provide;
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionInsertRow");
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_insert");
    }

    @Override
    protected boolean hasIcon() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.uiObj;
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        SpreadContext spreadContext = contextManager.getSpreadContext();
        this.provide = (ViewListProvider)contextManager.getProvider();
        this.setSheet(spreadContext.getBook().getActiveSheet());
        this.setDimensionManager((MbgViewListDimensionManager)contextManager.getProvider().getBgDimensionManager());
        Selection sel = this.getSheet().getSheetOption().getSelection();
        if (this.provide.isInsertRowDirection()) {
            this.getSheet().getSheetOption().setInsertType(InsertType.FLLOW_DOWN_STYLE);
        }
        ViewlistCombinHelper.checkIsSelectRow(sel);
        Set<Map<MbgViewListRowCol, Map<Integer, Row>>> selectRowSet = this.getSelectRowSet();
        this.checkforRowColbyCurOrg(selectRowSet, this.provide, this.getSheet());
        for (Map<MbgViewListRowCol, Map<Integer, Row>> selectRowMap : selectRowSet) {
            if (selectRowMap.isEmpty()) {
                MsgBox.showWarning((Component)((Object)processUI), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"onlyInsetCombin"));
                return;
            }
            spreadContext.getBook().startGroup();
            Map<Integer, Row> rowMap = null;
            int rowCount = 0;
            for (MbgViewListRowCol rowObject : selectRowMap.keySet()) {
                rowMap = selectRowMap.get(rowObject);
            }
            if (rowMap != null) {
                rowCount = rowMap.size();
            }
            this.doBatchInsertRow(selectRowMap, spreadContext, rowCount, false);
            spreadContext.getBook().endGroup();
            RepaintManager pm = RepaintManager.currentManager((JComponent)spreadContext);
            pm.addDirtyRegion((JComponent)spreadContext, 0, 0, spreadContext.getWidth(), spreadContext.getHeight());
            pm.paintDirtyRegions();
        }
    }

    protected void checkforRowColbyCurOrg(Set<Map<MbgViewListRowCol, Map<Integer, Row>>> set, ViewListProvider provider, Sheet sheet) {
    }

    public void doInsertRow(Map<MbgViewListRowCol, Map<Integer, Row>> selectRowMap, SpreadContext spreadContext) {
        HashMap<Integer, Integer> insertIndexMap = new HashMap<Integer, Integer>();
        int rowcolEndIndex = 0;
        Sheet sheet = null;
        for (MbgViewListRowCol rowObject : selectRowMap.keySet()) {
            Map<Integer, Row> rowMap = selectRowMap.get(rowObject);
            rowcolEndIndex = rowObject.getEndIndex();
            for (Row row : rowMap.values()) {
                sheet = row.getSheet();
                rowObject.setEndIndex(rowcolEndIndex + 1);
                System.out.println("rowcolEndIndex:" + rowcolEndIndex);
                this.insertRow(rowcolEndIndex, row, 1, false);
                if (!insertIndexMap.containsKey(rowObject.getIndex())) {
                    insertIndexMap.put(rowObject.getIndex(), 0);
                }
                insertIndexMap.put(rowObject.getIndex(), (Integer)insertIndexMap.get(rowObject.getIndex()) + 1);
            }
            ViewlistCombinHelper.reSetStartAndEndIndex(sheet, this.getDimensionManager());
        }
    }

    public void doBatchInsertRow(Map<MbgViewListRowCol, Map<Integer, Row>> selectRowMap, SpreadContext spreadContext, int rowCount, boolean isLoadFromDB) {
        long start = System.currentTimeMillis();
        HashMap<Integer, Integer> insertIndexMap = new HashMap<Integer, Integer>();
        int rowcolEndIndex = 0;
        Sheet sheet = null;
        logger.error((Object)(" doBatchInsertRow selectRowMap: " + selectRowMap.size() + "start: " + start + ",rowCount:" + rowCount));
        for (MbgViewListRowCol rowObject : selectRowMap.keySet()) {
            Map<Integer, Row> rowMap = selectRowMap.get(rowObject);
            rowcolEndIndex = rowObject.getEndIndex();
            Iterator<Row> it = rowMap.values().iterator();
            while (it.hasNext()) {
                Row row = it.next();
                sheet = row.getSheet();
                if (row.size() <= 0 || !this.provide.isInsertRowDirection() && it.hasNext()) continue;
                if (this.provide.isInsertRowDirection() && row.getIntMark() == rowObject.getStartIndex()) {
                    row.getAt(0).getUserObject("rowColGroupStart").setValue(null);
                }
                rowObject.setEndIndex(rowcolEndIndex + rowCount);
                long insertTime = System.currentTimeMillis();
                this.insertRow(rowObject.getStartIndex(), row, rowCount, isLoadFromDB);
                logger.error((Object)("insertRow cost time: " + (System.currentTimeMillis() - insertTime) + ".ms"));
                if (!insertIndexMap.containsKey(rowObject.getIndex())) {
                    insertIndexMap.put(rowObject.getIndex(), 0);
                }
                insertIndexMap.put(rowObject.getIndex(), (Integer)insertIndexMap.get(rowObject.getIndex()) + rowCount);
                break;
            }
            ViewlistCombinHelper.reSetStartAndEndIndex(sheet, this.getDimensionManager());
            ActionInsertRow.synCalculateRow(this.getProvider(), this.getSheetParseHelper(this.getSheet().getSheetIndex()), this.getSheet());
        }
    }

    public static void synCalculateRow(ViewListProvider provider, ViewListSheetParseHelper sheetParseHelper, Sheet sheet) {
        Cell cell = null;
        Row calcRow = null;
        for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
            calcRow = sheet.getRow(r, false);
            if (!(ViewListHelper.getDimension(calcRow) instanceof MbgViewListCalcutor)) continue;
            for (int j = ((MbgViewListSheetManager)provider.getCurMbgSheetManager()).getDimensionManager().getRowDimension().size(); j < sheet.getMaxColIndex() + 1; ++j) {
                cell = calcRow.getCell(j, false);
                if (cell == null || sheetParseHelper == null) continue;
                sheetParseHelper.parseCell(sheet, cell.getRow(), cell.getCol(), cell.getRow(), cell.getCol());
            }
        }
    }

    private Set<Map<MbgViewListRowCol, Map<Integer, Row>>> getSelectRowSet() {
        Range rangeSel = this.getSheet().getSelectionRange();
        HashSet<Map<MbgViewListRowCol, Map<Integer, Row>>> set = new HashSet<Map<MbgViewListRowCol, Map<Integer, Row>>>();
        for (int i = 0; i < rangeSel.size(); ++i) {
            CellBlock block = rangeSel.getBlock(i);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (int r = block.getRow(); r <= block.getRow2(); ++r) {
                MbgViewListRowCol rowObject;
                Row row = this.getSheet().getRow(r, true);
                if (row == null || !(ViewListHelper.getDimension(row) instanceof MbgViewListRowCol) || (rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(row)) == null || !rowObject.isCombin()) continue;
                if (!linkedHashMap.containsKey(rowObject)) {
                    linkedHashMap.put(rowObject, new LinkedHashMap());
                }
                ((Map)linkedHashMap.get(rowObject)).put(r, row);
            }
            set.add(linkedHashMap);
        }
        HashSet rowObjectSet = new HashSet();
        if (!set.isEmpty()) {
            for (Map map : set) {
                rowObjectSet.addAll(map.keySet());
            }
        }
        if (rowObjectSet != null && rowObjectSet.size() > 1) {
            MsgBox.showWarning((Component)((Object)((BgSpreadCoreViewUI)this.uiObj)), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)"selectMultiGroup"));
            SysUtil.abort();
        }
        return set;
    }

    private void insertRow(int rowIndex, Row oldRow) {
        int newRowIndex = rowIndex + 1;
        List<ConditionalFormat> cellCondFormat = this.removeCellCondForamt();
        this.getSheet().clearStyleCache();
        Row newRow = BgNFSHelper.addRow(this.getSheet(), newRowIndex, true);
        ViewlistCombinHelper.setInsertRowFlag(newRow);
        this.moveCondFormat(newRow);
        this.addCellCondFormat(cellCondFormat);
        this.getSheet().clearStyleCache();
        this.copyRow(oldRow, newRow, newRowIndex);
    }

    public void insertRow(int rowIndex, Row oldRow, int rowCount, boolean isLoadFromDB) {
        int i;
        int newRowIndex = this.provide.isInsertRowDirection() || isLoadFromDB ? oldRow.getIntMark() : oldRow.getIntMark() + 1;
        List<ConditionalFormat> cellCondFormat = this.removeCellCondForamt();
        this.getSheet().clearStyleCache();
        if (isLoadFromDB) {
            BgNFSHelper.addRowsOne(this.getSheet(), newRowIndex, rowCount, true);
        } else {
            BgNFSHelper.addRows(this.getSheet(), newRowIndex, rowCount, true);
        }
        for (i = newRowIndex; i < newRowIndex + rowCount; ++i) {
            Row newRow = this.sheet.getRow(i, true);
            if (this.provide.isInsertRowDirection() && i == rowIndex) {
                ViewListHelper.setRowColStart(newRow.getAt(0));
            }
            this.moveCondFormat(newRow);
            this.addCellCondFormat(cellCondFormat);
        }
        this.getSheet().clearStyleCache();
        if (this.provide.isInsertRowDirection() || isLoadFromDB) {
            for (i = newRowIndex; i < newRowIndex + rowCount; ++i) {
                this.copyRow(oldRow, this.sheet.getRow(i, true), i);
            }
        } else {
            for (i = newRowIndex; i < newRowIndex + rowCount; ++i) {
                this.copyRow(oldRow, this.sheet.getRow(i, true), i);
            }
        }
    }

    private void addCellCondFormat(List<ConditionalFormat> cellCondFormat) {
        for (int i = 0; i < cellCondFormat.size(); ++i) {
            this.getSheet().getConditionalFormats().addConditionalFormat(cellCondFormat.get(i));
        }
    }

    private List<ConditionalFormat> removeCellCondForamt() {
        ArrayList<ConditionalFormat> conds = new ArrayList<ConditionalFormat>();
        ConditionalFormat condFormat = null;
        for (int i = this.getSheet().getConditionalFormats().size() - 1; i >= 0; --i) {
            condFormat = this.getSheet().getConditionalFormats().getConditionalFormat(i);
            if (condFormat.getBlocks() instanceof Range) continue;
            conds.add(ConditionalFormatHelper.getCopyCond(condFormat));
            condFormat.setBlocks(new SortedCellBlockArray());
        }
        this.getSheet().getConditionalFormats().reduce();
        return conds;
    }

    private void moveCondFormat(Row newRow) {
        int rowIndex = newRow.getRow();
        Sheet sheet = this.getSheet();
        ConditionalFormat condFormat = null;
        CellBlock block = null;
        for (int i = 0; i < sheet.getConditionalFormats().size(); ++i) {
            condFormat = sheet.getConditionalFormats().getConditionalFormat(i);
            if (!(condFormat.getBlocks() instanceof Range)) continue;
            for (int c = 0; c < condFormat.getBlocks().size(); ++c) {
                block = condFormat.getBlocks().getBlock(c);
                if (block.getRow() >= rowIndex) {
                    block.setRow(block.getRow() + 1);
                }
                if (1048575 == block.getRow2() || block.getRow2() < rowIndex) continue;
                block.setRow2(block.getRow2() + 1);
            }
        }
    }

    private void copyRow(Row rowFrom, Row rowTo, int newRowIndex) {
        HashMap<ConditionalFormat, ConditionalFormat> condFormats = new HashMap<ConditionalFormat, ConditionalFormat>();
        HashMap<ConditionalFormat, BgSheetRange> condFormatRanges = new HashMap<ConditionalFormat, BgSheetRange>();
        Map<String, MbgViewListCell> cellStyles = ((MbgViewListSheetManager)this.getProvider().getCurMbgSheetManager()).getDimensionManager().getCellStyles();
        ConditionalFormat condFormat2 = null;
        BgSheetRange condRange = null;
        IMbgViewListStyle condObject = null;
        MbgViewListCell varCell = new MbgViewListCell();
        this.copyRowUserObjects(rowFrom, rowTo);
        MbgViewListRowCol rowObject = (MbgViewListRowCol)ViewListHelper.getDimension(rowTo);
        IMbgViewListStyle colObject = null;
        this.buildExpression(rowTo);
        BgSheetRange lockRange = new BgSheetRange(this.getSheet());
        Cell cellFrom = null;
        Cell cellTo = null;
        long styleTime = System.currentTimeMillis();
        int colCount = this.getSheet().getMaxColIndex() + 1;
        for (int j = 0; j < colCount; ++j) {
            if (ViewListHelper.getDimension(this.getSheet().getColumn(j, false)) instanceof IMbgViewListStyle) {
                colObject = (IMbgViewListStyle)((Object)ViewListHelper.getDimension(this.getSheet().getColumn(j, false)));
                if (colObject instanceof MbgViewListAtribute) continue;
                varCell.setRow(rowObject);
                varCell.setCol((IMbgViewListObject)((Object)colObject));
                MbgViewListCell realCell = cellStyles.containsKey(varCell.getCellName()) ? cellStyles.get(varCell.getCellName()) : varCell;
                condObject = realCell.getCondiionaFormatObject();
                if (condObject.getConditionaFormat() != null) {
                    if (!condFormats.containsKey(condObject.getConditionaFormat())) {
                        condFormat2 = new ConditionalFormat(condObject.getConditionaFormat().getConditions(), condObject.getConditionaFormat().getSSAs(), (SortedCellBlockArray)this.sheet.getRange(rowTo.getRow(), j));
                        condFormats.put(condObject.getConditionaFormat(), condFormat2);
                        condRange = new BgSheetRange(this.getSheet());
                        condFormatRanges.put(condFormat2, condRange);
                    } else {
                        condFormat2 = (ConditionalFormat)condFormats.get(condObject.getConditionaFormat());
                        condRange = (BgSheetRange)condFormatRanges.get(condFormat2);
                    }
                    condRange.addCell(rowTo.getRow(), j);
                }
            }
            if ((cellFrom = rowFrom.getCell(j, false)) == null) continue;
            cellTo = rowTo.getCell(j, true);
            this.copyCellUserObjects(cellFrom, cellTo);
            if (this.isAdjust() && BgNConstants.EDIT_COLOR.equals(cellTo.getStyle().getBackground())) {
                BgNFSHelper.setBackGroup(cellTo, BgNConstants.BASE_COLOR);
            }
            if (BgNFSHelper.getItemFormula(cellFrom) != null) {
                this.builderBgFormula(cellTo);
                lockRange.addCell(newRowIndex, j);
            }
            if (BgNFSHelper.getItemFormula(cellFrom) == null && ViewListHelper.getDimension(this.getSheet().getColumn(j, false)) instanceof MbgViewListRowCol) {
                lockRange.addCell(newRowIndex, j);
            }
            if (ViewListHelper.getCombinDimension(cellTo) != null) {
                lockRange.addCell(newRowIndex, j);
                this.setOrgMemberValue(cellTo);
            }
            this.setOrgAttribute(rowFrom, cellTo);
        }
        for (ConditionalFormat condFormat2 : condFormatRanges.keySet()) {
            condRange = (BgSheetRange)condFormatRanges.get(condFormat2);
            condFormat2.setBlocks((SortedCellBlockArray)condRange.getRange());
        }
        BgViewHelper.setLocked(true, lockRange.getRange());
    }

    private void copyRowUserObjects(Row rowFrom, Row rowTo) {
        SortedUserObjectArray ss = rowFrom.getUserObjects();
        UserObject useObj = null;
        if (ss != null && !ss.isEmpty()) {
            int ssSize = ss.size();
            for (int k = 0; k < ssSize; ++k) {
                useObj = ss.getUserObject(k);
                if (useObj.getKey() != null && (useObj.getKey().equals("dimensino.member") || useObj.getKey().equals("COMBIN_MEMBER"))) continue;
                rowTo.setUserObject(useObj.getKey(), useObj.getValue());
            }
        }
    }

    private void copyCellUserObjects(Cell cellFrom, Cell cellTo) {
        SortedUserObjectArray ss = cellFrom.getUserObjects(false);
        UserObject useObj = null;
        if (ss != null && !ss.isEmpty()) {
            int ssSize = ss.size();
            for (int k = 0; k < ssSize; ++k) {
                useObj = ss.getUserObject(k);
                if (useObj.getKey() != null && (useObj.getKey().equals("rowColGroupStart") || useObj.getKey().equals("ITEM") || useObj.getKey().equals("CELL_CHANGE_LASTUPDATETIME") || useObj.getKey().equals("dimensino.member"))) continue;
                Object value = useObj.getValue();
                HashMap clone = null;
                if (value != null && value instanceof Map) {
                    Map map = (Map)value;
                    clone = new HashMap(map);
                }
                cellTo.setUserObject(useObj.getKey(), clone);
                MbgViewListDescriptionHelper.removeDesriptionCell(cellTo);
                MbgViewListDescriptionHelper.removeDescriptionFormula(cellTo);
            }
        }
    }

    private void builderBgFormula(Cell cell) {
        if (cell == null) {
            return;
        }
        int sheetIndex = cell.getSheet().getSheetIndex();
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        Row row = cell.getRowObject();
        Column col = this.getSheet().getColumn(cell.getCol(), false);
        Object[] colMembers = ViewListHelper.getDimensionMember(col);
        Object[] rowMembers = ViewListHelper.getDimensionMember(row);
        members.clear();
        ViewListHelper.add(members, rowMembers);
        ViewListHelper.add(members, colMembers);
        members.addAll(ViewlistCombinHelper.getPageMembers(this.getDimensionManager(), this.getProvider().getPageF7List(sheetIndex)));
        members.addAll(ViewlistCombinHelper.getViewMembers(this.getDimensionManager(), this.getProvider().getViewF7List(sheetIndex)));
        BgDimensionParseCommonHelper.builderBgFormula(cell, members, true, null, new HashMap<String, MBGRowData>(), null, this.itemFields);
        if (ViewlistCombinHelper.checkCombinRowFullofMembers(row, false)) {
            MbgViewListDescriptionHelper.buildDescriptionFormula(this.provide.getOrgUnitId(), cell, null, members, this.getDimensionManager().getSheet(), row, col, true);
        }
    }

    private void buildExpression(Row row) {
        if (row == null) {
            return;
        }
        int r = row.getRow();
        MbgViewListCalcutor calculator = null;
        Cell _cell = null;
        Sheet sheet = row.getSheet();
        int colIndex = sheet.getMaxColIndex();
        for (int c = 0; c <= colIndex; ++c) {
            IMbgViewListObject colObject;
            Column col = sheet.getColumn(c, false);
            if (col == null || !((colObject = ViewListHelper.getDimension(col)) instanceof MbgViewListCalcutor)) continue;
            calculator = (MbgViewListCalcutor)colObject;
            _cell = sheet.getCell(r, c, false);
            if (_cell == null || this.getSheetParseHelper(sheet.getIndex()) == null) continue;
            BgNFSHelper.setExpression(_cell, "=" + this.getSheetParseHelper(sheet.getIndex()).convertFormula(calculator.getFormula(), r, _cell, true));
            if (_cell.getStyle().isLocked()) continue;
            BgNFSHelper.setLockOfCell(_cell, true);
        }
    }

    private ViewListSheetParseHelper getSheetParseHelper(int sheetIndex) {
        this.viewListSheetParseHelper = this.getProvider().getBookParseHelper().getSheetMap().get(sheetIndex);
        return this.viewListSheetParseHelper;
    }

    private boolean isAdjust() {
        return this.uiObj instanceof MbgViewListFormAdjustProcessUI;
    }

    private void setOrgMemberValue(Cell cellTo) {
        if (cellTo == null || !(ViewListHelper.getCombinDimension(cellTo) instanceof MbgViewListDimensionInfo) || ViewListHelper.getCombinDimension(cellTo).getMember().isEmpty()) {
            return;
        }
        if (!(ViewListHelper.getCombinDimension(cellTo).getMember().get(0) instanceof MbgViewListDimensionMember)) {
            return;
        }
        MbgViewListDimensionMember viewListMember = (MbgViewListDimensionMember)ViewListHelper.getCombinDimension(cellTo).getMember().get(0);
        if (viewListMember != null && viewListMember.getType().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) {
            String showType = DimensionCommonHelper.searchDimension(viewListMember.getType(), this.getDimensionManager().getDimension()).getShowType();
            Object oneMember = ViewListMemberRender.createExpaneMember(viewListMember);
            if (oneMember instanceof ExpandMember) {
                ExpandMember expandMember = (ExpandMember)oneMember;
                ViewListHelper.setHeadCell(cellTo, expandMember, showType);
            } else {
                ViewListHelper.setHeadCell(cellTo, oneMember, showType);
            }
        }
    }

    private void setOrgAttribute(Row rowFrom, Cell cellTo) {
        MbgViewListAtribute attribObject;
        if (cellTo != null && ViewListHelper.getDimension(this.getSheet().getColumn(cellTo.getCol(), false)) instanceof MbgViewListAtribute && DimensionConstants.DEF_ORGUNIT_NUMBER.equals((attribObject = (MbgViewListAtribute)ViewListHelper.getDimension(this.getSheet().getColumn(cellTo.getCol(), false))).getDimNumber())) {
            Map<String, Map<String, String>> propMaps = this.getProvider().getPropMaps();
            if (attribObject.getPropertySort().getId() != null) {
                String orgMemberNumber = null;
                BgDimensionMember[] members = ViewListHelper.getDimensionMember(rowFrom);
                if (members != null && members.length > 0) {
                    for (int b = 0; b < members.length; ++b) {
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(members[b].getType())) continue;
                        orgMemberNumber = members[b].getNumber();
                        break;
                    }
                }
                if (!StringUtils.isEmpty(orgMemberNumber) && attribObject.getPropertySort() != null) {
                    String key = "";
                    key = attribObject.getPropertySort().getId() != null ? attribObject.getDimNumber() + "_" + attribObject.getPropertySort().getId() : attribObject.getDimNumber() + "_" + attribObject.getPropertySort().getNumber();
                    BgNFSHelper.setValue(cellTo, propMaps.get(key).get(orgMemberNumber));
                    cellTo.setUserObject("dimensino.member", (Object)attribObject);
                }
            }
        }
    }
}

