/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.viewListForm;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgFormFacade;
import com.kingdee.eas.ma.mbg.client.BgNFProcessUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgNCWfHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBgExamineClientUtils;
import com.kingdee.eas.ma.mbg.client.viewListForm.MBGViewListFormContextManager;
import com.kingdee.eas.ma.mbg.client.worktable.WorkTableProcessUI;
import com.kingdee.eas.ma.mbg.provider.IViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class ActionRefer
extends AbstractAction {
    private static final long serialVersionUID = 5544760171870276051L;
    private boolean hasExamineCheck = false;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_submit");
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionRefer");
    }

    public void actionPerformed(ActionEvent e) {
        BgSpreadCoreViewUI ownerUi = (BgSpreadCoreViewUI)this.getUIObject();
        if (!(ownerUi.getContextManager() instanceof MBGViewListFormContextManager)) {
            return;
        }
        MBGViewListFormContextManager contextManager = (MBGViewListFormContextManager)ownerUi.getContextManager();
        MBGViewListFormProvider provider = (MBGViewListFormProvider)contextManager.getProvider();
        String bgFormId = provider.getBgFormInfo().getId().toString();
        boolean readonly = provider.getBgFormInfo().getBgTemplate().isReadonly();
        boolean canUndo = contextManager.getSpreadContext().getBook().getUndoManager().canUndo();
        String bgFormName = provider.getBgFormInfo().getName();
        try {
            if (readonly) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTemplateResource", (String)"cannotReferReadonly"));
                SysUtil.abort();
            }
            this.actionRefer(ownerUi, bgFormId, canUndo, bgFormName);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            ownerUi.handUIExceptionAndAbort(e1);
        }
    }

    public void actionRefer(CoreUI ownerUi, final String billId, boolean canUndo, String bgFormName) throws Exception {
        int re;
        Object obj;
        boolean isInPorInst = BgFormHelper.checkInProInst(billId);
        if (!isInPorInst) {
            this.checkCanSingleRefer(ownerUi, billId);
        }
        if (!((obj = ownerUi.getUIContext().get("Owner")) == null || obj instanceof MessageCenterUI || obj instanceof MultiApproveUI || ownerUi.getOprtState().equals(OprtState.EDIT) && isInPorInst || !isInPorInst)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"bgFormInWorkNoSubmit"));
            SysUtil.abort();
        }
        if (canUndo && ownerUi.getOprtState().equals(OprtState.EDIT) || ownerUi.getOprtState().equals(OprtState.ADDNEW)) {
            if (ownerUi instanceof BgNFProcessUI) {
                ((BgNFProcessUI)ownerUi).actionSave_actionPerformed(null);
            } else if (ownerUi instanceof BgSpreadCoreViewUI) {
                ActionEvent e = new ActionEvent(ownerUi, 0, ownerUi.getClass().getName() + "$ActionSave");
                try {
                    BookContextManager contextManager = (BookContextManager)((BgSpreadCoreViewUI)ownerUi).getContextManager();
                    if (contextManager.getProvider() instanceof IViewListProvider) {
                        ((IViewListProvider)contextManager.getProvider()).store(contextManager.getSpreadContext().getBook());
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Component)ownerUi, (Throwable)e1);
                    SysUtil.abort();
                }
                ((BgSpreadCoreViewUI)ownerUi).actionSave_actionPerformed(e);
            }
        }
        if ((re = MsgBox.showConfirm2((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"submitFormWork"))) == 1 || re == 2) {
            return;
        }
        if (ownerUi instanceof BgNFProcessUI && BgNSHelper.isCompulsionReportCheck(null) && !((BgNFProcessUI)ownerUi).isCheckReportPass(null, false)) {
            MsgBox.showWarning((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"cantSubmitOfCheck"));
            SysUtil.abort();
        }
        if (this.getExamineInterface().canExamine(new String[]{billId})) {
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)ownerUi);
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            Object viewId = this.uiObj.getUIContext().get("BGORGVIEW_ID");
            Object bgOrgViewId = viewId instanceof BOSUuid ? (BOSUuid)viewId : (viewId instanceof String ? BOSUuid.read((String)viewId.toString()) : null);
            this.hasExamineCheck = false;
            dialog.setLongTimeTask(new ILongTimeTask((BOSUuid)bgOrgViewId){
                final /* synthetic */ BOSUuid val$bgOrgViewId;
                {
                    this.val$bgOrgViewId = bOSUuid;
                }

                public Object exec() throws Exception {
                    Object result = ActionRefer.this.getExamineInterface().examine(billId);
                    if (result instanceof List && !((List)result).isEmpty()) {
                        result = (BgExamineResult)((List)result).get(0);
                    }
                    if (result instanceof BgExamineResult) {
                        BgExamineResult checkResult = (BgExamineResult)result;
                        if (checkResult.result) {
                            ActionRefer.this.hasExamineCheck = true;
                        }
                    }
                    return result;
                }

                public void afterExec(Object result) throws Exception {
                    if (result instanceof List && !((List)result).isEmpty()) {
                        result = (BgExamineResult)((List)result).get(0);
                    }
                    if (result instanceof BgExamineResult) {
                        BgExamineResult checkResult = (BgExamineResult)result;
                        if (!checkResult.result) {
                            MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoPass"));
                        } else {
                            ActionRefer.this.hasExamineCheck = true;
                        }
                        ArrayList<String> billIds = new ArrayList<String>();
                        billIds.add(billId);
                        MBgExamineClientUtils.getInstance().showCheckReport(checkResult, this.val$bgOrgViewId, false, billIds);
                    } else {
                        MsgBox.showError((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineError"));
                    }
                }
            });
            dialog.show();
        } else {
            this.hasExamineCheck = true;
        }
        if (this.hasExamineCheck) {
            boolean flag = false;
            BOSUuid bgFormId = BOSUuid.read((String)billId);
            BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo("select * where id ='" + bgFormId + "'");
            if (!BgFormHelper.checkProcessDefIsEnable(SysContext.getSysContext().getCurrentUserInfo().getId().toString(), (IObjectValue)bgFormInfo, "com.kingdee.eas.ma.mbg.BgFormFunction", BgNCWfHelper.getReferActionName(bgFormInfo.getState()))) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormAdjustResource", (String)"notFindWFProcf"));
                return;
            }
            if (isInPorInst) {
                ActionRefer.getFacadeInterface().submitFormWork(bgFormId);
                flag = true;
            } else if (!BgNCWfHelper.isNextPersonSubmit()) {
                flag = BgNCWfHelper.submitFormWork((CoreBaseInfo)bgFormInfo, ownerUi, ActionRefer.getFacadeInterface(), "com.kingdee.eas.ma.mbg.BgFormFunction", "ActionFormSubmit");
            } else {
                ActionRefer.getFacadeInterface().submitFormWork(bgFormId);
            }
            if (flag) {
                BgNFCHelper.uploadRefAttachmentFile(bgFormId.toString());
                ownerUi.setMessageText(bgFormName + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"submitFormSucceed"));
            } else {
                ownerUi.setMessageText(bgFormName + EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"submitFormDefeat"));
            }
            ownerUi.showMessage();
            if (ownerUi.getUIContext().get("WORKTABLE_PROCESSUI") instanceof WorkTableProcessUI) {
                if (((WorkTableProcessUI)((Object)ownerUi.getUIContext().get("WORKTABLE_PROCESSUI"))).getRptProSize() == 1) {
                    ((WorkTableProcessUI)((Object)ownerUi.getUIContext().get("WORKTABLE_PROCESSUI"))).destroyWindow();
                } else {
                    ((WorkTableProcessUI)((Object)ownerUi.getUIContext().get("WORKTABLE_PROCESSUI"))).closeTabPane();
                }
            } else {
                ownerUi.destroyWindow();
            }
        }
    }

    public IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    public IBgExamineFacade getExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    public boolean checkCanSchemeRefer(CoreUI ownerUi, String bgFormId) throws Exception {
        boolean result = false;
        if (bgFormId == null) {
            return result;
        }
        try {
            String sql = "select a.FIsSubmitByScheme from T_MBg_BgScheme a, T_MBg_BgForm b  where a.FID = b.FBgSchemeId and b.fid = '" + bgFormId + "'";
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = iSql.executeSQL();
            if (rs.next()) {
                result = rs.getBoolean(1);
            }
        }
        catch (Exception ex) {
            ownerUi.handUIException((Throwable)ex);
        }
        return result;
    }

    public void checkCanSingleRefer(CoreUI ownerUi, String bgFormId) throws Exception {
        boolean result = this.checkCanSchemeRefer(ownerUi, bgFormId);
        if (result) {
            MsgBox.showInfo((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgSubmitBySchemeResource", (String)"formOnlySubmitByScheme"));
            SysUtil.abort();
        }
    }

    public static IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }
}

