/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.analysisReport;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentSizeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentDownloadClient;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesConstant;
import com.kingdee.eas.ma.mbg.BgAnalysReportFactory;
import com.kingdee.eas.ma.mbg.BgAnalysReportInfo;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.utils.analysisReport.BgAnalysRptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FileHandle {
    private static final Logger logger = CoreUIObject.getLogger(FileHandle.class);
    private boolean isSuccess = true;
    FileOutputStream out = null;

    public boolean uploadFile(File attachFile, String boID, AttachmentUIContextInfo info, Component owner, IRow row, boolean isRpt) throws Exception {
        return this.uploadFile(attachFile, boID, info, owner, row, isRpt, false);
    }

    public boolean uploadFile(File attachFile, String boID, AttachmentUIContextInfo info, Component owner, IRow row, boolean isRpt, boolean isAddNew) throws Exception {
        try {
            BgAnalysReportInfo rptinfo;
            Thread.sleep(50L);
            if (isRpt && (rptinfo = BgAnalysReportFactory.getRemoteInstance().getBgAnalysReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)boID)))) != null && rptinfo.getState().getValue() != 1) {
                return false;
            }
            AttachmentInfo attachInfo = this.makeAttachmentInfo(attachFile, boID, info);
            AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
            String attchID = attachmentClientManager.submitAttachment(attachInfo);
            if (isRpt) {
                BgAnalysReportFactory.getRemoteInstance().updateWordId(boID, attchID);
                row.getCell("wordID").setValue((Object)attchID);
                row.getCell("updateTime").setValue((Object)BgAnalysRptUtil.getTime());
                row.getCell("updator").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
            } else {
                BgAnalysRptTemplateFactory.getRemoteInstance().updateWordId(boID, attchID);
                if (!isAddNew) {
                    row.getCell("wordAttachId").setValue((Object)attchID);
                    row.getCell("lastUpdateTime").setValue((Object)BgAnalysRptUtil.getTime());
                    row.getCell("lastUpdateUser.name").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
                }
            }
            this.isSuccess = true;
            return Boolean.TRUE;
        }
        catch (Exception e) {
            this.isSuccess = false;
            logger.info((Object)"", (Throwable)e);
            throw e;
        }
    }

    public AttachmentInfo makeAttachmentInfo(File attachFile, String boID, AttachmentUIContextInfo info) throws Exception {
        IAttachment ia = AttachmentFactory.getRemoteInstance();
        AttachmentInfo ai = new AttachmentInfo();
        String fullname = attachFile.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        Locale locale = SysContext.getSysContext().getLocale();
        extname = extname.toLowerCase(locale);
        String fileUrl = null;
        byte[] content = null;
        if (attachFile.length() > 0x3200000L) {
            fileUrl = attachFile.getAbsolutePath();
        } else {
            content = FileGetter.getBytesFromFile((File)attachFile);
        }
        if (extname.equals("url")) {
            StringUtil4File.checkURL((IAttachment)ia, (String)boID, (String)mainname);
        } else {
            if (mainname == null || mainname.equals("")) {
                throw new AttachmentException(AttachmentException.FILENAMEISEMPTY);
            }
            StringUtil4File.checkInvalidCharsInFileName((String)mainname);
            SimpleAttachmentInfo sa = new SimpleAttachmentInfo();
            double attSize = AttachmentSizeFactory.getRemoteInstance().getFileSize();
            sa.setContent(content);
            sa.checkFileSize(attSize);
        }
        MutilLangeToolForParam.muti2Obj((String)mainname, (IObjectValue)ai, (String)"name");
        MutilLangeToolForParam.muti2Obj(null, (IObjectValue)ai, (String)"description");
        String tempValue = ai.isIsShared() ? EASResource.getString((String)"yes") : EASResource.getString((String)"no");
        MutilLangeToolForParam.muti2Obj((String)tempValue, (IObjectValue)ai, (String)"sharedDesc");
        ai.setNumber(info.getCode());
        ai.setFile(content);
        ai.setIsShared(!extname.equals("url"));
        ai.setSimpleName(extname);
        ai.setType(extname.equals("url") ? "URL" : StringUtil4File.getFileTypeDescription((String)extname));
        ai.setSize(StringUtil4File.getFileSizeRepresentation((long)(content == null ? attachFile.length() : (long)content.length)));
        ai.setSizeInByte((int)(content == null ? attachFile.length() : (long)content.length));
        ai.setShareRange(info.getShareRange());
        ai.setAttachID(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + (int)(new SecureRandom().nextDouble() * 9000.0 + 1000.0));
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        ai.getBoAttchAsso().add(baai);
        ai.setBeizhu(info.getBeizhu());
        ai.setRemotePath(fileUrl);
        return ai;
    }

    public String download(String attchID, String dir, boolean isEditOpen, Component owner) throws Exception {
        return this.download(attchID, dir, null, isEditOpen, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String download(String attchID, String dir, String fileName, boolean isEditOpen, Component owner) throws Exception {
        String type = "";
        String fullname = "";
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("simpleName"));
            sic.add(new SelectorItemInfo("sizeInByte"));
            IAttachment ia = AttachmentFactory.getRemoteInstance();
            AttachmentInfo ai = (AttachmentInfo)ia.getValue((IObjectPK)new ObjectUuidPK(attchID), sic);
            final String waitAttachmentId = ai.getId().toString();
            String name = ai.getName();
            int oprtIndex = name.lastIndexOf("--");
            if (oprtIndex > 0) {
                name = name.substring(0, oprtIndex);
            }
            if (!StringUtils.isEmpty((String)fileName) && !name.startsWith(fileName)) {
                name = fileName + name.substring(name.lastIndexOf(")") + 1);
            }
            name = name + "--" + (isEditOpen ? ReportNotesConstant.edit : ReportNotesConstant.view);
            type = ai.getSimpleName();
            fullname = dir + File.separator + name + "." + type;
            File file = new File(fullname = FilenameUtils.normalize((String)fullname));
            if (file.exists() && !dir.equals("") && !file.delete()) {
                System.gc();
                if (!file.delete()) {
                    fullname = dir + File.separator + name + "N." + type;
                    fullname = FilenameUtils.normalize((String)fullname);
                    file = new File(fullname);
                }
            }
            this.out = new FileOutputStream(file);
            KDDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor(owner);
            dialog = win != null && win instanceof KDDialog ? (KDDialog)win : new KDDialog();
            LongTimeDialog ltd = new LongTimeDialog((Dialog)dialog);
            ltd.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    try {
                        AttachmentDownloadClient downloadClient = new AttachmentDownloadClient(AttachmentFtpFacadeFactory.getRemoteInstance());
                        downloadClient.setOutputStream((OutputStream)FileHandle.this.out);
                        downloadClient.downLoad(waitAttachmentId);
                        FileHandle.this.isSuccess = true;
                    }
                    catch (Exception e) {
                        FileHandle.this.isSuccess = false;
                        logger.error((Object)e);
                        throw e;
                    }
                    return true;
                }

                public void afterExec(Object arg0) throws Exception {
                }
            });
            ltd.show();
            if (!this.isSuccess) {
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)Resrcs.getString((String)"PathNotExisted"));
            fullname = "";
        }
        finally {
            if (this.out != null) {
                this.out.close();
            }
        }
        return fullname;
    }
}

