/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgGatherInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgDecomposeAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.BgDecomposeGatherUI;
import com.kingdee.eas.ma.mbg.client.BgDecomposeSpecialAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.BgDecomposeViewListProcessUI;
import com.kingdee.eas.ma.mbg.client.BgFormWorkTableProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormDescomposeProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.utils.BgMultiDecomposeGatherHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ActionGather
extends AbstractAction {
    private static final long serialVersionUID = 1578150494171106952L;
    private static final String PROCESSTYPE = "PROCESSTYPE";
    private static final String ORGUNITIDSET = "ORGUNITIDSET";
    private static final String SHEETNAME = "SHEETNAME";
    private static final String ORGUNITINFOS = "ORGUNITINFOS";
    public static final String ISCALCBIZ = "ISCALCBIZ";
    public static final String ISCLEAREXPRESSION = "ISCLEAREXPRESSION";
    private BgSchemeDimensionHelper schemeHelper = null;
    protected LongTimeDialog longTimeDialog = null;
    private Map<String, BigDecimal> otherMutilGatherValue = new HashMap<String, BigDecimal>();
    List<String> formulaList = null;

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionGather");
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_collect");
    }

    @Override
    protected boolean hasIcon() {
        return true;
    }

    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(this.getBgFormInfo().getBgScheme().getId().toString());
        }
        return this.schemeHelper;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            this.executeGather();
        }
        catch (Exception e1) {
            this.getUIObject().handUIException((Throwable)e1);
        }
    }

    public void executeGather() throws Exception {
        BgFormInfo BgFormInfo2 = this.getBgFormInfo();
        Book book = this.getBook();
        final Map<String, Object> paramMap = this.showGatherUI((CoreUI)this.getUIObject(), BgFormInfo2, book);
        if (paramMap.isEmpty()) {
            return;
        }
        Window win = SwingUtilities.getWindowAncestor((JComponent)this.getUIObject());
        if (win instanceof Frame) {
            this.longTimeDialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            this.longTimeDialog = new LongTimeDialog((Dialog)win);
        }
        if (this.longTimeDialog == null) {
            return;
        }
        this.longTimeDialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                ActionGather.this.runGather(paramMap);
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        this.longTimeDialog.show();
    }

    protected final void runGather(Map<String, Object> paramMap) throws Exception, EASBizException, BOSException {
        DimensionCacheHelper cacheHelper = this.getCacheHelper();
        IMbgViewBase view = this.filterSheet(paramMap);
        if (view == null) {
            return;
        }
        BgMultiDecomposeGatherHelper.filterBudgetScenario(view, cacheHelper);
        Map<String, Map<String, BgNViewDataInfo>> bgDataMap = this.queryData(view, paramMap);
        Map<String, Map<String, BgNViewDataInfo>> virtualBgDataMap = this.replaceBgDataMap(bgDataMap, view, paramMap, cacheHelper);
        this.fillData(virtualBgDataMap, paramMap, cacheHelper);
        ((CoreUI)this.getUIObject()).updateUI();
        if (((CoreUI)this.getUIObject() instanceof BgNFormDescomposeProcessUI || (CoreUI)this.getUIObject() instanceof BgDecomposeViewListProcessUI) && ((CoreUI)this.getUIObject()).getUIContext().get("WORKTABLE_PROCESSUI") instanceof BgFormWorkTableProcessUI) {
            BgFormWorkTableProcessUI workProcessui = (BgFormWorkTableProcessUI)((Object)((CoreUI)this.getUIObject()).getUIContext().get("WORKTABLE_PROCESSUI"));
            workProcessui.updateUI();
        }
    }

    private void filterBudgetScenario(IMbgViewBase view, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        List dimensions = null;
        BgDimensionBaseInfo dimension = null;
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimensions = view instanceof MbgViewListManager ? ((MbgViewListSheetManager)((MbgViewListManager)view).getSheetManagers().get(s)).getDimensionManager().getAllDimensions() : ((IMbgViewManager)view).getSheetManagers().get(s).getDimensionManager().getDimension();
            for (int d = 0; d < dimensions.size(); ++d) {
                if (!(dimensions.get(d) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_SCENARIO_NUMBER.equals((dimension = (BgDimensionBaseInfo)dimensions.get(d)).getNumber())) continue;
                Iterator it = dimension.getMember().iterator();
                while (it.hasNext()) {
                    if (cacheHelper.getBudgetScens().contains(BgViewHelper.getNumber(it.next()))) continue;
                    it.remove();
                }
            }
        }
    }

    protected DimensionCacheHelper getCacheHelper() {
        return ((BgNFProcessUI)this.getUIObject()).getCheckHelper().getCacheHelper();
    }

    protected final void fillData(Map<String, Map<String, BgNViewDataInfo>> virtualBgDataMap, Map<String, Object> paramMap, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        Book book = this.getBook();
        Sheet sheet = null;
        Cell cell = null;
        Object[] sheetNames = this.getSheetNames(paramMap);
        List sheetList = BgNFSHelper.toList(sheetNames);
        ItemFormula formula = null;
        String currVersionNumber = this.getBgFormInfo().getBgVersion().getNumber();
        String currOrgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
        String versionNumber = null;
        String cellOrgId = null;
        BgNViewDataInfo bgData = null;
        boolean isClearExpression = Boolean.parseBoolean(paramMap.containsKey(ISCLEAREXPRESSION) ? paramMap.get(ISCLEAREXPRESSION).toString() : null);
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            if (!sheetList.isEmpty() && !sheetList.contains(sheet.getSheetName())) continue;
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    formula = BgNFSHelper.getItemFormula(cell);
                    if (isClearExpression && BgNFSHelper.checkHasFormulaOfCell(cell) && BgNFSHelper.checkHasExpression(cell)) {
                        BgNFSHelper.clearExpression(cell);
                    }
                    if (formula == null) continue;
                    BgNFSHelper.removeCellChangeLastUpdataTime(cell);
                    versionNumber = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    if (versionNumber == null) {
                        versionNumber = currVersionNumber;
                    }
                    if (cellOrgId == null) {
                        cellOrgId = currOrgUnitId;
                    }
                    if (!versionNumber.equals(currVersionNumber) || !cellOrgId.equals(currOrgUnitId) || !this.isBudgetScenario(formula.getFormula(), cacheHelper)) continue;
                    bgData = MBGViewListFormClientHelper.getData(virtualBgDataMap, cellOrgId, formula.getFormula(), versionNumber, false);
                    if (bgData == null) {
                        BgNFSHelper.setValue(cell, null);
                        continue;
                    }
                    BgNFSHelper.setValue(cell, bgData.getBudgetValueNoDef());
                    this.fillAdjustData(cell, bgData);
                }
            }
        }
    }

    protected void fillAdjustData(Cell cell, BgNViewDataInfo bgData) {
        if (this.isAdjust(bgData)) {
            BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
        }
    }

    protected boolean isAdjust(BgNViewDataInfo bgData) {
        if (bgData != null && bgData.getBudgetValueNoDef() != null) {
            return this.isAdjust() && bgData.getBudgetValueNoDef().compareTo(bgData.getOldValue() == null ? BgNConstants.ZERO : bgData.getOldValue()) != 0;
        }
        return false;
    }

    protected boolean isAdjust() {
        return this.getBgFormInfo().getState().equals((Object)BgFormStateEnum.Adjusted);
    }

    private boolean isBudgetScenario(String formula, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        String[] formulas = BgNFSHelper.parseFormulaPara(formula);
        return cacheHelper.getBudgetScens().contains(formulas[3]);
    }

    protected Map<String, Map<String, BgNViewDataInfo>> replaceBgDataMap(Map<String, Map<String, BgNViewDataInfo>> bgDataMap, IMbgViewBase view, Map<String, Object> paramMap, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        List<BgGatherInfo> gatherInfos = this.getGatherInfos();
        if (((Object)((Object)this)).getClass().getName().indexOf("ActionMultiGather") < 0) {
            gatherInfos.clear();
        }
        BgProcessEnum processType = this.getProcessType(paramMap);
        HashSet<String> formulaList = new HashSet<String>(this.buildFormula(view));
        Map<String, Map<String, BgNViewDataInfo>> uiBgDataMap = this.getUiBgDataMap();
        Map<String, BgNViewDataInfo> subBgDataMap = null;
        String currentOrgUnitId = this.getBgFormInfo().getOrgUnit().getId().toString();
        String versionNumber = this.getBgFormInfo().getBgVersion().getNumber();
        Set<String> orgUnitIds = this.getOrgUnitIdSet(paramMap);
        if (uiBgDataMap.get(currentOrgUnitId) == null) {
            uiBgDataMap.put(currentOrgUnitId, new HashMap());
        }
        Map<String, BgNViewDataInfo> subUibgDataMap = uiBgDataMap.get(currentOrgUnitId);
        DimensionMemberCheckHelper checkHelper = DimensionMemberCheckHelper.getRemoteIntance(cacheHelper, currentOrgUnitId, null, this.getSchemeHelper(), view, true);
        BigDecimal value = null;
        String formulaKey = null;
        for (String formula : formulaList) {
            value = null;
            if (!this.isBudgetScenario(formula, cacheHelper) || !checkHelper.canSave(formula, null, null)) continue;
            formulaKey = formula + "_" + versionNumber;
            for (String orgUnitId : orgUnitIds) {
                subBgDataMap = bgDataMap == null ? null : bgDataMap.get(orgUnitId);
                if (subBgDataMap == null || subBgDataMap.get(formulaKey) == null || subBgDataMap.get(formulaKey).getBudgetValueNoDef() == null) continue;
                value = value == null ? subBgDataMap.get(formulaKey).getBudgetValueNoDef() : value.add(subBgDataMap.get(formulaKey).getBudgetValueNoDef());
                BgMultiDecomposeGatherHelper.addGatherInfo(gatherInfos, this.getBgFormInfo(), formula, orgUnitId, subBgDataMap.get(formulaKey).getBudgetValueNoDef(), processType);
            }
            if ((value = this.doAfter(formulaKey, value)) != null) {
                if (subUibgDataMap.get(formulaKey) != null) {
                    subUibgDataMap.get(formulaKey).setBudgetValue(value);
                    continue;
                }
                MBGViewListFormClientHelper.getData(uiBgDataMap, currentOrgUnitId, formula, versionNumber, true).setBudgetValue(value);
                continue;
            }
            if (subUibgDataMap.get(formulaKey) != null) {
                subUibgDataMap.get(formulaKey).setBudgetValue(null);
            } else {
                MBGViewListFormClientHelper.createNullData(uiBgDataMap, currentOrgUnitId, formula, versionNumber);
            }
            BgMultiDecomposeGatherHelper.addGatherInfo(gatherInfos, this.getBgFormInfo(), formula, null, null, processType);
        }
        return uiBgDataMap;
    }

    protected Map<String, BigDecimal> getOtherMutilGatherValue() {
        return this.otherMutilGatherValue;
    }

    protected BigDecimal doAfter(String formulaKey, BigDecimal value) {
        return value;
    }

    protected List<BgGatherInfo> getGatherInfos() {
        if (this.getUIObject() instanceof BgNFormDescomposeProcessUI) {
            return ((BgNFormDescomposeProcessUI)this.getUIObject()).getGatherInfos();
        }
        if (this.getUIObject() instanceof BgDecomposeAdjustProcessUI) {
            return ((BgDecomposeAdjustProcessUI)this.getUIObject()).getGatherInfos();
        }
        if (this.getUIObject() instanceof BgDecomposeSpecialAdjustProcessUI) {
            return ((BgDecomposeSpecialAdjustProcessUI)this.getUIObject()).getGatherInfos();
        }
        return new ArrayList<BgGatherInfo>();
    }

    protected Map<String, Map<String, BgNViewDataInfo>> getUiBgDataMap() {
        HashMap<String, Map<String, BgNViewDataInfo>> uiDataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
        uiDataMap.put(this.getBgFormInfo().getOrgUnit().getId().toString(), ((BgNFProcessUI)this.getUIObject()).getBgdataMap());
        return uiDataMap;
    }

    protected List<String> buildFormula(IMbgViewBase view) throws EASBizException, BOSException {
        return this.formulaList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, Map<String, BgNViewDataInfo>> queryData(IMbgViewBase view, Map<String, Object> paramMap) throws Exception {
        try {
            this.getBgFormInfo().put("ORGUNIT_ID", this.getOrgUnitIdSet(paramMap));
            ArrayList<IBgDimensionManagerBase> dimensionManagers = new ArrayList<IBgDimensionManagerBase>();
            for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                this.sysOrgMember(view.getSheetManagers().get(s).getDimensionManager(), this.getBgOrgUnitInfos(paramMap));
                dimensionManagers.add(view.getSheetManagers().get(s).getDimensionManager());
            }
            Boolean isCalcBiz = (Boolean)paramMap.get(ISCALCBIZ);
            BgFormInfo bgFormInfo = this.getBgFormInfo();
            BgFormStateEnum initState = bgFormInfo.getState();
            if (BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState()) && this.isAdjust()) {
                bgFormInfo.setState(BgFormStateEnum.Adjusted);
            }
            Map result = MBGFormFacadeFactory.getRemoteInstance().queryBgData(this.getBgFormInfo().getId(), (IObjectValue)bgFormInfo, dimensionManagers, DimensionCommonHelper.getDataType(this.getProcessType(paramMap)), false, null, false, null, isCalcBiz);
            bgFormInfo.setState(initState);
            Map map = result;
            return map;
        }
        finally {
            this.getBgFormInfo().remove("ORGUNIT_ID");
        }
    }

    private void sysOrgMember(IBgDimensionManagerBase dimensionManager, List<BgOrgUnitInfo> bgOrgUnitInfos) {
        List dimension = dimensionManager.getDimension();
        Iterator iterator = dimension.iterator();
        HashSet<String> existsOrg = new HashSet<String>();
        BgDimensionBaseInfo dimensionInfo = (BgDimensionBaseInfo)iterator.next();
        if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) {
            List members = dimensionInfo.getMember();
            int in = members.size();
            for (int i = 0; i < in; ++i) {
                BgDimensionMember member;
                Object obj = members.get(i);
                if (obj instanceof MbgViewListDimensionMember) {
                    member = (MbgViewListDimensionMember)obj;
                    existsOrg.add(member.getNumber());
                    continue;
                }
                if (obj instanceof BgDimensionMember) {
                    member = (BgDimensionMember)obj;
                    existsOrg.add(member.getNumber());
                    continue;
                }
                member = (MbgDimensionMember)obj;
                existsOrg.add(((MbgDimensionMember)member).getNumber());
            }
        }
        ArrayList<BgDimensionMember> newMembers = new ArrayList<BgDimensionMember>();
        for (BgOrgUnitInfo info : bgOrgUnitInfos) {
            if (existsOrg.contains(info.getNumber())) continue;
            if (dimensionManager instanceof MbgViewListDimensionManager) {
                MbgViewListDimensionMember vMember = new MbgViewListDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, info.getOrgUnitID(), info.getName(), info.getNumber());
                newMembers.add(vMember);
                continue;
            }
            BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, info.getOrgUnitID(), info.getName(), info.getNumber());
            newMembers.add(member);
        }
        if (dimensionManager instanceof MbgViewListDimensionManager) {
            MbgViewListDimensionManager dimManager = (MbgViewListDimensionManager)dimensionManager;
            List<IMbgViewListObject> rowCols = dimManager.getRowCols();
            block2: for (int r = 0; r < rowCols.size(); ++r) {
                if (!(rowCols.get(r) instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol object = (MbgViewListRowCol)rowCols.get(r);
                List<MbgViewListDimensionInfo> dimens = object.getDimensions();
                for (MbgViewListDimensionInfo dimInfo : dimens) {
                    if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                    dimInfo.getMember().addAll(newMembers);
                    continue block2;
                }
            }
            List dimensions = dimManager.getDimension();
            for (Object obj : dimensions) {
                MbgViewListDimensionInfo dimInfo;
                if (!(obj instanceof MbgViewListDimensionInfo) || !DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (MbgViewListDimensionInfo)obj).getNumber())) continue;
                dimInfo.getMember().addAll(newMembers);
                break;
            }
        } else {
            List rowdimensions = dimensionManager.getRowDimension();
            for (Object dimInfo : rowdimensions) {
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionBaseInfo)dimInfo).getNumber())) continue;
                ((BgDimensionBaseInfo)dimInfo).getMember().addAll(newMembers);
                break;
            }
            List coldimensions = dimensionManager.getColDimension();
            for (BgDimensionInfo dimInfo : coldimensions) {
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                dimInfo.getMember().addAll(newMembers);
                break;
            }
            List pagedimensions = dimensionManager.getPageDimension();
            for (int i = pagedimensions.size() - 1; i >= 0; --i) {
                BgDimensionInfo dimInfo = (BgDimensionInfo)pagedimensions.get(i);
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                dimInfo.getMember().addAll(newMembers);
                dimensionManager.getRowDimension().add(dimInfo);
                pagedimensions.remove(i);
                break;
            }
        }
    }

    protected BgFormInfo getBgFormInfo() {
        return ((BgNFProcessUI)this.getUIObject()).getBgFormInfo();
    }

    protected Book getBook() {
        return ((BgNFProcessUI)this.getUIObject()).getBook();
    }

    protected IMbgViewBase filterSheet(Map<String, Object> paramMap) throws Exception {
        this.formulaList = BgNFSHelper.getFormulaListOfBook(this.getBook(), this.getSheetNames(paramMap));
        if (this.formulaList == null || this.formulaList.isEmpty()) {
            return null;
        }
        HashSet<String> versionNumber = new HashSet<String>();
        versionNumber.add(this.getBgFormInfo().getBgVersion().getNumber());
        return DimensionFormulaHelper.buildViewMamager(null, this.formulaList, versionNumber);
    }

    public Map<String, Object> showGatherUI(CoreUI ownerUI, BgFormInfo bgFormInfo, Book book) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UIContext uiContext = new UIContext((Object)ownerUI);
        uiContext.put((Object)"BgDecomposeGatherUI_BGFORMINFO", (Object)bgFormInfo);
        uiContext.put((Object)"BgDecomposeGatherUI_BOOK", (Object)book);
        IUIWindow window = null;
        try {
            window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDecomposeGatherUI.class.getName(), (Map)uiContext);
        }
        catch (UIException e) {
            e.printStackTrace();
            return paramMap;
        }
        window.show();
        BgDecomposeGatherUI gatherUi = (BgDecomposeGatherUI)window.getUIObject();
        if (gatherUi.isCancel()) {
            return paramMap;
        }
        this.setProcessType(paramMap, gatherUi.getProcessType());
        this.setOrgUnitIdSet(paramMap, gatherUi.getSelectOrgUnitIds());
        this.setSheetNames(paramMap, gatherUi.getSheetNames());
        this.setBgOrgUnitInfos(paramMap, gatherUi.getOrgUnitInfos());
        paramMap.put(ISCALCBIZ, gatherUi.isCalcBiz());
        boolean clearExpression = (BgTemFormTypeEnum.FIXEDFORM.equals((Object)bgFormInfo.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgFormInfo.getFormType())) && gatherUi.isClearExpression();
        paramMap.put(ISCLEAREXPRESSION, clearExpression);
        return paramMap;
    }

    protected final void setProcessType(Map<String, Object> paramMap, BgProcessEnum processType) {
        paramMap.put(PROCESSTYPE, (Object)processType);
    }

    protected final void setBgOrgUnitInfos(Map<String, Object> paramMap, List<BgOrgUnitInfo> bgOrgUnitInfos) {
        paramMap.put(ORGUNITINFOS, bgOrgUnitInfos);
    }

    protected final List<BgOrgUnitInfo> getBgOrgUnitInfos(Map<String, Object> paramMap) {
        return (List)paramMap.get(ORGUNITINFOS);
    }

    protected final BgProcessEnum getProcessType(Map<String, Object> paramMap) {
        return (BgProcessEnum)((Object)paramMap.get(PROCESSTYPE));
    }

    protected final void setOrgUnitIdSet(Map<String, Object> paramMap, Set<String> orgUnitIds) {
        paramMap.put(ORGUNITIDSET, orgUnitIds);
    }

    protected final Set<String> getOrgUnitIdSet(Map<String, Object> paramMap) {
        return (Set)paramMap.get(ORGUNITIDSET);
    }

    protected final String[] getSheetNames(Map<String, Object> paramMap) {
        return (String[])paramMap.get(SHEETNAME);
    }

    protected final void setSheetNames(Map<String, Object> paramMap, String[] sheetNames) {
        paramMap.put(SHEETNAME, sheetNames);
    }
}

