/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyEvent;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.autoFilter.AutoFilterRender;
import com.kingdee.eas.ma.mbg.client.common.ContextManager;
import com.kingdee.eas.ma.mbg.client.common.FormulaManager;
import com.kingdee.eas.ma.mbg.client.common.ModifyManager;
import com.kingdee.eas.ma.mbg.client.template.UserCellDisplayProvider;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionDescriptionRender;
import com.kingdee.eas.ma.mbg.client.utils.UserItemRenderProvider;
import com.kingdee.eas.ma.mbg.common.CalculateContext;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.designer.IFormulaManager;
import com.kingdee.eas.ma.mbg.designer.IModifyManager;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgPrintHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.BudgetDisplayValueProvider;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BookContextManager
extends ContextManager {
    private static final Logger logger = CoreUIObject.getLogger(BookContextManager.class);
    protected SpreadContext sc = null;
    protected KDPanel mainPanel = null;
    protected IDisplayValueProvider displayProvider = null;
    protected IFormulaManager formulaManager = null;
    protected boolean isEditableItemToolBar = false;
    protected boolean isRunThreadCalc = true;
    private AutoFilterRender autoFilter = null;

    public boolean isRunThreadCalc() {
        return this.isRunThreadCalc;
    }

    public void setRunThreadCalc(boolean isRunThreadCalc) {
        this.isRunThreadCalc = isRunThreadCalc;
    }

    public BookContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    public IDisplayValueProvider getDisplayProvider() {
        if (this.displayProvider == null) {
            this.displayProvider = new BudgetDisplayValueProvider((Component)this.getOwnerUI());
        }
        return this.displayProvider;
    }

    public SpreadContext getSpreadContext() {
        if (this.sc == null) {
            this.sc = new SpreadContext();
        }
        return this.sc;
    }

    public void createSpreadContextImpl(Book book) {
        if (this.sc == null) {
            this.sc = new SpreadContext(book);
        } else {
            this.sc.setBook(book);
        }
    }

    protected void cell_Content_Changed(SheetChangeEvent e) {
        this.clearExpressForItemForm(e);
    }

    protected void clearExpressForItemForm(SheetChangeEvent e) {
        if (e.getChangedBlocks() != null && e.getSheet() != null) {
            Sheet sheet = e.getSheet();
            SortedCellBlockArray blocks = e.getChangedBlocks();
            Cell cell = null;
            CellBlock block = null;
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            int size = blocks.size();
            for (int index = 0; index < size; ++index) {
                block = blocks.getBlock(index);
                if (block == null) continue;
                int rowBegin = block.getRow();
                int rowEnd = block.getRow2() > rowCount ? rowCount : block.getRow2();
                int colBegin = block.getCol();
                int colEnd = block.getCol2() > colCount ? colCount : block.getCol2();
                for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        if (cell == null || cell.isLocked() || !cell.hasFormula() || !this.isCalculatRowCol(cell)) continue;
                        cell.setFormula(null);
                    }
                }
            }
        }
    }

    protected boolean isCalculatRowCol(Cell cell) {
        return true;
    }

    @Override
    protected IModifyManager createModifyManager() {
        return new ModifyManager(this.getSpreadContext());
    }

    public IFormulaManager createFormulaManagerImpl() {
        return new FormulaManager(this.getSpreadContext(), this);
    }

    public void setFormulaManager(IFormulaManager formulaManager) {
        this.formulaManager = formulaManager;
    }

    public IFormulaManager getFormulaManager() {
        if (this.formulaManager == null) {
            this.setFormulaManager(this.createFormulaManagerImpl());
        }
        return this.formulaManager;
    }

    @Override
    public void doInit() throws Exception {
        super.doInit();
        this.setModifyManager(this.createModifyManager());
    }

    @Override
    public void initLayout(IUIObject ui) {
        super.initLayout(ui);
        if (ui == null) {
            return;
        }
        ui.getUIContentPane().setPreferredSize(null);
        ui.getUIContentPane().setLayout(new BorderLayout());
        this.initToolBar(ui);
        this.initContext(ui);
        this.getFormulaManager().doInit();
        this.registerFormulaToBook();
    }

    public void registerFormulaToBook() {
        try {
            FormulaDefinition.registerFormulaToBook((Book)this.getSpreadContext().getBook(), (ICalculateContextProvider)new CalculateContext(this.getSpreadContext().getBook(), this.getReportAdapter()));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public abstract IReportPropertyAdapter getReportAdapter();

    @Override
    public void initListener() {
        super.initListener();
        this.registerCellDisplayProvider();
        this.registerCalSumAndAvgcListener();
        this.getSpreadContext().addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (e.hasState(SheetChangeEvent.Changed_Selection) || e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
                    try {
                        BookContextManager.this.cell_Selection_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
                if (e.hasState(SheetChangeEvent.Changed_Content)) {
                    try {
                        BookContextManager.this.cell_Content_Changed(e);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                        ExceptionHandler.handle((Component)BookContextManager.this.getOwnerUI(), (Throwable)ex);
                        SysUtil.abort();
                    }
                }
            }
        });
        this.getSpreadContext().getFacadeManager().setErrorMessageBox(new FacadeManager.IErrorMessageBox(){

            public boolean show(Component parent, String title, String msg, int msgType) {
                if (msgType == 2) {
                    BookContextManager.this.showWarningMsg(msg);
                } else if (msgType == 0) {
                    BookContextManager.this.showErrorMsg(msg);
                } else {
                    BookContextManager.this.showWarningMsg(msg);
                }
                return false;
            }
        });
        this.getSpreadContext().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                try {
                    BookContextManager.this.active_Sheet_Changed(e);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                }
            }
        });
        this.getSpreadContext().getActionManager().getAction("Show_Formula_Wizzard", true).setBeforeAction(new NotifyListener(){

            public void doNotify(NotifyEvent evt) {
                BookContextManager.this.beforeShowFormulaWizzard(evt);
            }
        });
    }

    private void registerCalSumAndAvgcListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent paramMouseEvent) {
                BookContextManager.this.calSumAndAvg();
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                BookContextManager.this.calSumAndAvg();
            }
        };
        this.getSpreadContext().getSpread().getView(1, 1).addMouseListener(mouseAdapter);
        this.getSpreadContext().getSpread().getView(2, 1).addMouseListener(mouseAdapter);
        this.getSpreadContext().getSpread().getView(1, 2).addMouseListener(mouseAdapter);
        this.getSpreadContext().getSpread().getView(2, 2).addMouseListener(mouseAdapter);
        this.getSpreadContext().getSpread().addKeyListener((KeyListener)keyAdapter);
    }

    private void calSumAndAvg() {
        try {
            Range range = this.getSpreadContext().getBook().getSelectionRange();
            Sheet.ICellsIterator rangeCellsIterator = this.getSpreadContext().getBook().getRangeCellsIterator(range, false, true);
            BigDecimal totalBig = new BigDecimal("0");
            int rumericalTotal = 0;
            int cellCount = 0;
            BigDecimal avgBig = new BigDecimal("0");
            while (rangeCellsIterator.hasNext()) {
                Cell cell = rangeCellsIterator.next();
                Variant var = cell.getValue();
                if (var == null || var.getValue() == null) continue;
                if (var.getValue() instanceof BigDecimal) {
                    ++rumericalTotal;
                    totalBig = totalBig.add((BigDecimal)var.getValue());
                }
                ++cellCount;
            }
            if (rumericalTotal > 0) {
                avgBig = totalBig.divide(BigDecimal.valueOf(rumericalTotal), 2, 4);
            }
            if (cellCount > 1) {
                if (rumericalTotal == 0) {
                    this.getOwnerUI().getMainStatusBar().setPerTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"82_ReportDesignerUI") + cellCount);
                } else {
                    this.getOwnerUI().getMainStatusBar().setPerTitle(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"83__ReportDesignerUI") + avgBig + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"82_ReportDesignerUI") + cellCount + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"84__ReportDesignerUI") + totalBig.setScale(2, 4));
                }
            } else {
                this.getOwnerUI().getMainStatusBar().setPerTitle("");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
        }
    }

    protected void beforeShowFormulaWizzard(NotifyEvent evt) {
        MsgBox.showInfo((Component)this.owner, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgViewTemplateResource", (String)"ViewCanntSetFormula"));
        evt.setCancel(true);
    }

    protected void active_Sheet_Changed(BookChangeEvent e) throws Exception {
        if ("Sheet_Active".equals(e.getType())) {
            this.refreshPagePnl(e.getSheet().getIndex());
            this.getProvider().setCurMbgSheetManager(e.getSheet().getIndex());
            ((BgSpreadCoreViewUI)this.getOwnerUI()).getActionsManager().refreshActionState();
            this.getOwnerUI().updateUI();
        } else if ("Sheet_Deactive".equals(e.getType())) {
            if (this.getSpreadContext().getEditManager().getCurrentEditor() != null) {
                this.getSpreadContext().getEditManager().getCurrentEditor().stopEditing();
            }
            AutoFilterRender.clearButton(this.getSpreadContext());
        }
        ViewlistCombinHelper.removeAllConbinBox((BgSpreadCoreViewUI)this.getOwnerUI());
    }

    protected final void refreshPagePnl(int activeSheetIndex) throws Exception {
        int pagePnlIndex = -1;
        Component component = null;
        ViewlistCombinHelper.removeAllConbinBox((BgSpreadCoreViewUI)this.getOwnerUI());
        KDPanel pageViewPanel = this.getMainPanel();
        block0: for (int i = 0; i < this.getMainPanel().getComponentCount(); ++i) {
            component = this.getMainPanel().getComponent(i);
            if (!(component instanceof KDTabbedPane)) continue;
            KDTabbedPane tabbedPane = (KDTabbedPane)component;
            int jn = tabbedPane.getTabCount();
            for (int j = 0; j < jn; ++j) {
                component = tabbedPane.getComponentAt(j);
                if (!(component instanceof KDPanel) || !"analyseData".equalsIgnoreCase(component.getName())) continue;
                pageViewPanel = (KDPanel)component;
                break block0;
            }
            break;
        }
        int xn = pageViewPanel.getComponentCount();
        for (int x = 0; x < xn; ++x) {
            if (!"pagePnl".equals(pageViewPanel.getComponent(x).getName())) continue;
            pagePnlIndex = x;
            break;
        }
        if (pagePnlIndex >= 0) {
            pageViewPanel.remove(pagePnlIndex);
            pageViewPanel.add(this.parseViewOrPageBgDimension(activeSheetIndex), (Object)"North");
        }
    }

    protected abstract Component parseViewOrPageBgDimension(int var1) throws Exception;

    public void showSuccessMsg(String msg) {
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_OK);
            this.getOwnerUI().setMessageBgcolor(CoreUI.SHOW_MESSAGE_BG_OK);
            this.getOwnerUI().setMessageText(msg);
            this.getOwnerUI().showMessage();
        }
    }

    public void showWarningMsg(String msg) {
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_ERROR);
            this.getOwnerUI().setMessageBgcolor(Color.yellow);
            this.getOwnerUI().setMessageText(msg);
            this.getOwnerUI().showMessage();
        }
    }

    public void showErrorMsg(String msg) {
        if (this.getOwnerUI() != null) {
            this.getOwnerUI().setMessageIcon(CoreUI.SHOW_MESSAGE_ICON_ERROR);
            this.getOwnerUI().setMessageBgcolor(CoreUI.SHOW_MESSAGE_BG_ERROR);
            this.getOwnerUI().setMessageText(msg);
            this.getOwnerUI().showMessage();
        }
    }

    @Override
    public void show() {
        super.show();
        this.getFormulaManager().setItemFormulaProvider(new IItemFormulaProvider(){

            public String getDisplayingItemFormula(Range range, int viewMode) {
                Object obj = range.getUserObject("ITEM");
                if (obj != null && obj instanceof ItemFormula) {
                    return BookContextManager.this.getShowBgFormula(((ItemFormula)obj).getFormula());
                }
                return null;
            }

            public String defaultItemFormula() {
                return "=BgItem()";
            }

            public boolean editable() {
                return BookContextManager.this.isEditableItemToolBar();
            }
        });
        this.getSpreadContext().getBook().getUndoManager().enable(true);
    }

    protected void initToolBar(IUIObject ui) {
        KDToolBar toolBar = this.getSpreadContext().getToolBarManager().getToolBar("common");
        toolBar.setIsControlByParent(false);
        toolBar.setTextIconDisStyle((short)2);
        toolBar.setPopupMenuShowable(true);
        ui.getUIContentPane().add((Component)toolBar, "North");
        if (ui instanceof BgSpreadCoreViewUI) {
            ((BgSpreadCoreViewUI)ui).initChatGptBtn(toolBar);
        }
        ui.setUIToolBar(toolBar);
        toolBar = this.getSpreadContext().getToolBarManager().getToolBar("style");
        toolBar.setIsControlByParent(false);
        toolBar.setTextIconDisStyle((short)2);
        toolBar.setPopupMenuShowable(true);
        ui.getUIContentPane().add((Component)toolBar, "North");
        BgNFCHelper.setNewStyleHide(this.getSpreadContext());
    }

    protected abstract void initContext(IUIObject var1);

    protected boolean isEnablePage() {
        return true;
    }

    protected String getShowBgFormula(String formulaStr) {
        return BgNFSHelper.getDisplayFormula(formulaStr, null);
    }

    public boolean isEditableItemToolBar() {
        return this.isEditableItemToolBar;
    }

    public void setEditableItemToolBar(boolean isEditableItemToolBar) {
        this.isEditableItemToolBar = isEditableItemToolBar;
    }

    @Override
    public void initData() throws Exception {
        Object _obj;
        super.initData();
        if (this.getProvider().getEditValue() != null && (_obj = this.getProvider().load()) instanceof Book) {
            Book _book = (Book)_obj;
            this.createSpreadContextImpl(_book);
        }
    }

    public void registerCellDisplayProvider() {
        this.getSpreadContext().getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)this.getCellDisplayProvider());
    }

    public UserCellDisplayProvider getCellDisplayProvider() {
        if (this.autoFilter == null) {
            this.autoFilter = new AutoFilterRender(this);
        }
        UserCellDisplayProvider userCellDisplayProvider = new UserCellDisplayProvider();
        userCellDisplayProvider.setDisplayValueProvider(this.getDisplayProvider());
        UserCellDisplayProvider.addRenderProvider((IRenderProvider)new UserItemRenderProvider());
        UserCellDisplayProvider.addRenderProvider(new DimensionDescriptionRender());
        UserCellDisplayProvider.addRenderProvider(this.autoFilter);
        return userCellDisplayProvider;
    }

    public void reloadAutoFilter() {
        if (this.autoFilter != null) {
            this.autoFilter.fireDimensionChanged();
        }
    }

    public void cell_Selection_Changed(SheetChangeEvent e) throws Exception {
    }

    public boolean hasPageDimension(IBgDimensionManager dimensionManager) {
        if (dimensionManager == null) {
            return false;
        }
        return !dimensionManager.getPageDisplayDimension().isEmpty();
    }

    public KDPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new KDPanel();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        }
        return this.mainPanel;
    }

    public String getOrgUnitId() {
        return this.getProvider().getOrgUnitId();
    }

    @Override
    public void close() {
        this.sc.getRenderManager().setUserCellDisplayProvider(null);
        this.getCellDisplayProvider().clearViewListTitleRender(this.getProvider().getBillId());
        super.close();
        this.sc = null;
        this.getFormulaManager().clear();
    }

    @Override
    public void afterInit() throws Exception {
        super.afterInit();
        this.getProvider().fillData(this.getSpreadContext().getBook());
        this.enableCal();
    }

    public void enableCal() {
        if (this.getSpreadContext() != null) {
            BgNFSHelper.enableCal(this.getSpreadContext().getBook());
        }
    }

    public Map<String, Map> getBgGatherInfo() {
        return null;
    }

    @Override
    public void actionDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
        String num2;
        if (eventObj == null) {
            return;
        }
        KDBizPromptBox prmt = (KDBizPromptBox)eventObj.getSource();
        String num1 = BgViewHelper.getNumber(eventObj.getNewValue());
        if (StringUtils.equals((String)num1, (String)(num2 = BgViewHelper.getNumber(eventObj.getOldValue())))) {
            return;
        }
        this.beforeDimensionChange_dataChanged(eventObj);
        if (this.isNeedSaveForDimensionChange(eventObj)) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                try {
                    this.saveForDimensionChange(eventObj);
                }
                catch (Exception e) {
                    prmt.setDataNoNotify(eventObj.getOldValue());
                    throw e;
                }
            } else if (1 != flag) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                return;
            }
        }
        if ("ORGUNIT".equalsIgnoreCase(prmt.getName())) {
            try {
                Book book = this.getProvider().pageChangeLoadBook();
                if (book != null) {
                    this.getSpreadContext().setBook(book);
                } else {
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                throw e;
            }
            this.getProvider().fillData(this.getSpreadContext().getBook());
            this.checkItemDimeinsionEmpty();
        } else {
            this.getProvider().fillData(this.getSpreadContext().getBook());
        }
        this.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        this.getSpreadContext().repaint();
    }

    protected void checkItemDimeinsionEmpty() {
    }

    protected void beforeDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
    }

    protected boolean isNeedSaveForDimensionChange(DataChangeEvent eventObj) {
        return false;
    }

    protected void saveForDimensionChange(DataChangeEvent eventObj) throws Exception, BOSException, EASBizException {
    }

    public BgFormInfo getCurrGatherForm() throws BOSException, EASBizException {
        return null;
    }

    public final void storeWidthStyle(IMbgViewBase view) {
        if (view == null) {
            return;
        }
        Book book = this.getSpreadContext().getBook();
        if (book == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            UserObject userObject;
            IMbgSheetBase sheetManager = view.getSheetManagers().get(i);
            Sheet sheet = book.getSheet(sheetManager.getSheetIndex());
            if (sheet == null) continue;
            sheetManager.getWidthMap().clear();
            int defRow = sheet.getOriginalDefRowHeight();
            int defCol = sheet.getOriginalDefColWidth();
            sheetManager.setWidth(true, -1, defRow);
            sheetManager.setWidth(false, -1, defCol);
            for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                Column col = sheet.getColumn(c, false);
                if (col != null && (userObject = col.getUserObject("IS_SET_WIDTH")) != null && userObject.getValue() instanceof Boolean && Boolean.FALSE.equals(userObject.getValue())) continue;
                sheetManager.setWidth(false, c, this.getWidth(sheet, c, false));
            }
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                Row row = sheet.getRow(r, false);
                if (row != null && (userObject = row.getUserObject("IS_SET_WIDTH")) != null && userObject.getValue() instanceof Boolean && Boolean.FALSE.equals(userObject.getValue())) continue;
                sheetManager.setWidth(true, r, this.getWidth(sheet, r, true));
            }
        }
    }

    private int getWidth(Sheet sheet, int index, boolean isRow) {
        int height = 0;
        SortedAttributeSpanArray sa = null;
        sa = isRow ? sheet.getRowSpans() : sheet.getColSpans();
        int newIndex = sa.searchSpan(index);
        if (newIndex >= 0) {
            SortedAttributeSpanArray.AttributeSpan span = sa.getAttributeSpan(newIndex);
            height = span.isVisible() ? span.getOriginalLength() : -span.getOriginalLength();
        }
        return height;
    }

    protected void storePrintSetting(IMbgViewBase view) {
        if (view == null) {
            return;
        }
        Book book = this.getSpreadContext().getBook();
        if (book == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IMbgSheetBase sheetManager = view.getSheetManagers().get(i);
            Sheet sheet = book.getSheet(sheetManager.getSheetName());
            if (sheet == null) continue;
            sheetManager.getPrintMap().clear();
            String printSetup = BgPrintHelper.encodePrintSetup(sheet);
            sheetManager.setPrintSetup(printSetup);
            NamedObjectNode node = sheet.getNamedObject("Print_Area", false);
            if (node != null) {
                sheetManager.setPrintArea(node.getRefersTo());
            } else {
                sheetManager.setPrintArea(null);
            }
            node = sheet.getNames().searchByName("Print_Titles");
            if (node != null) {
                sheetManager.setPrintTitle(node.getRefersTo());
                continue;
            }
            sheetManager.setPrintTitle(null);
        }
    }

    public void storeSplitInfo(IMbgViewBase view) {
        if (view == null) {
            return;
        }
        Book book = this.getSpreadContext().getBook();
        if (book == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IMbgSheetBase sheetManager = view.getSheetManagers().get(i);
            Sheet sheet = book.getSheet(sheetManager.getSheetIndex());
            if (sheet == null || sheet.getSheetOption() == null) continue;
            sheetManager.setSplitInfo(BgNFSHelper.transSplitToStr(sheet.getSheetOption().getViewSplitInfo()));
        }
    }

    public void storeSheetHide(IMbgViewBase view) {
        if (view == null) {
            return;
        }
        Book book = this.getSpreadContext().getBook();
        if (book == null) {
            return;
        }
        for (int i = 0; i < view.getSheetManagers().size(); ++i) {
            IMbgSheetBase sheetManager = view.getSheetManagers().get(i);
            Sheet sheet = book.getSheet(sheetManager.getSheetIndex());
            if (sheet == null) continue;
            sheetManager.setSheetHide(sheet.isHide());
        }
    }

    public boolean isLockByWorkPaperCell() {
        return false;
    }
}

