/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class LineFlowLayout
extends FlowLayout {
    private static final long serialVersionUID = 1L;

    public LineFlowLayout() {
    }

    public LineFlowLayout(int align) {
        super(align);
    }

    public LineFlowLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.computeSize(target, false);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.computeSize(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension computeSize(Container target, boolean minimum) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + vgap;
            int rowh = 0;
            Dimension d = null;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                d = minimum ? m.getPreferredSize() : m.getMinimumSize();
                m.setSize(d.width, d.height);
                if (x == 0 || x + d.width <= maxwidth) {
                    if (x > 0) {
                        x += hgap;
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                x = d.width;
                y += vgap + rowh;
                rowh = d.height;
            }
            if (d != null) {
                y += d.height + vgap;
            }
            return new Dimension(x, y);
        }
    }
}

