/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.common;

import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.client.ViewListLayoutDesignerUI;
import com.kingdee.eas.ma.mbg.client.common.ComponentDragSourceForMBGView;
import com.kingdee.eas.ma.mbg.common.BgAttributeColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.TransferableForLayout;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PanelDropTargetForMBGView
implements DropTargetListener {
    private CoreUI owner;
    protected int targetType = 0;
    protected JPanel panel;
    protected Point lastP;
    protected Color bg;
    protected IBgDimensionManagerBase iBgDimensionManager;
    private boolean isRoll = false;

    public CoreUI getOwner() {
        return this.owner;
    }

    public PanelDropTargetForMBGView(IGetComponent owner, JPanel aPanel, int targetType, IBgDimensionManagerBase iBgDimensionManager, boolean isRoll) {
        this.owner = (CoreUI)owner;
        this.panel = aPanel;
        new DropTarget(this.panel, this);
        this.bg = this.panel.getBackground();
        this.targetType = targetType;
        this.iBgDimensionManager = iBgDimensionManager;
        this.isRoll = isRoll;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.panel.setBackground(this.brighter(this.bg, 0.9f));
    }

    private Color brighter(Color c, float FACTOR) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = (int)(1.0 / (1.0 - (double)FACTOR));
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / FACTOR), 255), Math.min((int)((float)g / FACTOR), 255), Math.min((int)((float)b / FACTOR), 255));
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        if (this.lastP != null && (this.lastP.x != p.x || this.lastP.y != p.y)) {
            this.markTarget(this.lastP);
            this.panel.updateUI();
        }
        this.markTarget(p);
        this.lastP = p;
    }

    private void markTarget(Point p) {
        Graphics g = this.panel.getGraphics();
        g.setColor(Color.RED);
        int lenx = 25;
        int leny = 25;
        g.drawLine(p.x - 25, p.y, p.x + 25, p.y);
        g.drawLine(p.x, p.y - 25, p.x, p.y + 25);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private int getDropPositionIndex(Point dropPoint) {
        Point p;
        Component[] cs = this.panel.getComponents();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int j = 0; j < cs.length; ++j) {
            p = cs[j].getLocation();
            p.x += cs[j].getWidth();
            p.y += cs[j].getHeight();
            list.add(p);
        }
        int index = -1;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            p = (Point)list.get(i);
            if (dropPoint.x > p.x || dropPoint.y > p.y) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        try {
            BgDimensionInfo info = null;
            JComponent c = null;
            Integer sourcePnlType = null;
            if (tr.isDataFlavorSupported(TransferableForLayout.DIMENSION_FLAVOR) && tr.isDataFlavorSupported(TransferableForLayout.COMPONENT_FLAVOR) && tr.isDataFlavorSupported(TransferableForLayout.SOURCE_PNL_TYPE_FLAVOR)) {
                int result;
                List<BgAttributeColumn> attrCols;
                info = (BgDimensionInfo)tr.getTransferData(TransferableForLayout.DIMENSION_FLAVOR);
                c = ((IGetComponent)this.owner).getDimensionComponent(info);
                sourcePnlType = (Integer)tr.getTransferData(TransferableForLayout.SOURCE_PNL_TYPE_FLAVOR);
                if (this.targetType == 5 && info.isNecessary()) {
                    MsgBox.showInfo((Component)this.owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"layoutRestraint01"), info.getAlias()));
                    dtde.rejectDrop();
                    this.panel.setBackground(this.bg);
                    this.panel.updateUI();
                    return;
                }
                if (this.targetType == 6 && info.isNecessary()) {
                    MsgBox.showInfo((Component)this.owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"cannotHide"), info.getAlias()));
                    dtde.rejectDrop();
                    this.panel.setBackground(this.bg);
                    this.panel.updateUI();
                    return;
                }
                if (this.isRoll && this.targetType != 4 && DimensionConstants.DEF_PERIOD_NUMBER.equals(info.getNumber())) {
                    MsgBox.showInfo((Component)this.owner, (String)new BgRollException(BgRollException.BGPERIODONLYCOL).getMessage());
                    dtde.rejectDrop();
                    this.panel.setBackground(this.bg);
                    this.panel.updateUI();
                    return;
                }
                if (sourcePnlType != null && sourcePnlType == 3 && this.iBgDimensionManager != null && this.targetType != 3 && (attrCols = MBgTemplateHelper.getPropertiesForDim(this.iBgDimensionManager, info)) != null && attrCols.size() > 0 && (result = MsgBox.showConfirm2((Component)this.owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"delExtendCol"), info.getAlias()))) == 2) {
                    this.panel.updateUI();
                    return;
                }
                JPanel oldP = (JPanel)c.getParent();
                this.panel.add(c, null, this.getDropPositionIndex(dtde.getLocation()));
                this.panel.updateUI();
                if (oldP != null) {
                    oldP.updateUI();
                }
                this.createDragSource(dtde, info, c);
                dtde.dropComplete(true);
                if (this.owner instanceof ViewListLayoutDesignerUI) {
                    ViewListLayoutDesignerUI layoutUi = (ViewListLayoutDesignerUI)this.owner;
                    layoutUi.firePanelDimensions_changed(oldP, this.panel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dtde.rejectDrop();
        }
        this.panel.setBackground(this.bg);
    }

    protected void createDragSource(DropTargetDropEvent dtde, BgDimensionInfo info, Component comp) {
        ComponentDragSourceForMBGView.createDragSource(comp, info, dtde.getDropAction());
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.panel.setBackground(this.bg);
    }

    public int getTargetType() {
        return this.targetType;
    }

    public static interface IGetComponent {
        public JComponent getDimensionComponent(Object var1);
    }
}

