/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.IBgAdjustFacada;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgBookParseHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.IAdjust;
import com.kingdee.eas.ma.mbg.utils.MbgAdjustHelper;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgViewAdjustProvider
extends MBGFormProvider
implements IAdjust {
    public static final Color ADJUST_COLOR = Color.YELLOW;
    public static final Color NORMAL_COLOR = Color.WHITE;
    Map<String, BgFormStateEnum> orgIdFormState = new HashMap<String, BgFormStateEnum>();
    private boolean isCheckTmpData = false;
    private boolean isActionAdjust = false;
    private boolean isAdjustSave = true;
    private Map adjustMap = new HashMap();
    private MbgAdjustHelper adjustHelper = null;

    public boolean isCheckTmpData() {
        return this.isCheckTmpData;
    }

    public void setCheckTmpData(boolean isCheckTmpData) {
        this.isCheckTmpData = isCheckTmpData;
    }

    public boolean isActionAdjust() {
        return this.isActionAdjust;
    }

    public void setActionAdjust(boolean isActionAdjust) {
        this.isActionAdjust = isActionAdjust;
    }

    @Override
    protected void startQueryData(Map<String, List<IBgDimensionManagerBase>> initDimensionManagers) throws BOSException, EASBizException {
        this.getQueryDataHelper().startQueryData(this.getQueryDataInfo(), initDimensionManagers, this.getDataType(), this.getBgOrgViewId(), this.isActionAdjust || this.isCheckTmpData());
    }

    @Override
    public Object load() throws Exception {
        return super.load();
    }

    @Override
    public boolean isFixel() {
        return false;
    }

    @Override
    public String getBgVersion() {
        return this.getBgFormInfo().getBgVersion().getNumber();
    }

    public synchronized MbgAdjustHelper getAdjustHelper() {
        if (this.adjustHelper == null) {
            this.adjustHelper = new MbgAdjustHelper(this);
        }
        return this.adjustHelper;
    }

    @Override
    public Book loadBook() throws Exception {
        return super.loadBook();
    }

    @Override
    public BgFormInfo getBgFormInfo() {
        return super.getBgFormInfo();
    }

    @Override
    public MbgBookParseHelper getBookParseHelper() {
        MbgBookParseHelper h = super.getBookParseHelper();
        h.setViewF7Enable(false);
        h.setPageF7Enable(true);
        h.setOrgF7Enable(false);
        return h;
    }

    public void reFillAdustDataToBook(Book book) throws Exception {
        Map dataMap = null;
        if (this.adjustMap.isEmpty()) {
            return;
        }
        int sheetIndex1 = ((IMbgSheetManager)this.getCurMbgSheetManager()).getSheetIndex();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex1).getDimensionManager());
        if (isorgOnPageOrView) {
            List<KDPromptBox> pageF7List;
            List<KDPromptBox> viewF7List = this.getViewF7List(sheetIndex1);
            Object data = null;
            if (viewF7List != null) {
                for (int i = 0; i < viewF7List.size(); ++i) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(viewF7List.get(i).getName()) || !((data = viewF7List.get(i).getData()) instanceof OrgUnitInfo)) continue;
                    dataMap = (Map)this.adjustMap.get(((OrgUnitInfo)data).getId().toString());
                }
            }
            if ((pageF7List = this.getPageF7List(sheetIndex1)) != null) {
                for (int i = 0; i < pageF7List.size(); ++i) {
                    if (!MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(pageF7List.get(i).getName())) continue;
                    data = pageF7List.get(i).getData();
                    if (data instanceof OrgUnitInfo) {
                        dataMap = (Map)this.adjustMap.get(((OrgUnitInfo)data).getId().toString());
                        continue;
                    }
                    if (!(data instanceof BgOrgUnitInfo)) continue;
                    dataMap = (Map)this.adjustMap.get(((BgOrgUnitInfo)data).getOrgUnitID());
                }
            }
        } else {
            dataMap = (Map)this.adjustMap.get(this.getOrgUnitId());
        }
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            for (int rowIndex = 0; rowIndex <= book.getSheet(sheetIndex).getMaxRowIndex(); ++rowIndex) {
                Row row = book.getSheet(sheetIndex).getRow(rowIndex, false);
                if (row == null) continue;
                for (int colIndex = 0; colIndex <= book.getSheet(sheetIndex).getMaxColIndex(); ++colIndex) {
                    Cell cell = book.getSheet(sheetIndex).getCell(rowIndex, colIndex, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    String formula = BgNFSHelper.getFormulaOfCell(cell);
                    if (dataMap == null || !dataMap.containsKey(formula)) continue;
                    BgAdjustFormDiversityData data = (BgAdjustFormDiversityData)dataMap.get(formula);
                    BgNFSHelper.setValue(cell, data.getNewValue());
                    BgNFSHelper.setBackGroup(cell, BgNConstants.EDIT_COLOR);
                }
            }
        }
    }

    @Override
    public void fillData(Sheet sheet, Map<String, Map<String, BgNViewDataInfo>> tmpData) throws Exception {
        super.fillData(sheet, tmpData);
        this.fillAdjustData(sheet.getBook(), sheet.getSheetIndex());
    }

    @Override
    public void fillData(Book book) throws Exception {
        super.fillData(book);
        this.fillAdjustData(book, -1);
    }

    protected void fillAdjustData(Book book, int sheetIndex) throws BOSException, EASBizException {
        Set<String> orgIdSet = this.getOrgIdSetByCurManager();
        Map adjustData = BgAdjustFacadaFactory.getRemoteInstance().getAdjustData(this.getBgFormInfo().getAdjust().getId().toString(), orgIdSet);
        this.getAdjustMap().clear();
        this.getAdjustHelper().loadAdjustMapForMultiOrg(adjustData, this.getAdjustMap(), orgIdSet);
        Map<String, Set<String>> formulasAdjust = MBGViewListFormClientHelper.checkFormualHasAdjust(this.getBgFormInfo(), book);
        BgSheetRange editRange = null;
        DimensionMemberCheckFactory factory = this.getCheckFactory();
        DimensionMemberCheckHelper helper = null;
        String dimKey = null;
        ItemFormula itemFormula = null;
        String bgFormVersionNumber = this.getBgFormInfo().getBgVersion().getNumber();
        int max = sheetIndex;
        if (sheetIndex < 0) {
            sheetIndex = 0;
            max = book.getSheetCount() - 1;
        }
        while (sheetIndex <= max) {
            editRange = new BgSheetRange(book.getSheet(sheetIndex));
            for (int rowIndex = 0; rowIndex <= book.getSheet(sheetIndex).getMaxRowIndex(); ++rowIndex) {
                Row row = book.getSheet(sheetIndex).getRow(rowIndex, false);
                if (row == null) continue;
                for (int colIndex = 0; colIndex <= book.getSheet(sheetIndex).getMaxColIndex(); ++colIndex) {
                    BgNDataInfo dataInfo;
                    Cell cell = book.getSheet(sheetIndex).getCell(rowIndex, colIndex, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    itemFormula = BgNFSHelper.getItemFormula(cell);
                    String formula = BgNFSHelper.getFormulaOfCell(cell);
                    dimKey = DimUtils.getDimDataKey(formula, bgFormVersionNumber);
                    String orgid = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
                    if (!bgFormVersionNumber.equals(BgNFSHelper.getItemFormula(cell).getExt("Version"))) continue;
                    helper = factory.getHelper(orgid, (IMbgViewBase)this.getBgViewManagerForMulOrg().get(itemFormula.getExt("ORGUNIT")));
                    if (StringUtils.isEmpty((String)orgid) || !adjustData.containsKey(orgid)) continue;
                    if (((Map)adjustData.get(orgid)).containsKey(formula)) {
                        dataInfo = (BgNDataInfo)((Map)adjustData.get(orgid)).get(formula);
                        if (helper.isActualScen(dataInfo.getBgScenario())) continue;
                        BigDecimal oldValue = dataInfo.getBudgetValueNoDef() instanceof BigDecimal ? dataInfo.getBudgetValueNoDef() : (BgNFSHelper.getValue(cell) instanceof BigDecimal ? (BigDecimal)BgNFSHelper.getValue(cell) : null);
                        BigDecimal newValue = dataInfo.getAdjustValue();
                        if (this.getAdjustMap().get(orgid) != null && ((Map)this.getAdjustMap().get(orgid)).containsKey(formula)) {
                            this.updateDivInfo(cell, formula, newValue, oldValue);
                        } else {
                            this.createDivInfo(cell, formula, newValue, oldValue);
                        }
                        if (oldValue != null && (newValue == null || newValue.compareTo(oldValue) == 0)) continue;
                        this.setCellAdjustValue(cell, formula, newValue);
                        continue;
                    }
                    if (this.getBgDataMap().containsKey(orgid) && this.getBgDataMap().get(orgid).get(dimKey) instanceof BgNDataInfo) {
                        dataInfo = this.getBgDataMap().get(orgid).get(dimKey);
                        if (helper.isActualScen(dataInfo.getBgScenario())) continue;
                        if (dataInfo.getState() != 0) {
                            if (dataInfo.getOldValue() == null || dataInfo.getOldValue().compareTo(dataInfo.getBudgetValue()) == 0) continue;
                            if (this.getAdjustMap().get(orgid) != null && ((Map)this.getAdjustMap().get(orgid)).containsKey(formula)) {
                                this.updateDivInfo(cell, formula, dataInfo.getBudgetValue(), dataInfo.getOldValue());
                            } else {
                                this.createDivInfo(cell, formula, dataInfo.getBudgetValue(), dataInfo.getOldValue());
                            }
                            this.setCellAdjustValue(cell, formula, dataInfo.getBudgetValue());
                            continue;
                        }
                        if (formulasAdjust.containsKey(orgid) && formulasAdjust.get(orgid).contains(formula)) {
                            if (this.getOwner() != null && (!this.getOwner().getOprtState().equals(OprtState.VIEW) || this.getOwner().getOprtState().equals(OprtState.VIEW) && (BgFormStateEnum.Adjusted.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.AdjustApproving.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.RollEdited.equals((Object)this.getBgFormInfo().getState()) || BgFormStateEnum.RollApproving.equals((Object)this.getBgFormInfo().getState())))) {
                                editRange.addCell(cell.getRow(), cell.getCol());
                                continue;
                            }
                            this.setNormalBackGroup(cell);
                            continue;
                        }
                        this.setNormalBackGroup(cell);
                        continue;
                    }
                    this.setNormalBackGroup(cell);
                }
            }
            if (editRange != null && editRange.getRange() != null && !editRange.getRange().isEmpty()) {
                StyleAttributes edit = Styles.getEmptySA();
                edit.setBackground(BgNConstants.EDIT_COLOR);
                Range rg = editRange.getRange();
                if (rg != null) {
                    rg.setIgnoreProtected(true);
                    rg.setStyle(edit, Styles.getEmptySA());
                }
            }
            ++sheetIndex;
        }
        this.setAdjustSave(true);
        this.checkTmpData();
    }

    private void checkTmpData() throws BOSException, EASBizException {
        if (!this.isCheckTmpData()) {
            return;
        }
        IBgAdjustFacada iBgAdjustFacade = BgAdjustFacadaFactory.getRemoteInstance();
        iBgAdjustFacade.checkTmpDataForView(this.getEditValue(), this.getAdjustMap());
    }

    protected void setNormalBackGroup(Cell cell) {
        if (cell != null && !cell.getSheet().getRange(cell).isCellLocked()) {
            BgNFSHelper.setBackGroup(cell, Styles.getNullColor());
        }
    }

    public void updateDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        this.getAdjustHelper().updateDivInfo(cell, formulaStr, newValue, oldValue);
    }

    public void createDivInfo(Cell cell, String formulaStr, BigDecimal newValue, BigDecimal oldValue) {
        this.getAdjustHelper().createDivInfo(cell, formulaStr, newValue, oldValue);
    }

    public void setCellAdjustValue(Cell cell, String formula, BigDecimal value) {
        BgNFSHelper.setValue(cell, value);
    }

    public IObjectPK getUserPk() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        return userPK;
    }

    @Override
    protected boolean isCanEditBgData(Cell cell, String formula, BgNViewDataInfo bgData, IMbgViewManager view, DimensionMemberCheckHelper helper, int sheetIndex, String version) throws EASBizException, BOSException {
        return this.isCanEditBgData(formula, bgData, view, helper, sheetIndex, version, cell);
    }

    protected boolean isCanEditBgData(String formula, BgNViewDataInfo bgData, IMbgViewManager view, DimensionMemberCheckHelper helper, int sheetIndex, String version, Cell cell) throws EASBizException, BOSException {
        if (version == null || this.getBgFormInfo() == null || this.getBgFormInfo().getBgVersion() == null || !version.equals(this.getBgFormInfo().getBgVersion().getNumber())) {
            return false;
        }
        String orgUnitId = null;
        if (cell != null && BgNFSHelper.checkHasFormulaOfCell(cell)) {
            orgUnitId = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
        }
        return helper.canSave(formula, helper.getEditScen(view, sheetIndex, this.getEditScenType()), version) && this.isCanEditByState(bgData) && this.isCanEditByFormState(orgUnitId);
    }

    @Override
    protected boolean isCanEditByState(BgNViewDataInfo bgData) {
        return bgData == null || 9 == bgData.getState() || 5 == bgData.getState() || 0 == bgData.getState();
    }

    @Override
    protected boolean isCanEditByFormState(String orgId) {
        if (StringUtils.isEmpty((String)orgId)) {
            return true;
        }
        return this.orgIdFormState.get(orgId) == null || this.orgIdFormState.get(orgId) == BgFormStateEnum.Approved || this.orgIdFormState.get(orgId) == BgFormStateEnum.Adjusted;
    }

    @Override
    protected void getOrgIdFormStateMap() throws EASBizException, BOSException {
        Map orgIdFormIdMap;
        Set<String> orgIdSetByCurManager = this.getOrgIdSetByCurManager();
        BgFormInfo bgFormInfo = this.getBgFormInfo();
        if (bgFormInfo != null && bgFormInfo.getId() != null && orgIdSetByCurManager != null && !orgIdSetByCurManager.isEmpty() && (orgIdFormIdMap = BgAdjustFacadaFactory.getRemoteInstance().getOrgIdFormIdMap(bgFormInfo.getId().toString(), orgIdSetByCurManager)) != null && !orgIdFormIdMap.isEmpty()) {
            this.orgIdFormState = orgIdFormIdMap;
        }
    }

    @Override
    protected void storeDataValue(BigDecimal value, BgNViewDataInfo data) {
        super.storeDataValue(value, data);
        if (data.getOldValue() != null && value != null && data.getOldValue().compareTo(value) != 0 || data.getOldValue() != value) {
            data.setAdjustValue(value);
        }
    }

    @Override
    protected void setDataValueToCell(Cell cell, BgNViewDataInfo dataValue, DimensionMemberCheckHelper helper) {
        super.setDataValueToCell(cell, dataValue, helper);
    }

    @Override
    protected boolean isModify(BgNViewDataInfo data) {
        boolean modify = super.isModify(data);
        return this.isAdjustSave ? false : modify;
    }

    @Override
    public ICoreBase getBizInterface() throws Exception {
        return super.getBizInterface();
    }

    @Override
    public Map getAdjustMap() {
        return this.adjustMap;
    }

    public boolean isAdjustSave() {
        return this.isAdjustSave;
    }

    @Override
    public void setAdjustSave(boolean isAdjustSave) {
        this.isAdjustSave = isAdjustSave;
    }

    @Override
    protected boolean isCurrOrg() {
        return false;
    }

    @Override
    protected void loadMbgViewManager() throws Exception {
        super.loadMbgViewManager();
        if (this.getCurMbgViewManager() != null) {
            HashSet<String> orgIdSet = new HashSet<String>();
            this.dealOrgIdSet(orgIdSet);
            Set hasPermissionOrgIdSet = null;
            if (!orgIdSet.isEmpty()) {
                hasPermissionOrgIdSet = this.getHasPermissionOrgIdSet(orgIdSet);
            }
            Object orgId = null;
            IMbgSheetManager sheetManger = null;
            BgDimensionInfo orgDimension = null;
            List members = null;
            BgDimensionMember bgDimensionMember = null;
            for (int sheetIndex = 0; sheetIndex < ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().size(); ++sheetIndex) {
                sheetManger = ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex);
                if (sheetManger == null || (orgDimension = (BgDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, sheetManger.getDimensionManager().getDimension())) == null || (members = orgDimension.getMember()) == null || members.isEmpty()) continue;
                for (int i = 0; i < members.size(); ++i) {
                    bgDimensionMember = (BgDimensionMember)members.get(i);
                    if (bgDimensionMember == null || hasPermissionOrgIdSet == null || hasPermissionOrgIdSet.contains(bgDimensionMember.getAttribute())) continue;
                    members.remove(i);
                    --i;
                }
            }
        }
    }

    private void dealOrgIdSet(Set<String> orgIdSet) {
        String orgId = null;
        IMbgSheetManager sheetManger = null;
        BgDimensionInfo orgDimension = null;
        List members = null;
        for (int sheetIndex = 0; sheetIndex < ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().size(); ++sheetIndex) {
            sheetManger = ((IMbgViewManager)this.getCurMbgViewManager()).getSheetManagers().get(sheetIndex);
            if (sheetManger == null || (orgDimension = (BgDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, sheetManger.getDimensionManager().getDimension())) == null) continue;
            members = orgDimension.getMember();
            for (BgDimensionMember bgDimensionMember : members) {
                orgId = bgDimensionMember.getAttribute();
                orgIdSet.add(orgId);
            }
        }
    }

    private Set getHasPermissionOrgIdSet(Set<String> orgIdSet) throws BOSException, EASBizException {
        IObjectPK[] pkArray = new IObjectPK[orgIdSet.size()];
        int ItemNumber = 0;
        Iterator<String> iterator = orgIdSet.iterator();
        while (iterator.hasNext()) {
            pkArray[ItemNumber++] = new ObjectUuidPK(iterator.next().toString());
        }
        return PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), pkArray, this.getAdjustPermissionNumber());
    }

    protected String getAdjustPermissionNumber() {
        return "mbg_viewAdjust04_view";
    }
}

