/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.gpt;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.base.uiframe.client.ui.gpt.ChatgptUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgChatgptAnalyseDataFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IBgChatgptAnalyseDataFacade;
import com.kingdee.eas.ma.mbg.client.BgFormWorkTableProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNProcessUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.worktable.WorkTableProcessUI;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormBaseProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgChatgptHelper {
    private static final Logger logger = Logger.getLogger(BgChatgptHelper.class);

    public static String getBgDataForGpt(CoreUI coreUI, Map params) {
        HashMap<String, String> result = new HashMap<String, String>();
        String data = BgChatgptHelper.getBgDataForGpt(coreUI);
        if (!StringUtils.isEmpty((String)data)) {
            result.put("result", data);
        } else {
            result.put("result", "\u7a7a");
        }
        return JSON.toJSONString(result);
    }

    private static String getBgDataForGpt(CoreUI coreUI) {
        logger.error((Object)"getSelectData start");
        long begin = System.currentTimeMillis();
        String selectData = "";
        if (BgParamCHelper.isShowMultiForm()) {
            WorkTableProcessUI workTableProcessUI = null;
            if (coreUI.getUIContext().get("WORKTABLE_PROCESSUI") != null && coreUI.getUIContext().get("WORKTABLE_PROCESSUI") instanceof WorkTableProcessUI && (workTableProcessUI = (WorkTableProcessUI)((Object)coreUI.getUIContext().get("WORKTABLE_PROCESSUI"))).getCurrentProcessUI() != null) {
                selectData = (String)BgChatgptHelper.getSelectData(workTableProcessUI.getCurrentProcessUI());
            }
        } else {
            selectData = (String)BgChatgptHelper.getSelectData(coreUI);
        }
        logger.error((Object)"getSelectData end");
        logger.error((Object)("gptInvoke  ,\u8017\u65f6\u4e3a\uff1a" + (System.currentTimeMillis() - begin) + "ms"));
        return selectData;
    }

    public static Object getSelectData(CoreUI coreUI) {
        BgNProcessUI ui;
        Object obj = null;
        if (coreUI instanceof BgSpreadCoreViewUI) {
            BgSpreadCoreViewUI ui2 = (BgSpreadCoreViewUI)coreUI;
            BookContextManager contextManager = (BookContextManager)ui2.getContextManager();
            Book book = contextManager.getSpreadContext().getBook();
            BgFormInfo bgFormInfo = null;
            String orgViewId = null;
            AbstractProvider provider = null;
            if (contextManager.getProvider() instanceof MBGBaseFormProvider) {
                provider = (MBGBaseFormProvider)contextManager.getProvider();
                bgFormInfo = ((MBGBaseFormProvider)provider).getBgFormInfo();
                orgViewId = provider.getOrgViewId();
            } else if (contextManager.getProvider() instanceof MBGViewListFormBaseProvider) {
                provider = (MBGViewListFormBaseProvider)contextManager.getProvider();
                bgFormInfo = ((MBGViewListFormBaseProvider)provider).getBgFormInfo();
                orgViewId = provider.getOrgViewId();
            }
            Range range = book.getSelectionRange();
            Sheet _sheet = book.getActiveSheet();
            String orgUnitNum = null;
            CellBlock _block = null;
            Cell _cell = null;
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            ItemFormula itemFormula = null;
            if (range != null && !range.isEmpty()) {
                int size = range.size();
                block0: for (int index = 0; index < size; ++index) {
                    _block = range.getBlock(index);
                    if (_block == null) continue;
                    int maxRow = _block.getRow2() > rowCount ? rowCount : _block.getRow2();
                    int maxCol = _block.getCol2() > colCount ? colCount : _block.getCol2();
                    int rowEnd = maxRow;
                    for (int rowBegin = _block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                        int colEnd = maxCol;
                        for (int colBegin = _block.getCol(); colBegin <= colEnd; ++colBegin) {
                            _cell = _sheet.getCell(rowBegin, colBegin, false);
                            if (!BgNFSHelper.checkHasItemFormula(_cell)) continue;
                            String orgUnitNum1 = BgNFSHelper.getItemFormula(_cell).getExt("ORGUNIT");
                            if (orgUnitNum1 != null && orgUnitNum == null) {
                                orgUnitNum = orgUnitNum1;
                            }
                            itemFormula = BgNFSHelper.getItemFormula(_cell);
                            break block0;
                        }
                    }
                }
            }
            obj = BgChatgptHelper.processSelectData(ui2, book, bgFormInfo);
        } else if (coreUI instanceof BgNProcessUI && (ui = (BgNProcessUI)coreUI).getEditData() instanceof IDimDataQuery) {
            obj = BgChatgptHelper.processSelectData(coreUI, ui.getBook(), (IDimDataQuery)ui.getEditData());
        }
        return obj;
    }

    public static Object processSelectData(CoreUI coreUI, Book book, IDimDataQuery bgFormInfo) {
        Sheet _sheet = book.getActiveSheet();
        Range range = book.getSelectionRange();
        if (range == null) {
            MsgBox.showWarning((Component)coreUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"selectData"));
            return null;
        }
        HashMap orgFormulas = new HashMap();
        CellBlock block = null;
        Cell cell = null;
        ItemFormula formula = null;
        String cellOrgId = null;
        String formulaStr = null;
        String versionNumber = null;
        int size = range.size();
        for (int index = 0; index < size; ++index) {
            block = range.getBlock(index);
            if (block == null) continue;
            int rowEnd = block.getRow2();
            for (int rowBegin = block.getRow(); rowBegin <= rowEnd; ++rowBegin) {
                int colEnd = block.getCol2();
                for (int colBegin = block.getCol(); colBegin <= colEnd; ++colBegin) {
                    cell = _sheet.getCell(rowBegin, colBegin, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formula = BgNFSHelper.getItemFormula(cell);
                    if (formula != null) {
                        cellOrgId = formula.getExt("ORGUNITID");
                    }
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    versionNumber = BgNFSHelper.getItemFormula(cell).getExt("Version");
                    if (!StringUtils.isEmpty((String)versionNumber) && !versionNumber.equals(bgFormInfo.getBizVersion().getNumber())) continue;
                    if (StringUtils.isEmpty((String)cellOrgId)) {
                        cellOrgId = bgFormInfo.getBizOrgUnit().getId().toString();
                    }
                    if (StringUtils.isEmpty((String)cellOrgId)) continue;
                    if (!orgFormulas.containsKey(cellOrgId)) {
                        orgFormulas.put(cellOrgId, new ArrayList());
                    }
                    ((List)orgFormulas.get(cellOrgId)).add(formulaStr);
                }
            }
        }
        Object result = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("BGFORM_INFO", bgFormInfo);
        params.put("FORMULA", orgFormulas);
        try {
            result = BgChatgptAnalyseDataFacadeFactory.getRemoteInstance().queryData(params);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            coreUI.handUIException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            coreUI.handUIException((Throwable)e);
        }
        return result;
    }

    public IBgChatgptAnalyseDataFacade getInterFacade() throws BOSException {
        return BgChatgptAnalyseDataFacadeFactory.getRemoteInstance();
    }

    public static Rectangle getMultiFormChatgptUIBounds(CoreUI coreUI, WorkTableProcessUI ui) {
        int height;
        if (ui == null) {
            return new Rectangle(200, 200, 420, 600);
        }
        ChatgptUI chatgptUI = null;
        KDSpread kdSpread = null;
        if (coreUI instanceof BgNProcessUI) {
            kdSpread = ((BgNProcessUI)coreUI).getSpreadManager().getSpreadContainer().getSpread();
            chatgptUI = ((BgNProcessUI)coreUI).getChatGptUI();
        } else if (coreUI instanceof BgSpreadCoreViewUI) {
            kdSpread = ((BookContextManager)((BgSpreadCoreViewUI)coreUI).getContextManager()).getSpreadContext().getSpread();
            chatgptUI = ((BgSpreadCoreViewUI)coreUI).getChatGptUI();
        }
        if (kdSpread == null) {
            return new Rectangle(200, 200, 420, 600);
        }
        Container topUI = null;
        if (!ui.isShowing()) {
            for (Container curUI = kdSpread.getParent(); curUI != null; curUI = curUI.getParent()) {
                topUI = curUI;
            }
            if (topUI == null) {
                topUI = kdSpread;
            }
        }
        int kdSpreadScreenY = kdSpread.isShowing() ? kdSpread.getLocationOnScreen().y : 120;
        int uiScreenY = ui.isShowing() ? ui.getLocationOnScreen().y : topUI.getLocationOnScreen().y;
        int screenY = kdSpreadScreenY - uiScreenY;
        int y = ui.isShowing() ? screenY + 8 : screenY - 75;
        int n = height = ui.isShowing() ? ui.getY() + ui.getHeight() - screenY + 26 : topUI.getY() + topUI.getHeight() - screenY + 5;
        if (coreUI instanceof BgSpreadCoreViewUI) {
            y = ui.isShowing() ? screenY - 85 : screenY - 75;
            int n2 = height = ui.isShowing() ? ui.getY() + ui.getHeight() - screenY + 115 : topUI.getY() + topUI.getHeight() - screenY + 5;
        }
        if (chatgptUI != null && chatgptUI.getWidth() != 420 && chatgptUI.getWidth() != 0) {
            return new Rectangle(ui.getWidth() - chatgptUI.getWidth(), y, chatgptUI.getWidth(), height);
        }
        int x = ui.isShowing() ? ui.getWidth() - 440 : topUI.getWidth() - 440;
        return new Rectangle(x, y, 420, height);
    }

    public static int getWidth(CoreUI coreUI, Map uiContext) {
        ChatgptUI chatgptUI = null;
        if (coreUI instanceof BgNProcessUI) {
            chatgptUI = ((BgNProcessUI)coreUI).getChatGptUI();
        } else if (coreUI instanceof BgSpreadCoreViewUI) {
            chatgptUI = ((BgSpreadCoreViewUI)coreUI).getChatGptUI();
        }
        if (chatgptUI != null && uiContext.get("WORKTABLE_PROCESSUI") != null && uiContext.get("WORKTABLE_PROCESSUI") instanceof BgFormWorkTableProcessUI) {
            BgFormWorkTableProcessUI bgFormWorkTableProcessUI = (BgFormWorkTableProcessUI)((Object)uiContext.get("WORKTABLE_PROCESSUI"));
            return bgFormWorkTableProcessUI.getWidth();
        }
        return -1;
    }

    public static int getHeight(CoreUI coreUI, Map uiContext) {
        ChatgptUI chatgptUI = null;
        if (coreUI instanceof BgNProcessUI) {
            chatgptUI = ((BgNProcessUI)coreUI).getChatGptUI();
        } else if (coreUI instanceof BgSpreadCoreViewUI) {
            chatgptUI = ((BgSpreadCoreViewUI)coreUI).getChatGptUI();
        }
        if (chatgptUI != null && uiContext.get("WORKTABLE_PROCESSUI") != null && uiContext.get("WORKTABLE_PROCESSUI") instanceof BgFormWorkTableProcessUI) {
            BgFormWorkTableProcessUI bgFormWorkTableProcessUI = (BgFormWorkTableProcessUI)((Object)uiContext.get("WORKTABLE_PROCESSUI"));
            return bgFormWorkTableProcessUI.getHeight();
        }
        return -1;
    }
}

