/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.template;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.client.template.IMBGContextManager;
import com.kingdee.eas.ma.mbg.client.template.ProviderContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.provider.IMBGProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.awt.Component;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MBGContextManager
extends ProviderContextManager
implements IMBGContextManager {
    protected static final Logger logger = CoreUIObject.getLogger(MBGContextManager.class);

    public MBGContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    @Override
    protected void initContext(IUIObject ui) {
        try {
            ui.getUIContentPane().add(this.getPageDimensionPanel(this.getProvider().getCurMbgViewManager()), "Center");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected void checkItemDimeinsionEmpty() {
        BgViewClientHelper.checkItemDimeinsionEmpty(this.getOwnerUI(), this.getProvider().getBgDimensionManager());
    }

    public boolean hasViewOrPageDimension(IMbgViewManager mbgViewManager, int activeSheetIndex) {
        if (mbgViewManager == null) {
            return false;
        }
        if (mbgViewManager.getSheetManagers().size() < activeSheetIndex) {
            return false;
        }
        if (mbgViewManager.getSheetManagers().get(activeSheetIndex) == null) {
            return false;
        }
        IBgDimensionManager dimensionManager = mbgViewManager.getSheetManagers().get(activeSheetIndex).getDimensionManager();
        return !dimensionManager.getPageDimension().isEmpty() || !dimensionManager.getViewDimension().isEmpty();
    }

    public Component getPageDimensionPanel(IMbgViewManager mbgViewManager) throws Exception {
        KDPanel kdPanel = this.getMainPanel();
        kdPanel.removeAll();
        SpreadContext sc = this.getSpreadContext();
        int activeSheetIndex = sc.getBook().getActiveSheetIndex();
        if (this.hasViewOrPageDimension(mbgViewManager, activeSheetIndex)) {
            kdPanel.add(this.parseViewOrPageBgDimension(activeSheetIndex), (Object)"North");
        }
        this.getMainPanel().add((Component)sc, (Object)"Center");
        this.getMainPanel().revalidate();
        return kdPanel;
    }

    @Override
    public void refreshSheet(int sheetIndex) throws Exception {
        if (this.getSpreadContext() == null || this.getSpreadContext().getBook() == null) {
            return;
        }
        Book book = this.getSpreadContext().getBook();
        if (book.getSheet(sheetIndex) == null) {
            book.insertSheet(sheetIndex, null, true);
        }
        Sheet sheet = book.getSheet(sheetIndex);
        this.getProvider().refreshSheet(book, sheet);
        this.refreshPagePnl(sheetIndex);
        this.reloadAutoFilter();
        sheet.getRange(0, 0).select();
    }

    @Override
    protected Component parseViewOrPageBgDimension(int activeSheetIndex) throws Exception {
        return this.getProvider().getBookParseHelper().parseViewOrPageBgDimension((CoreUIObject)this.getOwnerUI(), true, activeSheetIndex);
    }

    @Override
    public void reloadBook() throws Exception {
        Book book = this.getSpreadContext().getBook();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        for (int i = book.getSheetCount() - 1; i > 0; --i) {
            book.removeSheet(i);
        }
        book.getSelectionRange().clear(true, true, true, true);
        this.getProvider().reloadBook(book);
        BgNFSHelper.enableUndo(book);
    }

    @Override
    public void setActiveSheet(int activeSheetIndex) {
        if (this.getSpreadContext().getBook() != null) {
            Book book = this.getSpreadContext().getBook();
            book.setActiveSheet(activeSheetIndex);
            this.getProvider().setCurMbgSheetManager(activeSheetIndex);
        }
    }

    @Override
    public void initListener() {
        super.initListener();
    }

    @Override
    protected IMBGProvider createProviderImpl() {
        return null;
    }

    @Override
    public IMBGProvider getProvider() {
        return (IMBGProvider)super.getProvider();
    }
}

