/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.template;

import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.impl.RenderManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.ma.mbg.client.template.ViewListTitleRender;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class UserCellDisplayProvider
implements ICellDisplayProvider {
    private IDisplayValueProvider provider;
    private ArrayList result = new ArrayList();
    private List allRenders = new ArrayList();
    private static List<IRenderProvider> renderList = Collections.synchronizedList(new ArrayList(3));
    private List<IRenderProvider> noStaticRenderList = Collections.synchronizedList(new ArrayList(3));

    public IBasicRender getBaseRender(Cell cell, int viewMode) {
        if (viewMode == 10) {
            ItemFormula itemFormula = null;
            Object obj = cell.getUserObjectValue("ITEM");
            if (obj instanceof String) {
                itemFormula = new ItemFormula(obj.toString());
                cell.setUserObject("ITEM", (Object)itemFormula);
            } else if (obj instanceof ItemFormula) {
                itemFormula = (ItemFormula)obj;
            }
            if (itemFormula == null) {
                return null;
            }
            String formula = itemFormula.getFormula();
            if (!StringUtils.isEmpty((String)formula)) {
                return RenderManager.getTextRender();
            }
            return null;
        }
        return null;
    }

    public Object getBaseValue(Cell cell, int viewMode) {
        DiagonalHeader d = cell.getDiagonalHeader();
        if (d != null) {
            return d;
        }
        if (this.provider == null) {
            return null;
        }
        return this.provider.getDisplayValue(cell, viewMode);
    }

    public ArrayList getExtRender(Cell cell, int viewMode) {
        this.result.clear();
        this.allRenders.clear();
        this.allRenders.addAll(renderList);
        this.allRenders.addAll(this.noStaticRenderList);
        int size = this.allRenders.size();
        for (int i = 0; i < size; ++i) {
            IRenderProvider provider = (IRenderProvider)this.allRenders.get(i);
            IBasicRender render = provider.getRender(cell, viewMode);
            if (render == null) continue;
            this.result.add(render);
        }
        return this.result;
    }

    public ArrayList getExtValue(Cell cell, int viewMode) {
        ArrayList<Cell> list = new ArrayList<Cell>(this.result.size());
        for (int i = 0; i < this.result.size(); ++i) {
            list.add(cell);
        }
        return list.size() > 0 ? list : null;
    }

    public void setDisplayValueProvider(IDisplayValueProvider provider) {
        this.provider = provider;
    }

    public static void addRenderProvider(IRenderProvider renderProvider) {
        if (!renderList.contains(renderProvider)) {
            renderList.add(renderProvider);
        }
    }

    public void clearRenderList() {
        renderList.clear();
        this.noStaticRenderList.clear();
        this.result.clear();
        this.allRenders.clear();
    }

    public void clearViewListTitleRender(String objectId) {
        if (objectId == null) {
            return;
        }
        this.removeViewListTitleRender(renderList, objectId);
        this.removeViewListTitleRender(this.noStaticRenderList, objectId);
        this.removeViewListTitleRender(this.result, objectId);
        this.removeViewListTitleRender(this.allRenders, objectId);
    }

    public void removeRenderProvider(IRenderProvider renderProvider) {
        renderList.remove(renderProvider);
    }

    public void addNoStaticRenderProvider(IRenderProvider renderProvider) {
        if (!this.noStaticRenderList.contains(renderProvider)) {
            this.noStaticRenderList.add(renderProvider);
        }
    }

    public void removeNoStaticRenderProvider(IRenderProvider renderProvider) {
        this.noStaticRenderList.remove(renderProvider);
    }

    public IDisplayValueProvider getDisplayValueProvider() {
        return this.provider;
    }

    public void removeViewListTitleRender(List result, String objectId) {
        if (result == null || result.isEmpty()) {
            return;
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next == null || !(next instanceof ViewListTitleRender) || ((ViewListTitleRender)next).getId() == null || !((ViewListTitleRender)next).getId().equalsIgnoreCase(objectId)) continue;
            iterator.remove();
        }
    }
}

