/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BgFormCourseDisplayInfo
implements Serializable {
    private static final long serialVersionUID = -8600185686179578386L;
    private String id = null;
    private String hasAtt = null;
    private String bgformNumber = null;
    private String bgformName = null;
    private String orgUnit = null;
    private String bgTemplate = null;
    private String bgSpecialItemsNumber = null;
    private String specialMember = null;
    private String bgType = null;
    private BgTemFormTypeEnum formType = null;
    private String bgPeriod = null;
    private String currency = null;
    private String bgVersion = null;
    private String operator = null;
    private Timestamp operateTime = null;
    private Timestamp lastCourseTime = null;
    private String auditOrgUnit = null;
    private String orgUnitID = null;
    private int processType = 0;
    private boolean isVirtual = false;
    private int state = 97;
    private Map<String, Boolean> virtuals = new HashMap<String, Boolean>();

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public Map<String, Boolean> getVirtuals() {
        return this.virtuals;
    }

    public void setVirtuals(Map<String, Boolean> virtuals) {
        this.virtuals = virtuals;
    }

    public String getOrgUnitID() {
        return this.orgUnitID;
    }

    public void setOrgUnitID(String orgUnitID) {
        this.orgUnitID = orgUnitID;
    }

    public int getProcessType() {
        return this.processType;
    }

    public void setProcessType(int processType) {
        this.processType = processType;
    }

    public String getAuditOrgUnit() {
        return this.auditOrgUnit;
    }

    public void setAuditOrgUnit(String auditOrgUnit) {
        this.auditOrgUnit = auditOrgUnit;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHasAtt() {
        return this.hasAtt;
    }

    public void setHasAtt(String hasAtt) {
        this.hasAtt = hasAtt;
    }

    public String getBgformNumber() {
        return this.bgformNumber;
    }

    public void setBgformNumber(String bgformNumber) {
        this.bgformNumber = bgformNumber;
    }

    public String getBgformName() {
        return this.bgformName;
    }

    public void setBgformName(String bgformName) {
        this.bgformName = bgformName;
    }

    public String getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = orgUnit;
    }

    public String getBgTemplate() {
        return this.bgTemplate;
    }

    public void setBgTemplate(String bgTemplate) {
        this.bgTemplate = bgTemplate;
    }

    public String getBgSpecialItemsNumber() {
        return this.bgSpecialItemsNumber;
    }

    public void setBgSpecialItemsNumber(String bgSpecialItemsNumber) {
        this.bgSpecialItemsNumber = bgSpecialItemsNumber;
    }

    public String getSpecialMember() {
        return this.specialMember;
    }

    public void setSpecialMember(String specialMember) {
        this.specialMember = specialMember;
    }

    public String getBgType() {
        return this.bgType;
    }

    public void setBgType(String bgType) {
        this.bgType = bgType;
    }

    public BgTemFormTypeEnum getFormType() {
        return this.formType;
    }

    public void setFormType(BgTemFormTypeEnum formType) {
        this.formType = formType;
    }

    public String getBgPeriod() {
        return this.bgPeriod;
    }

    public void setBgPeriod(String bgPeriod) {
        this.bgPeriod = bgPeriod;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getBgVersion() {
        return this.bgVersion;
    }

    public void setBgVersion(String bgVersion) {
        this.bgVersion = bgVersion;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Timestamp getOperateTime() {
        return this.operateTime;
    }

    public void setOperateTime(Timestamp operateTime) {
        this.operateTime = operateTime;
    }

    public Timestamp getLastCourseTime() {
        return this.lastCourseTime;
    }

    public void setLastCourseTime(Timestamp lastCourseTime) {
        this.lastCourseTime = lastCourseTime;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public static BgFormCourseDisplayInfo createByBgForm(BgFormInfo bgFormInfo, boolean hasAtt, Map<String, Boolean> virtuals, Map<String, Boolean> isShowAliasMap, Map<String, String> aliasMap, Set<Integer> states, Map orgUnitMap) {
        if (bgFormInfo == null) {
            return null;
        }
        BgFormCourseDisplayInfo info = new BgFormCourseDisplayInfo();
        if (bgFormInfo.getId() != null) {
            info.setHasAtt(String.valueOf(hasAtt));
            info.setId(bgFormInfo.getId().toString());
            info.setBgformNumber(bgFormInfo.getNumber());
            info.setBgformName(bgFormInfo.getName());
            if (Boolean.TRUE.equals(virtuals.get(bgFormInfo.getOrgUnit().getId().toString()))) {
                info.setOrgUnit(bgFormInfo.getOrgUnit().getName() + "(s)");
                info.setVirtual(true);
            } else {
                info.setOrgUnit(bgFormInfo.getOrgUnit().getName());
                info.setVirtual(false);
            }
            info.setBgTemplate(bgFormInfo.getBgTemplate().getName());
            info.setBgSpecialItemsNumber(bgFormInfo.getBgSpecialItems().get(0) != null ? bgFormInfo.getBgSpecialItems().get(0).getDimensionNumber() : null);
            info.setSpecialMember(bgFormInfo.getBgSpecialItems().get(0) != null ? bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null);
            info.setBgType(bgFormInfo.getBgTemplate().getBgType() != null ? bgFormInfo.getBgTemplate().getBgType().getName() : null);
            info.setFormType(bgFormInfo.getBgTemplate().getFormType());
            info.setBgPeriod(DimensionCacheHelper.getBgPeriodShowName(bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getBgPeriod().getId().toString(), isShowAliasMap, aliasMap, bgFormInfo.getBgPeriod().getName()) + "(" + bgFormInfo.getBgPeriod().getNumber().substring(0, 4) + ")");
            info.setCurrency(bgFormInfo.getCurrency().getName());
            info.setBgVersion(bgFormInfo.getBgVersion().getName());
            info.setState(bgFormInfo.getState().getValue());
            info.setOperator(bgFormInfo.getLastUpdateUser() != null ? bgFormInfo.getLastUpdateUser().getName() : null);
            info.setOperateTime(bgFormInfo.getLastUpdateTime() != null ? bgFormInfo.getLastUpdateTime() : null);
            info.setProcessType(bgFormInfo.getProcessType().getValue());
            info.setOrgUnitID(bgFormInfo.getOrgUnit().getId().toString());
            if (bgFormInfo.getState().getValue() != 1 && bgFormInfo.getState().getValue() != 42 && bgFormInfo.getState().getValue() != 25 && bgFormInfo.getState().getValue() != 14) {
                info.setLastCourseTime(bgFormInfo.getTimestamp("lastCourseTime") != null ? bgFormInfo.getTimestamp("lastCourseTime") : null);
            }
            info.setAuditOrgUnit(bgFormInfo.getAuditOrgUnit() == null ? null : bgFormInfo.getAuditOrgUnit().getName());
            info.setVirtuals(virtuals);
        } else if (states.contains(new Integer(97))) {
            String orgName;
            String _orgId = bgFormInfo.getOrgUnit().getId().toString();
            String string = orgName = orgUnitMap.containsKey(_orgId) ? ((OrgUnitInfo)orgUnitMap.get(_orgId)).getName() : _orgId;
            if (Boolean.TRUE.equals(virtuals.get(_orgId))) {
                info.setOrgUnit(orgName + "(s)");
                info.setVirtual(true);
            } else {
                info.setOrgUnit(orgName);
                info.setVirtual(false);
            }
            info.setOrgUnitID(_orgId);
            info.setHasAtt(String.valueOf(hasAtt));
            info.setBgTemplate(bgFormInfo.getBgTemplate().getName());
            info.setSpecialMember(bgFormInfo.getBgSpecialItems().get(0) != null ? bgFormInfo.getBgSpecialItems().get(0).getMemberDisplayName() : null);
            info.setBgType(bgFormInfo.getBgTemplate().getBgType() != null ? bgFormInfo.getBgTemplate().getBgType().getName() : null);
            info.setFormType(bgFormInfo.getBgTemplate().getFormType());
            info.setBgPeriod(DimensionCacheHelper.getBgPeriodShowName(_orgId, bgFormInfo.getBgPeriod().getId().toString(), isShowAliasMap, aliasMap, bgFormInfo.getBgPeriod().getName()) + "(" + bgFormInfo.getBgPeriod().getNumber().substring(0, 4) + ")");
            info.setCurrency(bgFormInfo.getCurrency().getName());
            info.setBgVersion(bgFormInfo.getBgVersion().getName());
            info.setAuditOrgUnit(bgFormInfo.getAuditOrgUnit() == null ? null : bgFormInfo.getAuditOrgUnit().getName());
            info.setVirtuals(virtuals);
        }
        return info;
    }

    public String get(String key) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orgUnit", this.getOrgUnit());
        map.put("bgformNumber", this.getBgformNumber());
        map.put("bgformName", this.getBgformName());
        map.put("hasAtt", this.getHasAtt());
        map.put("bgTemplate", this.getBgTemplate());
        map.put("bgSpecialItemsNumber", this.getBgSpecialItemsNumber());
        map.put("specialMember", this.getSpecialMember());
        map.put("bgType", this.getBgType());
        map.put("formType", this.getFormType().getAlias());
        map.put("bgPeriod", this.getBgPeriod());
        map.put("currency", this.getCurrency());
        map.put("bgVersion", this.getBgVersion());
        map.put("operator", this.getOperator());
        map.put("operateTime", String.valueOf(this.getOperateTime()));
        map.put("lastCourseTime", String.valueOf(this.getLastCourseTime()));
        map.put("auditOrgUnit", this.getAuditOrgUnit());
        map.put("state", String.valueOf(this.getState()));
        map.put("processType", String.valueOf(this.getProcessType()));
        map.put("orgUnit.id", this.getOrgUnitID());
        if (map.containsKey(key)) {
            return (String)map.get(key);
        }
        return "";
    }
}

