/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BgNTemplateToHelperFile {
    public static final String ENCODING = "UTF-8";
    public static final String DATA_FILE_TYPE = ".data";
    public static final String XML_FILE_TYPE = ".xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveDataToFile(BgTemplateInfo bgTemplateInfo, String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
            f.createNewFile();
        }
        FileOutputStream outPutStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outPutStream = new FileOutputStream(f);
            objectOutputStream = new ObjectOutputStream(outPutStream);
            objectOutputStream.writeObject(bgTemplateInfo);
            outPutStream.close();
            objectOutputStream.close();
            BgNTemplateToHelperFile.setFileHidden(f);
        }
        finally {
            if (outPutStream != null) {
                outPutStream.close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFileHidden(File file) {
        String osName = System.getProperty("os.name");
        if (osName == null) return;
        String hidden = null;
        try {
            if (osName.toLowerCase().indexOf("linux") < 0) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(hidden);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgTemplateInfo getDataToFile(String fileName) throws IOException, ClassNotFoundException {
        BgTemplateInfo bgTemplateInfo = null;
        ObjectInputStream objectInputStream = null;
        FileInputStream freader = null;
        try {
            freader = new FileInputStream(fileName);
            objectInputStream = new ObjectInputStream(freader);
            bgTemplateInfo = (BgTemplateInfo)objectInputStream.readObject();
            objectInputStream.close();
            freader.close();
        }
        finally {
            if (freader != null) {
                freader.close();
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        return bgTemplateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDimension(BgViewDimensionInfo bgViewDimensionInfo, BgTemFormTypeEnum formType, String fileName) throws DocumentException, IOException {
        try (FileOutputStream fos = null;){
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)new ByteArrayInputStream(bgViewDimensionInfo.getData()));
            fos = new FileOutputStream(new File(fileName));
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(ENCODING);
            XMLWriter writer = null;
            writer = new XMLWriter((OutputStream)fos, format);
            writer.write(document);
            writer.close();
            fos.close();
        }
    }

    public static BgViewDimensionInfo loadDimension(BgTemplateInfo template, File file) throws DocumentException, IOException {
        BgViewDimensionInfo viewDim = new BgViewDimensionInfo();
        viewDim.setTemplate(template);
        SAXReader reader = new SAXReader();
        FileInputStream fis = new FileInputStream(file);
        Document document = reader.read((InputStream)fis);
        OutputFormat format = OutputFormat.createPrettyPrint();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        format.setEncoding(ENCODING);
        XMLWriter writer = null;
        writer = new XMLWriter((OutputStream)bos, format);
        writer.write(document);
        writer.close();
        viewDim.setData(bos.toByteArray());
        return viewDim;
    }
}

