/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgRefDimMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeHelper {
    private static Logger logger = Logger.getLogger((String)BgSchemeHelper.class.getName());
    private static final String resource = "com.kingdee.eas.ma.mbg.client.BgSchemeResource";

    public static SelectorItemCollection getAssignSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("dateFrom"));
        sic.add(new SelectorItemInfo("dateTo"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("isSubmitByScheme"));
        return sic;
    }

    public static Set<String> getSchemeIdsByType(String orgId, String[] bgTypeNumbers) throws BOSException {
        HashSet<String> bgSchemeIds = new HashSet<String>();
        if (!StringUtils.isEmpty((String)orgId) && bgTypeNumbers != null && bgTypeNumbers.length != 0) {
            StringBuffer sql = new StringBuffer("select fbgschemeid from T_Mbg_Bgtemplate left join   T_Mbg_bgtype on T_Mbg_bgtype.fid = T_Mbg_Bgtemplate.FBGTYPEID where T_Mbg_bgtype.fnumber in (");
            for (int i = 0; i < bgTypeNumbers.length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("'").append(bgTypeNumbers[i]).append("'");
            }
            sql.append(")");
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rs = iSql.executeSQL();
            String fid = null;
            try {
                while (rs.next()) {
                    fid = rs.getString(1);
                    if (fid == null) continue;
                    bgSchemeIds.add(fid);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error((Object)e);
            }
        }
        if (bgSchemeIds.isEmpty()) {
            bgSchemeIds.add("000000000000000000000000000=");
        } else {
            Set<String> ids = BgNFCHelper.getBgSchemeIds(BOSUuid.read((String)orgId));
            if (ids == null) {
                ids = new HashSet<String>();
            }
            bgSchemeIds.retainAll(ids);
        }
        return bgSchemeIds;
    }

    public static void checkBudgetOrgView(List<BgDimSettingsMemberInfo> viewList, String currOrgUnitId) throws Exception {
        for (BgDimSettingsMemberInfo member : viewList) {
            if (!member.getType().equals((Object)MemberTypeEnum.budget)) continue;
            String viewID = member.getMemberID().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)viewID, CompareType.EQUALS));
            CoreBaseCollection colls = BgOrgUnitFactory.getRemoteInstance().getCollection(view);
            HashSet<String> orgUnitIDs = new HashSet<String>();
            for (int i = 0; i < colls.size(); ++i) {
                orgUnitIDs.add(((BgOrgUnitInfo)colls.get(i)).getOrgUnitID());
            }
            if (orgUnitIDs.contains(currOrgUnitId)) continue;
            MsgBox.showWarning((String)EASResource.getString((String)resource, (String)"ErrorBudgetView"));
            SysUtil.abort();
        }
    }

    public static void checkOrgUnitOfView(List<BgDimSettingsMemberInfo> viewList) throws Exception {
        String bgViewId = null;
        String bgViewNumber = null;
        HashMap viewMap = new HashMap();
        HashSet<BgOrgUnitInfo> bgUnitSet = new HashSet<BgOrgUnitInfo>();
        HashMap<String, BgOrgUnitInfo> bgUnits = new HashMap<String, BgOrgUnitInfo>();
        HashMap analyseUnitMap = new HashMap();
        HashSet<BgOrgUnitInfo> bgLeafUnitSet = new HashSet<BgOrgUnitInfo>();
        HashSet<BgOrgUnitInfo> bgNotLeafUnitSet = new HashSet<BgOrgUnitInfo>();
        HashSet<String> viewIdSet = new HashSet<String>();
        for (BgDimSettingsMemberInfo item : viewList) {
            if (item.getType().equals((Object)MemberTypeEnum.budget)) {
                bgViewNumber = item.getNumber();
                bgViewId = item.getMemberID().toString();
            }
            viewIdSet.add(item.getMemberID().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("viewId", viewIdSet, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("viewId"));
        CoreBaseCollection coll = BgOrgUnitFactory.getRemoteInstance().getCollection(view);
        BgOrgUnitInfo orgUnit = null;
        HashSet<BgOrgUnitInfo> analyseOrgUnitSet = null;
        String tmpOrgViewId = "";
        for (int i = 0; i < coll.size(); ++i) {
            orgUnit = (BgOrgUnitInfo)coll.get(i);
            if (orgUnit.getViewID().toString().equals(bgViewId)) {
                bgUnitSet.add(orgUnit);
                bgUnits.put(orgUnit.getNumber(), orgUnit);
                continue;
            }
            if (!orgUnit.getViewID().toString().equals(tmpOrgViewId)) {
                tmpOrgViewId = orgUnit.getViewID().toString();
                analyseOrgUnitSet = new HashSet<BgOrgUnitInfo>();
                analyseUnitMap.put(tmpOrgViewId, analyseOrgUnitSet);
            }
            if (analyseOrgUnitSet == null) continue;
            analyseOrgUnitSet.add(orgUnit);
        }
        for (BgOrgUnitInfo bgOrgUnit : bgUnitSet) {
            if (bgOrgUnit.isIsLeaf()) {
                bgLeafUnitSet.add(bgOrgUnit);
                continue;
            }
            bgNotLeafUnitSet.add(bgOrgUnit);
        }
        HashMap<String, BgOrgUnitInfo> analyseUnits = new HashMap<String, BgOrgUnitInfo>();
        HashMap<String, BgOrgUnitInfo> analyseNotLeafUnits = new HashMap<String, BgOrgUnitInfo>();
        HashSet<BgOrgUnitInfo> analyseLeafUnitSet = new HashSet<BgOrgUnitInfo>();
        for (String viewId : analyseUnitMap.keySet()) {
            Set analyseUnitSet = (Set)analyseUnitMap.get(viewId);
            analyseUnits.clear();
            analyseNotLeafUnits.clear();
            for (BgOrgUnitInfo bgOrgUnit : analyseUnitSet) {
                analyseUnits.put(bgOrgUnit.getNumber(), bgOrgUnit);
                if (bgOrgUnit.isIsLeaf()) {
                    analyseLeafUnitSet.add(bgOrgUnit);
                    continue;
                }
                analyseNotLeafUnits.put(bgOrgUnit.getNumber(), bgOrgUnit);
            }
            for (BgOrgUnitInfo bgOrgUnit : bgLeafUnitSet) {
                if (!analyseUnits.keySet().contains(bgOrgUnit.getNumber()) || ((BgOrgUnitInfo)analyseUnits.get(bgOrgUnit.getNumber())).isIsLeaf()) continue;
                MsgBox.showWarning((String)EASResource.getString((String)resource, (String)"errorBgIsNotLeaf", (Object[])new Object[]{bgOrgUnit.getName()}));
                SysUtil.abort();
            }
            for (BgOrgUnitInfo analyseOrgUnit : analyseLeafUnitSet) {
                if (!bgUnits.keySet().contains(analyseOrgUnit.getNumber()) || ((BgOrgUnitInfo)bgUnits.get(analyseOrgUnit.getNumber())).isIsLeaf()) continue;
                MsgBox.showWarning((String)EASResource.getString((String)resource, (String)"errorAnalyseIsNotLeaf", (Object[])new Object[]{analyseOrgUnit.getName()}));
                SysUtil.abort();
            }
            ArrayList<BgOrgUnitInfo> tmpBgUnits = new ArrayList<BgOrgUnitInfo>();
            ArrayList tmpAnalyseUnits = new ArrayList();
            for (BgOrgUnitInfo bgOrgUnit : bgNotLeafUnitSet) {
                if (!analyseNotLeafUnits.keySet().contains(bgOrgUnit.getNumber())) continue;
                tmpBgUnits.add(bgOrgUnit);
                tmpAnalyseUnits.add(analyseNotLeafUnits.get(bgOrgUnit.getNumber()));
            }
            if (tmpAnalyseUnits.isEmpty()) continue;
            Set tmpAnalyseUnitSet = (Set)analyseUnitMap.get(((BgOrgUnitInfo)tmpAnalyseUnits.get(0)).getViewID());
            HashSet<String> bgUnitLeafNum = new HashSet<String>();
            HashSet<String> analyseUnitLeafNum = new HashSet<String>();
            for (BgOrgUnitInfo notLeafUnit : tmpBgUnits) {
                bgUnitLeafNum.clear();
                analyseUnitLeafNum.clear();
                for (BgOrgUnitInfo tmp : bgUnitSet) {
                    if (!tmp.isIsLeaf() || !tmp.getLongNumber().startsWith(notLeafUnit.getLongNumber() + "!")) continue;
                    bgUnitLeafNum.add(tmp.getNumber());
                }
                for (BgOrgUnitInfo tmp : tmpAnalyseUnitSet) {
                    if (!tmp.isIsLeaf() || !tmp.getLongNumber().startsWith(((BgOrgUnitInfo)analyseNotLeafUnits.get(notLeafUnit.getNumber())).getLongNumber() + "!")) continue;
                    analyseUnitLeafNum.add(tmp.getNumber());
                }
                if (bgUnitLeafNum.size() == analyseUnitLeafNum.size()) {
                    for (String num : bgUnitLeafNum) {
                        if (analyseUnitLeafNum.contains(num)) continue;
                        MsgBox.showWarning((String)EASResource.getString((String)resource, (String)"errorDifLeaf", (Object[])new Object[]{notLeafUnit.getName()}));
                        SysUtil.abort();
                    }
                    continue;
                }
                MsgBox.showWarning((String)EASResource.getString((String)resource, (String)"errorDifLeaf", (Object[])new Object[]{notLeafUnit.getName()}));
                SysUtil.abort();
            }
        }
    }

    public static boolean checkRefTemplate(String bgSchemeID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeID, CompareType.EQUALS));
        CoreBaseCollection coll = BgTemplateFactory.getRemoteInstance().getCollection(view);
        if (coll.size() > 0) {
            HashSet<String> templateID = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                BgTemplateInfo template = (BgTemplateInfo)coll.get(i);
                templateID.add(template.getId().toString());
            }
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("bgSchemeID", (Object)bgSchemeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("refID", templateID, CompareType.INCLUDE));
            CoreBaseCollection refColl = BgRefDimMemberFactory.getRemoteInstance().getCollection(view);
            if (refColl.size() > 0) {
                return true;
            }
        }
        return false;
    }
}

