/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.io.kds.KDSBookToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.utils.BgAccountHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.ma.mbg.BgOrgUnitFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationEntryInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationException;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationMapInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationStateEnum;
import com.kingdee.eas.ma.mbg.client.BgSchemeIntegratioinProgressUI;
import com.kingdee.eas.ma.mbg.client.BgSchemeIntegrationRptListUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgSchemeIntegrationClientHelper {
    private static Logger logger = Logger.getLogger((String)BgSchemeIntegrationClientHelper.class.getName());

    public void integrate(CoreUI owner, String integragionId, Map<String, String> id_numbers, String bgPeriodNum, String uiModal, Boolean confirmCleanData) throws BOSException {
        if (integragionId == null) {
            return;
        }
        SimpleTimer time = new SimpleTimer();
        UIContext map = new UIContext((Object)owner);
        map.put((Object)"ID", (Object)integragionId);
        map.put((Object)BgBaseConstants.BGPERIOD_INFO, (Object)bgPeriodNum);
        IUIWindow window = UIFactory.createUIFactory((String)(uiModal == null ? "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory" : uiModal)).create(BgSchemeIntegratioinProgressUI.class.getName(), (Map)map, null, null, 16);
        if (window != null && window.getUIObject() instanceof BgSchemeIntegratioinProgressUI) {
            BgSchemeIntegratioinProgressUI ui = (BgSchemeIntegratioinProgressUI)window.getUIObject();
            ui.setShowTableMessage(true);
            logger.debug((Object)("begin initParameterValue" + time.getTime() + ""));
            ArrayList<String> integragionIds = new ArrayList<String>();
            integragionIds.add(integragionId);
            this.initParameterValue(owner, ui, integragionIds, id_numbers, bgPeriodNum, confirmCleanData);
            logger.debug((Object)("begin init" + time.getTime() + ""));
            ui.init();
            logger.debug((Object)("begin show" + time.getTime() + ""));
            window.show();
        }
    }

    private void initParameterValue(CoreUI owner, BgSchemeIntegratioinProgressUI ui, List<String> integragionIds, Map<String, String> id_numbers, String bgPeriodNum, Boolean confirmCleanData) {
        ui.setUITitle(BgSchemeIntegrationClientHelper.getString("integrateTitle"));
        ui.setInvokeClass(BgSchemeIntegrationClientHelper.class.getName());
        ui.setInvokeMethod("integrate");
        Class[] cls = new Class[]{CoreUI.class, BOSUuid.class, String.class, String.class, Boolean.class};
        ui.setInvokeMethodParmeterType(cls);
        ArrayList<Object[]> paramValues = new ArrayList<Object[]>();
        String id = null;
        String number = null;
        Object[] params = null;
        for (int i = 0; i < integragionIds.size(); ++i) {
            id = integragionIds.get(i);
            number = id_numbers.get(id);
            if (i == 0) {
                params = new Object[5];
                params[0] = owner;
                paramValues.add(params);
            }
            if (params == null) continue;
            params[2] = number;
            params = new Object[5];
            params[0] = owner;
            params[1] = BOSUuid.read((String)id);
            params[3] = bgPeriodNum;
            params[4] = confirmCleanData;
            paramValues.add(params);
        }
        ui.setInvokeMethodParmeterValue((Object[][])paramValues.toArray((T[])new Object[0][0]));
        ui.setCountSum(paramValues.size() - 1);
    }

    public Object integrate(CoreUI owner, BOSUuid id, String lastNumber, String bgPeriodNum, Boolean confirmCleanData) throws Exception {
        Object[] obj = new Object[3];
        if (lastNumber != null) {
            obj[0] = MessageFormat.format(BgSchemeIntegrationClientHelper.getString("integrateDetail"), lastNumber);
        }
        if (id != null) {
            try {
                BgSchemeIntegrationFacadeFactory.getRemoteInstance().integrate(id, bgPeriodNum, confirmCleanData);
                BgNFCHelper.refreshListUI(owner);
            }
            catch (BgPeriodException ex) {
                return ex;
            }
            catch (BgSchemeIntegrationException ex) {
                throw ex;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                owner.handUIException((Throwable)e);
            }
        }
        return obj;
    }

    public static void showReprotUI(CoreUI ownerUI, String integrationId) throws UIException {
        UIContext uiContext = new UIContext((Object)ownerUI);
        uiContext.put((Object)"ID", (Object)integrationId);
        UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgSchemeIntegrationRptListUI.class.getName(), (Map)uiContext).show();
    }

    public static BgSchemeIntegrationInfo getCopyNewObject(CoreUI ownerUI, String id) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("description");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("sourceBgScheme.id");
        sic.add("sourceBgScheme.number");
        sic.add("sourceBgScheme.name");
        sic.add("targetBgScheme.id");
        sic.add("targetBgScheme.number");
        sic.add("targetBgScheme.name");
        sic.add("dataState");
        sic.add("notExecuteBizCalc.*");
        sic.add("notExecuteBizCalc.bgBizCalc.*");
        sic.add("isDeleteHistoryData");
        sic.add("entries.*");
        sic.add("entries.members.*");
        sic.add("entries.memberMaps.*");
        try {
            BgSchemeIntegrationInfo info = BgSchemeIntegrationFactory.getRemoteInstance().getBgSchemeIntegrationInfo((IObjectPK)new ObjectStringPK(id), sic);
            info = (BgSchemeIntegrationInfo)info.clone();
            info.setState(BgSchemeIntegrationStateEnum.save);
            info.setId(null);
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setLastUpdateUser(info.getCreator());
            info.setLastUpdateTime(info.getCreateTime());
            info.getEntries().sort("seq");
            BgSchemeIntegrationEntryInfo entryInfo = null;
            BgSchemeIntegrationMemberInfo memberInfo = null;
            BgSchemeIntegrationMapInfo mapInfo = null;
            for (int e1 = 0; e1 < info.getEntries().size(); ++e1) {
                int m;
                entryInfo = info.getEntries().get(e1);
                entryInfo.getMemberMaps().sort("seq");
                entryInfo.setBgSchemeIntegration(info);
                entryInfo.setId(null);
                for (m = 0; m < entryInfo.getMembers().size(); ++m) {
                    memberInfo = entryInfo.getMembers().get(m);
                    memberInfo.setEntry(entryInfo);
                    memberInfo.setId(null);
                }
                for (m = 0; m < entryInfo.getMemberMaps().size(); ++m) {
                    mapInfo = entryInfo.getMemberMaps().get(m);
                    mapInfo.setEntry(entryInfo);
                    mapInfo.setId(null);
                }
            }
            return info;
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            ownerUI.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            ownerUI.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        return null;
    }

    public static String getString(String msgKey) {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeIntegrationResource", (String)msgKey);
    }

    public static void exportFile(CoreUI ui, KDTable tblMap) throws Exception {
        String filePath = BgSchemeIntegrationClientHelper.showExportDialog(ui);
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.getRowStyleAttributes(0).setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        kdsSheet.getRowStyleAttributes(0).setBackground(Color.blue);
        kdsSheet.getRowStyleAttributes(1).setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        kdsSheet.getRowStyleAttributes(1).setBackground(Color.blue);
        kdsSheet.setCellValue(0, 0, (Object)BgSchemeIntegrationClientHelper.getString("sourceScheme"));
        kdsSheet.setCellValue(0, 1, (Object)BgSchemeIntegrationClientHelper.getString("sourceScheme"));
        kdsSheet.setCellValue(0, 2, (Object)BgSchemeIntegrationClientHelper.getString("targetScheme"));
        kdsSheet.setCellValue(0, 3, (Object)BgSchemeIntegrationClientHelper.getString("targetScheme"));
        kdsSheet.getMerges().addMerge(0, 0, 0, 1);
        kdsSheet.getMerges().addMerge(0, 2, 0, 3);
        kdsSheet.setCellValue(1, 0, (Object)BgSchemeIntegrationClientHelper.getString("sourceMemberNumber"));
        kdsSheet.setCellValue(1, 1, (Object)BgSchemeIntegrationClientHelper.getString("sourceMemberName"));
        kdsSheet.setCellValue(1, 2, (Object)BgSchemeIntegrationClientHelper.getString("targetMemberNumber"));
        kdsSheet.setCellValue(1, 3, (Object)BgSchemeIntegrationClientHelper.getString("targetMemberName"));
        int in = tblMap.getRowCount();
        for (int i = 0; i < in; ++i) {
            int jn = tblMap.getColumnCount();
            for (int j = 0; j < jn; ++j) {
                kdsSheet.setCellValue(i + 2, j, tblMap.getValueAt(i, j));
            }
        }
        File file = new File(filePath);
        if (file.exists()) {
            int result = MsgBox.showConfirm2((Component)ui, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fileHasExisted"));
            if (result == 0) {
                if (file.delete()) {
                    file = new File(filePath);
                } else {
                    MsgBox.showInfo((Component)ui, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"openedfile"));
                }
            } else {
                SysUtil.abort();
            }
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            String sen = GlobalFunction.getFileExtension((String)filePath);
            Book temBook = null;
            if (sen.equals("xlsx")) {
                temBook = KDSBookToBook.traslate((KDSBook)kdsBook);
                BookDataWrapper bookDataWrapper = new BookDataWrapper(temBook);
                SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
                if (filePath != null) {
                    booksc.write(filePath.replaceAll(" ", ""));
                }
            } else {
                export.exportToExcel(kdsBook, filePath);
            }
        }
        catch (RuntimeException e1) {
            SysUtil.abort();
        }
    }

    public static void importFile(CoreUI ui) {
        BgSchemeIntegrationClientHelper.showImportDialog(ui);
    }

    private static KDSBook showImportDialog(CoreUI ownerUI) {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle("");
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)ownerUI) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            kdsBook = POIXlsReader.parse((String)filePath);
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgSchemeIntegrationResource", (String)"excelBad"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showInfo((Component)ownerUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgSchemeIntegrationResource", (String)"notFile"));
            SysUtil.abort();
        }
        return kdsBook;
    }

    private static String showExportDialog(CoreUI ownerUi) {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(BgSchemeIntegrationClientHelper.getString("integrationExport"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        filePath = BgAccountHelper.fileSelect((KDFileChooser)fileChooser, (CoreUI)ownerUi);
        return filePath;
    }

    public static void loadMap(IRow row, BgSchemeIntegrationMapInfo mapInfo) {
        if (row == null || mapInfo == null) {
            return;
        }
        row.setUserObject((Object)mapInfo);
        row.getCell("sourceMemberNumber").setValue((Object)mapInfo.getSourceMemberNumber());
        row.getCell("sourceMemberName").setValue((Object)mapInfo.getSourceMemberName());
        row.getCell("targetMemberNumber").setValue((Object)mapInfo.getTargetMemberNumber());
        row.getCell("targetMemberName").setValue((Object)mapInfo.getTargetMemberName());
    }

    public static Set<String> getBgSchemeIds(OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        HashSet<String> ids = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        TreeBaseCollection colls = CostCenterOrgUnitFactory.getRemoteInstance().getAllChildren((TreeBaseInfo)orgUnitInfo, view);
        if (colls != null && !colls.isEmpty()) {
            HashSet<String> orgIds = new HashSet<String>();
            for (int i = 0; i < colls.size(); ++i) {
                orgIds.add(colls.get(i).getId().toString());
            }
            EntityViewInfo view1 = new EntityViewInfo();
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add("id");
            view1.setSelector(sic1);
            view1.setFilter(new FilterInfo());
            view1.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgIds, CompareType.INCLUDE));
            BgSchemeCollection schemes = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(view1);
            if (schemes != null && !schemes.isEmpty()) {
                for (int i = 0; i < schemes.size(); ++i) {
                    ids.add(schemes.get(i).getId().toString());
                }
            }
        }
        return ids;
    }

    public static Set<String> getBgSchemeIds(OrgUnitInfo orgUnitInfo, UserInfo userInfo) throws EASBizException, BOSException {
        HashSet<String> ids;
        block3: {
            Set orgIds;
            block4: {
                ids = new HashSet<String>();
                orgIds = BgOrgUnitFacadeFactory.getRemoteInstance().getCostCenterChildren((IObjectValue)orgUnitInfo, (IObjectValue)userInfo);
                if (orgIds == null || orgIds.isEmpty()) break block3;
                if (orgIds.size() >= 1000) break block4;
                EntityViewInfo view1 = new EntityViewInfo();
                SelectorItemCollection sic1 = new SelectorItemCollection();
                sic1.add("id");
                view1.setSelector(sic1);
                view1.setFilter(new FilterInfo());
                view1.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgIds, CompareType.INCLUDE));
                BgSchemeCollection schemes = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(view1);
                if (schemes == null || schemes.isEmpty()) break block3;
                for (int i = 0; i < schemes.size(); ++i) {
                    ids.add(schemes.get(i).getId().toString());
                }
                break block3;
            }
            EntityViewInfo view1 = new EntityViewInfo();
            SelectorItemCollection sic1 = new SelectorItemCollection();
            sic1.add("id");
            sic1.add("orgUnit.id");
            view1.setSelector(sic1);
            view1.setFilter(new FilterInfo());
            BgSchemeCollection schemes = BgSchemeFactory.getRemoteInstance().getBgSchemeCollection(view1);
            if (schemes != null && !schemes.isEmpty()) {
                for (int i = 0; i < schemes.size(); ++i) {
                    if (!orgIds.contains(schemes.get(i).getOrgUnit().getId().toString())) continue;
                    ids.add(schemes.get(i).getId().toString());
                }
            }
        }
        return ids;
    }
}

