/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.client.BgNProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNewTemplateEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BudgetUtilForClient;
import com.kingdee.eas.util.SysUtil;
import java.util.Map;

public class BgTemplateProvider
extends IBookProvider {
    private BgNProcessUI ui = null;
    private boolean isAutoCal = false;

    private BgTemplateProvider() {
    }

    public BgTemplateProvider(BgNProcessUI obj) {
        this.ui = obj;
    }

    public Book loadBook() throws Exception {
        Book book = null;
        book = this.getTemplateInfo().getData() != null ? this.getTemplateInfo().getBook() : Book.Manager.getNewBook();
        if (this.ui.getOprtState().equals(OprtState.VIEW)) {
            // empty if block
        }
        this.setAutoCal(book.isAutoCalculate());
        book.setCalculate(false);
        if (book != null) {
            BudgetUtilForClient.prepareTemplateInfo4Display(this.getTemplateInfo(), book);
        }
        return book;
    }

    public IObjectValue getEditValue() {
        return super.getEditValue();
    }

    public BgTemplateInfo getTemplateInfo() {
        return (BgTemplateInfo)this.getEditValue();
    }

    public void restoreBook(Book book) throws Exception {
        BudgetUtilForClient.prepareTemplateInfo4Save(this.getTemplateInfo(), book);
        this.getTemplateInfo().setBook(book);
    }

    public IObjectValue createNewReport() throws Exception {
        UIContext uiContext = new UIContext(this.ui.getUIContext().get("Owner"));
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.ui.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, this.ui.getUIContext().get(BgBaseConstants.ORGUNIT_CU));
        uiContext.put((Object)BgBaseConstants.BGSCHEME_INFO, this.ui.getUIContext().get(BgBaseConstants.BGSCHEME_INFO));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean hasSubmit = ((BgNewTemplateEditUI)uiWindow.getUIObject()).isHasSubmit();
        if (!((IBgTemplate)this.getBizInterface()).exists((IObjectPK)new ObjectUuidPK(((BgTemplateInfo)uiWindow.getUIObject().getDataObject()).getId()))) {
            SysUtil.abort();
        }
        IObjectValue model = this.queryEditData((IObjectPK)new ObjectUuidPK(((BgTemplateInfo)uiWindow.getUIObject().getDataObject()).getId()));
        this.setEditValue(model);
        if (!hasSubmit || model == null || !(model instanceof BgTemplateInfo)) {
            SysUtil.abort();
        }
        return model;
    }

    protected String getEditUIName() {
        return BgNewTemplateEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    public ICoreBase getBizInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        return super.queryEditData(pk);
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("description");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("isAllowChange");
        sic.add("data");
        sic.add("canModify");
        sic.add("readonly");
        sic.add("templateStatus");
        sic.add("bgScheme.id");
        sic.add("bgScheme.number");
        sic.add("bgScheme.name");
        sic.add("bgScheme.dateFrom");
        sic.add("bgScheme.dateTo");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgTemplate.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.name");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("parent.id");
        sic.add("root.id");
        sic.add("formType");
        sic.add("postils.postilType");
        sic.add("postils.description");
        sic.add("postils.cellName");
        sic.add("postils.reportType");
        sic.add("postils.lastUpdateTime");
        sic.add("postils.createTime");
        sic.add("postils.sheet.sheetID");
        sic.add("postils.lastUpdateUser.name");
        sic.add("postils.lastUpdateUser.id");
        sic.add("postils.creator.name");
        sic.add("postils.creator.id");
        sic.add("bgRollRule.id");
        sic.add("isTransferQingAnalyse");
        return sic;
    }

    public String getBizFactoryName() {
        return BgTemplateFactory.class.getName();
    }

    public boolean isAutoCal() {
        return this.isAutoCal;
    }

    public void setAutoCal(boolean isAutoCal) {
        this.isAutoCal = isAutoCal;
    }
}

