/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.AggregateDataTypeEnum;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.DimensionDisplayModeEnum;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.client.BgNProcessUI;
import com.kingdee.eas.ma.mbg.client.DimensionMemberFormulaUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFillHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgSpecialBudgetClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNLockProtectHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionFillHelper {
    private static Logger logger = Logger.getLogger((String)DimensionFillHelper.class.getName());
    private static Map cachMap = new HashMap();

    public static void createBgFormulaFromItemFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, boolean isFromTemplate) throws BOSException, EASBizException {
        DimensionFillHelper.createBgFormulaFromItemFormula(win, sheet, value, formulaKind, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, null, isFromTemplate);
    }

    public static void createBgFormulaFromItemFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isFromTemplate) throws BOSException, EASBizException {
        DimensionFillHelper.createBgFormulaFromItemFormula(win, sheet, value, formulaKind, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, filterValueMap, true, true, isFromTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBgFormulaFromItemFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired, boolean isFromTemplate) throws BOSException, EASBizException {
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return;
        }
        boolean isCalc = sheet.getBook().isAutoCalculate();
        try {
            BgNFSHelper.disableCal(sheet.getBook());
            Protection pro = sheet.getSheetOption().getProtection(false);
            boolean isPro = false;
            if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
                isPro = true;
            }
            boolean hasItemFormula = false;
            boolean hasNotLock = false;
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int i = 0; i < num; ++i) {
                CellBlock block = range.getBlock(i);
                int xn = Math.min(maxRow, block.getRow2());
                for (int x = block.getRow(); x <= xn; ++x) {
                    int yn = Math.min(maxCol, block.getCol2());
                    for (int y = block.getCol(); y <= yn; ++y) {
                        Cell cell = sheet.getCell(x, y, false);
                        if (cell == null) continue;
                        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
                            hasItemFormula = true;
                        }
                        if (isPro && BgNLockProtectHelper.isCellLocked(cell)) continue;
                        hasNotLock = true;
                        break;
                    }
                    if (hasNotLock) break;
                }
                if (hasNotLock) break;
            }
            if (!hasItemFormula) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"notBgItemFormula"));
                SysUtil.abort();
            }
            if (!hasNotLock) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"cellLock"));
                SysUtil.abort();
            }
            Map scenarioMap = BgScenarioHelper.getScenariooObjMap();
            for (int i = 0; i < range.size(); ++i) {
                CellBlock block = range.getBlock(i);
                for (int j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                    for (int k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                        Cell cell;
                        if (sheet.getMergeBlock(j, k) != null || (cell = sheet.getCell(j, k, false)) == null) continue;
                        if (value instanceof BgFormInfo) {
                            if (isPro && BgNLockProtectHelper.isCellLocked(cell)) continue;
                            DimensionFillHelper.subCreateBgFormulaFromItemFormula(cell, value, formulaKind, scenarioMap);
                            continue;
                        }
                        if (isPro && BgNLockProtectHelper.isCellLocked(cell)) continue;
                        DimensionFillHelper.subCreateBgFormulaFromItemFormula(cell, value, formulaKind, scenarioMap);
                    }
                }
                BgNTemplateHelper.dealWith(sheet.getBook(), orgUnitId, null, isFromTemplate, false, null, needItemVariable, isEnumForm, null, DimensionMemberSelectHelper.getSchemeHelper(win), isMustAllDim, filterValueMap, isElementRequired, isScenarioRequired);
            }
        }
        finally {
            if (isCalc) {
                BgNFSHelper.enableCal(sheet.getBook());
            }
        }
    }

    public static void subCreateBgFormulaFromItemFormula(Cell cell, IObjectValue value, String formulaKind, Map<String, BgScenarioInfo> scenarioMap) {
        if (cell == null) {
            return;
        }
        String itemCombinStr = "";
        String bgPeriodNumber = "";
        String elementNumber = "";
        String currencyNumber = "";
        String orgNumber = "";
        String bgSchemeNumber = "";
        String beginTime = "";
        String endTime = "";
        String periodType = "MONTH";
        String scenarioNumber = "";
        String versionNumber = "";
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
            versionNumber = ((BgFormInfo)value).getBgVersion().getNumber();
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
            itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula);
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (params.length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
                itemCombinStr = params[0] == null ? "" : params[0];
                bgPeriodNumber = params[1] == null ? "" : params[1];
                elementNumber = params[2] == null ? "" : params[2];
                scenarioNumber = params[3] == null ? "" : params[3];
                currencyNumber = params[5] == null ? "" : params[5];
                orgNumber = "";
                bgSchemeNumber = "";
                if (StringUtils.isEmpty((String)bgPeriodNumber)) {
                    beginTime = "";
                    endTime = "";
                } else {
                    beginTime = BgNFillHelper.getBeginTime(bgPeriodNumber);
                    endTime = BgNFillHelper.getEndTime(bgPeriodNumber);
                }
            } else if (params.length == 5 && hint.name.equalsIgnoreCase("BgItem")) {
                itemCombinStr = params[0] == null ? "" : params[0];
                bgPeriodNumber = params[1] == null ? "" : params[1];
                elementNumber = params[2] == null ? "" : params[2];
                scenarioNumber = params[3] == null ? "" : params[3];
                currencyNumber = params[4] == null ? "" : params[4];
                orgNumber = "";
                bgSchemeNumber = "";
                if (StringUtils.isEmpty((String)bgPeriodNumber)) {
                    beginTime = "";
                    endTime = "";
                } else {
                    beginTime = BgNFillHelper.getBeginTime(bgPeriodNumber);
                    endTime = BgNFillHelper.getEndTime(bgPeriodNumber);
                }
            }
        } else {
            return;
        }
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
            orgNumber = info.getOrgUnit().getNumber();
            bgSchemeNumber = info.getBgScheme().getNumber();
            beginTime = String.valueOf(info.getBgPeriod().getBeginDate());
            endTime = String.valueOf(info.getBgPeriod().getEndDate());
        }
        int cslIndex = -1;
        if (itemCombinStr != null) {
            cslIndex = itemCombinStr.indexOf(DimensionConstants.DEF_CSL_SRCNUMBER + ":");
        }
        if (cslIndex >= 0) {
            String[] combins = DimensionFormulaHelper.splitCombinations(itemCombinStr);
            StringBuffer newItem = new StringBuffer();
            for (int i = 0; i < combins.length; ++i) {
                if (combins[i].startsWith(DimensionConstants.DEF_CSL_SRCNUMBER + ":")) continue;
                DimensionFormulaHelper.addItem(newItem, combins[i]);
            }
            itemCombinStr = newItem.toString();
        }
        AggregateDataTypeEnum aggregateDataType = null;
        if (scenarioMap != null && !scenarioMap.isEmpty() && !StringUtils.isEmpty((String)scenarioNumber) && scenarioMap.containsKey(scenarioNumber)) {
            if (scenarioMap.get(scenarioNumber).getType().equals((Object)BgScenarioType.ActualData)) {
                aggregateDataType = AggregateDataTypeEnum.actual;
            } else if (scenarioMap.get(scenarioNumber).getType().equals((Object)BgScenarioType.BudgetData)) {
                aggregateDataType = AggregateDataTypeEnum.budget;
            }
        }
        String _formula = null;
        _formula = formulaKind.equalsIgnoreCase("BgAvlBal") || formulaKind.equalsIgnoreCase("BgAvlBalF") ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\")" : (formulaKind.equalsIgnoreCase("BgActualExt") || formulaKind.equalsIgnoreCase("BgActualExtF") ? (BgPeriodNVariableHelper.checkCanConvert((String)bgPeriodNumber) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\",\"" + periodType + "\")" : "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + beginTime + "\",\"" + endTime + "\",\"" + periodType + "\")") : (formulaKind.equalsIgnoreCase("MbgActualS") || formulaKind.equalsIgnoreCase("BgActualExtF") ? FormulaUtils.getMbgActualsExp(orgNumber, bgSchemeNumber, scenarioNumber, itemCombinStr, bgPeriodNumber, bgPeriodNumber, versionNumber, currencyNumber, elementNumber, null) : (formulaKind.equalsIgnoreCase("MbgAggregate") || formulaKind.equalsIgnoreCase("BgActualExtF") ? FormulaUtils.getMbgAggregateExp(orgNumber, bgSchemeNumber, scenarioNumber, itemCombinStr, bgPeriodNumber, bgPeriodNumber, versionNumber, currencyNumber, elementNumber, aggregateDataType, null, null) : (formulaKind.equalsIgnoreCase("MbgFormula") || formulaKind.equalsIgnoreCase("BgActualExtF") ? FormulaUtils.getMbgFormulaExp(orgNumber, bgSchemeNumber, scenarioNumber, itemCombinStr, bgPeriodNumber, bgPeriodNumber, versionNumber, currencyNumber, elementNumber) : "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\")"))));
        BgNFSHelper.setExpression(cell, _formula);
    }

    public static void mutiUpdateBgItemFormula(IUIObject ui, Sheet sheet, String currentBgPeriodNumber, String orgUnitId, BgSchemeDimensionHelper schemeHelper, Map<String, Set<String>> filterValueMap) {
        DimensionFillHelper.mutiUpdateBgItemFormula(ui, sheet, currentBgPeriodNumber, orgUnitId, null, schemeHelper, filterValueMap);
    }

    public static void mutiUpdateBgItemFormula(IUIObject ui, Sheet sheet, String currentBgPeriodNumber, String orgUnitId, String unionGroupId, BgSchemeDimensionHelper schemeHelper, Map<String, Set<String>> filterValueMap) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", ui);
        ctx.put("currentBgPeiodNumber", currentBgPeriodNumber);
        ctx.put(BgBaseConstants.ORGUNIT_ID, orgUnitId);
        ctx.put(BgBaseConstants.UNIONGROUP_ID, unionGroupId);
        ctx.put("BGSCHEME_HELPER", schemeHelper);
        ctx.put("filterValueMap", filterValueMap);
        String formula = null;
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(DimensionMemberFormulaUI.class.getName(), ctx);
            messageDialog.show();
            if (messageDialog.getUIObject() instanceof DimensionMemberFormulaUI) {
                formula = ((DimensionMemberFormulaUI)messageDialog.getUIObject()).getFormula();
            }
        }
        catch (Exception e1) {
            ui.handUIException((Throwable)e1);
            return;
        }
        if (StringUtils.isEmpty(formula)) {
            return;
        }
        String[] newParamFormulaArray = DimensionFillHelper.parseStrFormulaToArray(formula);
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return;
        }
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        for (int i = 0; i < num; ++i) {
            CellBlock block = range.getBlock(i);
            int _num = Math.min(maxRow, block.getRow2());
            for (int j = block.getRow(); j <= _num; ++j) {
                int __num = Math.min(maxCol, block.getCol2());
                for (int k = block.getCol(); k <= __num; ++k) {
                    Cell cell = sheet.getCell(j, k, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || !BgNFSHelper.checkCanEditFormulaOfCell(cell)) continue;
                    String tempFormula = BgNFSHelper.getFormulaOfCell(cell);
                    if ((tempFormula = BgNTemplateHelper.get6ParematerItemFormula(tempFormula)) == null || tempFormula.trim().length() <= 0) continue;
                    String[] oldParamFormulaArray = DimensionFillHelper.parseStrFormulaToArray(tempFormula);
                    if (oldParamFormulaArray.length == 0) {
                        return;
                    }
                    tempFormula = DimensionFillHelper.updateFormula(oldParamFormulaArray, newParamFormulaArray);
                    Range range2 = cell.getSheet().getRange(cell);
                    range2.setIgnoreProtected(true);
                    BgSpecialBudgetClientHelper.addItemFormulaCell(ui, cell);
                    ItemFormula itemFormula = new ItemFormula(tempFormula);
                    range2.setUserObject("ITEM", (Object)itemFormula);
                }
            }
        }
        BgSpecialBudgetClientHelper.fillSpecialItem(ui);
        BgSpecialBudgetClientHelper.afterFillItemFormula(ui);
    }

    public static void mutiUpdateBgItemFormula(IUIObject ui, Sheet sheet, String currentBgPeriodNumber, String orgUnitId, BgSchemeDimensionHelper schemeHelper) {
        DimensionFillHelper.mutiUpdateBgItemFormula(ui, sheet, currentBgPeriodNumber, orgUnitId, schemeHelper, null);
    }

    public static String[] parseStrFormulaToArray(String formula) {
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)formula, (boolean)false);
        }
        catch (ParserException e1) {
            return new String[0];
        }
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        return params;
    }

    public static String updateFormula(String[] oldArray, String[] newArray) {
        String[] param = new String[oldArray.length];
        param = DimensionFillHelper.updateFormulaHelper(oldArray, newArray, param);
        String formulaTemplate = BgNFSHelper.getFormulaFromParam(param);
        return formulaTemplate;
    }

    public static String[] updateFormulaHelper(String[] oldArray, String[] newArray, String[] param) {
        int num = param.length;
        for (int i = 0; i < num; ++i) {
            param[i] = i == 4 ? oldArray[i] : (newArray[i].equals("") ? oldArray[i] : newArray[i]);
        }
        return param;
    }

    public static void showBgItem(IUIObject win, String bgSchemeId, Sheet sheet, boolean isAutoCreateFormula, String srcBgPeriodNumber, String srcCurrencyNumber, Map itemFormulaMap, Map itemGroup, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired) throws EASBizException, BOSException {
        DimensionFillHelper.showBgItem(win, bgSchemeId, sheet, isAutoCreateFormula, srcBgPeriodNumber, srcCurrencyNumber, itemFormulaMap, itemGroup, needItemVariable, isEnumForm, orgUnitId, null, isMustAllDim, filterValueMap, isElementRequired, isScenarioRequired);
    }

    public static void showBgItem(IUIObject win, String bgSchemeId, Sheet sheet, boolean isAutoCreateFormula, String srcBgPeriodNumber, String srcCurrencyNumber, Map itemFormulaMap, Map itemGroup, boolean needItemVariable, boolean isEnumForm, String orgUnitId, String unionGroupId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired) throws EASBizException, BOSException {
        Range range = BgNFillHelper.getSelectRange(win, sheet);
        range.setIgnoreProtected(true);
        NewDimensionMemberSelectDialog dialog = null;
        dialog = unionGroupId != null ? new NewDimensionMemberSelectDialog((Component)((CoreUI)win), bgSchemeId, null, unionGroupId, true, false, unionGroupId) : new NewDimensionMemberSelectDialog((Component)((CoreUI)win), bgSchemeId, (DimensionInfo)null, orgUnitId, true, false);
        dialog.setOnlySelectItem(true);
        dialog.setShowFilterRadioBtn(true);
        if (filterValueMap != null) {
            dialog.setFilterValueMap(filterValueMap);
        }
        dialog.show();
        if (!dialog.isCanceled() && dialog.getData() != null) {
            DimensionDisplayModeEnum bgItemShowStyle = DimensionDisplayModeEnum.Name;
            boolean isFromForm = false;
            if (win instanceof BgNProcessUI) {
                ((BgNProcessUI)win).setSelectItem(true);
                isFromForm = !((BgNProcessUI)win).isTemplate();
            }
            BgSchemeDimensionHelper schemehelper = DimensionMemberSelectHelper.getSchemeHelper(win);
            List coll = (List)dialog.getData();
            if (range.size() > 0) {
                CellBlock block = range.getBlock(0);
                if (block.getRow() == block.getRow2() && block.getCol() != block.getCol2()) {
                    int index = 0;
                    int j = block.getRow();
                    for (int k = block.getCol(); k <= (coll.size() >= block.getCol2() - block.getCol() + 1 ? block.getCol() + coll.size() - 1 : block.getCol2()); ++k) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        BgDimensionMember member = (BgDimensionMember)coll.get(index % coll.size());
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_item", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", member.getNumber(), true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillSrcNumber", member.getSrcNumber(), true);
                        if (DimensionDisplayModeEnum.Number.equals((Object)bgItemShowStyle)) {
                            BgNTemplateHelper.setValue(cell, member.getNumber(), true);
                        } else if (DimensionDisplayModeEnum.NumberAndName.equals((Object)bgItemShowStyle)) {
                            BgNTemplateHelper.setValue(cell, member.getNumber() + " " + member.getName(), true);
                        } else {
                            BgNTemplateHelper.setValue(cell, member.getName(), true);
                        }
                        ++index;
                    }
                } else if (block.getCol() == block.getCol2()) {
                    int index = 0;
                    for (int j = block.getRow(); j <= (coll.size() >= block.getRow2() - block.getRow() + 1 ? block.getRow() + coll.size() - 1 : block.getRow2()); ++j) {
                        int k = block.getCol();
                        BgDimensionMember member = (BgDimensionMember)coll.get(index % coll.size());
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        sheet.getBook().setSkipListeners(true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_item", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", member.getNumber(), true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillSrcNumber", member.getSrcNumber(), true);
                        sheet.getBook().setSkipListeners(false);
                        if (DimensionDisplayModeEnum.Number.equals((Object)bgItemShowStyle)) {
                            BgNTemplateHelper.setValue(cell, member.getNumber(), true);
                        } else if (DimensionDisplayModeEnum.NumberAndName.equals((Object)bgItemShowStyle)) {
                            BgNTemplateHelper.setValue(cell, member.getNumber() + " " + member.getName(), true);
                        } else {
                            BgNTemplateHelper.setValue(cell, member.getName(), true);
                        }
                        if (isAutoCreateFormula) {
                            String bgItemNumber = DimensionFillHelper.getBgCombinItemNumber(sheet, j, k + 1, "bgFillValueType_item");
                            DimensionFillHelper.createItemFormulaFromContract(win, sheet, j, k + 1, bgItemNumber, srcBgPeriodNumber, srcCurrencyNumber, isFromForm, itemFormulaMap, false, isElementRequired, isScenarioRequired, isMustAllDim, filterValueMap);
                        }
                        ++index;
                    }
                    BgSpecialBudgetClientHelper.fillSpecialItem(win);
                    BgNTemplateHelper.dealWith(sheet.getBook(), orgUnitId, itemFormulaMap, !isFromForm, true, null, needItemVariable, isEnumForm, null, schemehelper, isMustAllDim, filterValueMap, isElementRequired, isScenarioRequired);
                    BgSpecialBudgetClientHelper.afterFillItemFormula(win);
                }
            }
        }
    }

    public static void showBgItem(IUIObject win, String bgSchemeId, Sheet sheet, boolean isAutoCreateFormula, String srcBgPeriodNumber, String srcCurrencyNumber, Map itemFormulaMap, Map itemGroup, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap) throws EASBizException, BOSException {
        DimensionFillHelper.showBgItem(win, bgSchemeId, sheet, isAutoCreateFormula, srcBgPeriodNumber, srcCurrencyNumber, itemFormulaMap, itemGroup, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, filterValueMap, true, true);
    }

    public static void showBgItem(IUIObject win, String bgSchemeId, Sheet sheet, boolean isAutoCreateFormula, String srcBgPeriodNumber, String srcCurrencyNumber, Map itemFormulaMap, Map itemGroup, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim) throws EASBizException, BOSException {
        DimensionFillHelper.showBgItem(win, bgSchemeId, sheet, isAutoCreateFormula, srcBgPeriodNumber, srcCurrencyNumber, itemFormulaMap, itemGroup, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, null, true, true);
    }

    public static void createBgFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isFromTemplate) throws BOSException, EASBizException {
        DimensionFillHelper.createBgFormula(win, sheet, value, formulaKind, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, filterValueMap, true, true, isFromTemplate);
    }

    public static void createBgFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired, boolean isFormTemplate) throws BOSException, EASBizException {
        Range cell;
        int k;
        int j;
        CellBlock block;
        int i;
        Range range = sheet.getSelectionRange();
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isPro = false;
        if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
            isPro = true;
        }
        range.setIgnoreProtected(true);
        Map mapSelectionCell = null;
        mapSelectionCell = BgNTemplateHelper.getSelectCells(sheet);
        int num = range.size();
        if (num <= 0) {
            logger.debug((Object)"range.size=0");
            return;
        }
        int maxCol = sheet.getMaxColIndex();
        int maxRow = sheet.getMaxRowIndex();
        boolean hasLock = false;
        for (i = 0; i < num; ++i) {
            block = range.getBlock(i);
            for (j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    cell = sheet.getRange(j, k);
                    if (cell == null || !isPro || !cell.isCellLocked()) continue;
                    hasLock = true;
                }
            }
        }
        if (hasLock) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"cellLock"));
            SysUtil.abort();
        }
        for (i = 0; i < num; ++i) {
            block = range.getBlock(i);
            for (j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    HashMap map;
                    if (sheet.getMergeBlock(j, k) != null || BgNTemplateHelper.getItemFormulaObject((Cell)(cell = sheet.getCell(j, k, false)), "bgFillType") != null) continue;
                    if (value instanceof BgFormInfo) {
                        if (isPro && BgNLockProtectHelper.isCellLocked((Cell)cell)) continue;
                        map = new HashMap();
                        DimensionFillHelper.initAllFormulaElement(sheet, j, k, map, mapSelectionCell);
                        DimensionFillHelper.subCreateBgFormula(sheet, map, j, k, value, formulaKind);
                        continue;
                    }
                    if (isPro && BgNLockProtectHelper.isCellLocked((Cell)cell)) continue;
                    map = new HashMap();
                    DimensionFillHelper.initAllFormulaElement(sheet, j, k, map, mapSelectionCell);
                    DimensionFillHelper.subCreateBgFormula(sheet, map, j, k, value, formulaKind);
                }
            }
            BgNTemplateHelper.dealWith(sheet.getBook(), orgUnitId, null, isFormTemplate, false, null, needItemVariable, isEnumForm, null, DimensionMemberSelectHelper.getSchemeHelper(win), isMustAllDim, filterValueMap, isElementRequired, isScenarioRequired);
        }
    }

    public static void createBgFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, boolean isFormTemplate) throws BOSException, EASBizException {
        DimensionFillHelper.createBgFormula(win, sheet, value, formulaKind, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, null, isFormTemplate);
    }

    public static String getBgCombinItemNumber(Sheet sheet, int rowIndex, int colIndex, String valueType) throws BOSException {
        String result = "";
        for (int m = colIndex - 1; m >= 0; --m) {
            Cell tmpCell = sheet.getCell(rowIndex, m, false);
            if (sheet.getMergeBlock(rowIndex, m) != null) {
                CellBlock blockMerge = sheet.getMergeBlock(rowIndex, m);
                tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
            }
            if (tmpCell == null || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").toString().equals(valueType)) continue;
            String number = StringUtils.cnulls((String)BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillValue"));
            String srcNumber = StringUtils.cnulls((String)BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillSrcNumber"));
            if (!StringUtils.isEmpty((String)number) && !StringUtils.isEmpty((String)srcNumber)) {
                result = DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber) ? DimensionFormulaHelper.getCombination(srcNumber, number) + "," + result : result + DimensionFormulaHelper.getCombination(srcNumber, number) + ",";
            }
            if (!valueType.equals("bgFillValueType_item")) break;
        }
        if (result.trim().length() > 0) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static void createItemFormulaFromContract(IUIObject win, Sheet sheet, int row, int col, String itemCombinStr, String srcBgPeriodNumber, String srcCurrencyNumber, boolean isFromForm, Map itemFormulaMap, boolean isEnumerateForm, boolean isElementRequired, boolean isScenarioRequired, boolean isMustAllDim, Map<String, Set<String>> filterValueMap) throws EASBizException, BOSException {
        for (int i = col; i <= sheet.getMaxColIndex(); ++i) {
            CellBlock blockMerge;
            Cell tmpCell;
            int k;
            CellBlock blockMerge2;
            Cell tmpCell2;
            int k2;
            String period = null;
            String scenario = null;
            String element = null;
            String currency = null;
            String bgItem = null;
            for (k2 = row - 1; k2 >= 0; --k2) {
                tmpCell2 = sheet.getCell(k2, i, false);
                if (sheet.getMergeBlock(k2, i) != null) {
                    blockMerge2 = sheet.getMergeBlock(k2, i);
                    tmpCell2 = sheet.getCell(blockMerge2.getRow(), blockMerge2.getCol(), true);
                }
                if (tmpCell2 == null || BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillType").toString().equals("bgFillValueType_scenario")) continue;
                scenario = BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillValue");
                break;
            }
            for (k2 = row - 1; k2 >= 0; --k2) {
                tmpCell2 = sheet.getCell(k2, i, false);
                if (sheet.getMergeBlock(k2, i) != null) {
                    blockMerge2 = sheet.getMergeBlock(k2, i);
                    tmpCell2 = sheet.getCell(blockMerge2.getRow(), blockMerge2.getCol(), true);
                }
                if (tmpCell2 == null || BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillType").toString().equals("bgFillValueType_period")) continue;
                period = BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillValue");
                break;
            }
            for (k2 = row - 1; k2 >= 0; --k2) {
                tmpCell2 = sheet.getCell(k2, i, false);
                if (sheet.getMergeBlock(k2, i) != null) {
                    blockMerge2 = sheet.getMergeBlock(k2, i);
                    tmpCell2 = sheet.getCell(blockMerge2.getRow(), blockMerge2.getCol(), true);
                }
                if (tmpCell2 == null || BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillType").toString().equals("bgFillValueType_item")) continue;
                bgItem = DimensionFormulaHelper.getCombination(BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillSrcNumber"), BgNTemplateHelper.getBgDataValue(tmpCell2, "bgFillValue"));
                break;
            }
            boolean isContinue = false;
            for (k = row - 1; k >= 0; --k) {
                tmpCell = sheet.getCell(k, i, false);
                if (sheet.getMergeBlock(k, i) != null) {
                    blockMerge = sheet.getMergeBlock(k, i);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), true);
                }
                if (tmpCell == null || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").toString().equals("bgFillValueType_element")) continue;
                element = BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillValue");
                String trueStr = BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula");
                if (trueStr == null || !trueStr.equals("false")) break;
                isContinue = true;
                break;
            }
            if (isContinue) continue;
            for (k = row - 1; k >= 0; --k) {
                tmpCell = sheet.getCell(k, i, false);
                if (sheet.getMergeBlock(k, i) != null) {
                    blockMerge = sheet.getMergeBlock(k, i);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), true);
                }
                if (tmpCell == null || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").toString().equals("bgFillValueType_currency")) continue;
                currency = BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillValue");
                break;
            }
            if (period == null && currency == null && (!isElementRequired || element == null) && (!isScenarioRequired || scenario == null || bgItem == null)) continue;
            Cell cell = sheet.getCell(row, i, true);
            if (sheet.getMergeBlock(row, i) != null) {
                blockMerge2 = sheet.getMergeBlock(row, i);
                cell = sheet.getCell(blockMerge2.getRow(), blockMerge2.getCol(), true);
            }
            if (cell == null) continue;
            boolean canEdit = BgNFSHelper.checkCanEditFormulaOfCell(cell);
            if (!isEnumerateForm && !canEdit) continue;
            String bgPeriodNumber = period == null ? "" : period.trim();
            String scenarioNumber = scenario == null ? "" : scenario.trim();
            String elementNumber = element == null ? "" : element.trim();
            String currencyNumber = currency == null ? "" : currency.trim();
            String itemCombinStr1 = bgItem == null ? itemCombinStr : itemCombinStr + "," + bgItem.trim();
            boolean isFillItemFormula = true;
            if (isMustAllDim && filterValueMap != null && !filterValueMap.isEmpty()) {
                for (String srcNumber : filterValueMap.keySet()) {
                    if (itemCombinStr1.indexOf(srcNumber + ":") >= 0) continue;
                    isFillItemFormula = false;
                    break;
                }
            }
            if (!isFillItemFormula) continue;
            if (isFromForm) {
                bgPeriodNumber = bgPeriodNumber.equals("") ? srcBgPeriodNumber : bgPeriodNumber;
                currencyNumber = currencyNumber.equals("") ? srcCurrencyNumber : currencyNumber;
            }
            String formulaLine = BgNFSHelper.getFormulaFromParam(new String[]{itemCombinStr1, bgPeriodNumber, elementNumber, scenarioNumber, currencyNumber});
            if (!isFromForm && itemFormulaMap != null) {
                itemFormulaMap.put(formulaLine, formulaLine);
            }
            BgNTemplateHelper.clearFormulaOfCell(cell, true);
            BgNTemplateHelper.setFormulaOfCell(cell, formulaLine, true, true);
            BgNTemplateHelper.setFormulaEditOfCell(cell, canEdit, true);
            BgSpecialBudgetClientHelper.addItemFormulaCell(win, cell);
        }
    }

    public static void createItemFormula(IUIObject win, Sheet sheet, IObjectValue value, Map itemFormulaMap, boolean isFromTemplate, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap) throws BOSException, EASBizException {
        DimensionFillHelper.createItemFormula(win, sheet, value, itemFormulaMap, isFromTemplate, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, filterValueMap, true, true);
    }

    public static void createItemFormula(IUIObject win, Sheet sheet, IObjectValue value, Map itemFormulaMap, boolean isFromTemplate, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim, Map<String, Set<String>> filterValueMap, boolean isElementRequired, boolean isScenarioRequired) throws BOSException, EASBizException {
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        Map mapSelectionCell = null;
        mapSelectionCell = BgNTemplateHelper.getSelectCells(sheet);
        int num = range.size();
        if (num <= 0) {
            return;
        }
        int maxCol = sheet.getMaxColIndex();
        int maxRow = sheet.getMaxRowIndex();
        for (int i = 0; i < num; ++i) {
            CellBlock block = range.getBlock(i);
            for (int j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (int k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    Cell cell;
                    if (sheet.getMergeBlock(j, k) != null || (cell = sheet.getCell(j, k, false)) != null && cell.getMerge(false) != null || BgNTemplateHelper.getItemFormulaObject(cell, "bgFillType") != null || cell != null && !BgNFSHelper.checkCanEditFormulaOfCell(cell)) continue;
                    HashMap map = new HashMap();
                    if (BgNTemplateHelper.checkHaveBgFillType(cell) && BgNTemplateHelper.checkHaveBgFillValue(cell)) continue;
                    DimensionFillHelper.initAllFormulaElement(sheet, j, k, map, mapSelectionCell);
                    DimensionFillHelper.subCreateItemFormula(win, sheet, map, j, k, value, itemFormulaMap, isFromTemplate);
                }
            }
        }
        BgSpecialBudgetClientHelper.fillSpecialItem(win);
        BgNTemplateHelper.dealWith(sheet.getBook(), orgUnitId, itemFormulaMap, isFromTemplate, true, null, needItemVariable, isEnumForm, null, DimensionMemberSelectHelper.getSchemeHelper(win), isMustAllDim, filterValueMap, isElementRequired, isScenarioRequired);
        BgSpecialBudgetClientHelper.afterFillItemFormula(win);
    }

    public static void createItemFormula(IUIObject win, Sheet sheet, IObjectValue value, Map itemFormulaMap, boolean isFromTemplate, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim) throws BOSException, EASBizException {
        DimensionFillHelper.createItemFormula(win, sheet, value, itemFormulaMap, isFromTemplate, needItemVariable, isEnumForm, orgUnitId, isMustAllDim, null);
    }

    public static void initAllFormulaElement(Sheet sheet, int rowIndex, int colIndex, HashMap map, Map mapSelectionCell) throws BOSException, EASBizException {
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            DimensionFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_item", mapSelectionCell);
            DimensionFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_element", mapSelectionCell);
            DimensionFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_period", mapSelectionCell);
            DimensionFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_currency", mapSelectionCell);
            DimensionFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_scenario", mapSelectionCell);
        }
    }

    public static void subCreateItemFormula(IUIObject win, Sheet sheet, HashMap map, int rowIndex, int colIndex, IObjectValue value, Map itemFormulaMap, boolean isFromTemplate) {
        String scenarioNumber;
        if (map.isEmpty()) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        if (!map.isEmpty() && map.get("isAttachFormula") != null && map.get("isAttachFormula").toString().equals("false")) {
            return;
        }
        String itemCombinStr = map.get("bgFillValueType_item") == null ? "" : map.get("bgFillValueType_item").toString();
        String bgPeriodNumber = map.get("bgFillValueType_period") == null ? "" : map.get("bgFillValueType_period").toString();
        String elementNumber = map.get("bgFillValueType_element") == null ? "" : map.get("bgFillValueType_element").toString();
        String currencyNumber = map.get("bgFillValueType_currency") == null ? "" : map.get("bgFillValueType_currency").toString();
        String string = scenarioNumber = map.get("bgFillValueType_scenario") == null ? "" : map.get("bgFillValueType_scenario").toString();
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
        }
        String formulaLine = BgNFSHelper.getFormulaFromParam(itemCombinStr, bgPeriodNumber, elementNumber, currencyNumber, scenarioNumber);
        Cell cell = sheet.getCell(rowIndex, colIndex, true);
        BgNTemplateHelper.setFormulaOfCell(cell, formulaLine, true, true);
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            BgSpecialBudgetClientHelper.addItemFormulaCell(win, cell);
            if (isFromTemplate) {
                itemFormulaMap.put(formulaLine, formulaLine);
            }
            BgNTemplateHelper.setFormulaEditOfCell(cell, true, true);
        }
    }

    public static void subCreateBgFormula(Sheet sheet, HashMap map, int rowIndex, int colIndex, IObjectValue value, String formulaKind) {
        if (map.isEmpty()) {
            return;
        }
        Cell cell = sheet.getCell(rowIndex, colIndex, true);
        if (BgNTemplateHelper.checkHaveBgFillType(cell)) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        if (!map.isEmpty() && map.get("isAttachFormula") != null && map.get("isAttachFormula").toString().equals("false")) {
            return;
        }
        String itemCombinStr = map.get("bgFillValueType_item") == null ? "" : map.get("bgFillValueType_item").toString();
        String bgPeriodNumber = map.get("bgFillValueType_period") == null ? "" : map.get("bgFillValueType_period").toString();
        String elementNumber = map.get("bgFillValueType_element") == null ? "" : map.get("bgFillValueType_element").toString();
        String currencyNumber = map.get("bgFillValueType_currency") == null ? "" : map.get("bgFillValueType_currency").toString();
        String scenarioNumber = map.get("bgFillValueType_scenario") == null ? "" : map.get("bgFillValueType_scenario").toString();
        String beginTime = null;
        String endTime = null;
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            beginTime = "";
            endTime = "";
        } else {
            beginTime = BgNFillHelper.getBeginTime(bgPeriodNumber);
            endTime = BgNFillHelper.getEndTime(bgPeriodNumber);
        }
        String periodType = "MONTH";
        String aggregateType = "budget";
        String actualType = "all";
        String orgNumber = "";
        String bgSchemeNumber = "";
        String versionNumber = "";
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
            orgNumber = info.getOrgUnit().getNumber();
            bgSchemeNumber = info.getBgScheme().getNumber();
            beginTime = String.valueOf(info.getBgPeriod().getBeginDate());
            endTime = String.valueOf(info.getBgPeriod().getEndDate());
        }
        int isEleNotNullCount = 0;
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            ++isEleNotNullCount;
        }
        if (!StringUtils.isEmpty((String)bgPeriodNumber)) {
            ++isEleNotNullCount;
        }
        if (!StringUtils.isEmpty((String)elementNumber)) {
            ++isEleNotNullCount;
        }
        if (!StringUtils.isEmpty((String)itemCombinStr)) {
            ++isEleNotNullCount;
        }
        if (isEleNotNullCount < 2) {
            return;
        }
        String _formula = null;
        _formula = formulaKind.equalsIgnoreCase("BgAvlBal") || formulaKind.equalsIgnoreCase("BgAvlBalF") ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\")" : (formulaKind.equalsIgnoreCase("BgActualExt") || formulaKind.equalsIgnoreCase("BgActualExtF") ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + beginTime + "\",\"" + endTime + "\",\"" + periodType + "\")" : (formulaKind.equalsIgnoreCase("MbgActualS") || formulaKind.equalsIgnoreCase("BgActualExtF") ? FormulaUtils.getMbgActualsExp(orgNumber, bgSchemeNumber, scenarioNumber, itemCombinStr, bgPeriodNumber, bgPeriodNumber, versionNumber, currencyNumber, elementNumber, null) : (formulaKind.equalsIgnoreCase("MbgAggregate") || formulaKind.equalsIgnoreCase("BgActualExtF") ? FormulaUtils.getMbgAggregateExp(orgNumber, bgSchemeNumber, scenarioNumber, itemCombinStr, bgPeriodNumber, bgPeriodNumber, versionNumber, currencyNumber, elementNumber, null, null, null) : (formulaKind.equalsIgnoreCase("MbgFormula") || formulaKind.equalsIgnoreCase("BgActualExtF") ? FormulaUtils.getMbgFormulaExp(orgNumber, bgSchemeNumber, scenarioNumber, itemCombinStr, bgPeriodNumber, bgPeriodNumber, versionNumber, currencyNumber, elementNumber) : "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\")"))));
        BgNFSHelper.setExpression(cell, _formula);
    }

    public static void initFormulaElement(Sheet sheet, int rowIndex, int colIndex, CellBlock block, HashMap map, String elementType, Map mapSelectionCell) throws BOSException {
        int y;
        int x;
        CellBlock mergeBlock;
        CellBlock blockMerge;
        Cell tmpCell;
        int m;
        int minRow = block.getRow();
        int maxRow = Math.min(sheet.getMaxRowIndex(), block.getRow2());
        int minCol = block.getCol();
        int maxCol = Math.min(sheet.getMaxColIndex(), block.getCol2());
        boolean isInit = false;
        for (m = rowIndex - 1; m >= minRow; --m) {
            tmpCell = sheet.getCell(m, colIndex, false);
            if (sheet.getMergeBlock(m, colIndex) != null) {
                blockMerge = sheet.getMergeBlock(m, colIndex);
                tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
            }
            if (tmpCell == null || !DimensionFillHelper.isInBlock(tmpCell, block)) continue;
            if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                mergeBlock = tmpCell.getMerge(false);
                x = mergeBlock.getRow();
                y = mergeBlock.getCol();
                tmpCell = sheet.getCell(x, y, false);
            }
            if (!DimensionFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
            if (elementType.equals("bgFillValueType_element")) {
                map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
            }
            if (elementType.equals("bgFillValueType_item")) {
                DimensionFillHelper.buildItemCombination(tmpCell, map);
                continue;
            }
            map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
            isInit = true;
            break;
        }
        if (!isInit) {
            for (m = rowIndex + 1; m <= maxRow; ++m) {
                tmpCell = sheet.getCell(m, colIndex, false);
                if (sheet.getMergeBlock(m, colIndex) != null) {
                    blockMerge = sheet.getMergeBlock(m, colIndex);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
                }
                if (tmpCell == null || !DimensionFillHelper.isInBlock(tmpCell, block)) continue;
                if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                    tmpCell.getMerge(false);
                    mergeBlock = tmpCell.getMerge(false);
                    x = mergeBlock.getRow();
                    y = mergeBlock.getCol();
                    tmpCell = sheet.getCell(x, y, false);
                }
                if (!DimensionFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
                if (elementType.equals("bgFillValueType_element")) {
                    map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
                }
                if (elementType.equals("bgFillValueType_item")) {
                    DimensionFillHelper.buildItemCombination(tmpCell, map);
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                isInit = true;
                break;
            }
        }
        if (!isInit) {
            for (m = colIndex - 1; m >= minCol; --m) {
                tmpCell = sheet.getCell(rowIndex, m, false);
                if (sheet.getMergeBlock(rowIndex, m) != null) {
                    blockMerge = sheet.getMergeBlock(rowIndex, m);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
                }
                if (tmpCell == null || !DimensionFillHelper.isInBlock(tmpCell, block)) continue;
                if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                    mergeBlock = tmpCell.getMerge(false);
                    x = mergeBlock.getRow();
                    y = mergeBlock.getCol();
                    tmpCell = sheet.getCell(x, y, false);
                }
                if (!DimensionFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
                if (elementType.equals("bgFillValueType_element")) {
                    map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
                }
                if (elementType.equals("bgFillValueType_item")) {
                    DimensionFillHelper.buildItemCombination(tmpCell, map);
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                isInit = true;
                break;
            }
        }
        if (!isInit) {
            for (m = colIndex + 1; m <= maxCol; ++m) {
                tmpCell = sheet.getCell(rowIndex, m, false);
                if (sheet.getMergeBlock(rowIndex, m) != null) {
                    blockMerge = sheet.getMergeBlock(rowIndex, m);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
                }
                if (tmpCell == null || !DimensionFillHelper.isInBlock(tmpCell, block)) continue;
                if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                    mergeBlock = tmpCell.getMerge(false);
                    x = mergeBlock.getRow();
                    y = mergeBlock.getCol();
                    tmpCell = sheet.getCell(x, y, false);
                }
                if (!DimensionFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
                if (elementType.equals("bgFillValueType_element")) {
                    map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
                }
                if (elementType.equals("bgFillValueType_item")) {
                    DimensionFillHelper.buildItemCombination(tmpCell, map);
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                isInit = true;
                break;
            }
        }
    }

    private static void buildItemCombination(Cell cell, Map map) throws BOSException {
        if (cell == null || map == null) {
            return;
        }
        String result = "";
        if (map.get("bgFillValueType_item") != null) {
            result = (String)map.get("bgFillValueType_item");
        }
        String number = StringUtils.cnulls((String)BgNTemplateHelper.getBgDataValue(cell, "bgFillValue"));
        String srcNumber = StringUtils.cnulls((String)BgNTemplateHelper.getBgDataValue(cell, "bgFillSrcNumber"));
        if (!StringUtils.isEmpty((String)number) && !StringUtils.isEmpty((String)srcNumber)) {
            if (!StringUtils.isEmpty((String)result)) {
                result = result + ",";
            }
            result = result + DimensionFormulaHelper.getCombination(srcNumber, number);
        }
        map.put("bgFillValueType_item", result);
    }

    private static boolean isInBlock(Cell cell, CellBlock block) {
        if (cell == null || block == null) {
            return false;
        }
        int minRow = block.getRow();
        int maxRow = block.getRow2();
        int minCol = block.getCol();
        int maxCol = block.getCol2();
        return cell.getRow() >= minRow && cell.getRow() <= maxRow && cell.getCol() >= minCol && cell.getCol() <= maxCol;
    }

    public static boolean isInBlock(Cell cell, Map mapSelectionCell) {
        if (cell == null || mapSelectionCell == null || mapSelectionCell.isEmpty()) {
            return false;
        }
        return mapSelectionCell.containsKey(cell.getRow() + "-" + cell.getCol());
    }
}

