/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.client.IRptDataPublisher;
import com.kingdee.eas.fi.rpt.client.RptFormulaCompProxyFactory;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumEntry;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumType;
import com.kingdee.eas.fi.rpt.client.RptOperObject;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MbgCorDimensionMemberSelectHelper
extends DimensionMemberSelectHelper {
    private Set<String> excludeCorDim = new HashSet<String>();

    public void setExcludeCorDim(Set<String> excludeCorDim) {
        this.excludeCorDim = excludeCorDim;
    }

    public MbgCorDimensionMemberSelectHelper(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        super(schemeHelper);
    }

    @Override
    public void loadDimension(boolean isOnlyRefDim, boolean isOnlySelectItem, BgDimensionBaseInfo dimensionInfo, Map<String, Set<String>> filterValueMap, boolean isHideOrg) {
        super.loadDimension(isOnlyRefDim, isOnlySelectItem, dimensionInfo, filterValueMap, isHideOrg);
        this.excludeCorDimAndCsl();
    }

    private void excludeCorDimAndCsl() {
        Iterator it = this.dimensions.iterator();
        while (it.hasNext()) {
            BgDimensionInfo dim = (BgDimensionInfo)it.next();
            if (dim.getType().equals(DimensionConstants.DEF_CSL_NUMBER)) {
                it.remove();
                continue;
            }
            if (this.excludeCorDim.isEmpty() || !this.excludeCorDim.contains(dim.getNumber())) continue;
            it.remove();
        }
    }

    public void loadCorDimension(KDComboBox corUnitItemBox, KDTextField corUnitItemTxt) {
        Object obj;
        this.loadDimension(true, true, null, null, false);
        if (this.dimensions != null && this.dimensions.size() > 0 && (obj = RptFormulaCompProxyFactory.getInstance().getDataType("corUnitItemStr")) instanceof RptFormulaEnumType) {
            RptFormulaEnumType corUnitItemStr = (RptFormulaEnumType)obj;
            RptOperObject itemAt = (RptOperObject)corUnitItemBox.getItemAt(0);
            corUnitItemBox.removeAllItems();
            corUnitItemBox.addItem((Object)itemAt);
            corUnitItemStr.clear();
            corUnitItemStr.publish(itemAt);
            if (StringUtils.isEmpty((String)corUnitItemTxt.getText())) {
                corUnitItemBox.setSelectedItem((Object)itemAt, false);
            }
            String corUnitDisplayTxt = corUnitItemTxt.getText();
            for (BgDimensionBaseInfo baseInfo : this.dimensions) {
                RptFormulaEnumEntry entry = new RptFormulaEnumEntry(baseInfo.getNumber(), (IRptDataPublisher)corUnitItemStr);
                entry.setLocalName("en_US", baseInfo.getName());
                entry.setLocalName("zh_CN", baseInfo.getName());
                entry.setLocalName("zh_TW", baseInfo.getName());
                corUnitItemBox.addItem((Object)entry);
                if (baseInfo.getNumber().equalsIgnoreCase(corUnitItemTxt.getText())) {
                    corUnitItemBox.setSelectedItem((Object)entry, false);
                    corUnitDisplayTxt = baseInfo.getName();
                }
                corUnitItemStr.publish((RptOperObject)entry);
            }
            corUnitItemTxt.setText(corUnitDisplayTxt);
        }
    }
}

