/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.OrderObject;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.IMbgDataStateSynFacade;
import com.kingdee.eas.ma.mbg.MbgDataStateSynFacadeFactory;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.MbgDataStateSynNewProgressUI;
import com.kingdee.eas.ma.mbg.client.MbgDataStateSynNewUI;
import com.kingdee.eas.ma.mbg.client.MbgDataStateSynResultUI;
import com.kingdee.eas.ma.mbg.client.MbgDataStateSynUI;
import com.kingdee.eas.ma.mbg.client.ProgressDialogUI;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.utils.BgTemplateObject;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataStateSynClientHelper {
    private static Logger logger = Logger.getLogger((String)MbgDataStateSynClientHelper.class.getName());
    public static final String RESOURCE = "com.kingdee.eas.ma.mbg.MbgDataStateSynResource";
    private static OrderObject orgKey = new OrderObject("orgUnit", MbgDataStateSynClientHelper.getString("orgUnit"), 0);
    private static OrderObject bgTemplateKey = new OrderObject("bgTemplate", MbgDataStateSynClientHelper.getString("bgTemplate"), 1);
    private static OrderObject bgPeriodKey = new OrderObject("bgPeriod", MbgDataStateSynClientHelper.getString("bgPeriod"), 2);
    private static OrderObject bgVersionKey = new OrderObject("bgVersion", MbgDataStateSynClientHelper.getString("bgVersion"), 3);
    private static OrderObject currencyKey = new OrderObject("currency", MbgDataStateSynClientHelper.getString("currency"), 4);
    private static OrderObject bgFormKey = new OrderObject("bgForm", MbgDataStateSynClientHelper.getString("bgForm"), 5);
    private static OrderObject resultKey = new OrderObject("result", MbgDataStateSynClientHelper.getString("result"), 6);
    private static OrderObject detailKey = new OrderObject("detail", MbgDataStateSynClientHelper.getString("detail"), 7);

    public static final String getString(String msgKey) {
        return EASResource.getString((String)RESOURCE, (String)msgKey);
    }

    public static void startSyn(MbgDataStateSynUI ownerUi, BgSchemeInfo bgScheme, Object bgOrgUnits, Object bgTemplates, Object bgPeriods, Object bgVersions, Object currencies) throws Exception {
        String bgSchemeId = bgScheme.getId().toString();
        Set<String> bgOrgUnitIds = MbgDataStateSynClientHelper.getIdSet(bgOrgUnits);
        Set<String> bgTemplateIds = MbgDataStateSynClientHelper.getIdSet(bgTemplates);
        Set<String> bgPeriodIds = MbgDataStateSynClientHelper.getIdSet(bgPeriods);
        Set<String> bgVersionIds = MbgDataStateSynClientHelper.getIdSet(bgVersions);
        Set<String> currencyIds = MbgDataStateSynClientHelper.getIdSet(currencies);
        BgFormCollection bgFormCol = MbgDataStateSynFacadeFactory.getRemoteInstance().queryBgForm(bgSchemeId, bgOrgUnitIds, bgTemplateIds, bgPeriodIds, bgVersionIds, currencyIds, BgFormStateEnum.Approved);
        if (bgFormCol == null || bgFormCol.isEmpty()) {
            MsgBox.showInfo((Component)((Object)ownerUi), (String)MbgDataStateSynClientHelper.getString("noFondBgForm"));
            return;
        }
        SimpleTimer time = new SimpleTimer();
        UIContext map = new UIContext((Object)ownerUi);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            ui.setUITitle(ownerUi.getUITitle());
            ui.setShowTableMessage(true);
            logger.debug((Object)("begin initParameterValue" + time.getTime() + ""));
            MbgDataStateSynClientHelper.initParameterValue(ui, bgFormCol);
            logger.debug((Object)("begin init" + time.getTime() + ""));
            ui.init();
            logger.debug((Object)("begin show" + time.getTime() + ""));
            window.show();
        }
    }

    private static void initParameterValue(ProgressDialogUI ui, BgFormCollection bgFormCol) {
        ui.setInvokeClass(MbgDataStateSynClientHelper.class.getName());
        ui.setInvokeMethod("invokeMethod");
        Class[] cls = new Class[]{BgFormInfo.class, BgFormInfo.class};
        ui.setInvokeMethodParmeterType(cls);
        BgFormInfo thisBgForm = null;
        BgFormInfo lastBgForm = null;
        Object[][] params = new Object[bgFormCol.size() + 1][];
        for (int i = 0; i < bgFormCol.size(); ++i) {
            thisBgForm = bgFormCol.get(i);
            params[i] = new Object[]{lastBgForm, thisBgForm};
            lastBgForm = thisBgForm;
        }
        params[bgFormCol.size()] = new Object[]{lastBgForm, null};
        ui.setInvokeMethodParmeterValue(params);
        ui.setCountSum(bgFormCol.size());
    }

    public Object invokeMethod(BgFormInfo thisForm, BgFormInfo nextForm) {
        Object[] obj = new Object[3];
        if (nextForm != null) {
            obj[0] = MessageFormat.format(MbgDataStateSynClientHelper.getString("processTitle"), nextForm.getOrgUnit().getNumber(), nextForm.getNumber());
        }
        if (thisForm != null) {
            HashMap<OrderObject, String> result = new HashMap<OrderObject, String>();
            result.put(orgKey, thisForm.getOrgUnit().getName());
            result.put(bgTemplateKey, thisForm.getBgTemplate().getName());
            result.put(bgPeriodKey, thisForm.getBgPeriod().getName());
            result.put(bgVersionKey, thisForm.getBgVersion().getName());
            result.put(currencyKey, thisForm.getCurrency().getName());
            result.put(bgFormKey, thisForm.getName());
            result.put(resultKey, MbgDataStateSynClientHelper.getString("success"));
            result.put(detailKey, "");
            obj[1] = result;
            try {
                MbgDataStateSynFacadeFactory.getRemoteInstance().executeSyn(thisForm.getId().toString());
            }
            catch (EASBizException e) {
                logger.error((Object)"", (Throwable)e);
                result.put(resultKey, MbgDataStateSynClientHelper.getString("exception"));
                result.put(detailKey, e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                result.put(resultKey, MbgDataStateSynClientHelper.getString("exception"));
                result.put(detailKey, e.getMessage());
            }
        }
        return obj;
    }

    public static Set<String> getIdSet(Object obj) {
        HashSet<String> ids = new HashSet<String>();
        if (obj instanceof IObjectCollection) {
            obj = ((IObjectCollection)obj).toArray();
        } else if (obj instanceof Collection) {
            obj = ((Collection)obj).toArray();
        }
        if (obj instanceof Object[]) {
            Object[] objs = obj;
            for (int i = 0; i < objs.length; ++i) {
                MbgDataStateSynClientHelper.addId(ids, objs[i]);
            }
        } else {
            MbgDataStateSynClientHelper.addId(ids, obj);
        }
        return ids;
    }

    public static void addId(Set<String> ids, Object obj) {
        if (obj instanceof CoreBaseInfo && ((CoreBaseInfo)obj).getId() != null) {
            ids.add(((CoreBaseInfo)obj).getId().toString());
        }
    }

    public static void actionMbgDataStateSyn(CoreUI ui, List bgFormIds, OrgUnitInfo costCenter, BgSchemeInfo bgScheme, RptSrcTypeEnum SourceType) throws Exception {
        CommonQueryDialog dialog = MbgDataStateSynClientHelper.getDialog(ui, bgFormIds, costCenter, bgScheme, SourceType);
        if (dialog != null && dialog.show()) {
            MbgDataStateSynNewUI userPanel = (MbgDataStateSynNewUI)dialog.getUserPanel(0);
            userPanel.setOrgUnit(costCenter);
            userPanel.actionDataStateSyn_actionPerformed();
        }
    }

    public static CommonQueryDialog getDialog(CoreUI ui, List bgFormIds, OrgUnitInfo costCenter, BgSchemeInfo bgScheme, RptSrcTypeEnum SourceType) {
        CommonQueryDialog dialog = null;
        try {
            dialog = MbgDataStateSynClientHelper.getCommonQueryDialog(ui, bgFormIds, costCenter, bgScheme, SourceType);
        }
        catch (Exception e) {
            ui.handUIException((Throwable)e);
        }
        return dialog;
    }

    protected static CommonQueryDialog getCommonQueryDialog(CoreUI ui, List bgFormIds, OrgUnitInfo costCenter, BgSchemeInfo bgScheme, RptSrcTypeEnum SourceType) throws Exception {
        CommonQueryDialog dialog = new CommonQueryDialog();
        MbgDataStateSynNewUI mbgDataStateSynNewUI = MbgDataStateSynClientHelper.getDefEditUI(ui, bgFormIds, costCenter, bgScheme, SourceType);
        dialog.setOwner((Component)ui);
        dialog.setParentUIClassName(ui.getMetaDataPK().getFullName());
        dialog.setEntityViewInfo(new EntityViewInfo());
        dialog.setQueryObjectPK(ui.getMetaDataPK());
        dialog.setWidth(400);
        dialog.setHeight(450);
        dialog.setParentUIClassName(ui.getClass().getName() + "_EDIT");
        dialog.addUserPanel((KDPanel)mbgDataStateSynNewUI);
        dialog.setTitle(mbgDataStateSynNewUI.getUITitle());
        dialog.setShowFilter(false);
        dialog.setShowSorter(false);
        return dialog;
    }

    private static MbgDataStateSynNewUI getDefEditUI(CoreUI ui, List bgFormIds, OrgUnitInfo costCenter, BgSchemeInfo bgScheme, RptSrcTypeEnum SourceType) {
        MbgDataStateSynNewUI defEditUI = null;
        try {
            defEditUI = new MbgDataStateSynNewUI(ui, bgScheme);
            defEditUI.getUIContext().put("sourceType", SourceType);
            defEditUI.getUIContext().put(BgBaseConstants.ORGUNIT_INFO, costCenter);
            defEditUI.getUIContext().put("BGFORM_IDS", bgFormIds);
        }
        catch (Exception e) {
            ui.handUIException((Throwable)e);
        }
        return defEditUI;
    }

    public static void startSynNew(MbgDataStateSynNewUI ownerUi, BgSchemeInfo bgScheme, Object bgOrgUnits, Object bgTemplates, Object bgPeriods, Object bgVersions, Object currencies, BgFormStateEnum bgFormState) throws Exception {
        String bgSchemeId = bgScheme.getId().toString();
        Set<String> bgOrgUnitIds = MbgDataStateSynClientHelper.getBgOrgUnitIds(bgScheme, bgOrgUnits);
        Set<String> bgTemplateIds = MbgDataStateSynClientHelper.getBgTemplateIds(bgTemplates);
        Set<String> bgPeriodIds = MbgDataStateSynClientHelper.getIdSet(bgPeriods);
        Set<String> bgVersionIds = MbgDataStateSynClientHelper.getIdSet(bgVersions);
        Set<String> currencyIds = MbgDataStateSynClientHelper.getIdSet(currencies);
        BgFormCollection bgFormCol = MbgDataStateSynFacadeFactory.getRemoteInstance().queryBgForm(bgSchemeId, bgOrgUnitIds, bgTemplateIds, bgPeriodIds, bgVersionIds, currencyIds, bgFormState);
        if (bgFormCol == null || bgFormCol.isEmpty()) {
            MsgBox.showInfo((Component)((Object)ownerUi), (String)MbgDataStateSynClientHelper.getString("noFondBgForm"));
            return;
        }
        UIContext uiContext = new UIContext((Object)ownerUi);
        uiContext.put((Object)"BGFORM_INFO", (Object)bgFormCol);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(MbgDataStateSynNewProgressUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, 16);
        uiWindow.show();
    }

    public static Boolean checkHasBgForms(MbgDataStateSynNewUI ownerUi, BgSchemeInfo bgScheme, Object bgOrgUnits, Object bgTemplates, Object bgPeriods, Object bgVersions, Object currencies, BgFormStateEnum bgFormState) throws EASBizException, BOSException {
        String bgSchemeId = bgScheme.getId().toString();
        Set<String> bgOrgUnitIds = MbgDataStateSynClientHelper.getBgOrgUnitIds(bgScheme, bgOrgUnits);
        Set<String> bgTemplateIds = MbgDataStateSynClientHelper.getBgTemplateIds(bgTemplates);
        Set<String> bgPeriodIds = MbgDataStateSynClientHelper.getIdSet(bgPeriods);
        Set<String> bgVersionIds = MbgDataStateSynClientHelper.getIdSet(bgVersions);
        Set<String> currencyIds = MbgDataStateSynClientHelper.getIdSet(currencies);
        BgFormCollection bgFormCol = MbgDataStateSynFacadeFactory.getRemoteInstance().queryBgForm(bgSchemeId, bgOrgUnitIds, bgTemplateIds, bgPeriodIds, bgVersionIds, currencyIds, bgFormState);
        if (bgFormCol == null || bgFormCol.isEmpty()) {
            return false;
        }
        return true;
    }

    public static void showResult(CoreUI ownerUi, List result) throws UIException {
        UIContext uiContext = new UIContext((Object)ownerUi);
        uiContext.put((Object)"EXAMINE_DATA", (Object)result);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MbgDataStateSynResultUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected static Set<String> getBgOrgUnitIds(BgSchemeInfo bgSchemeInfo, Object bgOrgUnits) throws BOSException, EASBizException {
        Set<String> ids = new HashSet<String>();
        if (bgSchemeInfo != null && bgOrgUnits instanceof MbgViewListResultData && !((MbgViewListResultData)bgOrgUnits).getMembers().isEmpty()) {
            List members = ((MbgViewListResultData)bgOrgUnits).getMembers();
            ids = MbgDataStateSynClientHelper.getFacade().queryBgOrgIds(bgSchemeInfo, members);
        }
        return ids;
    }

    protected static Set<String> getBgTemplateIds(Object bgTemplates) {
        HashSet<String> ids = new HashSet<String>();
        if (bgTemplates instanceof BgTemplateObject && ((BgTemplateObject)bgTemplates).getResult() != null && !((BgTemplateObject)bgTemplates).getResult().isEmpty()) {
            BgTemplateCollection colls = ((BgTemplateObject)bgTemplates).getResult();
            for (int i = 0; i < colls.size(); ++i) {
                ids.add(colls.get(i).getId().toString());
            }
        }
        return ids;
    }

    public static IMbgDataStateSynFacade getFacade() throws BOSException {
        return MbgDataStateSynFacadeFactory.getRemoteInstance();
    }
}

