/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IMbgQingAnalyse;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.client.utils.PropertiesDimMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.LineFlowLayout;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class MbgQingAnalyseUtils {
    public static final String PROPERTIES_F7_NAME = "propertiesContainer";
    public static final String PANEL_NAME = "propertiesPanel";
    private KDTabbedPane tabbedPane = null;
    private IProvider provider = null;
    private String bgSchemeId = null;
    private Map<String, BgDimensionInfo> dimensions = null;
    private Map<String, List<Map<String, List<BgDimensionMember>>>> propertiesDimension = null;
    private KDPanel analyse = null;

    public KDTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setTabbedPane(KDTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    public IProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IProvider provider) {
        this.provider = provider;
    }

    public Map<String, BgDimensionInfo> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, BgDimensionInfo> dimensions) {
        this.dimensions = dimensions;
    }

    public String getBgSchemeId() {
        return this.bgSchemeId;
    }

    public void setBgSchemeId(String bgSchemeId) {
        this.bgSchemeId = bgSchemeId;
    }

    public Map<String, List<Map<String, List<BgDimensionMember>>>> getPropertiesDimension() {
        return this.propertiesDimension;
    }

    public void setPropertiesDimension(Map<String, List<Map<String, List<BgDimensionMember>>>> propertiesDimension) {
        this.propertiesDimension = propertiesDimension;
    }

    public KDPanel getAnalyse() {
        return this.analyse;
    }

    public void setAnalyse(KDPanel analyse) {
        this.analyse = analyse;
    }

    public void initDimensions() throws BOSException, EASBizException {
        Map initPropertiesDimension = MbgQingAnalyseFacadeFactory.getRemoteInstance().initPropertiesDimension((MbgViewListManager)this.provider.getCurMbgViewManager(), this.provider.getBgSchemeInfo().getId().toString(), this.provider.getOrgUnitId());
        if (initPropertiesDimension != null && !initPropertiesDimension.isEmpty()) {
            this.setPropertiesDimension(initPropertiesDimension);
        }
        if (this.provider != null && this.provider instanceof MBGViewListFormProvider) {
            MBGViewListFormProvider viewListProvider = (MBGViewListFormProvider)this.provider;
            List<BgDimensionInfo> allDimensions = viewListProvider.getSchemeHelper().getAllDimensions();
            HashMap<String, BgDimensionInfo> dimensions = new HashMap<String, BgDimensionInfo>();
            for (BgDimensionInfo info : allDimensions) {
                if (DimensionConstants.canNotCancelProp.contains(info.getNumber())) continue;
                dimensions.put(info.getNumber(), info);
            }
            this.setDimensions(dimensions);
        }
    }

    public static boolean verifyAnalyse(IMbgQingAnalyse MbgQingAnalyse2, String analyseId, OrgUnitInfo orgUnitInfo, BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        MbgQingAnalyseInfo info = MbgQingAnalyse2.getMbgQingAnalyseInfo((IObjectPK)new ObjectUuidPK(analyseId));
        Map filterMap = MbgQingAnalyseFacadeFactory.getRemoteInstance().getQingAnalyseFilter(analyseId, bgSchemeInfo.getId().toString(), info.getOrgUnitId().toString(), true);
        List limitMember = (List)filterMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER + "_" + "NUM");
        if (limitMember != null && !limitMember.isEmpty()) {
            Map<String, String> childrenOrgUnitMap = MbgQingAnalyseHelper.getChildrenOrgUnit(null, orgUnitInfo.getId().toString(), MbgQingAnalyseHelper.getOrgViewInfo(null, bgSchemeInfo).getId().toString());
            HashSet<String> childNumbers = new HashSet<String>();
            for (Map.Entry<String, String> entry : childrenOrgUnitMap.entrySet()) {
                childNumbers.add(entry.getValue());
            }
            for (String member : limitMember) {
                if (childNumbers.contains(member)) continue;
                return false;
            }
        }
        return true;
    }

    public KDPanel initPageDimensionPanel() throws Exception {
        KDPanel propertiesPnl = new KDPanel();
        propertiesPnl.setLayout((LayoutManager)new LineFlowLayout(0));
        propertiesPnl.setName(PANEL_NAME);
        propertiesPnl.add((Component)this.createF7Container());
        propertiesPnl.setVisible(true);
        return propertiesPnl;
    }

    protected KDBizPromptBox getBizPromptBox() {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setCommitFormat("$number$");
        bizPromptBox.setEditable(false);
        return bizPromptBox;
    }

    private KDLabelContainer createF7Container() throws EASBizException, BOSException {
        KDLabelContainer cont = this.createContainer();
        cont.setBoundLabelText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"propertiesText"));
        cont.setBoundEditor((JComponent)this.getPropertiesDimensionF7());
        cont.setName(PROPERTIES_F7_NAME);
        return cont;
    }

    protected PropertiesDimMemberDialog getPropertiesDimMemberSelectDialog() {
        PropertiesDimMemberDialog dialog = new PropertiesDimMemberDialog();
        dialog.setMulti(false);
        dialog.setDimensions(this.dimensions);
        dialog.setAnalyse(this.analyse);
        dialog.setProvider(this.provider);
        dialog.setBgSchemeId(this.provider.getBgSchemeInfo().getId().toString());
        dialog.setPropertiesDimension(this.propertiesDimension);
        return dialog;
    }

    private KDLabelContainer createContainer() {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setBounds(new Rectangle(240, 19));
        cont.setBoundLabelLength(80);
        cont.setBoundLabelUnderline(true);
        cont.setPreferredSize(new Dimension(240, 19));
        cont.setMinimumSize(new Dimension(240, 19));
        return cont;
    }

    private KDBizPromptBox getPropertiesDimensionF7() throws EASBizException, BOSException {
        PropertiesDimMemberDialog dialog = this.getPropertiesDimMemberSelectDialog();
        KDBizPromptBox bizPromptBox = this.getBizPromptBox();
        BgCommHelper.removeUndo((KDBizPromptBox)bizPromptBox);
        bizPromptBox.setSelector((KDPromptSelector)dialog);
        bizPromptBox.addDataChangeListener((DataChangeListener)dialog);
        if (this.propertiesDimension != null && this.propertiesDimension.size() == 1) {
            String propertySortId2 = null;
            Set<String> keySet = this.propertiesDimension.keySet();
            for (String propertySortId2 : keySet) {
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("name");
            selector.add("sourceType");
            selector.add("mbgDim.id");
            selector.add("mbgDim.number");
            selector.add("mbgDim.srcNumber");
            BgPropertySortInfo bgPropertySortInfo = BgPropertySortFactory.getRemoteInstance().getBgPropertySortInfo((IObjectPK)new ObjectUuidPK(propertySortId2), selector);
            if (bgPropertySortInfo != null && "D177852B".equals(bgPropertySortInfo.getSourceType())) {
                bgPropertySortInfo.put(BgBaseConstants.DIMENSION_NUMBER, (Object)bgPropertySortInfo.getMbgDim().getNumber());
            }
            bizPromptBox.setData((Object)bgPropertySortInfo);
        }
        return bizPromptBox;
    }
}

