/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.AbstractVirtualModeTableHelper;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class VirtualModeTableHelper
extends AbstractVirtualModeTableHelper {
    private static final Logger logger = CoreUIObject.getLogger(VirtualModeTableHelper.class);
    private NumberExpandHelper numberHelper = null;
    private String bgSchemeId = null;
    private boolean isShowOuSealup = true;
    private boolean showDisable = false;

    public void setBgSchemeId(String bgSchemeId) {
        this.bgSchemeId = bgSchemeId;
    }

    public String getBgSchemeId() {
        return this.bgSchemeId;
    }

    public void setShowOuSealup(boolean isShowOuSealup) {
        this.isShowOuSealup = isShowOuSealup;
    }

    public boolean isShowOuSealup() {
        return this.isShowOuSealup;
    }

    public void setShowDisable(boolean showDisable) {
        this.showDisable = showDisable;
    }

    public boolean isShowDisable() {
        return this.showDisable;
    }

    public VirtualModeTableHelper(CoreUI owner, KDTable table) {
        super(owner, table);
    }

    public void doQuery(BgDimensionBaseInfo dimension, FilterInfo filter, String[] orgIds, NumberExpandHelper numberHelper, String bgOrgViewId, String unionGroupId) throws EASBizException, BOSException {
        this.numberHelper = numberHelper;
        this.doQuery(new Object[]{dimension, filter, orgIds, bgOrgViewId, unionGroupId});
    }

    public void doQuery(BgDimensionBaseInfo dimension, FilterInfo filter, String orgId, NumberExpandHelper numberHelper, String bgOrgViewId, String unionGroupId) throws EASBizException, BOSException {
        this.numberHelper = numberHelper;
        this.doQuery(new Object[]{dimension, filter, orgId, bgOrgViewId, unionGroupId});
    }

    protected IDataProvider createQueryExecutor(Object[] parameters) throws EASBizException, BOSException {
        return this.createQueryExecutor((BgDimensionBaseInfo)parameters[0], (FilterInfo)parameters[1], parameters[2], (String)parameters[3], (String)parameters[4]);
    }

    protected IDataProvider createQueryExecutor(BgDimensionBaseInfo dimension, FilterInfo filter, Object orgId, String bgOrgViewId, String unionGroupId) throws EASBizException, BOSException {
        DimensionFilterHelper helper = null;
        String orgid = null;
        String[] orgIds = null;
        if (orgId instanceof String[]) {
            orgIds = (String[])orgId;
            if (orgIds.length > 0) {
                helper = DimensionFilterHelper.getRemoteIntance(dimension, (String[])orgId, ((String[])orgId)[0], this.bgSchemeId, bgOrgViewId, unionGroupId);
                orgid = ((String[])orgId)[0];
            } else {
                helper = DimensionFilterHelper.getRemoteIntance(dimension, (String)null, this.bgSchemeId, bgOrgViewId, unionGroupId);
            }
        } else {
            helper = DimensionFilterHelper.getRemoteIntance(dimension, (String)orgId, this.bgSchemeId, bgOrgViewId, unionGroupId);
            orgid = (String)orgId;
        }
        EntityViewInfo evi = new EntityViewInfo();
        String flag = helper.getFieldFlag();
        evi.getSelector().add("id");
        HashSet props = new HashSet();
        evi.getSelector().add(flag + "number");
        evi.getSelector().add(flag + "name");
        if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimension.getNumber()) || !DimensionConstants.necessary.contains(dimension.getNumber())) {
            evi.getSelector().add(flag + "description");
            evi.getSelector().add(flag + "orgUnit.name");
        }
        if (helper.isTreeBase()) {
            if (!props.contains("level")) {
                evi.getSelector().add(flag + "level");
            }
            if (!props.contains("longNumber")) {
                evi.getSelector().add(flag + "longNumber");
            }
            if (!props.contains("isLeaf")) {
                evi.getSelector().add(flag + "isLeaf");
            }
            if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimension.getNumber()) || !DimensionConstants.necessary.contains(dimension.getNumber())) {
                if (!props.contains("description")) {
                    evi.getSelector().add(flag + "description");
                }
                if (!props.contains("orgUnit.name")) {
                    evi.getSelector().add(flag + "orgUnit.name");
                }
                if (!props.contains("displayName")) {
                    evi.getSelector().add(flag + "displayName");
                }
            }
        }
        if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimension.getType()) || DimensionConstants.DEF_VERSION_NUMBER.equals(dimension.getType())) {
            evi.getSelector().add(flag + "isSysData");
        } else if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getType()) && "com.kingdee.eas.ma.mbg.app.BgOrgUnit".equals(helper.getEntity().getFullName())) {
            evi.getSelector().add(flag + "isVirtual");
        }
        evi.setFilter(helper.getFilter());
        if (filter != null && filter.getFilterItems().size() > 0) {
            if (!StringUtils.isEmpty((String)filter.getMaskString()) && filter.getMaskString().indexOf("or") > 0) {
                evi.getFilter().mergeFilter(filter, "and");
            } else {
                int size = evi.getFilter().getFilterItems().size();
                String mask = evi.getFilter().getMaskString();
                if (mask == null) {
                    evi.getFilter().mergeFilter(filter, "and");
                } else {
                    for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                        evi.getFilter().getFilterItems().add(filter.getFilterItems().get(i));
                    }
                }
                if (mask != null) {
                    String maskString = evi.getFilter().getMaskString();
                    for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                        maskString = maskString + " and #" + String.valueOf(size + i);
                    }
                    evi.getFilter().setMaskString(maskString);
                }
            }
        }
        if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimension.getNumber()) || !DimensionConstants.necessary.contains(dimension.getNumber())) {
            if (!this.isShowDisable()) {
                FilterInfo _filter = new FilterInfo();
                _filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)Boolean.TRUE, CompareType.EQUALS));
                evi.getFilter().mergeFilter(_filter, "and");
            }
        } else if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber()) && !this.isShowOuSealup()) {
            FilterInfo _filter = new FilterInfo();
            _filter.getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)Boolean.FALSE, CompareType.EQUALS));
            evi.getFilter().mergeFilter(_filter, "and");
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getType()) && !DimensionCommonHelper.isOrgTreeDimension(dimension).booleanValue()) {
            SorterItemCollection sort = new SorterItemCollection();
            SorterItemInfo sortorSysDefault = new SorterItemInfo("showLevel");
            sortorSysDefault.setSortType(SortType.ASCEND);
            sort.add(sortorSysDefault);
            evi.setSorter(sort);
        } else {
            evi.setSorter(helper.getOrder());
        }
        this.exec = helper.getQueryExecutor();
        this.exec.setObjectView(evi);
        this.numberHelper.setFilter(filter, helper.getBizInterface());
        return this.exec;
    }
}

