/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.worktable;

import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.mbg.client.worktable.SingleRptProperties;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MultiRptPropertiesManager {
    private Map<String, SingleRptProperties> bgMultiRptPro = new HashMap<String, SingleRptProperties>();
    public static final String NOTFOUND = "NOTFOUND";
    static final Object LOCK = new Lock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRptPro(String ctxid, SingleRptProperties prop) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.bgMultiRptPro.put(ctxid, prop);
        }
    }

    protected Map<String, SingleRptProperties> getBgMultiRptPro() {
        return this.bgMultiRptPro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRptPro(String ctxid) {
        Object object = this.getTreeLock();
        synchronized (object) {
            SingleRptProperties rptpro = this.bgMultiRptPro.remove(ctxid);
            if (rptpro != null) {
                rptpro.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleRptProperties getRptProperties(String ctxid) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.bgMultiRptPro.get(ctxid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRptProperties(String ctxid) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.bgMultiRptPro.containsKey(ctxid);
        }
    }

    public boolean hasModify(String ctxid) {
        SingleRptProperties rptprop = this.getRptProperties(ctxid);
        return rptprop.getWorkTableUI().isModifyForWorkTable();
    }

    public void discardAllEdits() {
        if (this.bgMultiRptPro.size() > 0) {
            for (SingleRptProperties rptprop : this.bgMultiRptPro.values()) {
                rptprop.getWorkTableUI().discardAllEdits();
            }
        }
    }

    public String findReportByID(String reportId) {
        for (Map.Entry<String, SingleRptProperties> entry : this.bgMultiRptPro.entrySet()) {
            if (!this.hasFound(entry.getValue(), reportId)) continue;
            return entry.getKey();
        }
        return NOTFOUND;
    }

    private boolean hasFound(SingleRptProperties rptprop, String reportId) {
        if (rptprop == null || StringUtils.isEmpty((String)reportId)) {
            return false;
        }
        String reportid = rptprop.getWorkTableUI().getReportID();
        return reportId.equals(reportid);
    }

    public String getModifyBgCslDetailBySingleRpt(SingleRptProperties rptprop) {
        StringBuffer detail = new StringBuffer();
        boolean isModify = rptprop.getWorkTableUI().isModifyForWorkTable();
        String oprtStatus = rptprop.getWorkTableUI().getOprtState();
        String tabTitle = rptprop.getTabTitle();
        if (isModify && !OprtState.VIEW.equalsIgnoreCase(oprtStatus)) {
            detail.append(tabTitle);
            detail.append("\n");
        }
        return detail.toString();
    }

    public Map getAllModifyDetail() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer detail = new StringBuffer();
        ArrayList<SingleRptProperties> bgRpts = new ArrayList<SingleRptProperties>();
        if (this.bgMultiRptPro.size() > 0) {
            for (SingleRptProperties rptprop : this.bgMultiRptPro.values()) {
                if (rptprop.getWorkTableUI() == null) continue;
                boolean isModify = rptprop.getWorkTableUI().isModifyForWorkTable();
                String oprtStatus = rptprop.getWorkTableUI().getOprtState();
                String editingMessage = rptprop.getWorkTableUI().getEditingMessage();
                if (!isModify || OprtState.VIEW.equalsIgnoreCase(oprtStatus)) continue;
                bgRpts.add(rptprop);
                detail.append(editingMessage);
                detail.append("\r\n");
            }
        }
        map.put("detail", detail.toString());
        map.put("bgRpts", bgRpts);
        return map;
    }

    public void clearAll() {
        for (SingleRptProperties rptprop : this.bgMultiRptPro.values()) {
            rptprop.clear();
        }
        this.bgMultiRptPro.clear();
    }

    public int size() {
        return this.bgMultiRptPro.size();
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    static class Lock {
        Lock() {
        }
    }
}

