/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBgDimensionManagerBase
implements IBgDimensionManagerBase,
Cloneable {
    private static final long serialVersionUID = 2759335848534881456L;
    private IMbgSheetBase sheet;
    private List dimension = new ArrayList();
    private List viewDimension = new ArrayList();
    private List pageDimension = new ArrayList();
    private List rowDimension = new ArrayList();
    private List colDimension = new ArrayList();

    public AbstractBgDimensionManagerBase(IMbgSheetBase sheet) {
        this.sheet = sheet;
    }

    @Override
    public List getPageDimension() {
        return this.pageDimension;
    }

    protected void setPageDimension(List pageDimension) {
        this.pageDimension = pageDimension;
    }

    @Override
    public final List getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public final List getColDimension() {
        return this.colDimension;
    }

    @Override
    public final List getViewDimension() {
        return this.viewDimension;
    }

    @Override
    public final List getDimension() {
        return this.dimension;
    }

    @Override
    public List getPageDisplayDimension() {
        return null;
    }

    @Override
    public List getRowDisplayDimension() {
        return null;
    }

    @Override
    public List getColDisplayDimension() {
        return null;
    }

    @Override
    public List getViewDisplayDimension() {
        return null;
    }

    @Override
    public List getHideDisplayDimension() {
        return null;
    }

    @Override
    public IMbgSheetBase getSheet() {
        return this.sheet;
    }

    public void setSheet(IMbgSheetBase sheet) {
        this.sheet = sheet;
    }

    @Override
    public void clear() {
        this.getDimension().clear();
        this.getViewDimension().clear();
        this.getPageDimension().clear();
        this.getRowDimension().clear();
        this.getColDimension().clear();
    }

    public void addDimensionInfo(BgDimensionBaseInfo dimensionInfo) {
        if (dimensionInfo == null) {
            return;
        }
        this.getDimension().add(dimensionInfo);
        if ("page".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getPageDimension().add(dimensionInfo);
        } else if ("row".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getRowDimension().add(dimensionInfo);
        } else if ("col".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getColDimension().add(dimensionInfo);
        } else if ("view".equalsIgnoreCase(dimensionInfo.getLayout())) {
            this.getViewDimension().add(dimensionInfo);
        }
    }

    public void addDimensionCol(List<BgDimensionInfo> list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            this.addDimensionInfo(list.get(i));
        }
    }

    @Override
    public BgDimensionBaseInfo searchDimension(String dimensionNumber) {
        return DimensionCommonHelper.searchDimension(dimensionNumber, this.getDimension());
    }

    protected AbstractBgDimensionManagerBase clone() throws CloneNotSupportedException {
        AbstractBgDimensionManagerBase clone = (AbstractBgDimensionManagerBase)super.clone();
        clone.dimension = DimensionCommonHelper.cloneViewListObject(this.dimension);
        clone.viewDimension = new ArrayList(this.viewDimension);
        this.cloneDimension(clone.viewDimension, clone.dimension);
        clone.pageDimension = new ArrayList(this.pageDimension);
        this.cloneDimension(clone.pageDimension, clone.dimension);
        clone.rowDimension = new ArrayList(this.rowDimension);
        this.cloneDimension(clone.viewDimension, clone.dimension);
        clone.colDimension = new ArrayList(this.colDimension);
        this.cloneDimension(clone.colDimension, clone.dimension);
        return clone;
    }

    private void cloneDimension(List viewDimension, List allDimension) {
        BgDimensionBaseInfo dim = null;
        for (int i = 0; i < viewDimension.size(); ++i) {
            if (!(viewDimension.get(i) instanceof BgDimensionBaseInfo)) continue;
            dim = (BgDimensionBaseInfo)viewDimension.get(i);
            viewDimension.set(i, DimensionCommonHelper.searchDimension(dim.getNumber(), allDimension));
        }
    }
}

