/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgDimTypeEnum;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.DimensionMemberFilterInfo;
import com.kingdee.eas.ma.mbg.common.FixAndMbgMeasureCellActionAfterListener;
import com.kingdee.eas.ma.mbg.common.FormStyleInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.IBookDimensionParse;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IViewListNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.LineFlowLayout;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.ViewListMeasureCellActionAfterListener;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgPrintHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public abstract class AbstractBookParseHelper {
    protected IBookDimensionParse bookParse = null;
    private Context ctx = null;
    public static final String PROPERTY_LBC = "PropertyKDLabelContainer";
    public static final String F7_LBC = "DimensionF7KDLabelContainer";
    public static final String PNL_SUFFIX = "_PNL";
    protected BgSchemeDimensionHelper schemeHelper = null;
    private Map<String, IMbgViewBase> bgViewManagerForMulOrg = new HashMap<String, IMbgViewBase>();
    private Map<String, FullOrgUnitInfo> orgUnitMap = new HashMap<String, FullOrgUnitInfo>();
    private Map<String, String> multiOrgCreatorMap = new HashMap<String, String>();
    private FullOrgUnitInfo orgUnitInfo = null;
    private DimensionMemberFilterInfo memberFilter = null;
    private final Map<Integer, List<KDPanel>> viewPnlMap = new HashMap<Integer, List<KDPanel>>();
    private final Map<Integer, List<KDPanel>> pagePnlMap = new HashMap<Integer, List<KDPanel>>();
    private boolean isCheckFull = true;
    private boolean isPageF7Enable = false;
    private boolean isViewF7Enable = false;
    private boolean isOrgF7Enable = true;
    protected boolean isSetDefaultOrg = true;
    private String versionNumber = null;
    private String bgFormPeriodNumber = null;
    private BgScenarioType editScenType = null;
    private DimensionCacheHelper cacheHelper = null;
    private String orgViewId = null;
    private String unionGroupId = null;
    private boolean isReadonly = false;

    public AbstractBookParseHelper(IBookDimensionParse bookParse, FullOrgUnitInfo orgUnitInfo, Map bgViewManagerForMulOrg, Map<String, FullOrgUnitInfo> orgUnitMap, boolean isCheckFull, DimensionMemberFilterInfo memberFilter, DimensionCacheHelper cacheHelper) {
        this.bookParse = bookParse;
        this.bgViewManagerForMulOrg.putAll(bgViewManagerForMulOrg);
        this.orgUnitInfo = orgUnitInfo;
        this.orgUnitMap.putAll(orgUnitMap);
        this.isCheckFull = isCheckFull;
        this.memberFilter = memberFilter;
        this.cacheHelper = cacheHelper;
    }

    public AbstractBookParseHelper(IBookDimensionParse bookParse, FullOrgUnitInfo orgUnitInfo, Map bgViewManagerForMulOrg, Map<String, FullOrgUnitInfo> orgUnitMap, boolean isCheckFull, DimensionMemberFilterInfo memberFilter, DimensionCacheHelper cacheHelper, String unionGroupId) {
        this(bookParse, orgUnitInfo, bgViewManagerForMulOrg, orgUnitMap, isCheckFull, memberFilter, cacheHelper);
        this.unionGroupId = unionGroupId;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public String getString(String resourceFile, String msgKey) {
        if (this.ctx == null) {
            return EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)msgKey);
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)msgKey, (Locale)this.ctx.getLocale());
    }

    public DimensionCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void setSchemeHelper(BgSchemeDimensionHelper schemeHelper) {
        this.schemeHelper = schemeHelper;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public Map<String, IMbgViewBase> getBgViewManagerForMulOrg() {
        return this.bgViewManagerForMulOrg;
    }

    public void setOrgUnitInfo(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    public FullOrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public Map<String, FullOrgUnitInfo> getOrgUnitMap() {
        return this.orgUnitMap;
    }

    public Map<String, String> getMultiOrgCreatorMap() {
        return this.multiOrgCreatorMap;
    }

    public boolean isReadonly() {
        return this.isReadonly;
    }

    public boolean isPageF7Enable() {
        return this.isPageF7Enable;
    }

    public void setPageF7Enable(boolean isPageF7Enable) {
        this.isPageF7Enable = isPageF7Enable;
    }

    public boolean isViewF7Enable() {
        return this.isViewF7Enable;
    }

    public void setViewF7Enable(boolean isViewF7Enable) {
        this.isViewF7Enable = isViewF7Enable;
    }

    public void setOrgF7Enable(boolean isOrgF7Enable) {
        this.isOrgF7Enable = isOrgF7Enable;
    }

    public boolean isOrgF7Enable() {
        return this.isOrgF7Enable;
    }

    public void setSetDefaultOrg(boolean isSetDefaultOrg) {
        this.isSetDefaultOrg = isSetDefaultOrg;
    }

    public boolean isSetDefaultOrg() {
        return this.isSetDefaultOrg;
    }

    public String getUnionGroupId() {
        return this.unionGroupId;
    }

    public void setUnionGroupId(String unionGroupId) {
        this.unionGroupId = unionGroupId;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setBgFormPeriodNumber(String bgFormPeriodNumber) {
        this.bgFormPeriodNumber = bgFormPeriodNumber;
    }

    public String getBgFormPeriodNumber() {
        return this.bgFormPeriodNumber;
    }

    public void setEditScenType(BgScenarioType editScenType) {
        this.editScenType = editScenType;
    }

    public BgScenarioType getEditScenType() {
        return this.editScenType;
    }

    public void setOrgViewId(String orgViewId) {
        this.orgViewId = orgViewId;
    }

    public void setReadonly(boolean isReadonly) {
        this.isReadonly = isReadonly;
    }

    public DimensionMemberFilterInfo getMemberFilter() {
        return this.memberFilter;
    }

    public boolean isCheckFull() {
        return this.isCheckFull;
    }

    public String getOrgViewId() {
        return this.orgViewId;
    }

    public Map<Integer, List<KDPanel>> getViewPnlMap() {
        return this.viewPnlMap;
    }

    public Map<Integer, List<KDPanel>> getPagePnlMap() {
        return this.pagePnlMap;
    }

    public void refreshCurMbgViewManager(FullOrgUnitInfo orgUnitInfo, IMbgViewBase mbgViewManager) {
        this.refreshCurMbgViewManager(orgUnitInfo, mbgViewManager, false);
    }

    public void refreshCurMbgViewManager(FullOrgUnitInfo orgUnitInfo, IMbgViewBase mbgViewManager, boolean isClearPnlMap) {
        this.getBgViewManagerForMulOrg().put(orgUnitInfo.getNumber(), mbgViewManager);
        this.setOrgUnitInfo(orgUnitInfo);
        this.getOrgUnitMap().put(orgUnitInfo.getNumber(), orgUnitInfo);
        if (isClearPnlMap) {
            if (this.getViewPnlMap() != null) {
                this.getViewPnlMap().clear();
            }
            if (this.getPagePnlMap() != null) {
                this.getPagePnlMap().clear();
            }
        }
    }

    public List<KDPromptBox> getPageF7List(int sheetIndex) {
        return AbstractBookParseHelper.getF7List(sheetIndex, this.pagePnlMap);
    }

    public List<KDPromptBox> getViewF7List(int sheetIndex) {
        return AbstractBookParseHelper.getF7List(sheetIndex, this.viewPnlMap);
    }

    public static List<KDPromptBox> getF7List(int sheetIndex, Map<Integer, List<KDPanel>> pnlMap) {
        if (pnlMap == null || pnlMap.get(sheetIndex) == null) {
            return null;
        }
        ArrayList<KDPromptBox> f7List = new ArrayList<KDPromptBox>();
        List<KDPanel> subPnlList = pnlMap.get(sheetIndex);
        KDPromptBox f7 = null;
        for (int i = 0; i < subPnlList.size(); ++i) {
            f7 = AbstractBookParseHelper.getF7FromPnl(subPnlList.get(i));
            if (f7 == null) continue;
            f7List.add(f7);
        }
        return f7List;
    }

    public List<KDPanel> getViewPnlList(int sheetIndex) {
        return this.viewPnlMap.get(sheetIndex);
    }

    public List<KDPanel> getPagePnlList(int sheetIndex) {
        return this.pagePnlMap.get(sheetIndex);
    }

    public static KDPromptBox getF7FromPnl(KDPanel subPnl) {
        if (subPnl == null || StringUtils.isEmpty((String)subPnl.getName()) || !subPnl.getName().endsWith(PNL_SUFFIX)) {
            return null;
        }
        Component component = null;
        for (int i = 0; i < subPnl.getComponentCount(); ++i) {
            component = subPnl.getComponent(i);
            if (!F7_LBC.equals(component.getName())) continue;
            return (KDPromptBox)((KDLabelContainer)component).getBoundEditor();
        }
        return null;
    }

    private KDLabelContainer createF7Container(CoreUIObject ownerUI, String orgUnitId, String unionGroupId, BgDimensionBaseInfo dimensionInfo, boolean isEnable, String permissionNumber) throws Exception {
        Object obj;
        if (dimensionInfo == null || this.bookParse == null) {
            return null;
        }
        KDPromptBox f7 = this.bookParse.getDimensionF7(this, ownerUI, orgUnitId, unionGroupId, dimensionInfo, isEnable, permissionNumber);
        KDLabelContainer cont = this.createContainer();
        if (this.isCsl() && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) {
            cont.setBoundLabelText(BgOrgDimTypeEnum.CslOrgUnit.getAlias());
            if (ownerUI != null && ownerUI.getClass().getName().indexOf("BgCslViewListFormProcessUI") >= 0) {
                f7.setEnabled(isEnable);
            } else {
                f7.setEnabled(false);
            }
        } else {
            cont.setBoundLabelText(StringUtils.isEmpty((String)dimensionInfo.getAlias()) ? dimensionInfo.getName() : dimensionInfo.getAlias());
            f7.setEnabled(isEnable);
        }
        cont.setBoundEditor((JComponent)f7);
        cont.setName(F7_LBC);
        if (ownerUI != null && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber()) && (obj = ownerUI.getUIContext().get("isenableOrgF7")) != null && obj instanceof Boolean) {
            cont.setEnabled(((Boolean)obj).booleanValue());
        }
        return cont;
    }

    private KDPanel createSubPnl(CoreUIObject ownerUI, String orgUnitId, String unionGroupId, IBgDimensionManagerBase bgDimensionManage, BgDimensionBaseInfo dimensionInfo, boolean isF7Enable, String permissionNumber) throws Exception {
        if (StringUtils.isEmpty((String)orgUnitId) || dimensionInfo == null) {
            return null;
        }
        KDPanel subPnl = new KDPanel();
        subPnl.setName(dimensionInfo.getNumber() + PNL_SUFFIX);
        subPnl.setVisible(dimensionInfo.getMember().size() != 1 || dimensionInfo.isShow());
        if (ownerUI == null) {
            return subPnl;
        }
        subPnl.add((Component)this.createF7Container(ownerUI, orgUnitId, unionGroupId, dimensionInfo, isF7Enable, permissionNumber));
        return subPnl;
    }

    private KDLabelContainer createContainer() {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setBounds(new Rectangle(240, 19));
        cont.setBoundLabelLength(80);
        cont.setBoundLabelUnderline(true);
        cont.setPreferredSize(new Dimension(240, 19));
        cont.setMinimumSize(new Dimension(240, 19));
        return cont;
    }

    public Book getBook(CoreUIObject ownerUI, IProvider provider, DimensionMemberCheckFactory checkFactory, String permissionNumber) throws Exception {
        if (this.getSheetManagersForStyle() != null && this.getSheetManagersForStyle().size() <= 0) {
            return Book.Manager.getNewBook();
        }
        Book book = Book.Manager.getNewBook(null, (int)this.getSheetManagersForStyle().size());
        this.getBook(ownerUI, provider, book, checkFactory, permissionNumber);
        if (ownerUI instanceof IViewListNumberCellDisplayHelper) {
            book.setCellActionAfterListener((CellActionAfterListener)new ViewListMeasureCellActionAfterListener((IViewListNumberCellDisplayHelper)ownerUI));
        } else if (ownerUI instanceof IBgNumberCellDisplayHelper) {
            book.setCellActionAfterListener((CellActionAfterListener)new FixAndMbgMeasureCellActionAfterListener((IBgNumberCellDisplayHelper)ownerUI));
        }
        return book;
    }

    protected abstract List<? extends IMbgSheetBase> getSheetManagersForStyle();

    protected abstract List<? extends IMbgSheetBase> getSheetManagers(String var1);

    public void getBook(CoreUIObject ownerUI, IProvider provider, Book book, DimensionMemberCheckFactory checkFactory, String permissionNumber) throws Exception {
        MBgTemplateHelper.startLog("Start AbstractBookParseHelper.getBook");
        BgNFSHelper.setBookProtection(book, false, null);
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        Sheet sheet = null;
        HashMap<String, IMbgSheetBase> bgSheetManagerForMulOrg = null;
        String orgNum2 = null;
        long st = System.currentTimeMillis();
        int count = this.getSheetManagersForStyle().size();
        for (int s = 0; s < book.getSheetCount(); ++s) {
            book.getSheet(s).setName("Sheet" + st++);
            if (count > s) continue;
            book.removeSheet(s);
            --s;
        }
        for (int i = 0; i < this.getSheetManagersForStyle().size(); ++i) {
            if (book.getSheetCount() <= i) {
                book.addSheet(null);
            }
            sheet = book.getSheet(i);
            bgSheetManagerForMulOrg = new HashMap<String, IMbgSheetBase>();
            if (this.isOrgOnPageOrView(this.getSheetManagersForStyle().get(i).getDimensionManager())) {
                bgSheetManagerForMulOrg.put(this.orgUnitInfo.getNumber(), this.getSheetManagers(this.orgUnitInfo.getNumber()).get(i));
            } else {
                for (String orgNum2 : this.bgViewManagerForMulOrg.keySet()) {
                    bgSheetManagerForMulOrg.put(orgNum2, this.getSheetManagers(orgNum2).get(i));
                }
            }
            this.getSheet(ownerUI, provider, this.orgUnitInfo.getNumber(), bgSheetManagerForMulOrg, sheet, checkFactory, permissionNumber);
        }
        BgNFSHelper.enableUndo(book);
        BgNFSHelper.setBookProtection(book, true, BgNFSHelper.getBookOperation());
        MBgTemplateHelper.logTime("End AbstractBookParseHelper.getBook");
    }

    protected boolean isOrgOnPageOrView(IBgDimensionManagerBase dimensionManager) {
        return MBgTemplateHelper.isOrgOnPageOrView(dimensionManager);
    }

    public Component parseViewOrPageBgDimension(CoreUIObject ownerUI, boolean isEnable, int activeSheetIndex) throws Exception {
        int i;
        KDPanel page = new KDPanel();
        page.setName("pagePnl");
        page.setLayout((LayoutManager)new LineFlowLayout(0));
        page.setEnabled(isEnable);
        if (this.getViewF7List(activeSheetIndex) != null && this.getViewF7List(activeSheetIndex).size() > 0) {
            for (i = 0; i < this.getViewF7List(activeSheetIndex).size(); ++i) {
                page.add((Component)this.getViewPnlList(activeSheetIndex).get(i));
            }
        }
        if (this.getPageF7List(activeSheetIndex) != null && this.getPageF7List(activeSheetIndex).size() > 0) {
            for (i = 0; i < this.getPageF7List(activeSheetIndex).size(); ++i) {
                page.add((Component)this.getPagePnlList(activeSheetIndex).get(i));
            }
        }
        return page;
    }

    public void createPageView(CoreUIObject ownerUI, String orgNumForDimensionData, Map<String, IMbgSheetBase> bgSheetManagerForMulOrg, Sheet sheet, DimensionMemberCheckFactory checkFactory, String permissionNumber) throws Exception {
        IMbgSheetBase sheetManagerForStyle = this.getSheetManagersForStyle().get(sheet.getIndex());
        IBgDimensionManagerBase dimensionManagerForStyle = sheetManagerForStyle.getDimensionManager();
        IBgDimensionManagerBase dimensionManagerForData = bgSheetManagerForMulOrg.get(orgNumForDimensionData).getDimensionManager();
        List viewDimenions = MBgTemplateHelper.getDimensions(dimensionManagerForData, MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getViewDisplayDimension()));
        List pageDimenions = MBgTemplateHelper.getDimensions(dimensionManagerForData, MBgTemplateHelper.getDimensionsNum(dimensionManagerForStyle.getPageDisplayDimension()));
        this.createViewOrPagePnl(ownerUI, sheet, this.getUnionGroupId(), dimensionManagerForData, viewDimenions, this.viewPnlMap, this.isViewF7Enable(), permissionNumber);
        this.createViewOrPagePnl(ownerUI, sheet, this.getUnionGroupId(), dimensionManagerForData, pageDimenions, this.pagePnlMap, this.isPageF7Enable(), permissionNumber);
    }

    public abstract void getSheet(CoreUIObject var1, IProvider var2, String var3, Map<String, ? extends IMbgSheetBase> var4, Sheet var5, DimensionMemberCheckFactory var6, String var7) throws Exception;

    public void createViewOrPagePnl(CoreUIObject ownerUI, Sheet sheet, String unionGroupId, IBgDimensionManagerBase dimensionManagerForData, List<? extends BgDimensionBaseInfo> viewDimenions, Map<Integer, List<KDPanel>> subPnlMap, boolean isF7Enable, String permissionNumber) throws Exception {
        if (viewDimenions != null && viewDimenions.size() > 0) {
            HashMap<String, Object> existF7ValueMap = new HashMap<String, Object>();
            List<KDPromptBox> oldViewF7List = AbstractBookParseHelper.getF7List(sheet.getSheetIndex(), subPnlMap);
            if (oldViewF7List != null) {
                for (int index = 0; index < oldViewF7List.size(); ++index) {
                    existF7ValueMap.put(oldViewF7List.get(index).getName(), oldViewF7List.get(index).getData());
                }
                subPnlMap.get(sheet.getSheetIndex()).clear();
            }
            if (subPnlMap.get(sheet.getSheetIndex()) == null) {
                subPnlMap.put(sheet.getSheetIndex(), new ArrayList());
            }
            List<KDPanel> subPnl = subPnlMap.get(sheet.getSheetIndex());
            for (int j = 0; j < viewDimenions.size(); ++j) {
                BgDimensionBaseInfo dimensionInfo = viewDimenions.get(j);
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) {
                    if (this.bgViewManagerForMulOrg.containsKey(this.orgUnitInfo.getNumber())) {
                        dimensionInfo = this.getSheetManagers(this.orgUnitInfo.getNumber()).get(sheet.getSheetIndex()).getDimensionManager().searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER);
                    }
                    if (this.getSchemeHelper() != null) {
                        Set<String> bgOrgUnitPer = new HashSet();
                        UserInfo userInfo = null;
                        if (this.getCtx() == null) {
                            userInfo = SysContext.getSysContext().getCurrentUserInfo();
                            bgOrgUnitPer = MbgPermissionFactory.getRemoteInstance().getBgOrgUnitPermission(null, userInfo.getId().toString(), this.getSchemeHelper().getBgSchemeId());
                        } else {
                            userInfo = ContextUtil.getCurrentUserInfo((Context)this.getCtx());
                            bgOrgUnitPer = MbgPermissionFactory.getLocalInstance(this.getCtx()).getBgOrgUnitPermission(null, userInfo.getId().toString(), this.getSchemeHelper().getBgSchemeId());
                        }
                        if (!bgOrgUnitPer.isEmpty()) {
                            List members;
                            if (!this.getMultiOrgCreatorMap().isEmpty()) {
                                for (String key : this.getMultiOrgCreatorMap().keySet()) {
                                    if (!this.getMultiOrgCreatorMap().get(key).equals(userInfo.getId().toString())) continue;
                                    bgOrgUnitPer.add(key);
                                }
                            }
                            if ((members = dimensionInfo.getMember()) != null && !members.isEmpty()) {
                                for (int i = 0; i < members.size(); ++i) {
                                    BgDimensionMember member = (BgDimensionMember)members.get(i);
                                    if (!bgOrgUnitPer.contains(member.getAttribute())) {
                                        member.setHide(true);
                                        continue;
                                    }
                                    member.setHide(false);
                                }
                            }
                        }
                    }
                }
                KDPanel pnl = this.createSubPnl(ownerUI, this.orgUnitMap.get(this.orgUnitInfo.getNumber()).getId().toString(), unionGroupId, dimensionManagerForData, dimensionInfo, isF7Enable, permissionNumber);
                if (existF7ValueMap.get(dimensionInfo.getNumber()) != null && this.isExistInMembers(dimensionInfo.getMember(), existF7ValueMap.get(dimensionInfo.getNumber()))) {
                    AbstractBookParseHelper.getF7FromPnl(pnl).setDataNoNotify(existF7ValueMap.get(dimensionInfo.getNumber()));
                }
                subPnl.add(pnl);
            }
        } else if (subPnlMap != null && subPnlMap.get(sheet.getIndex()) != null) {
            subPnlMap.get(sheet.getIndex()).clear();
        }
    }

    protected boolean isExistInMembers(List members, Object oldMember) {
        return true;
    }

    protected final void setWidthStyle(Sheet sheet, IMbgSheetBase sheetManagerForStyle) {
        int width;
        int defRow;
        if (sheet == null || sheetManagerForStyle == null || sheetManagerForStyle.getWidthMap().isEmpty()) {
            return;
        }
        this.resetColWidth(sheetManagerForStyle);
        int defCol = sheetManagerForStyle.getWidth(false, -1);
        if (defCol > 0) {
            sheet.setOriginalDefColWidth(defCol);
        }
        if ((defRow = sheetManagerForStyle.getWidth(true, -1)) > 0) {
            sheet.setOriginalDefRowHeight(defRow);
        }
        for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
            width = sheetManagerForStyle.getWidth(false, c);
            if (width == 0) continue;
            if (width > 0) {
                sheet.getColRange(c, c).setColumnWidth(width);
                continue;
            }
            sheet.getColRange(c, c).setColumnWidth(-width);
            sheet.getColRange(c, c).setColumnHidden(true);
        }
        for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
            width = sheetManagerForStyle.getWidth(true, r);
            if (width == 0) continue;
            if (width >= 0) {
                sheet.getRowRange(r, r).setRowHeight(width);
                continue;
            }
            sheet.getRowRange(r, r).setRowHeight(-width);
            sheet.getRowRange(r, r).setRowHidden(true);
        }
    }

    protected void resetColWidth(IMbgSheetBase sheetManagerForStyle) {
        HashMap<String, Integer> realWidthMap = new HashMap<String, Integer>();
        if (!(sheetManagerForStyle.getDimensionManager() instanceof MbgViewListDimensionManager)) {
            return;
        }
        MbgViewListDimensionManager manager = (MbgViewListDimensionManager)sheetManagerForStyle.getDimensionManager();
        Map<String, Integer> widthMap = sheetManagerForStyle.getWidthMap();
        List<IMbgViewListObject> columns = manager.getColumns();
        int colOriginalIndex = 0;
        if (columns != null && columns.size() > 0) {
            int originalSize;
            for (IMbgViewListObject rowCol : columns) {
                if (!(rowCol instanceof MbgViewListRowCol)) continue;
                MbgViewListDimensionInfo dimensionCon = this.getDimensionByDimensionType((MbgViewListRowCol)rowCol, DimensionBaseConstants.DEF_CSL_NUMBER);
                boolean isCons = false;
                if (dimensionCon != null) {
                    isCons = true;
                }
                if (!isCons) continue;
                int total = this.getDimensionSize((MbgViewListRowCol)rowCol);
                MbgViewListDimensionInfo dimensionOrg = this.getDimensionByDimensionType((MbgViewListRowCol)rowCol, DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
                int initIndex = ((MbgViewListRowCol)rowCol).getInitIndex();
                if (initIndex == 0) {
                    colOriginalIndex = ((MbgViewListRowCol)rowCol).getStartIndex();
                }
                int startCol = ((MbgViewListRowCol)rowCol).getStartIndex();
                int endCol = ((MbgViewListRowCol)rowCol).getEndIndex();
                int conSize = this.getDimensionValueSize(dimensionCon);
                int orgSize = this.getDimensionValueSize(dimensionOrg);
                if (conSize == 1) {
                    for (int j = 0; j < total; ++j) {
                        String key = "col" + colOriginalIndex;
                        int colWidth = widthMap.get("col-1");
                        if (widthMap.containsKey(key)) {
                            colWidth = widthMap.get(key);
                        }
                        for (int k = startCol; k <= orgSize; ++k) {
                            key = "col" + k;
                            if (colWidth < 0 && !widthMap.containsKey(key)) {
                                realWidthMap.put(key, 72);
                                continue;
                            }
                            realWidthMap.put(key, colWidth);
                        }
                        startCol = startCol + orgSize + 1;
                        ++colOriginalIndex;
                    }
                    continue;
                }
                if (conSize <= 1) continue;
                int totalCol = endCol - startCol + 1;
                int combSize = totalCol / (conSize * total);
                if (combSize == 1) {
                    for (int i = startCol; i <= endCol; ++i) {
                        String key = "col" + colOriginalIndex;
                        int colWidth = widthMap.get("col-1");
                        if (widthMap.containsKey(key)) {
                            colWidth = widthMap.get(key);
                        }
                        key = "col" + i;
                        if (colWidth < 0 && !widthMap.containsKey(key)) {
                            realWidthMap.put(key, 72);
                        } else {
                            realWidthMap.put(key, colWidth);
                        }
                        ++colOriginalIndex;
                    }
                    continue;
                }
                if (combSize <= 1) continue;
                Integer[] lens = new Integer[conSize];
                for (int j = 0; j < total; ++j) {
                    for (int k = 0; k < conSize; ++k) {
                        String key = "col" + colOriginalIndex;
                        int colWidth = widthMap.get("col-1");
                        if (widthMap.containsKey(key)) {
                            colWidth = widthMap.get(key);
                        }
                        lens[k] = colWidth;
                        ++colOriginalIndex;
                    }
                    int colSize = orgSize * conSize;
                    for (int m = startCol; m < startCol + colSize; ++m) {
                        for (int n = 0; n < conSize; ++n) {
                            String key = "col" + m;
                            int colWidth = lens[n];
                            if (colWidth < 0 && !widthMap.containsKey(key)) {
                                realWidthMap.put(key, 72);
                            } else {
                                realWidthMap.put(key, colWidth);
                            }
                            ++m;
                        }
                        --m;
                    }
                    startCol += colSize;
                }
            }
            if (realWidthMap.size() > 0 && (originalSize = this.getOriginalSize(widthMap)) <= colOriginalIndex) {
                this.resetMap(realWidthMap, widthMap);
            }
        }
    }

    private int getOriginalSize(Map<String, Integer> widthMap) {
        int originalSize = widthMap.size();
        for (String key : widthMap.keySet()) {
            if (!key.contains("row") && !key.equals("col-1") && !key.equals("col0")) continue;
            --originalSize;
        }
        return originalSize;
    }

    private MbgViewListDimensionInfo getDimensionByDimensionType(MbgViewListRowCol rowCol, String dimensionType) {
        List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
        for (MbgViewListDimensionInfo dimension : dimensions) {
            String dimNumber = dimension.getNumber();
            if (!dimensionType.equals(dimNumber)) continue;
            return dimension;
        }
        return null;
    }

    private int getDimensionSize(MbgViewListRowCol rowCol) {
        List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
        int total = 1;
        for (MbgViewListDimensionInfo dimension : dimensions) {
            String dimNumber = dimension.getNumber();
            if (DimensionBaseConstants.DEF_CSL_NUMBER.equals(dimNumber) || DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) continue;
            String value = dimension.getValue();
            String[] strs = value.split("\\|");
            int size = strs.length;
            total *= size;
        }
        return total;
    }

    private int getDimensionValueSize(MbgViewListDimensionInfo dimension) {
        int size = 1;
        if (dimension == null) {
            return size;
        }
        String value = dimension.getValue();
        String[] strs = value.split("\\|");
        size = strs.length;
        return size;
    }

    public void resetMap(Map<String, Integer> realWidthMap, Map<String, Integer> widthMap) {
        for (String key : widthMap.keySet()) {
            if (realWidthMap.containsKey(key)) continue;
            int width = widthMap.get(key);
            realWidthMap.put(key, width);
        }
        widthMap.clear();
        widthMap.putAll(realWidthMap);
    }

    protected final void setPrintSetting(Sheet sheet, IMbgSheetBase sheetManagerForStyle) {
        if (sheet == null || sheetManagerForStyle == null || sheetManagerForStyle.getPrintMap().isEmpty()) {
            return;
        }
        String setting = sheetManagerForStyle.getPrintSetup();
        BgPrintHelper.decodePrintSetup(sheet, setting);
        try {
            String sheetName = sheet.getSyntaxName();
            if (!StringUtils.isEmpty((String)sheetManagerForStyle.getPrintArea())) {
                sheet.getRange(1, 1).setName(sheetName + '!' + "Print_Area", sheetManagerForStyle.getPrintArea());
            } else {
                sheet.getNames().remove((Object)"Print_Area");
            }
            if (!StringUtil.isEmptyString((String)sheetManagerForStyle.getPrintTitle())) {
                sheet.getRange(1, 1).setName(sheetName + '!' + "Print_Titles", sheetManagerForStyle.getPrintTitle());
            } else {
                sheet.getNames().remove((Object)"Print_Titles");
            }
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
    }

    protected StyleAttributes getColHeadStyle(FormStyleInfo styleInfo) {
        StyleAttributes sa = Styles.getEmptySA();
        if (styleInfo == null) {
            return sa;
        }
        sa.setFont(styleInfo.getColumnHeaderStyleAttributes().getFont());
        sa.setFontSize(styleInfo.getColumnHeaderStyleAttributes().getFontSize());
        sa.setBold(styleInfo.getColumnHeaderStyleAttributes().isBold());
        sa.setItalic(styleInfo.getColumnHeaderStyleAttributes().isItalic());
        sa.setUnderline(styleInfo.getColumnHeaderStyleAttributes().isUnderline());
        return sa;
    }

    protected StyleAttributes getDataStyleWithoutNumberFormat(FormStyleInfo styleInfo) {
        StyleAttributes sa = Styles.getEmptySA();
        if (styleInfo == null) {
            return sa;
        }
        sa.setFont(styleInfo.getDataStyleAttributes().getFont());
        sa.setFontSize(styleInfo.getDataStyleAttributes().getFontSize());
        sa.setBold(styleInfo.getDataStyleAttributes().isBold());
        sa.setItalic(styleInfo.getDataStyleAttributes().isItalic());
        sa.setUnderline(styleInfo.getDataStyleAttributes().isUnderline());
        return sa;
    }

    protected StyleAttributes getDataStyle(FormStyleInfo styleInfo) {
        StyleAttributes sa = Styles.getEmptySA();
        if (styleInfo == null) {
            return sa;
        }
        sa.setFont(styleInfo.getDataStyleAttributes().getFont());
        sa.setFontSize(styleInfo.getDataStyleAttributes().getFontSize());
        sa.setBold(styleInfo.getDataStyleAttributes().isBold());
        sa.setItalic(styleInfo.getDataStyleAttributes().isItalic());
        sa.setUnderline(styleInfo.getDataStyleAttributes().isUnderline());
        sa.setNumberFormat(styleInfo.toNumberPattern());
        return sa;
    }

    protected void setSpliteInfo(Sheet sheet, IMbgSheetBase sheetManagerForStyle) {
        if (sheet != null && sheet.getSheetOption() != null && sheetManagerForStyle != null && sheetManagerForStyle.getSplitInfo() != null) {
            ViewSplitInfo info = BgNFSHelper.transStrToSplit(sheetManagerForStyle.getSplitInfo());
            if (this.getMemberFilter() != null && this.getMemberFilter().isEnableFilter() && !info.isFreezed()) {
                return;
            }
            sheet.getSheetOption().getViewSplitInfo().copyFrom(info);
            sheet.getSheetOption().getViewSplitInfo().setColFixLine(info.getColFixLine());
            sheet.getSheetOption().getViewSplitInfo().setRowFixLine(info.getRowFixLine());
            if (sheet.getActiveRow() == 0 && sheet.getActiveCol() == 0) {
                sheet.getSheetOption().getSelection().setActiveCell(info.getRowSplit(), info.getColSplit());
            }
        }
    }

    protected void clearSpliteInfo(Sheet sheet) {
        if (sheet != null && sheet.getSheetOption() != null && sheet.getSheetOption().getViewSplitInfo().isFreezed()) {
            sheet.getSheetOption().getViewSplitInfo().setFreezed(false);
            sheet.getSheetOption().getViewSplitInfo().setColFixLine(0);
            sheet.getSheetOption().getViewSplitInfo().setFirstCol(0);
            sheet.getSheetOption().getViewSplitInfo().setFirstCol2(0);
            sheet.getSheetOption().getViewSplitInfo().setFirstRow(0);
            sheet.getSheetOption().getViewSplitInfo().setFirstRow2(0);
            sheet.getSheetOption().getViewSplitInfo().setRowFixLine(0);
        }
    }

    public boolean isCsl() {
        return this.schemeHelper != null && (this.schemeHelper.isBgCsl() || this.schemeHelper.getClass().getName().equals(DimensionConstants.CSLSCHEME_HELPER));
    }

    public static class DimensionF7Formatter
    implements IFormatter {
        private String showType = null;

        public DimensionF7Formatter(String showType) {
            this.showType = showType;
        }

        public String valueToString(Object o) {
            if (o instanceof List) {
                return this.valueToStringArray(((List)o).toArray());
            }
            if (o instanceof IObjectCollection) {
                return this.valueToStringArray(((IObjectCollection)o).toArray());
            }
            return this.valueToStringOneObject(o);
        }

        public String valueToStringOneObject(Object o) {
            if (o == null) {
                return "";
            }
            if (o instanceof BgDimensionMember) {
                BgDimensionMember m = (BgDimensionMember)o;
                if ("NUMBER".equals(this.showType)) {
                    return m.getNumber();
                }
                if ("NAME".equals(this.showType)) {
                    return m.getName();
                }
                if ("NAMEANDNUMBER".equals(this.showType)) {
                    return m.getNumber() + "_" + m.getName();
                }
                if ("SIMPLENAME".equals(this.showType)) {
                    return m.getSimpleName();
                }
                if ("LONGNAME".equals(this.showType)) {
                    if (!StringUtils.isEmpty((String)m.getLongName())) {
                        return m.getLongName();
                    }
                    return m.getName();
                }
            } else if (o instanceof IObjectValue) {
                IObjectValue ov = (IObjectValue)o;
                if ("NUMBER".equals(this.showType)) {
                    return ov.getString("number");
                }
                if ("NAME".equals(this.showType)) {
                    return ov.getString("name");
                }
                if ("NAMEANDNUMBER".equals(this.showType)) {
                    return ov.getString("number") + "_" + ov.getString("name");
                }
                if ("SIMPLENAME".equals(this.showType)) {
                    return ov.getString("simplename");
                }
                if ("LONGNAME".equals(this.showType)) {
                    if (!StringUtils.isEmpty((String)ov.getString("displayName"))) {
                        return ov.getString("displayName");
                    }
                    return ov.getString("name");
                }
            }
            return o.toString();
        }

        public String valueToStringArray(Object[] objs) {
            if (objs == null || objs.length == 0) {
                return "";
            }
            StringBuffer res = new StringBuffer();
            for (int i = 0; i < objs.length; ++i) {
                if (i > 0) {
                    res.append(",");
                }
                res.append(this.valueToStringOneObject(objs[i]));
            }
            return res.toString();
        }

        public void applyPattern(String pattern) {
        }
    }
}

