/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.IMbgPermission;
import com.kingdee.eas.ma.mbg.MbgPermissionCollection;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.common.AbstractBgSchemeCopy;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeParam;
import com.kingdee.eas.ma.mbg.common.BgCopySchemeResult;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BgDataPermissionCopy
extends AbstractBgSchemeCopy {
    public BgDataPermissionCopy(BgCopySchemeParam param, BgSchemeInfo scheme, boolean isAddScheme, Context ctx, BgSchemeInfo target) {
        super(param, scheme, isAddScheme, ctx, target);
    }

    @Override
    public boolean isCopy(BgCopySchemeParam param) {
        return param.isCopyDataPermission() && this.getScheme() != null && this.getTarget() != null;
    }

    @Override
    protected List<BgCopySchemeResult> dealCopyByParam() throws Exception {
        ArrayList<BgCopySchemeResult> result = new ArrayList<BgCopySchemeResult>();
        BgSchemeInfo sourceScheme = this.getScheme();
        BgSchemeInfo targetScheme = this.getTarget();
        IMbgPermission localInstance = MbgPermissionFactory.getLocalInstance(this.ctx);
        EntityViewInfo view = this.getDataPermissionEntityView(targetScheme);
        MbgPermissionCollection targetMbgPermissionCollection = localInstance.getMbgPermissionCollection(view);
        view = this.getDataPermissionEntityView(sourceScheme);
        MbgPermissionCollection sourceMbgPermissionCollection = localInstance.getMbgPermissionCollection(view);
        if (sourceMbgPermissionCollection == null || sourceMbgPermissionCollection.isEmpty()) {
            return null;
        }
        HashSet<String> targetTempNumberSet = new HashSet<String>();
        BgTemplateCollection bgTemplateCollection = BgTemplateFactory.getLocalInstance(this.ctx).getBgTemplateCollection("select id, name, number where bgScheme.id='" + targetScheme.getId() + "'");
        for (int i = 0; i < bgTemplateCollection.size(); ++i) {
            targetTempNumberSet.add(bgTemplateCollection.get(i).getNumber());
        }
        BgSchemeDimensionHelper bgSchemeDimensionHelper = new BgSchemeDimensionHelper(this.ctx, targetScheme.getId().toString());
        Set<String> targetOrgNumberSet = this.getOrgNumberSetByScheme(targetScheme, bgSchemeDimensionHelper);
        HashSet<String> uniKeySet = new HashSet<String>();
        if (targetMbgPermissionCollection != null && !targetMbgPermissionCollection.isEmpty()) {
            for (int i = 0; i < targetMbgPermissionCollection.size(); ++i) {
                MbgPermissionInfo mbgPermissionInfo = targetMbgPermissionCollection.get(i);
                String uniqueKey = mbgPermissionInfo.getUniqueKey();
                uniKeySet.add(uniqueKey);
            }
        }
        String creatUniqueKey = null;
        BgCopySchemeResult item = null;
        String nullString = EASResource.getString((String)this.RES, (String)"nullValue");
        CoreBaseCollection addPermissionColls = new CoreBaseCollection();
        for (int i = 0; i < sourceMbgPermissionCollection.size(); ++i) {
            String orgNumber;
            String copyResult;
            String name;
            String baseMsg;
            MbgPermissionInfo mbgPermissionInfo = sourceMbgPermissionCollection.get(i);
            MbgPermissionTypeEnum permissionType = mbgPermissionInfo.getPermissionType();
            if (3 == permissionType.getValue()) {
                String number = mbgPermissionInfo.getBgTemplate().getNumber();
                if (!targetTempNumberSet.contains(number)) {
                    baseMsg = EASResource.getString((String)this.RES, (String)"dataPermission");
                    name = EASResource.getString((String)this.RES, (String)"name1", (Object[])new Object[]{mbgPermissionInfo.getPermissionType().getAlias()});
                    copyResult = EASResource.getString((String)this.RES, (String)"res1", (Object[])new Object[]{this.getPersonName(nullString, mbgPermissionInfo), this.getGroupName(nullString, mbgPermissionInfo), mbgPermissionInfo.getPermissionType().getAlias(), this.getTemp(mbgPermissionInfo)});
                    item = new BgCopySchemeResult();
                    item.setBaseMsg(baseMsg);
                    item.setName(name);
                    item.setOrgName(null);
                    item.setCopyResult(copyResult);
                    result.add(item);
                    continue;
                }
            } else if (4 == permissionType.getValue() && !targetOrgNumberSet.contains(orgNumber = mbgPermissionInfo.getBgOrgUnit().getNumber())) {
                baseMsg = EASResource.getString((String)this.RES, (String)"dataPermission");
                name = EASResource.getString((String)this.RES, (String)"name1", (Object[])new Object[]{mbgPermissionInfo.getPermissionType().getAlias()});
                copyResult = EASResource.getString((String)this.RES, (String)"res2", (Object[])new Object[]{this.getPersonName(nullString, mbgPermissionInfo), this.getGroupName(nullString, mbgPermissionInfo), mbgPermissionInfo.getPermissionType().getAlias(), this.getOrg(mbgPermissionInfo)});
                item = new BgCopySchemeResult();
                item.setBaseMsg(baseMsg);
                item.setName(name);
                item.setOrgName(this.getOrg(mbgPermissionInfo).toString());
                item.setCopyResult(copyResult);
                result.add(item);
                continue;
            }
            mbgPermissionInfo.setBgScheme(targetScheme);
            creatUniqueKey = mbgPermissionInfo.creatUniqueKey();
            mbgPermissionInfo.setUniqueKey(creatUniqueKey);
            if (uniKeySet.contains(creatUniqueKey)) continue;
            if (this.isAddScheme()) {
                mbgPermissionInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                mbgPermissionInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                mbgPermissionInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                mbgPermissionInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            } else {
                mbgPermissionInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                mbgPermissionInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            }
            mbgPermissionInfo.setId(BOSUuid.create((BOSObjectType)mbgPermissionInfo.getBOSType()));
            addPermissionColls.add((CoreBaseInfo)mbgPermissionInfo);
        }
        if (!addPermissionColls.isEmpty()) {
            localInstance.saveBatchData(addPermissionColls);
        }
        return result;
    }

    private Object getOrg(MbgPermissionInfo mbgPermissionInfo) {
        return mbgPermissionInfo.getBgOrgUnit().getNumber() + "(" + mbgPermissionInfo.getBgOrgUnit().getName() + ")";
    }

    private String getTemp(MbgPermissionInfo mbgPermissionInfo) {
        return mbgPermissionInfo.getBgTemplate().getNumber() + "(" + mbgPermissionInfo.getBgTemplate().getName() + ")";
    }

    private Object getGroupName(String nullString, MbgPermissionInfo mbgPermissionInfo) {
        return mbgPermissionInfo.getUserGroup() == null ? nullString : mbgPermissionInfo.getUserGroup().getName();
    }

    private Object getPersonName(String nullString, MbgPermissionInfo mbgPermissionInfo) {
        return mbgPermissionInfo.getPerson() == null ? nullString : mbgPermissionInfo.getPerson().getName();
    }

    private EntityViewInfo getDataPermissionEntityView(BgSchemeInfo scheme) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("person.*"));
        selector.add(new SelectorItemInfo("userGroup.*"));
        selector.add(new SelectorItemInfo("orgUnit.*"));
        selector.add(new SelectorItemInfo("bgScheme.*"));
        selector.add(new SelectorItemInfo("bgType.*"));
        selector.add(new SelectorItemInfo("bgTemplate.*"));
        selector.add(new SelectorItemInfo("bgOrgUnit.*"));
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)scheme.getId().toString(), CompareType.EQUALS));
        SorterItemInfo sortItem1 = new SorterItemInfo("userGroup.number");
        sortItem1.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem1);
        SorterItemInfo sortItem2 = new SorterItemInfo("person.number");
        sortItem2.setSortType(SortType.ASCEND);
        view.getSorter().add(sortItem2);
        return view;
    }

    private Set<String> getOrgNumberSetByScheme(BgSchemeInfo scheme, BgSchemeDimensionHelper bgSchemeDimensionHelper) throws EASBizException, BOSException {
        Set<String> existsOrgId = this.getExistsOrgNumberByViewId(bgSchemeDimensionHelper);
        return existsOrgId;
    }

    private Set<String> getExistsOrgNumberByViewId(BgSchemeDimensionHelper bgSchemeDimensionHelper) throws BOSException {
        HashSet<String> existsOrgNumber = new HashSet<String>();
        String bgOrgViewId = bgSchemeDimensionHelper.getBgOrgViewId();
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(this.ctx).getBgOrgUnitCollection("where viewID ='" + bgOrgViewId + "'");
        for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
            existsOrgNumber.add(bgOrgUnitCollection.get(i).getNumber());
        }
        return existsOrgNumber;
    }
}

