/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.mbg.common.BgDecomposeError;
import com.kingdee.eas.ma.mbg.common.BgDecomposeParameter;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BgDecomposeResult
implements Serializable {
    private static final long serialVersionUID = 8041030189328317004L;
    private BgDecomposeParameter bgDecParameter = null;
    private Map dataResult = null;
    private List<BgDecomposeError> errors = new ArrayList<BgDecomposeError>();

    public BgDecomposeParameter getBgDecParameter() {
        return this.bgDecParameter;
    }

    public void setBgDecParameter(BgDecomposeParameter bgDecParameter) {
        this.bgDecParameter = bgDecParameter;
    }

    public List<BgDecomposeError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<BgDecomposeError> errors) {
        this.errors = errors;
    }

    public Map getDataResult() {
        return this.dataResult;
    }

    public void setDataResult(Map dataResult) {
        this.dataResult = dataResult;
    }

    public BgDecomposeError getError(String orgUnitId, String versionNumber, String formula) {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)versionNumber) || StringUtils.isEmpty((String)formula) || this.errors.isEmpty()) {
            return null;
        }
        BgDecomposeError error = null;
        int size = this.errors.size();
        for (int i = 0; i < size; ++i) {
            error = this.errors.get(i);
            if (!error.getOrgUnitId().equals(orgUnitId) || !error.getBgVersionNumber().equals(versionNumber) || !error.getFormula().equals(formula)) continue;
            return error;
        }
        return null;
    }

    public void removeError(String orgUnitId, String versionNumber, String formula) {
        if (StringUtils.isEmpty((String)orgUnitId) || StringUtils.isEmpty((String)versionNumber) || StringUtils.isEmpty((String)formula) || this.errors.isEmpty()) {
            return;
        }
        BgDecomposeError error = null;
        Iterator<BgDecomposeError> ite = this.errors.iterator();
        while (ite.hasNext()) {
            error = ite.next();
            if (!error.getOrgUnitId().equals(orgUnitId) || !error.getBgVersionNumber().equals(versionNumber) || !error.getFormula().equals(formula)) continue;
            ite.remove();
        }
    }
}

