/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import java.util.Iterator;
import org.dom4j.Element;

public class BgDimensionLoader {
    public void loadDimension(IBgDimensionManager bgDimensionManager, Element view) {
        Element dim;
        if (bgDimensionManager == null || view == null) {
            return;
        }
        boolean rowAddMember = false;
        Element config = view.element("config");
        if (config != null) {
            rowAddMember = Boolean.TRUE.toString().equalsIgnoreCase(BgViewHelper.getElementValue(config, "rowAddMember"));
        }
        if ((dim = view.element("dimension")) != null) {
            int index = 0;
            Iterator itM = dim.elementIterator();
            while (itM.hasNext()) {
                Element member = (Element)itM.next();
                ++index;
                String type = BgViewHelper.getElementValue(member, "type");
                String value = BgViewHelper.getElementValue(member, "value");
                String attribute = BgViewHelper.getElementValue(member, "attribute");
                String layout = BgViewHelper.getElementValue(member, "layout");
                String showType = BgViewHelper.getElementValue(member, "showType");
                this.addDimension(bgDimensionManager, type, value, attribute, layout, showType, index);
            }
        }
    }

    private void addDimension(IBgDimensionManager bgDimensionManager, String type, String value, String attribute, String layout, String showType, int index) {
        BgDimensionInfo dimensionInfo = new BgDimensionInfo(bgDimensionManager);
        dimensionInfo.setType(type);
        dimensionInfo.setValue(value);
        dimensionInfo.setAttribute(attribute);
        dimensionInfo.setLayout(layout);
        dimensionInfo.setShowType(showType);
        dimensionInfo.setIndex(index);
        bgDimensionManager.addDimensionInfo(dimensionInfo);
    }
}

