/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementDataTypeEnum;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.IBgElement;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.ExpandMember;
import com.kingdee.eas.ma.mbg.common.FormStyleInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBGRowData;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionDescriptionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BgDimensionParseCommonHelper {
    private static Logger logger = Logger.getLogger((String)BgDimensionParseCommonHelper.class.getName());
    public static final String RES_VIEWTEMP = "com.kingdee.eas.ma.mbg.client.BgViewTemplateResource";
    public static final String DIMENSION_ORGUNIT = "orgunit";
    public static final String DIMENSION_BGITEM = "bgitem";
    public static final String DIMENSION_BGPERIOD = "bgperiod";
    public static final String DIMENSION_BGELEMENT = "bgelement";
    public static final String DIMENSION_CURRENCY = "currency";
    public static final String DIMENSION_MEMBER = "dimensionMember";
    public static final String MEMBER_FILTER_DIMENSION_INFO = "MEMBER_FILTER_DIMENSION_INFO";

    public static void setBgPeriodIdsFilter(KDBizPromptBox prmt, BgDimensionBaseInfo dimensionInfo) {
        if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dimensionInfo.getNumber())) {
            return;
        }
        HashSet<String> periodIds = new HashSet<String>();
        BgDimensionMember member = null;
        if (!dimensionInfo.getMember().isEmpty()) {
            for (int i = 0; i < dimensionInfo.getMember().size(); ++i) {
                member = (BgDimensionMember)dimensionInfo.getMember().get(i);
                if (StringUtils.isEmpty((String)member.getAttribute())) {
                    periodIds.clear();
                    break;
                }
                periodIds.add(member.getAttribute());
            }
        }
        if (!periodIds.isEmpty()) {
            HashSet<String> disIds = new HashSet<String>();
            HashSet<String> numbers = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(new SelectorItemCollection());
            view.getSelector().add("id");
            view.getSelector().add("number");
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", periodIds, CompareType.INCLUDE));
            try {
                BgPeriodDispCollection colls = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(view);
                if (colls != null && !colls.isEmpty()) {
                    for (int i = 0; i < colls.size(); ++i) {
                        if (numbers.contains(colls.get(i).getNumber())) continue;
                        numbers.add(colls.get(i).getNumber());
                        disIds.add(colls.get(i).getId().toString());
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (!disIds.isEmpty() && dimensionInfo.getMemberValueType().getValue() != 2) {
                prmt.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("id", disIds, CompareType.INCLUDE));
            }
        }
    }

    public static BgDimensionMember getDefaultMember(IUIObject owner, BgDimensionBaseInfo dimensionInfo, BgScenarioType editScenType, DimensionCacheHelper cacheHelper) {
        try {
            BgDimensionMember member;
            int i;
            Set<String> scens = cacheHelper.getEditScenSet(dimensionInfo.getDimensionManager().getSheet().getEditScenNumber(), editScenType);
            Set<String> allScensForType = BgScenarioType.ActualData.equals((Object)editScenType) ? cacheHelper.getActualScens() : cacheHelper.getBudgetScens();
            for (i = 0; i < dimensionInfo.getMember().size(); ++i) {
                member = (BgDimensionMember)dimensionInfo.getMember().get(i);
                if (!scens.contains(member.getNumber())) continue;
                return member;
            }
            for (i = 0; i < dimensionInfo.getMember().size(); ++i) {
                member = (BgDimensionMember)dimensionInfo.getMember().get(i);
                if (!allScensForType.contains(member.getNumber())) continue;
                return member;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            if (owner != null) {
                owner.handUIException((Throwable)e);
            }
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            owner.handUIException((Throwable)e);
            SysUtil.abort();
        }
        if (dimensionInfo.getMember().isEmpty()) {
            return null;
        }
        return (BgDimensionMember)dimensionInfo.getMember().get(0);
    }

    public static void setNumberFilter(KDPromptBox prmt, BgDimensionBaseInfo dimensionInfo, String defaultNumber) {
        if (prmt instanceof KDBizPromptBox && dimensionInfo.getMemberValueType().getValue() != 2) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            if (dimensionInfo.getMember().isEmpty()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"number", CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"number", CompareType.NOTEQUALS));
            } else {
                HashSet<String> numbers = new HashSet<String>();
                for (int i = 0; i < dimensionInfo.getMember().size(); ++i) {
                    numbers.add(((BgDimensionMember)dimensionInfo.getMember().get(i)).getNumber());
                }
                evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
            }
            ((KDBizPromptBox)prmt).setEntityViewInfo(evi);
        }
        BgDimensionParseCommonHelper.setDefault(prmt, dimensionInfo, defaultNumber);
    }

    public static void setDefault(KDPromptBox prmt, BgDimensionBaseInfo dimensionInfo, String defaultNumber) {
        if (!dimensionInfo.getMember().isEmpty()) {
            if (!StringUtils.isEmpty((String)defaultNumber)) {
                for (int i = 0; i < dimensionInfo.getMember().size(); ++i) {
                    if (!defaultNumber.equals(((BgDimensionMember)dimensionInfo.getMember().get(i)).getNumber())) continue;
                    prmt.setDataNoNotify(dimensionInfo.getMember().get(i));
                    return;
                }
            }
            prmt.setDataNoNotify(dimensionInfo.getMember().get(0));
        } else {
            prmt.setDataNoNotify(null);
        }
    }

    public static void setValue(Cell cell, BgDimensionMember member, String showType, IMbgViewManager mbgViewManager, boolean isShowLevel, boolean isShowAlias) {
        if (cell != null && member != null && mbgViewManager != null) {
            FormStyleInfo style = mbgViewManager.getSheetManagers().get(cell.getSheet().getSheetIndex()).getDimensionManager().getFormStyleInfo();
            boolean isShowUnit = style != null && style.isMeasureUnitIsShow();
            String text = BgDimensionParseCommonHelper.getShowText(member, showType, mbgViewManager, isShowLevel, isShowAlias, false, isShowUnit);
            BgNFSHelper.setValue(cell, text);
            BgDimensionParseCommonHelper.setCellMember(cell, member);
        }
    }

    public static String getShowText(BgDimensionMember member, String showType, IMbgViewManager mbgViewManager, boolean isShowLevel, boolean isShowAlias, boolean isShowSimpleName, boolean isShowUnit) {
        String text = null;
        String name = null;
        if (DimensionConstants.DEF_PERIOD_NUMBER.equals(member.getType()) && (isShowAlias || "ALIAS".equals(showType))) {
            name = member.getAlias();
            if (StringUtils.isEmpty((String)name)) {
                name = member.getName();
            }
        } else {
            name = member.getName();
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(member.getType()) && isShowSimpleName && "SIMPLENAME".equals(showType)) {
            if (!StringUtils.isEmpty((String)member.getSimpleName())) {
                name = member.getSimpleName();
            }
        } else if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(member.getType()) && !isShowSimpleName && !"SIMPLENAME".equals(showType)) {
            name = member.getName();
        }
        text = "NUMBER".equalsIgnoreCase(showType) ? member.getNumber() : ("NAMEANDNUMBER".equalsIgnoreCase(showType) ? (member.getNumber() != null ? member.getNumber() + "_" + name : name) : ("LONGNAME".equalsIgnoreCase(showType) ? (!StringUtils.isEmpty((String)member.getLongName()) ? member.getLongName() : name) : name));
        if (isShowLevel) {
            if (member.getSortValue() != null) {
                String longNumber = member.getSortValue().toString();
                int level = 0;
                if (!StringUtils.isEmpty((String)longNumber)) {
                    String[] nums = longNumber.split("\\!");
                    level = nums.length - 1;
                }
                for (int i = 0; i < level; ++i) {
                    text = " " + text;
                }
            } else {
                for (int i = 0; i < member.getLevel(); ++i) {
                    text = " " + text;
                }
            }
        }
        if (isShowUnit && mbgViewManager != null && !mbgViewManager.getMeasureMap().isEmpty() && MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType())) {
            MeasureUnitInfo mu = mbgViewManager.getDefaultMeasureUnit();
            if (mbgViewManager.getMeasureMap().containsKey(member.getNumber())) {
                mu = (MeasureUnitInfo)mbgViewManager.getMeasureMap().get(member.getNumber());
            }
            text = text + "(" + mu.getName() + ")";
        }
        return text;
    }

    private static void setCellMember(Cell cell, BgDimensionMember member) {
        BgNFSHelper.setCellExtData(cell, DIMENSION_MEMBER, member);
    }

    public static BgDimensionMember getCellMember(Cell cell) {
        return (BgDimensionMember)BgNFSHelper.getCellExtData(cell, DIMENSION_MEMBER);
    }

    public static void parseBgItem(Context ctx, int startRowIndex, Sheet sheet, List viewDimensionMember, List pageDimensionMember, Map bgDataMap, StyleAttributes dataStyle, int headerRowCount, boolean isCheckFull, Map<String, MBGRowData> rowDatas, String curOrgNumber, IProvider provider, Set<Integer> itemFields, BgDimensionMember orgDimMember) {
        MBgTemplateHelper.logTime("Start bgDimensionParseHelper.parseBgItem");
        if (sheet == null) {
            return;
        }
        BgNFSHelper.disableCal(sheet.getBook());
        BgNFSHelper.disableUndo(sheet.getBook());
        sheet.getBook().getUndoManager().discardAllEdits();
        List _rowObj = null;
        List _colObj = null;
        ArrayList<BgDimensionMember> _tmp = new ArrayList<BgDimensionMember>();
        ArrayList<BgDimensionMember> _page = null;
        ArrayList _view = null;
        Row row = null;
        Column col = null;
        Cell cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        ArrayList<BgDimensionMember> currentList = new ArrayList<BgDimensionMember>();
        ArrayList<BgDimensionMember> rowDimList = new ArrayList<BgDimensionMember>();
        ArrayList<Comparable> sortValueList = new ArrayList<Comparable>();
        HashMap scenarios = null;
        try {
            scenarios = (HashMap)BgDimensionParseCommonHelper.getScenario(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            e.printStackTrace();
        }
        _page = pageDimensionMember != null ? pageDimensionMember : new ArrayList<BgDimensionMember>();
        _view = viewDimensionMember != null ? viewDimensionMember : new ArrayList();
        BgSheetRange totalRange = new BgSheetRange(sheet);
        BgSheetRange sheetRange = new BgSheetRange(sheet);
        BgSheetRange descRange = new BgSheetRange(sheet);
        BgSheetRange textRange = new BgSheetRange(sheet);
        for (int rowIndex = startRowIndex; rowIndex <= rowCount; ++rowIndex) {
            row = sheet.getRow(rowIndex, false);
            if (MBgTemplateHelper.isSubTotalRow(row)) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    col = sheet.getColumn(colIndex, false);
                    _colObj = (List)col.getUserObjectValue("DIMENSION");
                    if (_colObj == null || _colObj.isEmpty()) continue;
                    cell = row.getCell(colIndex, true);
                    Range r = sheet.getRange(cell);
                    sheetRange.addCell(rowIndex, colIndex);
                    totalRange.addCell(rowIndex, colIndex);
                }
                MBgTemplateHelper.createSubTotalExpression(sheet, row, headerRowCount);
                continue;
            }
            if (MBgTemplateHelper.isDimTotalRow(sheet.getRow(rowCount, false)) && row != null && (_rowObj = (List)row.getUserObjectValue("DIMENSION")) != null && _rowObj.size() > 0) {
                BgDimensionMember bgRowObj = (BgDimensionMember)_rowObj.get(0);
                String dimSortValue = String.valueOf(bgRowObj.getSortValue());
                if (bgRowObj.getNumber() != null && !currentList.contains(bgRowObj)) {
                    currentList.add(bgRowObj);
                    sortValueList.add(bgRowObj.getSortValue());
                }
            }
            if (MBgTemplateHelper.isDimTotalRow(row)) {
                if (rowIndex == rowCount && (((ArrayList)row.getUserObject("DIMENSION").getValue()).size() == 0 || ((ArrayList)row.getUserObject("DIMENSION").getValue()).isEmpty())) {
                    for (int i = 0; i < currentList.size(); ++i) {
                        BgDimensionMember member = (BgDimensionMember)currentList.get(i);
                        String cSortValue = member.getSortValue().toString();
                        if (member.getNumber() == null || rowDimList.contains(member)) continue;
                        if (!(cSortValue != null && cSortValue.contains("!") || rowDimList.contains(member))) {
                            rowDimList.add(member);
                            continue;
                        }
                        if (!cSortValue.contains("!") || rowDimList.contains(member)) continue;
                        BgDimensionMember tmpMember = new BgDimensionMember(member.getType(), member.getAttribute(), null, null);
                        tmpMember.setNumber(cSortValue.substring(0, cSortValue.indexOf("!")));
                        tmpMember.setSortValue((Comparable)((Object)cSortValue.substring(0, cSortValue.indexOf("!"))));
                        tmpMember.setSrcNumber(member.getSrcNumber());
                        if (sortValueList.contains(tmpMember.getSortValue())) continue;
                        rowDimList.add(tmpMember);
                        sortValueList.add(tmpMember.getSortValue());
                    }
                    for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                        col = sheet.getColumn(colIndex, false);
                        _colObj = (List)col.getUserObjectValue("DIMENSION");
                        if (_colObj == null || _colObj.isEmpty()) continue;
                        cell = row.getCell(colIndex, true);
                        _tmp.clear();
                        _tmp.addAll(_view);
                        _tmp.addAll(_page);
                        if (rowDimList != null) {
                            _tmp.addAll(rowDimList);
                        }
                        _tmp.addAll(_colObj);
                        sheetRange.addCell(rowIndex, colIndex);
                        totalRange.addCell(rowIndex, colIndex);
                        MBgTemplateHelper.createDimSumExpression(sheet, cell, _tmp, provider, scenarios, rowDimList, _colObj, _page);
                    }
                    continue;
                }
                _rowObj = (List)row.getUserObjectValue("DIMENSION");
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    col = sheet.getColumn(colIndex, false);
                    _colObj = (List)col.getUserObjectValue("DIMENSION");
                    if (_colObj == null || _colObj.isEmpty()) continue;
                    cell = row.getCell(colIndex, true);
                    _tmp.clear();
                    _tmp.addAll(_view);
                    _tmp.addAll(_page);
                    if (_rowObj != null) {
                        _tmp.addAll(_rowObj);
                    }
                    _tmp.addAll(_colObj);
                    sheetRange.addCell(rowIndex, colIndex);
                    totalRange.addCell(rowIndex, colIndex);
                    MBgTemplateHelper.createDimTotalExpression(sheet, cell, _tmp, provider, scenarios);
                }
                continue;
            }
            if (row == null) continue;
            if (row.getUserObjectValue("DIMENSION") == null) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    cell = row.getCell(colIndex, false);
                    if (BgNFSHelper.getValue(cell) == null || !BgNFSHelper.isNumerical(BgNFSHelper.getValue(cell))) continue;
                    textRange.addCell(rowIndex, colIndex);
                }
                continue;
            }
            _rowObj = (List)row.getUserObjectValue("DIMENSION");
            if (_rowObj == null || _rowObj.isEmpty()) continue;
            for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                BgDescriptionColumn descCol;
                col = sheet.getColumn(colIndex, false);
                _colObj = (List)col.getUserObjectValue("DIMENSION");
                if (_colObj != null && !_colObj.isEmpty()) {
                    cell = row.getCell(colIndex, true);
                    _tmp.clear();
                    _tmp.addAll(_view);
                    _tmp.addAll(_page);
                    if (_rowObj != null) {
                        _tmp.addAll(_rowObj);
                    }
                    _tmp.addAll(_colObj);
                    BgDimensionParseCommonHelper.builderBgFormula(cell, _tmp, isCheckFull, bgDataMap, rowDatas, curOrgNumber, itemFields);
                    sheetRange.addCell(rowIndex, colIndex);
                } else {
                    cell = row.getCell(colIndex, false);
                    if (BgNFSHelper.getValue(cell) != null && BgNFSHelper.isNumerical(BgNFSHelper.getValue(cell))) {
                        textRange.addCell(rowIndex, colIndex);
                    }
                }
                if (!(col.getUserObjectValue("des_col") instanceof BgDescriptionColumn) || (descCol = (BgDescriptionColumn)col.getUserObjectValue("des_col")) == null) continue;
                _tmp.clear();
                _tmp.addAll(_view);
                _tmp.addAll(_page);
                if (orgDimMember != null) {
                    _tmp.add(orgDimMember);
                }
                cell = row.getCell(colIndex, true);
                descRange.addCell(rowIndex, colIndex);
                BgDimensionParseCommonHelper.buildDescriptionFormula(cell, descCol, _rowObj, _tmp);
            }
        }
        MBgTemplateHelper.logTime("Start bgDimensionParseHelper.setStyle");
        dataStyle.setWrapText(false);
        MBgTemplateHelper.setRangeStyle(sheetRange.getRange(), dataStyle, null);
        MBgTemplateHelper.logTime("End bgDimensionParseHelper.setStyle(dataStyle)");
        StyleAttributes textStyle = Styles.getSA((StyleAttributes)dataStyle);
        textStyle.setWrapText(true);
        textStyle.setNumberFormat("@");
        MBgTemplateHelper.setRangeStyle(textRange.getRange(), textStyle, null);
        MBgTemplateHelper.logTime("End bgDimensionParseHelper.setStyle(textStyle)");
        textStyle.setLocked(false);
        MBgTemplateHelper.setRangeStyle(descRange.getRange(), textStyle, null);
        MBgTemplateHelper.logTime("End bgDimensionParseHelper.setStyle(descStyle)");
        BgViewHelper.setLockedAndBackgroud(true, totalRange.getRange());
        MBgTemplateHelper.logTime("End bgDimensionParseHelper.setLockedAndBackgroud(dataStyle)");
        BgNFSHelper.enableUndo(sheet.getBook());
        MBgTemplateHelper.logTime("End bgDimensionParseHelper.parseBgItem");
    }

    private static void buildDescriptionFormula(Cell cell, BgDescriptionColumn descCol, List _rowObj, List<BgDimensionMember> pageMembers) {
        if (cell == null || descCol == null || _rowObj == null || _rowObj.isEmpty() || pageMembers == null || pageMembers.isEmpty()) {
            return;
        }
        ArrayList<BgDimensionMember> members = new ArrayList<BgDimensionMember>();
        members.addAll(_rowObj);
        members.addAll(pageMembers);
        if (!members.isEmpty()) {
            BgDimensionMember _org = null;
            BgDimensionMember member = null;
            int in = members.size();
            for (int i = 0; i < in; ++i) {
                member = (BgDimensionMember)members.get(i);
                if (member == null || member.getType() == null || !MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) continue;
                _org = member;
            }
            if (_org == null) {
                return;
            }
            String _bgFormula = DimensionDescriptionHelper.parseDescriptionFormula(members, descCol.getAlias());
            if (!StringUtils.isEmpty((String)_bgFormula)) {
                DimensionDescriptionHelper.setDescriptionFormula(cell, _bgFormula, _org != null ? _org.getAttribute() : null);
            }
        }
    }

    public static void setSheetStyle(Sheet sheet, IBgDimensionManager bgDimensionManager, StyleAttributes dataStyle) {
        if (sheet == null) {
            return;
        }
        sheet.getSheetRange().setStyle(dataStyle, Styles.getEmptySA());
        if (sheet.getSheetOption().getMerger(false) != null) {
            sheet.getSheetOption().getMerger(false).clear();
        }
        if (bgDimensionManager.isLockSheet()) {
            BgNFSHelper.setSheetLocked(sheet, true);
        }
    }

    public static void addDimensionInfo(Row row, List<BgDimensionMember> dimensionMembers) {
        if (row == null || dimensionMembers == null) {
            return;
        }
        ArrayList _obj = row.getUserObjectValue("DIMENSION");
        if (_obj instanceof List) {
            ((List)_obj).addAll(dimensionMembers);
        } else {
            _obj = new ArrayList();
            ((List)_obj).addAll(dimensionMembers);
            row.setUserObject("DIMENSION", _obj);
        }
    }

    public static List<BgDimensionMember> getDimensionInfo(Row row) {
        if (row == null) {
            return null;
        }
        if (row.getUserObjectValue("DIMENSION") instanceof List) {
            return (List)row.getUserObjectValue("DIMENSION");
        }
        return null;
    }

    public static void addDimensionInfo(Column column, List<BgDimensionMember> dimensionMembers) {
        if (column == null || dimensionMembers == null) {
            return;
        }
        ArrayList _obj = column.getUserObjectValue("DIMENSION");
        if (_obj instanceof List) {
            ((List)_obj).addAll(dimensionMembers);
        } else {
            _obj = new ArrayList();
            ((List)_obj).addAll(dimensionMembers);
            column.setUserObject("DIMENSION", _obj);
        }
    }

    public static void builderBgFormula(Cell cell, List<BgDimensionMember> members, boolean isCheckFull, Map bgDataMap, Map<String, MBGRowData> rowDatas, String curOrgNumber, Set<Integer> itemFields) {
        if (members == null || members.isEmpty() || cell == null) {
            return;
        }
        HashMap<Integer, String> _item = new HashMap<Integer, String>();
        String _element = null;
        String _period = null;
        String _currency = null;
        String _version = null;
        String _scenario = null;
        BgDimensionMember _org = null;
        BgDimensionMember member = null;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (member.getType() == null || member.getNumber() == null) {
                if (!isCheckFull) continue;
                _item.clear();
                break;
            }
            if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType())) {
                if ("BGPERIOD".equals(member.getNumber())) {
                    _period = "";
                    continue;
                }
                _period = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType())) {
                _element = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType())) {
                _currency = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) {
                _org = member;
                continue;
            }
            if (MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType())) {
                _scenario = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType())) {
                _version = member.getNumber();
                continue;
            }
            if (StringUtils.isEmpty((String)member.getNumber()) || StringUtils.isEmpty((String)member.getAttribute())) continue;
            _item.put(DimensionCommonHelper.getField(member.getAttribute().toUpperCase()), member.getSrcNumber() + ":" + member.getNumber());
        }
        if (isCheckFull && (_item.isEmpty() || _period == null || _element == null || _currency == null || _version == null || _scenario == null || itemFields == null || !itemFields.equals(_item.keySet()))) {
            return;
        }
        MBGRowData rowData = null;
        rowData = _org != null && !StringUtils.isEmpty((String)_org.getNumber()) ? rowDatas.get(_org.getNumber()) : rowDatas.get(curOrgNumber);
        if (rowDatas != null && !rowDatas.isEmpty() && rowData != null && !rowData.isInRalation(members)) {
            return;
        }
        String _bgFormula = BgViewHelper.parseItemFormula(_element, _currency, _period, _scenario, _item);
        if (!StringUtils.isEmpty((String)_bgFormula) && cell != null) {
            ItemFormula itemFormula = null;
            MBgTemplateHelper.oneStart();
            if (cell.getUserObjectValue("ITEM") instanceof ItemFormula) {
                itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            } else {
                itemFormula = new ItemFormula();
                itemFormula.putExt("Formula_Key", "Item");
                cell.setUserObject("ITEM", (Object)itemFormula);
            }
            itemFormula.putExt("13", _bgFormula);
            MBgTemplateHelper.oneEnd();
            itemFormula.putExt("BGFORMULA_CANUPDATE", BgNConstants.FALSE_UPDATE);
            if (_org != null) {
                itemFormula.putExt("ORGUNITID", _org.getAttribute());
                itemFormula.putExt("ORGUNIT", _org.getNumber());
                itemFormula.putExt("Version", _version);
                if (bgDataMap != null) {
                    if (!bgDataMap.containsKey(_org.getAttribute())) {
                        bgDataMap.put(_org.getAttribute(), new HashMap());
                    }
                    Map subMap = (Map)bgDataMap.get(_org.getAttribute());
                    subMap.put(_bgFormula, _bgFormula);
                }
            }
        }
    }

    private static Map getScenario(Context ctx) throws BOSException {
        HashMap<String, BgElementDataTypeEnum> scenarioMap = new HashMap<String, BgElementDataTypeEnum>();
        IBgElement biz = null;
        biz = ctx == null ? BgElementFactory.getRemoteInstance() : BgElementFactory.getLocalInstance((Context)ctx);
        BgElementCollection bgElementCollection = biz.getBgElementCollection();
        for (int i = 0; i < bgElementCollection.size(); ++i) {
            scenarioMap.put(bgElementCollection.get(i).getNumber(), bgElementCollection.get(i).getDataType());
        }
        return scenarioMap;
    }

    public static void setFilterDimension(Cell cell, BgDimensionBaseInfo dimension) {
        BgNFSHelper.setCellData(cell, MEMBER_FILTER_DIMENSION_INFO, dimension);
    }

    public static BgDimensionMember getMember(Object obj) {
        if (obj instanceof ExpandMember) {
            return ((ExpandMember)obj).member;
        }
        return null;
    }
}

